/*
 * Decompiled with CFR 0.152.
 */
package ssmith.android.framework.modules;

import com.scs.stellarforces.Statics;
import java.awt.event.MouseWheelEvent;
import ssmith.android.compatibility.PointF;
import ssmith.android.framework.MyEvent;
import ssmith.android.framework.modules.AbstractModule;
import ssmith.android.lib2d.gui.AbstractComponent;
import ssmith.lang.GeometryFuncs;

public abstract class SimpleScrollingAbstractModule
extends AbstractModule {
    private static final float MIN_DRAG_DIST = Statics.SCREEN_HEIGHT / 25;
    private PointF last_down_screen = new PointF();
    private boolean is_dragging = false;
    private boolean can_drag = true;
    protected boolean limit_dragging = true;

    public SimpleScrollingAbstractModule(int am) {
        super(am);
    }

    @Override
    public void updateGame(long interpol) {
        if (this.limit_dragging) {
            this.can_drag = this.root_node.getWorldBounds().top < this.root_cam.top || this.root_node.getWorldBounds().bottom > this.root_cam.bottom;
        }
    }

    @Override
    public boolean processEvent(MyEvent ev) throws Exception {
        if (ev.getAction() == 502) {
            this.last_down_screen.y = ev.getY();
            if (!this.is_dragging) {
                AbstractComponent c = super.GetComponentAt(this.stat_node, ev.getX(), ev.getY());
                if (c == null) {
                    float x = ev.getX() + this.root_cam.left;
                    float y = ev.getY() + this.root_cam.top;
                    c = super.GetComponentAt(this.root_node, x, y);
                }
                if (c != null) {
                    this.handleClick(c);
                    return true;
                }
                this.noComponentClicked();
            }
            this.is_dragging = false;
        } else if (ev.getAction() == 506) {
            float offy;
            double dist;
            if (this.can_drag && ((dist = (double)GeometryFuncs.distance(0.0f, 0.0f, 0.0f, offy = this.last_down_screen.y - ev.getY())) > (double)MIN_DRAG_DIST || this.is_dragging)) {
                this.drag(offy);
                this.is_dragging = true;
                this.last_down_screen.y = ev.getY();
            }
        } else if (ev.getAction() == 501) {
            this.last_down_screen.y = ev.getY();
        }
        return false;
    }

    private void drag(float offy) {
        this.root_cam.moveCam(0.0f, offy);
        if (this.limit_dragging) {
            if (this.root_node.getHeight() > (float)Statics.SCREEN_HEIGHT) {
                if (this.root_cam.top < this.root_node.getWorldY()) {
                    this.root_cam.moveCam(0.0f, this.root_node.getWorldY() - this.root_cam.top);
                } else if (this.root_cam.bottom > this.root_node.getWorldBounds().bottom) {
                    this.root_cam.moveCam(0.0f, this.root_node.getWorldBounds().bottom - this.root_cam.bottom);
                }
            }
        } else if (this.root_node.getHeight() > (float)Statics.SCREEN_HEIGHT) {
            if (this.root_cam.bottom < this.root_node.getWorldY()) {
                this.root_cam.moveCam(0.0f, this.root_node.getWorldY() - this.root_cam.bottom);
            } else if (this.root_cam.top > this.root_node.getWorldBounds().bottom) {
                this.root_cam.moveCam(0.0f, this.root_node.getWorldBounds().bottom - this.root_cam.top);
            }
        }
    }

    public abstract void handleClick(AbstractComponent var1) throws Exception;

    public void noComponentClicked() {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mwe) {
        this.drag(mwe.getWheelRotation() * 30);
    }
}

