/*
 * Decompiled with CFR 0.152.
 */
package ssmith.android.lib2d;

import com.scs.stellarforces.Statics;
import ssmith.android.compatibility.PointF;
import ssmith.android.compatibility.RectF;
import ssmith.android.lib2d.MyPointF;
import ssmith.android.lib2d.Spatial;
import ssmith.lang.GeometryFuncs;
import ssmith.lang.NumberFunctions;

public class Camera
extends RectF {
    public int zoom = 1;
    private PointF target_point = new PointF();
    private boolean lock_to_target;
    private boolean moving = false;
    private MyPointF actual_point = new MyPointF();
    private float last_dist = -1.0f;
    private boolean vibrating = false;
    private long vibrate_until;

    public MyPointF getActualCentre() {
        return this.actual_point;
    }

    public void moveCam(float offx, float offy) {
        this.moveCam(offx, offy, true);
    }

    public void moveCam(float offx, float offy, boolean lock) {
        this.lock_to_target = lock;
        if (lock) {
            this.actual_point.x += offx;
            this.actual_point.y += offy;
            this.moving = false;
            this.updateWindow();
        } else {
            this.target_point.x += offx;
            this.target_point.y += offy;
            this.moving = true;
            this.last_dist = -1.0f;
        }
    }

    public void lookAt(float x, float y, boolean lock) {
        this.lock_to_target = lock;
        if (lock) {
            this.actual_point.x = x;
            this.actual_point.y = y;
            this.moving = false;
            this.updateWindow();
        } else {
            this.target_point.x = x;
            this.target_point.y = y;
            this.moving = true;
            this.last_dist = -1.0f;
        }
    }

    public void lookAt(Spatial s, boolean lock) {
        s.updateGeometricState();
        this.lookAt(s.getWorldCentreX(), s.getWorldCentreY(), lock);
    }

    public void update(long interpol) {
        if (this.vibrating) {
            if (System.currentTimeMillis() > this.vibrate_until) {
                this.vibrating = false;
            } else {
                float diff = (float)Statics.SCREEN_WIDTH / 40.0f;
                this.moveCam(NumberFunctions.rndFloat(-diff, diff), NumberFunctions.rndFloat(-diff, diff));
            }
        } else if (!this.lock_to_target && this.moving) {
            float dist = GeometryFuncs.distance(this.actual_point.x, this.actual_point.y, this.target_point.x, this.target_point.y);
            if (dist > this.last_dist && this.last_dist >= 0.0f || dist <= 3.0f) {
                this.lookAt(this.target_point.x, this.target_point.y, true);
            } else {
                float off_x = (this.target_point.x - this.actual_point.x) / 4.0f;
                float off_y = (this.target_point.y - this.actual_point.y) / 4.0f;
                this.actual_point.x += off_x;
                this.actual_point.y += off_y;
                this.updateWindow();
            }
            this.last_dist = dist;
        }
    }

    public boolean isMoving() {
        return !this.lock_to_target;
    }

    private void updateWindow() {
        this.left = this.actual_point.x - (float)(Statics.SCREEN_WIDTH / 2 / this.zoom);
        this.top = this.actual_point.y - (float)(Statics.SCREEN_HEIGHT / 2 / this.zoom);
        this.right = this.actual_point.x + (float)(Statics.SCREEN_WIDTH / 2 / this.zoom);
        this.bottom = this.actual_point.y + (float)(Statics.SCREEN_HEIGHT / 2 / this.zoom);
    }

    public void vibrate(long time) {
        this.vibrating = true;
        this.vibrate_until = System.currentTimeMillis() + time;
    }
}

