/*
 * Decompiled with CFR 0.152.
 */
package ssmith.astar;

import java.awt.Point;
import ssmith.astar.IAStarMapInterface;
import ssmith.astar.Node;
import ssmith.astar.PriorityList;
import ssmith.astar.WayPoints;

public class AStar
extends Thread {
    private IAStarMapInterface map_interface;
    private Node[][] map;
    private PriorityList open;
    private boolean[][] checked;
    private int start_x;
    private int start_z;
    private int end_x;
    private int end_z;
    private int max_dist;
    private volatile boolean finding_path = false;
    private volatile boolean failed = false;
    private volatile WayPoints route = new WayPoints();
    private boolean can_timeout = false;
    private long max_dur;
    private long timeout_time;
    public static volatile int tot_threads = 0;
    private String[][] strmap;

    public AStar(IAStarMapInterface intface, long max_duration) {
        this(intface);
        this.can_timeout = true;
        this.max_dur = max_duration;
    }

    public AStar(IAStarMapInterface intface) {
        this.setDaemon(true);
        this.map_interface = intface;
        int w = intface.getMapWidth();
        int h = intface.getMapHeight();
        this.strmap = new String[w][h];
    }

    public void findPath(int start_x, int start_z, int targ_x, int targ_z, boolean thread) {
        this.findPath(start_x, start_z, targ_x, targ_z, -1, thread);
    }

    public void findPath(int start_x, int start_z, int targ_x, int targ_z, int max_dist, boolean thread) {
        if (this.can_timeout) {
            this.timeout_time = System.currentTimeMillis() + this.max_dur;
        }
        if (this.finding_path) {
            System.err.println("Trying to find path concurrently!");
        }
        this.route = new WayPoints();
        this.finding_path = true;
        this.start_x = start_x;
        this.start_z = start_z;
        this.end_x = targ_x;
        this.end_z = targ_z;
        this.max_dist = max_dist;
        if (thread) {
            this.start();
        } else {
            this.run();
        }
    }

    @Override
    public void run() {
        Node node;
        ++tot_threads;
        int w = this.map_interface.getMapHeight();
        int h = this.map_interface.getMapWidth();
        this.map = new Node[w][h];
        int z = 0;
        while (z < h) {
            int x = 0;
            while (x < w) {
                this.strmap[x][z] = "-";
                ++x;
            }
            ++z;
        }
        this.strmap[this.start_x][this.start_z] = "S";
        this.strmap[this.end_x][this.end_z] = "F";
        this.open = new PriorityList();
        this.checked = new boolean[w][h];
        this.map[this.start_x][this.start_z] = node = new Node(this.start_x, this.start_z);
        node.setHeuristic(null, this.end_x, this.end_z, 1.0f);
        this.open.add(node);
        while (node.x != this.end_x || node.z != this.end_z) {
            if (this.can_timeout && System.currentTimeMillis() > this.timeout_time) {
                this.failed = true;
                break;
            }
            this.open.remove(node);
            this.checked[node.x][node.z] = true;
            this.getAdjacentSquares(0, -1, node, this.end_x, this.end_z, this.max_dist);
            this.getAdjacentSquares(1, 0, node, this.end_x, this.end_z, this.max_dist);
            this.getAdjacentSquares(0, 1, node, this.end_x, this.end_z, this.max_dist);
            this.getAdjacentSquares(-1, 0, node, this.end_x, this.end_z, this.max_dist);
            if (this.open.size() > 0) {
                node = (Node)this.open.getFirst();
                continue;
            }
            this.failed = true;
            this.route = new WayPoints();
            break;
        }
        while (node.getParent() != null) {
            this.route.add(0, new Point(node.x, node.z));
            node = node.getParent();
            this.strmap[node.x][node.z] = "X";
        }
        this.route.add(0, new Point(this.start_x, this.start_z));
        this.strmap[this.start_x][this.start_z] = "S";
        this.strmap[this.end_x][this.end_z] = "F";
        this.finding_path = false;
        --tot_threads;
    }

    public boolean isFindingPath() {
        return this.finding_path;
    }

    public boolean wasSuccessful() {
        return !this.failed;
    }

    public WayPoints getRoute() {
        return this.route;
    }

    public void showRoute() {
        try {
            int w = this.map_interface.getMapWidth();
            int h = this.map_interface.getMapHeight();
            int z = 0;
            while (z < h) {
                int x = 0;
                while (x < w) {
                    System.out.print(this.strmap[x][z]);
                    ++x;
                }
                System.out.println("");
                ++z;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getAdjacentSquares(int off_x, int off_z, Node prnt, int targ_x, int targ_z, int max_dist) {
        int x = prnt.x + off_x;
        int z = prnt.z + off_z;
        try {
            if (max_dist > 0 && prnt.getDistFromStart() >= (double)max_dist) {
                return;
            }
            if (!this.checked[x][z]) {
                if (this.map_interface.isMapSquareTraversable(x, z) || x == targ_x && z == targ_z) {
                    Node n = new Node(x, z);
                    float dist = this.map_interface.getMapSquareDifficulty(x, z);
                    n.setHeuristic(prnt, targ_x, targ_z, dist);
                    boolean found = false;
                    if (this.map[x][z] != null) {
                        Node other = this.map[x][z];
                        if (other.getHeuristic() <= n.getHeuristic()) {
                            found = true;
                        } else {
                            this.map[x][z] = null;
                            this.open.remove(other);
                        }
                    }
                    if (!found) {
                        this.map[x][z] = n;
                        this.open.add(n);
                        if (this.strmap[x][z].equalsIgnoreCase("-")) {
                            this.strmap[x][z] = "+";
                        }
                    }
                } else {
                    this.strmap[x][z] = "B";
                }
            } else if (!this.strmap[x][z].equalsIgnoreCase("B")) {
                this.strmap[x][z] = "W";
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }
}

