/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.game;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.game.GameModule;
import ssmith.android.compatibility.Paint;
import ssmith.android.lib2d.Node;
import ssmith.android.lib2d.gui.Button;
import ssmith.android.lib2d.gui.GUIFunctions;
import ssmith.android.lib2d.layouts.GridLayout;

public class InGameMenu
extends Node {
    public static final int STATUS_HIDDEN = 0;
    public static final int STATUS_SHOWN = 1;
    private static final float MOVE_SPEED = (float)Statics.SCREEN_HEIGHT * 0.05f;
    private static final float ICON_WIDTH = (float)Statics.SCREEN_WIDTH * 0.3f;
    private static final float ICON_HEIGHT = ICON_WIDTH / 4.0f;
    private int status = 0;
    private static Paint paint_menu_text = new Paint();
    private static Paint paint_background = new Paint();

    static {
        paint_menu_text.setARGB(255, 255, 255, 255);
        paint_menu_text.setAntiAlias(true);
        paint_menu_text.setTypeface(Statics.stdfnt);
        paint_background.setARGB(200, 255, 255, 255);
        paint_background.setAntiAlias(true);
        paint_background.setTextSize(GUIFunctions.GetTextSizeToFit("Advanced ScannerX", ICON_WIDTH, ICON_HEIGHT));
    }

    public InGameMenu(GameModule _game) {
        super("InGameMenu");
        GridLayout menu_node = new GridLayout("Menu", ICON_WIDTH, ICON_HEIGHT, (int)((float)Statics.SCREEN_HEIGHT * 0.005f));
        menu_node.attachChild(new Button("2", "Advanced Scanner", paint_background, paint_menu_text, GameModule.ImgCache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT)), 0, 0);
        menu_node.attachChild(new Button("4", "Game Log", paint_background, paint_menu_text, GameModule.ImgCache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT)), 1, 0);
        menu_node.attachChild(new Button("5", "Tutorial", paint_background, paint_menu_text, GameModule.ImgCache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT)), 0, 1);
        menu_node.attachChild(new Button("3", "Toggle Grid", paint_background, paint_menu_text, GameModule.ImgCache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT)), 1, 1);
        menu_node.attachChild(new Button("7", "Mission File", paint_background, paint_menu_text, GameModule.ImgCache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT)), 0, 2);
        menu_node.attachChild(new Button("9", "All Unit Stats", paint_background, paint_menu_text, GameModule.ImgCache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT)), 1, 2);
        menu_node.attachChild(new Button("10", "Game Details", paint_background, paint_menu_text, GameModule.ImgCache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT)), 0, 3);
        menu_node.attachChild(new Button("11", "Msg Opponent", paint_background, paint_menu_text, GameModule.ImgCache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT)), 1, 3);
        menu_node.attachChild(new Button("13", "Instructions", paint_background, paint_menu_text, GameModule.ImgCache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT)), 0, 4);
        menu_node.attachChild(new Button("8", "Game Chat", paint_background, paint_menu_text, GameModule.ImgCache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT)), 1, 4);
        if (_game.game_data.getComradeSide() > 0) {
            menu_node.attachChild(new Button("12", "Msg Comrade", paint_background, paint_menu_text, GameModule.ImgCache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT)), 1, 5);
        }
        menu_node.updateGeometricState();
        this.attachChild(menu_node);
        this.updateGeometricState();
        this.setLocation((float)Statics.SCREEN_WIDTH - ICON_WIDTH * 2.0f, Statics.SCREEN_HEIGHT);
        this.updateGeometricState();
    }

    public void process() {
        switch (this.status) {
            case 0: {
                if (!(this.getWorldY() < (float)Statics.SCREEN_HEIGHT)) break;
                this.setLocation(this.getLocation().x, this.getLocation().y + MOVE_SPEED);
                this.parent.updateGeometricState();
                break;
            }
            case 1: {
                if (!(this.getWorldBounds().bottom > (float)Statics.SCREEN_HEIGHT)) break;
                this.setLocation(this.getLocation().x, this.getLocation().y - MOVE_SPEED);
                this.parent.updateGeometricState();
                break;
            }
            default: {
                throw new RuntimeException("Unknown status: " + this.status);
            }
        }
    }

    public void show() {
        this.status = 1;
    }

    public void hide() {
        this.status = 0;
    }

    public void toggle() {
        this.status = this.status == 1 ? 0 : 1;
    }

    public void instaHide() {
        this.hide();
        this.setLocation(this.getLocation().x, this.getLocation().y + this.getHeight() + (float)Statics.SCREEN_HEIGHT);
        this.updateGeometricState();
    }

    public int getStatus() {
        return this.status;
    }
}

