/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.game;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.game.GameModule;
import dsr.data.MapSquare;
import ssmith.android.compatibility.Paint;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.framework.modules.AbstractOptionsModule2;
import ssmith.lang.NumberFunctions;

public class SelectStructureToBuildModule
extends AbstractOptionsModule2 {
    private static Paint paint_normal_text = new Paint();
    private GameModule game;

    static {
        paint_normal_text.setARGB(255, 255, 255, 255);
        paint_normal_text.setAntiAlias(true);
        paint_normal_text.setTextSize(Statics.GetHeightScaled(0.05f));
    }

    public SelectStructureToBuildModule(AbstractActivity act, GameModule mod) {
        super(act, -1, 2, paint_normal_text, "lumin_green_button2", -1, false, "Select Structure (" + mod.game_data.getResPointsForOurSide() + " Res Points)", true);
        this.mod_return_to = mod;
        this.game = mod;
        this.setBackground("space1.jpg");
    }

    @Override
    public void getOptions() {
        int[] data;
        int[] nArray = data = new int[]{86, 87, 88, 85, 16};
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            this.addOption(String.valueOf(SelectStructureToBuildModule.TexToString(i)) + " (" + SelectStructureToBuildModule.GetRPCostToBuildStructure(i) + ")", i);
            ++n2;
        }
    }

    @Override
    public void optionSelected(int idx) {
        String cmd = super.getActionCommand(idx);
        this.game.buildStructure(NumberFunctions.ParseInt(cmd));
        this.returnTo();
    }

    public static String TexToString(int tex) {
        switch (tex) {
            case 85: {
                return "Medi-Bay";
            }
            case 87: {
                return "Gun Vending Machine";
            }
            case 88: {
                return "Grenade Vending Machine";
            }
            case 86: {
                return "Clone Generator";
            }
            case 16: {
                return "Wall";
            }
            case 84: {
                return "Power Unit";
            }
            case 93: {
                return "Alien Egg";
            }
        }
        throw new RuntimeException("Unknown structure type: " + tex);
    }

    public static int GetResPtsForDismantledStructure(MapSquare sq) {
        int res = 0;
        res = sq.door_type > 0 ? 1 : (sq.major_type == 3 ? 1 : SelectStructureToBuildModule.GetRPCostToBuildStructure(sq.texture_code));
        if (res > 1) {
            --res;
        }
        return res;
    }

    public static int GetRPCostToBuildStructure(int tex) {
        int res = 0;
        switch (tex) {
            case 85: {
                res = 3;
                break;
            }
            case 87: {
                res = 5;
                break;
            }
            case 88: {
                res = 5;
                break;
            }
            case 86: {
                res = 6;
                break;
            }
            case 16: {
                res = 1;
                break;
            }
            case 84: {
                res = 1;
                break;
            }
            case 93: {
                res = 1;
                break;
            }
            default: {
                return 0;
            }
        }
        return res;
    }

    public static int GetAPCostToBuildStructure(int tex) {
        int res = 0;
        switch (tex) {
            case 85: {
                res = 20;
                break;
            }
            case 93: {
                res = 20;
                break;
            }
            case 16: {
                res = 10;
                break;
            }
            default: {
                return 40;
            }
        }
        return res;
    }

    @Override
    public boolean playMusic() {
        return false;
    }
}

