/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.start.newgame;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.start.GetGamesModule;
import dsr.comms.AbstractCommFuncs;
import dsr.comms.WGet_SF;
import ssmith.android.compatibility.Paint;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.framework.modules.SimpleScrollingAbstractModule;
import ssmith.android.lib2d.gui.AbstractComponent;
import ssmith.android.lib2d.gui.Button;
import ssmith.android.lib2d.gui.Label;
import ssmith.android.lib2d.gui.MultiLineLabel;
import ssmith.android.lib2d.layouts.VerticalFlowLayout;

public class StartPractiseGameModule
extends SimpleScrollingAbstractModule {
    private Button cmd_accept;
    private static Paint paint_large_text = new Paint();
    private static Paint paint_med_text = new Paint();
    private static Paint paint_normal_text = new Paint();

    static {
        paint_large_text.setARGB(255, 255, 255, 255);
        paint_large_text.setAntiAlias(true);
        paint_large_text.setTextSize(Statics.GetHeightScaled(0.09f));
        paint_med_text.setARGB(255, 255, 255, 255);
        paint_med_text.setAntiAlias(true);
        paint_med_text.setTextSize(Statics.GetHeightScaled(0.07f));
        paint_normal_text.setARGB(255, 255, 255, 255);
        paint_normal_text.setAntiAlias(true);
        paint_normal_text.setTextSize(Statics.GetHeightScaled(0.05f));
    }

    public StartPractiseGameModule(AbstractActivity act) {
        super(9);
        paint_large_text.setTypeface(Statics.bigfnt);
        paint_med_text.setTypeface(Statics.bigfnt);
        paint_normal_text.setTypeface(Statics.stdfnt);
        this.setBackground("space1.jpg");
    }

    @Override
    public void started() {
        this.root_node.detachAllChildren();
        Label l = new Label("Title", "New Practise Game", 0.0f, 0.0f, null, paint_large_text, true);
        l.setCentre(Statics.SCREEN_WIDTH / 2, paint_large_text.getTextSize());
        this.root_node.attachChild(l);
        VerticalFlowLayout vfl = new VerticalFlowLayout("vfl", (float)Statics.SCREEN_HEIGHT * 0.05f);
        vfl.setLocation(0.0f, (float)Statics.SCREEN_HEIGHT * 0.2f);
        MultiLineLabel mll = new MultiLineLabel("mll", "", null, paint_normal_text, true, (float)Statics.SCREEN_WIDTH * 0.9f);
        mll.setText("Here you can start a practise game.  It is the same as a normal game except you are playing against a very simple AI.  When you end your turn, the AI will move, and then it will be your turn again.\n\nPractise games are a good way to get familiar with the basic game, but we would recommend playing against another player to get the most enjoyment!");
        vfl.attachChild(mll);
        int sides = 1;
        float width = (float)Statics.SCREEN_WIDTH * 0.9f / (float)(sides + 1);
        float height = Statics.SCREEN_HEIGHT / 7;
        this.cmd_accept = new Button("Start", "Start Practise Game", null, paint_normal_text, Statics.img_cache.getImage("lumin_green_button2", width, height));
        this.cmd_accept.setLocation(10.0f, (float)Statics.SCREEN_HEIGHT - height);
        vfl.attachChild(this.cmd_accept);
        vfl.updateGeometricState();
        vfl.setCentre(Statics.SCREEN_WIDTH / 2, Statics.SCREEN_HEIGHT / 2);
        this.root_node.attachChild(vfl);
        this.root_node.updateGeometricState();
        this.root_cam.lookAt(Statics.SCREEN_WIDTH / 2, Statics.SCREEN_HEIGHT / 2, true);
    }

    @Override
    public void handleClick(AbstractComponent c) throws Exception {
        if (c == this.cmd_accept) {
            this.createNewGame();
        }
    }

    private void createNewGame() {
        block6: {
            AbstractActivity act = Statics.act;
            this.showPleaseWait("Creating game...");
            try {
                try {
                    WGet_SF wc = new WGet_SF(act, null, "cmd=start_practise_with_ai&version=" + Statics.COMMS_VERSION + "&login=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_LOGIN) + "&pwd=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_PWD));
                    String response = wc.getResponse();
                    if (response.length() == 0 || response.equalsIgnoreCase("ok")) {
                        this.getMainThread().setNextModule(new GetGamesModule(act, true));
                        break block6;
                    }
                    this.dismissPleaseWait();
                    this.showToast(response);
                }
                catch (Exception ex) {
                    AbstractActivity.HandleError(ex);
                    this.dismissPleaseWait();
                }
            }
            finally {
                this.dismissPleaseWait();
            }
        }
    }
}

