/*
 * Decompiled with CFR 0.152.
 */
package dsr.comms;

import com.scs.stellarforces.Statics;
import dsr.data.ClientMapData;
import dsr.data.EquipmentData;
import dsr.data.UnitData;
import java.util.ArrayList;
import ssmith.dbs.SQLFuncs;
import ssmith.lang.NumberFunctions;

public final class EquipmentDataComms {
    public static String GetEquipmentDataRequest(int gameid, String gamecode) {
        return "cmd=equipdata&version=" + Statics.COMMS_VERSION + "&getput=" + "get" + "&gid=" + gameid + "&gc=" + gamecode;
    }

    public static EquipmentData[] DecodeEquipmentDataResponse(ClientMapData map, ArrayList<UnitData> units, String response) {
        String[] data = response.split("\\|", -1);
        int pos = 0;
        int num = 0;
        EquipmentData[] equipment = null;
        do {
            if (data[pos].equalsIgnoreCase("qty")) {
                int u = NumberFunctions.ParseInt(data[pos + 1]);
                equipment = new EquipmentData[u];
                pos += 2;
                continue;
            }
            if (data[pos].equalsIgnoreCase("equipment")) {
                equipment[num] = new EquipmentData();
                equipment[num].equip_id = NumberFunctions.ParseInt(data[pos + 1]);
                equipment[num].equipcode = data[pos + 2];
                equipment[num].setName(data[pos + 3]);
                equipment[num].setUnitID(NumberFunctions.ParseInt(data[pos + 4]));
                equipment[num].major_type = NumberFunctions.ParseByte(data[pos + 5]);
                int x = NumberFunctions.ParseInt(data[pos + 6]);
                int y = NumberFunctions.ParseInt(data[pos + 7]);
                equipment[num].shot_damage = NumberFunctions.ParseShort(data[pos + 8]);
                equipment[num].cc_damage = NumberFunctions.ParseShort(data[pos + 9]);
                equipment[num].aimed_shot_acc = NumberFunctions.ParseByte(data[pos + 10]);
                equipment[num].aimed_shot_aps = NumberFunctions.ParseByte(data[pos + 11]);
                equipment[num].snap_shot_acc = NumberFunctions.ParseByte(data[pos + 12]);
                equipment[num].snap_shot_aps = NumberFunctions.ParseByte(data[pos + 13]);
                equipment[num].auto_shot_acc = NumberFunctions.ParseByte(data[pos + 14]);
                equipment[num].auto_shot_aps = NumberFunctions.ParseByte(data[pos + 15]);
                equipment[num].explosion_rad = NumberFunctions.ParseByte(data[pos + 16]);
                equipment[num].cc_acc = NumberFunctions.ParseByte(data[pos + 17]);
                equipment[num].primed = NumberFunctions.ParseInt(data[pos + 18]) == 1;
                equipment[num].explode_turns = NumberFunctions.ParseByte(data[pos + 19]);
                equipment[num].explosion_dam = NumberFunctions.ParseShort(data[pos + 20]);
                equipment[num].setAmmo(NumberFunctions.ParseByte(data[pos + 21]));
                equipment[num].ammo_type_id = NumberFunctions.ParseInt(data[pos + 22]);
                equipment[num].ammo_capacity = NumberFunctions.ParseByte(data[pos + 23]);
                equipment[num].weight = NumberFunctions.ParseByte(data[pos + 24]);
                equipment[num].destroyed = NumberFunctions.ParseInt(data[pos + 25]) == 1;
                equipment[num].explodes = NumberFunctions.ParseInt(data[pos + 26]) == 1;
                equipment[num].reload_cost = NumberFunctions.ParseInt(data[pos + 27]);
                equipment[num].indestructable = NumberFunctions.ParseByte(data[pos + 29]);
                equipment[num].last_unit_to_touch = NumberFunctions.ParseInt(data[pos + 30]);
                equipment[num].seen_by_side[1] = NumberFunctions.ParseByte(data[pos + 31]);
                equipment[num].seen_by_side[2] = NumberFunctions.ParseByte(data[pos + 32]);
                equipment[num].seen_by_side[3] = NumberFunctions.ParseByte(data[pos + 33]);
                equipment[num].seen_by_side[4] = NumberFunctions.ParseByte(data[pos + 34]);
                equipment[num].equipment_type_id = NumberFunctions.ParseInt(data[pos + 35]);
                equipment[num].range_sq = NumberFunctions.ParseByte(data[pos + 36]);
                try {
                    equipment[num].code = data[pos + 37];
                    equipment[num].primed_time = Long.parseLong(data[pos + 38]);
                    pos += 38;
                }
                catch (Exception ex) {
                    pos += 37;
                }
                if (equipment[num].last_unit_to_touch <= 0 && equipment[num].getUnitID() > 0) {
                    equipment[num].last_unit_to_touch = equipment[num].getUnitID();
                }
                if (!equipment[num].destroyed) {
                    if (equipment[num].getUnitID() > 0) {
                        UnitData unit = UnitData.GetUnitDataFromID(units, equipment[num].getUnitID());
                        unit.items.add(equipment[num]);
                        if (unit.current_item_id_TMP == equipment[num].equip_id) {
                            unit.current_item = equipment[num];
                        }
                    } else if (x >= 0 && y >= 0) {
                        if (map != null) {
                            map.getSq_MaybeNULL(x, y).addEquipment(equipment[num]);
                        }
                    } else {
                        equipment[num].destroyed = true;
                    }
                }
                ++num;
                continue;
            }
            ++pos;
        } while (pos < data.length);
        if (equipment == null) {
            throw new RuntimeException("Error decoding equipment data");
        }
        return equipment;
    }

    public static String GetEquipmentUpdateRequest(EquipmentData eq, int mapx, int mapy, int gameid) {
        StringBuffer str = new StringBuffer();
        str.append(String.valueOf(eq.equip_id) + "|");
        str.append(String.valueOf(eq.equipcode) + "|");
        str.append(String.valueOf(eq.getUnitID()) + "|");
        str.append(String.valueOf(mapx) + "|");
        str.append(String.valueOf(mapy) + "|");
        str.append(String.valueOf(eq.getAmmo()) + "|");
        str.append(String.valueOf(eq.explode_turns) + "|");
        str.append(String.valueOf(SQLFuncs.b201(eq.primed)) + "|");
        str.append(String.valueOf(SQLFuncs.b201(eq.destroyed)) + "|");
        str.append(String.valueOf(gameid) + "|");
        str.append(String.valueOf(eq.last_unit_to_touch) + "|");
        str.append(String.valueOf(eq.seen_by_side[1]) + "|");
        str.append(String.valueOf(eq.seen_by_side[2]) + "|");
        str.append(String.valueOf(eq.seen_by_side[3]) + "|");
        str.append(String.valueOf(eq.seen_by_side[4]) + "|");
        str.append(String.valueOf(System.currentTimeMillis()) + "|");
        str.append(String.valueOf(eq.new_item) + "|");
        str.append(String.valueOf(eq.equipment_type_id) + "|");
        str.append(String.valueOf(eq.primed_time) + "|");
        return "cmd=equipdata&version=" + Statics.COMMS_VERSION + "&getput=" + "put" + "&data=" + str.toString();
    }
}

