/*
 * Decompiled with CFR 0.152.
 */
package ssmith.awt;

import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public class ImageFunctions {
    private ImageFunctions() {
    }

    public static BufferedImage CombineBitmaps(BufferedImage image, BufferedImage overlay) {
        int w = Math.max(image.getWidth(), overlay.getWidth());
        int h = Math.max(image.getHeight(), overlay.getHeight());
        BufferedImage newBmp = new BufferedImage(w, h, 2);
        Graphics g = newBmp.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.drawImage(overlay, 0, 0, null);
        return newBmp;
    }

    public static BufferedImage Clone(BufferedImage bi) {
        BufferedImage bi2 = new BufferedImage(bi.getColorModel(), bi.copyData(null), bi.getColorModel().isAlphaPremultiplied(), null);
        return bi2;
    }

    public static BufferedImage Rotate(BufferedImage image, int angle, boolean b) {
        int w = image.getWidth();
        int h = image.getHeight();
        AffineTransform scaleTransform = new AffineTransform();
        scaleTransform.rotate(1.5707963267948966, w / 2, h / 2);
        AffineTransformOp scaleOp = new AffineTransformOp(scaleTransform, 2);
        BufferedImage newBI = scaleOp.filter(image, null);
        return newBI;
    }
}

