/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.algorithm;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import com.sun.xml.internal.fastinfoset.algorithm.BuiltInEncodingAlgorithm;
import com.sun.xml.internal.org.jvnet.fastinfoset.EncodingAlgorithmException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HexadecimalEncodingAlgorithm
extends BuiltInEncodingAlgorithm {
    private static final char[] NIBBLE_TO_HEXADECIMAL_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int[] HEXADECIMAL_TO_NIBBLE_TABLE = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};

    @Override
    public final Object decodeFromBytes(byte[] byArray, int n, int n2) throws EncodingAlgorithmException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    @Override
    public final Object decodeFromInputStream(InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException(CommonResourceBundle.getInstance().getString("message.notImplemented"));
    }

    @Override
    public void encodeToOutputStream(Object object, OutputStream outputStream) throws IOException {
        if (!(object instanceof byte[])) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.dataNotByteArray"));
        }
        outputStream.write((byte[])object);
    }

    @Override
    public final Object convertFromCharacters(char[] cArray, int n, int n2) {
        if (n2 == 0) {
            return new byte[0];
        }
        StringBuilder stringBuilder = this.removeWhitespace(cArray, n, n2);
        int n3 = stringBuilder.length();
        if (n3 == 0) {
            return new byte[0];
        }
        int n4 = stringBuilder.length() / 2;
        byte[] byArray = new byte[n4];
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            int n6 = HEXADECIMAL_TO_NIBBLE_TABLE[stringBuilder.charAt(n5++) - 48];
            int n7 = HEXADECIMAL_TO_NIBBLE_TABLE[stringBuilder.charAt(n5++) - 48];
            byArray[i] = (byte)(n6 << 4 | n7);
        }
        return byArray;
    }

    @Override
    public final void convertToCharacters(Object object, StringBuffer stringBuffer) {
        if (object == null) {
            return;
        }
        byte[] byArray = (byte[])object;
        if (byArray.length == 0) {
            return;
        }
        stringBuffer.ensureCapacity(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(NIBBLE_TO_HEXADECIMAL_TABLE[byArray[i] >>> 4 & 0xF]);
            stringBuffer.append(NIBBLE_TO_HEXADECIMAL_TABLE[byArray[i] & 0xF]);
        }
    }

    @Override
    public final int getPrimtiveLengthFromOctetLength(int n) throws EncodingAlgorithmException {
        return n * 2;
    }

    @Override
    public int getOctetLengthFromPrimitiveLength(int n) {
        return n / 2;
    }

    @Override
    public final void encodeToBytes(Object object, int n, int n2, byte[] byArray, int n3) {
        System.arraycopy((byte[])object, n, byArray, n3, n2);
    }
}

