/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client;

import com.sun.xml.internal.ws.util.JAXWSUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceException;

final class SCAnnotations {
    final ArrayList<QName> portQNames = new ArrayList();
    final ArrayList<Class> classes = new ArrayList();

    SCAnnotations(final Class<?> clazz) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                WebServiceClient webServiceClient = clazz.getAnnotation(WebServiceClient.class);
                if (webServiceClient == null) {
                    throw new WebServiceException("Service Interface Annotations required, exiting...");
                }
                String string = webServiceClient.targetNamespace();
                try {
                    JAXWSUtils.getFileOrURL(webServiceClient.wsdlLocation());
                }
                catch (IOException iOException) {
                    throw new WebServiceException(iOException);
                }
                for (Method method : clazz.getDeclaredMethods()) {
                    Object object;
                    WebEndpoint webEndpoint = method.getAnnotation(WebEndpoint.class);
                    if (webEndpoint != null) {
                        object = webEndpoint.name();
                        QName qName = new QName(string, (String)object);
                        SCAnnotations.this.portQNames.add(qName);
                    }
                    if ((object = method.getReturnType()) == Void.TYPE) continue;
                    SCAnnotations.this.classes.add((Class)object);
                }
                return null;
            }
        });
    }
}

