/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client.sei;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

class MethodUtil {
    private static final Logger LOGGER;
    private static final Method INVOKE_METHOD;

    MethodUtil() {
    }

    static Object invoke(Object object, Method method, Object[] objectArray) throws IllegalAccessException, InvocationTargetException {
        if (INVOKE_METHOD != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Invoking method using sun.reflect.misc.MethodUtil");
            }
            try {
                return INVOKE_METHOD.invoke(null, method, object, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw MethodUtil.unwrapException(invocationTargetException);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Invoking method directly, probably non-Oracle JVM");
        }
        return method.invoke(object, objectArray);
    }

    private static InvocationTargetException unwrapException(InvocationTargetException invocationTargetException) {
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable != null && throwable instanceof InvocationTargetException) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unwrapping invocation target exception");
            }
            return (InvocationTargetException)throwable;
        }
        return invocationTargetException;
    }

    static {
        Method method;
        block3: {
            LOGGER = Logger.getLogger(MethodUtil.class.getName());
            try {
                Class<?> clazz = Class.forName("sun.reflect.misc.MethodUtil");
                method = clazz.getMethod("invoke", Method.class, Object.class, Object[].class);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Class sun.reflect.misc.MethodUtil found; it will be used to invoke methods.");
                }
            }
            catch (Throwable throwable) {
                method = null;
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.log(Level.FINE, "Class sun.reflect.misc.MethodUtil not found, probably non-Oracle JVM");
            }
        }
        INVOKE_METHOD = method;
    }
}

