/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.runtime.config;

import com.sun.istack.internal.logging.Logger;
import com.sun.xml.internal.ws.config.metro.dev.FeatureReader;
import com.sun.xml.internal.ws.config.metro.util.ParserUtil;
import com.sun.xml.internal.ws.runtime.config.TubelineFeature;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.ws.WebServiceException;

public class TubelineFeatureReader
implements FeatureReader {
    private static final Logger LOGGER = Logger.getLogger(TubelineFeatureReader.class);
    private static final QName NAME_ATTRIBUTE_NAME = new QName("name");

    public TubelineFeature parse(XMLEventReader xMLEventReader) throws WebServiceException {
        try {
            StartElement startElement = xMLEventReader.nextEvent().asStartElement();
            boolean bl = true;
            Iterator iterator = startElement.getAttributes();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                QName qName = attribute.getName();
                if (ENABLED_ATTRIBUTE_NAME.equals(qName)) {
                    bl = ParserUtil.parseBooleanValue(attribute.getValue());
                    continue;
                }
                if (NAME_ATTRIBUTE_NAME.equals(qName)) continue;
                throw LOGGER.logSevereException(new WebServiceException("Unexpected attribute"));
            }
            return this.parseFactories(bl, startElement, xMLEventReader);
        }
        catch (XMLStreamException xMLStreamException) {
            throw LOGGER.logSevereException(new WebServiceException("Failed to unmarshal XML document", xMLStreamException));
        }
    }

    private TubelineFeature parseFactories(boolean bl, StartElement startElement, XMLEventReader xMLEventReader) throws WebServiceException {
        int n = 0;
        block8: while (xMLEventReader.hasNext()) {
            try {
                XMLEvent xMLEvent = xMLEventReader.nextEvent();
                switch (xMLEvent.getEventType()) {
                    case 5: {
                        break;
                    }
                    case 4: {
                        if (xMLEvent.asCharacters().isWhiteSpace()) break;
                        throw LOGGER.logSevereException(new WebServiceException("No character data allowed, was " + xMLEvent.asCharacters()));
                    }
                    case 1: {
                        ++n;
                        break;
                    }
                    case 2: {
                        if (--n >= 0) continue block8;
                        EndElement endElement = xMLEvent.asEndElement();
                        if (startElement.getName().equals(endElement.getName())) break block8;
                        throw LOGGER.logSevereException(new WebServiceException("End element does not match " + endElement));
                    }
                    default: {
                        throw LOGGER.logSevereException(new WebServiceException("Unexpected event, was " + xMLEvent));
                    }
                }
            }
            catch (XMLStreamException xMLStreamException) {
                throw LOGGER.logSevereException(new WebServiceException("Failed to unmarshal XML document", xMLStreamException));
            }
        }
        return new TubelineFeature(bl);
    }
}

