/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.tools;

import com.sun.xml.internal.fastinfoset.QualifiedName;
import com.sun.xml.internal.fastinfoset.tools.VocabularyGenerator;
import com.sun.xml.internal.fastinfoset.util.CharArrayArray;
import com.sun.xml.internal.fastinfoset.util.ContiguousCharArrayArray;
import com.sun.xml.internal.fastinfoset.util.PrefixArray;
import com.sun.xml.internal.fastinfoset.util.QualifiedNameArray;
import com.sun.xml.internal.fastinfoset.util.StringArray;
import com.sun.xml.internal.fastinfoset.vocab.ParserVocabulary;
import java.io.File;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class PrintTable {
    public static void printVocabulary(ParserVocabulary parserVocabulary) {
        PrintTable.printArray("Attribute Name Table", parserVocabulary.attributeName);
        PrintTable.printArray("Attribute Value Table", parserVocabulary.attributeValue);
        PrintTable.printArray("Character Content Chunk Table", parserVocabulary.characterContentChunk);
        PrintTable.printArray("Element Name Table", parserVocabulary.elementName);
        PrintTable.printArray("Local Name Table", parserVocabulary.localName);
        PrintTable.printArray("Namespace Name Table", parserVocabulary.namespaceName);
        PrintTable.printArray("Other NCName Table", parserVocabulary.otherNCName);
        PrintTable.printArray("Other String Table", parserVocabulary.otherString);
        PrintTable.printArray("Other URI Table", parserVocabulary.otherURI);
        PrintTable.printArray("Prefix Table", parserVocabulary.prefix);
    }

    public static void printArray(String string, StringArray stringArray) {
        System.out.println(string);
        for (int i = 0; i < stringArray.getSize(); ++i) {
            System.out.println("" + (i + 1) + ": " + stringArray.getArray()[i]);
        }
    }

    public static void printArray(String string, PrefixArray prefixArray) {
        System.out.println(string);
        for (int i = 0; i < prefixArray.getSize(); ++i) {
            System.out.println("" + (i + 1) + ": " + prefixArray.getArray()[i]);
        }
    }

    public static void printArray(String string, CharArrayArray charArrayArray) {
        System.out.println(string);
        for (int i = 0; i < charArrayArray.getSize(); ++i) {
            System.out.println("" + (i + 1) + ": " + charArrayArray.getArray()[i]);
        }
    }

    public static void printArray(String string, ContiguousCharArrayArray contiguousCharArrayArray) {
        System.out.println(string);
        for (int i = 0; i < contiguousCharArrayArray.getSize(); ++i) {
            System.out.println("" + (i + 1) + ": " + contiguousCharArrayArray.getString(i));
        }
    }

    public static void printArray(String string, QualifiedNameArray qualifiedNameArray) {
        System.out.println(string);
        for (int i = 0; i < qualifiedNameArray.getSize(); ++i) {
            QualifiedName qualifiedName = qualifiedNameArray.getArray()[i];
            System.out.println("" + (qualifiedName.index + 1) + ": {" + qualifiedName.namespaceName + "}" + qualifiedName.prefix + ":" + qualifiedName.localName);
        }
    }

    public static void main(String[] stringArray) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            ParserVocabulary parserVocabulary = new ParserVocabulary();
            VocabularyGenerator vocabularyGenerator = new VocabularyGenerator(parserVocabulary);
            File file = new File(stringArray[0]);
            sAXParser.parse(file, (DefaultHandler)vocabularyGenerator);
            PrintTable.printVocabulary(parserVocabulary);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

