/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.server;

import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.server.InstanceResolver;
import com.sun.xml.internal.ws.api.server.MethodUtil;
import com.sun.xml.internal.ws.api.server.ResourceInjector;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.resources.ServerMessages;
import com.sun.xml.internal.ws.server.ServerRtException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class AbstractInstanceResolver<T>
extends InstanceResolver<T> {
    protected static ResourceInjector getResourceInjector(WSEndpoint wSEndpoint) {
        ResourceInjector resourceInjector = wSEndpoint.getContainer().getSPI(ResourceInjector.class);
        if (resourceInjector == null) {
            resourceInjector = ResourceInjector.STANDALONE;
        }
        return resourceInjector;
    }

    protected static void invokeMethod(final @Nullable Method method, final Object object, final Object ... objectArray) {
        if (method == null) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    MethodUtil.invoke(object, method, objectArray);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new ServerRtException("server.rt.err", new Object[]{illegalAccessException});
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new ServerRtException("server.rt.err", new Object[]{invocationTargetException});
                }
                return null;
            }
        });
    }

    @Nullable
    protected final Method findAnnotatedMethod(Class clazz, Class<? extends Annotation> clazz2) {
        boolean bl = false;
        Method method = null;
        for (Method method2 : clazz.getDeclaredMethods()) {
            if (method2.getAnnotation(clazz2) == null) continue;
            if (bl) {
                throw new ServerRtException(ServerMessages.ANNOTATION_ONLY_ONCE(clazz2), new Object[0]);
            }
            if (method2.getParameterTypes().length != 0) {
                throw new ServerRtException(ServerMessages.NOT_ZERO_PARAMETERS(method2), new Object[0]);
            }
            method = method2;
            bl = true;
        }
        return method;
    }
}

