/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.nio.file.InvalidPathException;
import sun.nio.fs.WindowsPathType;

class WindowsPathParser {
    private static final String reservedChars = "<>:\"|?*";

    private WindowsPathParser() {
    }

    static Result parse(String string) {
        return WindowsPathParser.parse(string, true);
    }

    static Result parseNormalizedPath(String string) {
        return WindowsPathParser.parse(string, false);
    }

    private static Result parse(String string, boolean bl) {
        String string2 = "";
        WindowsPathType windowsPathType = null;
        int n = string.length();
        int n2 = 0;
        if (n > 1) {
            char c = string.charAt(0);
            char c2 = string.charAt(1);
            boolean bl2 = false;
            int n3 = 2;
            if (WindowsPathParser.isSlash(c) && WindowsPathParser.isSlash(c2)) {
                windowsPathType = WindowsPathType.UNC;
                n2 = WindowsPathParser.nextNonSlash(string, n3, n);
                if (n2 == (n3 = WindowsPathParser.nextSlash(string, n2, n))) {
                    throw new InvalidPathException(string, "UNC path is missing hostname");
                }
                String string3 = string.substring(n2, n3);
                n2 = WindowsPathParser.nextNonSlash(string, n3, n);
                if (n2 == (n3 = WindowsPathParser.nextSlash(string, n2, n))) {
                    throw new InvalidPathException(string, "UNC path is missing sharename");
                }
                string2 = "\\\\" + string3 + "\\" + string.substring(n2, n3) + "\\";
                n2 = n3;
            } else if (WindowsPathParser.isLetter(c) && c2 == ':') {
                char c3;
                if (n > 2 && WindowsPathParser.isSlash(c3 = string.charAt(2))) {
                    string2 = c3 == '\\' ? string.substring(0, 3) : string.substring(0, 2) + '\\';
                    n2 = 3;
                    windowsPathType = WindowsPathType.ABSOLUTE;
                } else {
                    string2 = string.substring(0, 2);
                    n2 = 2;
                    windowsPathType = WindowsPathType.DRIVE_RELATIVE;
                }
            }
        }
        if (n2 == 0) {
            if (n > 0 && WindowsPathParser.isSlash(string.charAt(0))) {
                windowsPathType = WindowsPathType.DIRECTORY_RELATIVE;
                string2 = "\\";
            } else {
                windowsPathType = WindowsPathType.RELATIVE;
            }
        }
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder(string.length());
            stringBuilder.append(string2);
            return new Result(windowsPathType, string2, WindowsPathParser.normalize(stringBuilder, string, n2));
        }
        return new Result(windowsPathType, string2, string);
    }

    private static String normalize(StringBuilder stringBuilder, String string, int n) {
        int n2 = string.length();
        int n3 = n = WindowsPathParser.nextNonSlash(string, n, n2);
        char c = '\u0000';
        while (n < n2) {
            char c2 = string.charAt(n);
            if (WindowsPathParser.isSlash(c2)) {
                if (c == ' ') {
                    throw new InvalidPathException(string, "Trailing char <" + c + ">", n - 1);
                }
                stringBuilder.append(string, n3, n);
                n = WindowsPathParser.nextNonSlash(string, n, n2);
                if (n != n2) {
                    stringBuilder.append('\\');
                }
                n3 = n;
                continue;
            }
            if (WindowsPathParser.isInvalidPathChar(c2)) {
                throw new InvalidPathException(string, "Illegal char <" + c2 + ">", n);
            }
            c = c2;
            ++n;
        }
        if (n3 != n) {
            if (c == ' ') {
                throw new InvalidPathException(string, "Trailing char <" + c + ">", n - 1);
            }
            stringBuilder.append(string, n3, n);
        }
        return stringBuilder.toString();
    }

    private static final boolean isSlash(char c) {
        return c == '\\' || c == '/';
    }

    private static final int nextNonSlash(String string, int n, int n2) {
        while (n < n2 && WindowsPathParser.isSlash(string.charAt(n))) {
            ++n;
        }
        return n;
    }

    private static final int nextSlash(String string, int n, int n2) {
        char c;
        while (n < n2 && !WindowsPathParser.isSlash(c = string.charAt(n))) {
            if (WindowsPathParser.isInvalidPathChar(c)) {
                throw new InvalidPathException(string, "Illegal character [" + c + "] in path", n);
            }
            ++n;
        }
        return n;
    }

    private static final boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static final boolean isInvalidPathChar(char c) {
        return c < ' ' || reservedChars.indexOf(c) != -1;
    }

    static class Result {
        private final WindowsPathType type;
        private final String root;
        private final String path;

        Result(WindowsPathType windowsPathType, String string, String string2) {
            this.type = windowsPathType;
            this.root = string;
            this.path = string2;
        }

        WindowsPathType type() {
            return this.type;
        }

        String root() {
            return this.root;
        }

        String path() {
            return this.path;
        }
    }
}

