/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.config.Config;
import com.sun.deploy.panel.JHighDPITable;
import com.sun.deploy.panel.JSmartTextArea;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.ui.DialogTemplate;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableRowSorter;

public class ExceptionListDialog
extends JDialog
implements ActionListener,
ChangeListener,
ListSelectionListener {
    private JButton _addBtn;
    private JButton _removeBtn;
    private JButton _okBtn;
    private JButton _cancelBtn;
    private EListTableModel _exceptionTableModel;
    private ETable _exceptionTable;
    private JScrollPane _sp;
    private JTextArea _emptyViewComponent;
    private URLEditor _exceptionTableEditor;

    public ExceptionListDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
    }

    private void initComponents() {
        Box box = Box.createVerticalBox();
        this._addBtn = this.makeButton("jcp.add.button");
        this._removeBtn = this.makeButton("jcp.remove.button");
        this._okBtn = new JButton(ExceptionListDialog.getMessage("deploy.jre.ok.button"));
        this._okBtn.addActionListener(this);
        this._cancelBtn = new JButton(ExceptionListDialog.getMessage("deploy.jre.cancel.button"));
        this._cancelBtn.addActionListener(this);
        this._exceptionTableModel = new EListTableModel();
        this._exceptionTable = new ETable(this._exceptionTableModel);
        this._exceptionTable.setRowSorter(new TableRowSorter<EListTableModel>(this._exceptionTableModel));
        this._sp = new JScrollPane();
        this._sp.setViewportView(this._exceptionTable);
        this._emptyViewComponent = new EmptyText();
        this.setTitle(ExceptionListDialog.getMessage("jcp.exception.list.title"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ExceptionListDialog.this.closeDialog();
            }
        });
        this._addBtn.setToolTipText(ExceptionListDialog.getMessage("jcp.add.button.tooltip"));
        this._removeBtn.setToolTipText(ExceptionListDialog.getMessage("jcp.remove.button.tooltip"));
        JButton[] jButtonArray = new JButton[]{this._addBtn, this._removeBtn};
        DialogTemplate.resizeButtons(jButtonArray);
        Dimension dimension = new Dimension(400, 160);
        this._exceptionTable.setBorder(new LineBorder(this._exceptionTable.getForeground()));
        this._exceptionTable.setPreferredScrollableViewportSize(dimension);
        this._exceptionTable.setFillsViewportHeight(true);
        JLabel jLabel = new JLabel(ExceptionListDialog.getMessage("jcp.exception.list.title"));
        jLabel.setLabelFor(this._exceptionTable);
        Box box2 = Box.createHorizontalBox();
        box2.add(Box.createHorizontalGlue());
        box2.add(this._addBtn);
        box2.add(Box.createHorizontalStrut(5));
        box2.add(this._removeBtn);
        box2.setBorder(new EmptyBorder(0, 0, 6, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JSmartTextArea jSmartTextArea = new JSmartTextArea(ExceptionListDialog.getMessage("jcp.exception.list.text"));
        jSmartTextArea.setBorder(new EmptyBorder(15, 15, 15, 15));
        jSmartTextArea.setColumns(40);
        jPanel.add(jSmartTextArea);
        box.add(jPanel);
        Box box3 = Box.createHorizontalBox();
        box3.setBorder(new EmptyBorder(0, 15, 0, 15));
        box3.add(this._sp);
        box.add(box3);
        box2.setBorder(new EmptyBorder(0, 15, 0, 15));
        box.add(box2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2, 10, 5));
        JButton[] jButtonArray2 = new JButton[]{this._okBtn, this._cancelBtn};
        DialogTemplate.resizeButtons(jButtonArray2);
        jPanel2.add(this._okBtn);
        jPanel2.add(this._cancelBtn);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(new EmptyBorder(0, 15, 15, 15));
        JSmartTextArea jSmartTextArea2 = new JSmartTextArea(ExceptionListDialog.getMessage("jcp.exception.list.detail"));
        jSmartTextArea2.setLineWrap(false);
        URL uRL = ClassLoader.getSystemResource("com/sun/deploy/resources/image/open_lock16.png");
        JLabel jLabel2 = new JLabel(new ImageIcon(uRL));
        jLabel2.setVerticalAlignment(1);
        jLabel2.setBorder(new EmptyBorder(0, 5, 5, 5));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jLabel2, "North");
        jPanel3.add((Component)jPanel4, "West");
        jPanel3.add((Component)jSmartTextArea2, "Center");
        box.add(jPanel3);
        box.add(jPanel2);
        this.getRootPane().setDefaultButton(this._okBtn);
        this.getContentPane().add((Component)box, "Center");
        this._exceptionTable.getSelectionModel().addListSelectionListener(this);
        this._exceptionTable.getColumnModel().getColumn(1).setCellRenderer(new URLRenderer("https://www.example.com/dir/ or https://www.example.com/app.html"));
        this._exceptionTableEditor = new URLEditor();
        this._exceptionTable.getColumnModel().getColumn(1).setCellEditor(this._exceptionTableEditor);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().getActionMap().put("cancel", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExceptionListDialog.this.closeDialog();
            }
        });
        this._exceptionTable.getTableHeader().setFocusable(false);
        this.pack();
        this.enableButtons();
    }

    private static boolean canWrite() {
        File file = Config.getExceptionSitesFile();
        if (file != null) {
            if (file.canWrite()) {
                return true;
            }
            File file2 = file.getParentFile();
            if (!file.exists() && file2 != null) {
                return file2.canWrite();
            }
        }
        return false;
    }

    private JButton makeButton(String string) {
        JButton jButton = new JButton(ExceptionListDialog.getMessage(string));
        jButton.setMnemonic(ResourceManager.getMnemonic(string));
        jButton.addActionListener(this);
        return jButton;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.enableButtons();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.enableButtons();
    }

    private void enableButtons() {
        int n;
        boolean bl = false;
        if (this._exceptionTableModel.isEmpty()) {
            this._sp.setViewportView(this._emptyViewComponent);
            this._sp.setHorizontalScrollBarPolicy(31);
            this._sp.setVerticalScrollBarPolicy(21);
        } else {
            this._sp.setViewportView(this._exceptionTable);
            this._sp.setHorizontalScrollBarPolicy(30);
            this._sp.setVerticalScrollBarPolicy(20);
            for (n = 0; n < this._exceptionTableModel.getRowCount(); ++n) {
                if (!this._exceptionTable.isRowSelected(n)) continue;
                bl = true;
            }
        }
        n = ExceptionListDialog.canWrite();
        this._removeBtn.setEnabled(n != 0 && bl);
        this._addBtn.setEnabled(n != 0);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        if (jButton == this._cancelBtn) {
            this._exceptionTable._canceled = true;
        }
        this._exceptionTableEditor.stopCellEditing();
        ETable eTable = this._exceptionTable;
        EListTableModel eListTableModel = (EListTableModel)eTable.getModel();
        if (jButton == this._addBtn) {
            eListTableModel.add();
            int n = eListTableModel.getRowCount() - 1;
            n = eTable.convertRowIndexToModel(n);
            eTable.setRowSelectionInterval(n, n);
            eTable.editCellAt(n, 1);
            eTable.requestFocus();
        } else if (jButton == this._removeBtn) {
            int n;
            int[] nArray = this._exceptionTable.getSelectedRows();
            if (nArray != null) {
                for (n = 0; n < nArray.length; ++n) {
                    nArray[n] = eTable.convertRowIndexToModel(nArray[n]);
                }
            }
            if (nArray != null && nArray.length > 0) {
                n = nArray[0];
                eListTableModel.remove(nArray);
                int n2 = eListTableModel.getRowCount();
                if (n < n2) {
                    eTable.setRowSelectionInterval(n, n);
                    eTable.editCellAt(n, 1);
                    eTable.requestFocus();
                } else if (n2 > 0) {
                    eTable.setRowSelectionInterval(n - 1, n - 1);
                    eTable.editCellAt(n - 1, 1);
                    eTable.requestFocus();
                }
            }
        } else if (jButton == this._okBtn) {
            this.apply();
            this.closeDialog();
        } else if (jButton == this._cancelBtn) {
            this.closeDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apply() {
        ArrayList arrayList = this._exceptionTableModel.getConfirmed();
        File file = Config.getExceptionSitesFile();
        try {
            PrintStream printStream = new PrintStream(file);
            try {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string = (String)arrayList.get(i);
                    if (string == null || string.length() <= 0) continue;
                    printStream.println(string.trim());
                }
                Object var7_7 = null;
                if (printStream != null) {
                    printStream.close();
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (printStream != null) {
                    printStream.close();
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            Trace.ignored(exception);
        }
    }

    private boolean isValid(URL uRL) {
        return "file".equalsIgnoreCase(uRL.getProtocol()) ? uRL.getPath() != null && uRL.getPath().length() > 0 : ("http".equalsIgnoreCase(uRL.getProtocol()) || "https".equalsIgnoreCase(uRL.getProtocol())) && uRL.getHost() != null && uRL.getHost().length() > 0;
    }

    private static String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    private class EListTableModel
    extends AbstractTableModel {
        private ArrayList _elistData = new ArrayList();
        private ArrayList _elistConfirmed;
        private ImageIcon unlockImage = null;
        private ImageIcon invalidImage = null;

        public EListTableModel() {
            Object[] objectArray = Config.getExceptionSites();
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                try {
                    new URL((String)objectArray[i]);
                    if (this._elistData.contains(objectArray[i])) continue;
                    this._elistData.add(objectArray[i]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this._elistConfirmed = (ArrayList)this._elistData.clone();
            URL uRL = ClassLoader.getSystemResource("com/sun/deploy/resources/image/open_lock16.png");
            this.unlockImage = new ImageIcon(uRL, ExceptionListDialog.getMessage("jcp.exception.list.valid_image"));
            uRL = ClassLoader.getSystemResource("com/sun/deploy/resources/image/edit_error16.png");
            this.invalidImage = new ImageIcon(uRL, ExceptionListDialog.getMessage("jcp.exception.list.invalid_image"));
        }

        public boolean isEmpty() {
            return this._elistData.size() == 0;
        }

        public boolean contains(String string) {
            for (int i = 0; i < this._elistConfirmed.size(); ++i) {
                String string2 = (String)this._elistConfirmed.get(i);
                if (!(string2 == null ? string == null : string2.equals(string))) continue;
                return true;
            }
            return false;
        }

        public Object getValueAt(int n, int n2) {
            String string = (String)this._elistData.get(n);
            boolean bl = false;
            boolean bl2 = false;
            URL uRL = null;
            try {
                uRL = new URL(string);
                bl = "https".equalsIgnoreCase(uRL.getProtocol());
                bl2 = ExceptionListDialog.this.isValid(uRL);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            switch (n2) {
                default: {
                    if (bl2 && bl) {
                        return null;
                    }
                    if (bl2) {
                        return this.unlockImage;
                    }
                    return this.invalidImage;
                }
                case 1: 
            }
            return string;
        }

        public boolean isCellEditable(int n, int n2) {
            return ExceptionListDialog.canWrite() && n2 == 1;
        }

        public Class getColumnClass(int n) {
            return n == 0 ? ImageIcon.class : String.class;
        }

        void add() {
            for (int i = this._elistData.size() - 1; i >= 0; --i) {
                String string = (String)this._elistData.get(i);
                if (string != null && string.length() != 0) continue;
                this._elistData.remove(i);
                this._elistConfirmed.remove(i);
                this.fireTableDataChanged();
            }
            this._elistData.add("");
            this._elistConfirmed.add("");
            this.fireTableRowsInserted(this._elistData.size() - 1, this._elistData.size() - 1);
            this.fireTableDataChanged();
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return this._elistData.size();
        }

        public String getColumnName(int n) {
            if (n == 1) {
                return ExceptionListDialog.getMessage("jcp.exception.list.location");
            }
            if (n == 0) {
                return ExceptionListDialog.getMessage("jcp.exception.list.url");
            }
            return "";
        }

        void remove(int[] nArray) {
            if (nArray != null) {
                int n = this.getRowCount();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    if (nArray[i] == -1 || nArray[i] >= n) continue;
                    this._elistData.remove(nArray[i]);
                    this._elistConfirmed.remove(nArray[i]);
                }
            }
            this.fireTableDataChanged();
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n >= 0 && n < this._elistData.size() && n2 == 1 && object != null && object instanceof String) {
                this._elistData.set(n, (String)object);
                this.fireTableRowsUpdated(n, n);
            }
        }

        public void confirm(int n) {
            if (n < this._elistData.size() && n < this._elistConfirmed.size()) {
                this._elistConfirmed.set(n, this._elistData.get(n));
            }
        }

        public boolean revert(int n) {
            boolean bl = false;
            if (n < this._elistData.size() && n < this._elistConfirmed.size()) {
                String string = (String)this._elistConfirmed.get(n);
                if (string != null && string.length() > 0) {
                    this._elistData.set(n, this._elistConfirmed.get(n));
                    this.fireTableRowsUpdated(n, n);
                    this.fireTableDataChanged();
                } else {
                    if (n >= 0 && n < this._elistData.size()) {
                        this._elistData.remove(n);
                        this._elistConfirmed.remove(n);
                        bl = true;
                    }
                    this.fireTableDataChanged();
                }
            }
            return bl;
        }

        public ArrayList getConfirmed() {
            return (ArrayList)this._elistConfirmed.clone();
        }

        public boolean rowChanged(int n) {
            if (n < this._elistData.size() && n < this._elistConfirmed.size()) {
                return !this._elistData.get(n).equals(this._elistConfirmed.get(n));
            }
            return false;
        }
    }

    private class ETable
    extends JHighDPITable {
        public boolean _canceled;

        public ETable(AbstractTableModel abstractTableModel) {
            super(abstractTableModel);
            this._canceled = false;
            this.columnModel.getColumn(0).setPreferredWidth(24);
            this.columnModel.getColumn(0).setMaxWidth(24);
            this.columnModel.getColumn(0).setResizable(false);
            this.columnModel.getColumn(1).setPreferredWidth(460);
        }
    }

    private class EmptyText
    extends JTextArea {
        public EmptyText() {
            super(ExceptionListDialog.getMessage("jcp.exception.list.add.text"));
            this.setForeground(Color.GRAY);
            this.setBackground(ExceptionListDialog.this._exceptionTable.getBackground());
            this.setOpaque(true);
            this.setEditable(false);
            this.setFocusable(false);
            this.setFont(new JLabel().getFont());
            this.setWrapStyleWord(true);
            this.setLineWrap(true);
        }

        public Dimension getPreferredSize() {
            return new Dimension(1000, 1000);
        }
    }

    public class IconRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, false, false, n, n2);
            return component;
        }
    }

    public class PromptTextField
    extends JFormattedTextField {
        private String prompt = "";

        public void setPrompt(String string) {
            this.prompt = string;
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            String string = this.getText();
            if ((string == null || string.trim().isEmpty()) && !this.prompt.isEmpty()) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics2D.setColor(Color.GRAY);
                graphics2D.setFont(this.getFont().deriveFont(0));
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                graphics2D.drawString(this.prompt, 3, fontMetrics.getHeight() - 4);
                graphics2D.dispose();
            }
        }
    }

    private class URLEditor
    extends DefaultCellEditor
    implements DocumentListener {
        private int row;
        private Border border;
        private JTable table;
        private EListTableModel model;
        private JFormattedTextField ftf;

        URLEditor() {
            super(new PromptTextField());
            this.border = new LineBorder(Color.black);
            this.ftf = (JFormattedTextField)this.getComponent();
            this.ftf.getDocument().addDocumentListener(this);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            jTable.getTableHeader().setResizingAllowed(false);
            this.row = jTable.convertRowIndexToModel(n);
            this.table = jTable;
            this.model = (EListTableModel)jTable.getModel();
            PromptTextField promptTextField = (PromptTextField)super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            if (n2 == 1 && promptTextField.getText().isEmpty()) {
                promptTextField.setPrompt("https://www.example.com/dir/ or https://www.example.com/app.html");
            } else {
                promptTextField.setPrompt("");
            }
            promptTextField.setBorder(this.border);
            return promptTextField;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateBorderFromEditor();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateBorderFromEditor();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private void updateBorderFromEditor() {
            Object object = this.getCellEditorValue();
            if (object instanceof String) {
                this.model.setValueAt(object, this.row, 1);
            }
        }

        public boolean stopCellEditing() {
            Object object = this.getCellEditorValue();
            boolean bl = super.stopCellEditing();
            ETable eTable = (ETable)this.table;
            if (this.table != null && this.model != null && object != null && object instanceof String && this.model.rowChanged(this.row)) {
                if (eTable._canceled) {
                    return bl;
                }
                boolean bl2 = false;
                try {
                    URL uRL = new URL((String)object);
                    boolean bl3 = "https".equalsIgnoreCase(uRL.getProtocol());
                    boolean bl4 = ExceptionListDialog.this.isValid(uRL);
                    if (!this.model.contains((String)object)) {
                        if (bl4 && bl3) {
                            bl2 = true;
                        } else if (bl4) {
                            bl2 = this.showConfirmDialog(uRL);
                        }
                    }
                }
                catch (Exception exception) {
                    Trace.ignored(exception);
                }
                if (bl2) {
                    this.model.confirm(this.row);
                } else {
                    boolean bl5 = this.model.revert(this.row);
                    if (bl5 && this.row < this.model.getRowCount()) {
                        this.table.setRowSelectionInterval(this.row, this.row);
                        this.table.editCellAt(this.row, 1);
                    }
                }
                this.table.getTableHeader().setResizingAllowed(true);
            }
            return bl;
        }

        private boolean showConfirmDialog(URL uRL) {
            AppInfo appInfo = new AppInfo();
            String string = ExceptionListDialog.getMessage("jcp.exception.list.confirm.title");
            String string2 = ExceptionListDialog.getMessage("jcp.exception.list.confirm.masthead");
            String string3 = ExceptionListDialog.getMessage("jcp.exception.list.confirm.message");
            if ("file".equalsIgnoreCase(uRL.getProtocol())) {
                string = ExceptionListDialog.getMessage("jcp.exception.list.confirm.file.title");
                string2 = ExceptionListDialog.getMessage("jcp.exception.list.confirm.file.masthead");
                string3 = ExceptionListDialog.getMessage("jcp.exception.list.confirm.file.message");
            }
            appInfo.setFrom(uRL);
            appInfo.setTitle("");
            int n = ToolkitStore.getUI().showMessageDialog(this.table.getTopLevelAncestor(), appInfo, 2, string, string2, string3, null, ExceptionListDialog.getMessage("common.continue_btn"), ExceptionListDialog.getMessage("common.cancel_btn"), null, null, null, 1);
            return n == 0;
        }
    }

    public class URLRenderer
    extends DefaultTableCellRenderer {
        private Border border = new LineBorder(Color.black);
        private String prompt;

        public URLRenderer(String string) {
            this.prompt = "<html><font color=gray>" + string + "</font></html>";
        }

        public void setValue(Object object) {
            String string = object == null ? "" : object.toString();
            this.setText(string.isEmpty() ? this.prompt : string);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Serializable serializable;
            if (jTable.getModel() instanceof EListTableModel && (serializable = (EListTableModel)jTable.getModel()).isEmpty()) {
                bl = false;
                bl2 = false;
            }
            if ((serializable = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2)) instanceof JComponent && jTable.getModel() instanceof EListTableModel) {
                ((JComponent)serializable).setBorder(this.border);
            }
            if (serializable instanceof JComponent) {
                String string = null;
                if (object != null) {
                    string = object.toString();
                }
                ((JComponent)serializable).setToolTipText(string);
            }
            return serializable;
        }
    }
}

