#pragma once
#include <string>
#include <vector>
#include <sstream>
#include <iostream>
#include <algorithm>
#include "curllib/curl.h"

//define this if compiling for mac
//#define MAC_VERSION

//compile with curl and networking libraries,
//	for windows: curllib.lib ws2_32.lib winmm.lib
//	current curllib.lib with these files are static build and require the following pre-processor definition: CURL_STATICLIB
//  add /NODEFAULTLIB:LIBCMT.lib if using the dll runtime (which is required for allegro)


//this is a highscore.
//	gethighscores returns an array (vector) of these
//	submithighscore can use one of these to store a high-score
struct HighScoreEntry
{
	std::string name;
	long score1;
	long score2;
	long score3;
	long score4;
	std::string date;
	HighScoreEntry() { score1=score2=score3=score4=0;date=name="";}
	HighScoreEntry(const std::string& _name,long _score1, long _score2, long _score3, long _score4, const std::string& _date) : name(_name), score1(_score1), score2(_score2),score3(_score3),score4(_score4),date(_date) {};
};


//core functions

//get a list of highscores (optionally sorted) for a game - errorcode is populated when an error occurs with friendly text
std::vector<HighScoreEntry> GetHighScores(const std::string& gameid,int numentries,int sortScore1, int sortScore2, int sortScore3, int sortScore4, std::string& errorcode,const std::string& baseurl,const std::string& proxy="");
//submit a highscore using a pre-prepared encrypted string - errorcode is populated when an error occurs with friendly text
long SubmitHighScore(const std::string& code,const std::string& username,std::string& errorcode,const std::string& baseurl,const std::string& proxy="");
//submit a highscore using the details of a score - this just encrypts the details and calls the other SubmitHighScore function - errorcode is populated when an error occurs with friendly text
long SubmitHighScore(int gameCodeID, int numberOfScores, int* dataSizesInBytes,const HighScoreEntry& highscore,std::string& errorcode,std::string& returnedHSCode,const std::string& baseurl,const std::string& proxy="");

//stuff that might be useful

//return the contents of a webpage, file, etc. to a string - errorcode is populated when an error occurs with friendly text
std::string GetURLData(const std::string& url, const std::string& proxy,std::string& errorcode);
//generate an encrypted code based on details passed in. usually just use submithighscore - errorcode is populated when an error occurs with friendly text
std::string CreateHighScoreCode(int gameCodeID, const HighScoreEntry& highscore,int numberOfScores, int* dataSizesInBytes);

