//Tranz-Am
#include "game_transam.h"

static bool initialised=false;

static BITMAP* checker=NULL;
static BITMAP* top=NULL;
static BITMAP* bottom=NULL;
static Car* car1=NULL;

std::vector<std::string> items;

static const int lineGap=2;		//gap between lines
static unsigned int currentLine=0;		//current index of last line output
static int scrollHeight=0;		//size of display window
static int scrollWidth=0;
static float currentScroll=0.0;		//offset
static FONT* titleFont=NULL;
static FONT* textFont=NULL;
static FONT* mediumFont=NULL;
//static FSOUND_STREAM* hsstream=NULL;
static int channel=-1;

static int offsetX=0;
static int offsetY=0;
static bool atEnd=false;

bool CreditLogic()
{
	static int cycle=0;
	bool finished=false;

	if(!initialised)
	{
		CreditInitialise();
		initialised=true;
	}
	//if(cycle>120.0 && hsstream==NULL)
	//	hsstream=PlaySampleFromStream((const char*)(GameDAT[MUSIC_MP3_PAUSE].dat),channel,GameConfiguration->CapsSound.MusicVolume,GameDAT[MUSIC_MP3_PAUSE].size,FSOUND_LOADMEMORY | FSOUND_LOOP_NORMAL);

	//populate top bitmap
	//populate bottom bitmap
	//change top placement for top by -increment
	//change bottom placement as above
	//when top is off the screen, copy bottom onto top (as will be same place) and new page to bottom
	//	then reset position back to beginning
	//
	//keep pointer to the current row and only add if fits bitmap after sizing

	currentScroll-=(GameConfiguration->CapsSystem.fps/60.0/1.7);	//scroll 6 pixels per second

	if(currentScroll<(-scrollHeight))
		finished=GenerateBitmaps();

	//wait three seconds before allow exit. just to stop keypresses from interfering
	if(!top || !bottom || ((cycle>GameConfiguration->CapsSystem.fps*3) && (keypressed() || GameFramework->JoypadAnythingPressed())))
		finished=true;
    else
        clear_keybuf();

	if(atEnd && currentScroll<(-(scrollHeight/2)))
		finished=true;

	if(finished)
	{
		cycle=0;
	    if(keypressed())    //in case top/bottom are null
            readkey();
        CreditDestroy();
        GameFramework->SetAutoGameLoop(
                    TransAmMenuLogic,TransAmMenuDrawing
                    );
		return false;
	}
	else
		clear_keybuf();

	cycle++;
	return false;
}

bool CreditDrawing()
{
    blit(checker,GameFramework->DrawingSurface,0,0,0,0,checker->w,checker->h);
	masked_blit(top,GameFramework->DrawingSurface,0,0,offsetX,offsetY+(int)currentScroll,top->w,top->h);
	masked_blit(bottom,GameFramework->DrawingSurface,0,0,offsetX,offsetY+(int)currentScroll+scrollHeight,top->w,top->h);
	//masked_blit(bottom,GameFramework->DrawingSurface,0,0,0,0,bottom->w,bottom->h);
	//textprintf_ex(GameFramework->DrawingSurface,font,0,50,makecol(255,0,0),-1,"%f",currentScroll);
	return false;
}

void CreditInitialise()
{
	CreditDestroy();

	car1=new Car();
	car1->SetupCar("player",true,true);
	atEnd=false;

    currentLine=0;
	titleFont=LargeFont;
	//textFont=MainFont;
	textFont=SmallFont;
	mediumFont=MainFont2;

	scrollWidth=SCREEN_W;
	scrollHeight=SCREEN_H;

	checker=GenerateChecker();
	top=create_bitmap(scrollWidth,scrollHeight);
	bottom=create_bitmap(scrollWidth,scrollHeight);

	clear_to_color(top,makecol(255,0,255));
	clear_to_color(bottom,makecol(255,0,255));
	offsetX=(SCREEN_W-scrollWidth)/2;
	offsetY=(SCREEN_H-scrollHeight)/2;

	items.push_back("*");
	items.push_back("^");
	items.push_back("^");
	items.push_back("^");
	items.push_back("^TranzAm Credits");	//title font
	items.push_back("^");
	items.push_back("^");
	items.push_back("^");
	items.push_back("^");
	items.push_back("^");
	items.push_back("^");
	items.push_back("^");
	items.push_back("^");
	items.push_back("^Original Concept");
	items.push_back("$Ultimate (1982)");
	items.push_back("^");
	items.push_back("^Programming");
	items.push_back("$Neil Walker");
	items.push_back("^");
	items.push_back("^Graphics");
	items.push_back("$Yves Rizoud (Audric)");
	items.push_back("^");
	items.push_back("^Car Sprites");
	items.push_back("$Graham Goring");
	items.push_back("^");
	items.push_back("^Music (Main Tune)");
	items.push_back("$Happiness by Sanctorum");
	items.push_back("^");
	items.push_back("^Music (End Tune 1)");
	items.push_back("$trs taxi by am-fm^s!p");
	items.push_back("^");
	items.push_back("^Music (End Tune 2)");
	items.push_back("$chip2 by tdk");
	items.push_back("^");
	items.push_back("^Sound Effects");
	items.push_back("$www.grsites.com");
	items.push_back("^");
	items.push_back("^Mac Conversion");
	items.push_back("$Peter Hull");
	items.push_back("^");
	items.push_back("^Testing");
	items.push_back("$Neil Black");
	items.push_back("$Retrospec");
	items.push_back("^");
	items.push_back("^");
	items.push_back("^");
	items.push_back("^");
	items.push_back("*");		//car item
	items.push_back("^");
	items.push_back("^");
	items.push_back("^");
	items.push_back("^Libraries");
	items.push_back("");
	items.push_back("$Allegro");
	items.push_back("$tinyXML");
	items.push_back("$Mappy");
	items.push_back("$LibCurl");
	items.push_back("$Graham Goring");
	items.push_back("Funky Font System");
	items.push_back("");
	items.push_back("$FMod");
	items.push_back("$Adime");
	items.push_back("");
	items.push_back("$Tomaz Kac");
	items.push_back("High Score Encryption");
	items.push_back("");
	items.push_back("$AXL");
	items.push_back("^");
	items.push_back("^");
	items.push_back("*");		//car item
	items.push_back("^");
	items.push_back("^");
	items.push_back("^Retrospec");
	items.push_back("Mostly consist of:");
	items.push_back("");
	items.push_back("$Jeff, Graham, Rich,");
	items.push_back("$Neil, Allan, Tomaz,");
	items.push_back("$John, Bill, Pierre,");
	items.push_back("$Matt, Dan, Adam,");
	items.push_back("$Kruze, Ignacio, Allan,");
	items.push_back("$Russ, Peter, Andy");
	items.push_back("^");
	items.push_back("^");
	items.push_back("*");		//car item
	items.push_back("^");
	items.push_back("^");

	//get list of members
	bool gotMembers=false;
	std::string error="";
	std::string contents=GetURLData(GameConfiguration->GetCustom("rootsite","http://retrospec.sgn.net")+"/getmembers.php",GameConfiguration->GetCustom("proxy",""),error);

	//temp test
	//contents="neil|bob|frank|bob the builder";
	if(contents!="")
		gotMembers=true;
	if(gotMembers)
	{
		items.push_back("^");
		items.push_back("^Registered Users");
		items.push_back("Special thanks to the following who have taken time out");
		items.push_back("to join the forums and provide support.");
		items.push_back("This list is taken live from the Retrospec website");
		items.push_back("So register to find yourself here ;)");
		items.push_back("^");
		StringTokenizer token(contents,"|");
		while(token.hasMoreTokens())
			items.push_back("$"+token.nextToken());
	}
	items.push_back("^");
	items.push_back("*");		//car item
	items.push_back("");
	items.push_back("");
	items.push_back("");
	items.push_back("");
	items.push_back("");
	items.push_back("");
	items.push_back("");
	items.push_back("");
	items.push_back("^the end");
	items.push_back("^");
	items.push_back("^");
	items.push_back("^");
	items.push_back("^");
	items.push_back("^");
	items.push_back("^");
	items.push_back("^");
	items.push_back("^");
	items.push_back("^");
	items.push_back("^");
	items.push_back("^");
	items.push_back("^");
	items.push_back("^");
	items.push_back("^");

	GenerateBitmaps();

}

void CreditDestroy()
{
	initialised=false;
	//StopStream(hsstream);
	//hsstream=NULL;
	channel=-1;
	if(checker) destroy_bitmap(checker);
	if(top) destroy_bitmap(top);
	if(bottom) destroy_bitmap(bottom);
	top=bottom=checker=NULL;
	items.clear();
	if(car1)
        delete car1;

	car1=NULL;
}

bool GenerateBitmaps()
{
	//copy bottom to top and clear top
	blit(bottom,top,0,0,0,0,bottom->w,bottom->h);
	clear_to_color(bottom,makecol(255,0,255));

	//reset position so that bitmap is the same as before as we've moved bottom to top
	//- current position passed in means top is off the screen and bottom is fully visible
	currentScroll=0.0;


	//populate bitmap - ignore bitmaps for now
	//currently when the bottom has reached, stop. maybe change so that bottom scrolls off too
	int currentHeight=0;
	FONT* currentFont;
	std::string currentItem;

	while(true)
	{
	    if(currentLine>=items.size())
		{
			atEnd=true;
            break;
		}

		currentItem=items[currentLine];
		if(currentItem.substr(0,1)=="*")
		{
            rotate_sprite(bottom, car1->car->ReadOnly_CurrentItem, (bottom->w/2)-(car1->car->ReadOnly_CurrentItem->w/2),currentHeight, itofix(FIX_ANGLE[car1->angle]));
            currentHeight+=(car1->car->ReadOnly_CurrentItem->h+lineGap);
		}
		else
		{
            if(currentItem.substr(0,1)=="^")
            {
                currentItem.replace(0,1,"");	//remove ^
                currentFont=titleFont;
            }
            else if(currentItem.substr(0,1)=="$")
            {
                currentItem.replace(0,1,"");	//remove $
                currentFont=mediumFont;
            }
            else
                currentFont=textFont;

            if(currentLine>items.capacity() || currentHeight+text_height(currentFont)>scrollHeight)
                break;

            //ok to put it in
            textout_centre_ex(bottom,currentFont,currentItem.c_str(),(bottom->w/2),currentHeight,-1,-1);
            currentHeight+=(text_height(currentFont)+lineGap);

		}
		currentLine++;
	}
    return false;
}

