//Tranz-Am
#include "game_transam.h"

static Animation* logo=NULL;
static Animation* gamelogo=NULL;

/*int fadevalue=255;
bool startfade=false;
bool endfade=false;
bool fadestarted=false;
bool firstphase=true;
bool finalphase=false;
*/

static bool initialised=false;
static bool phase1_delay=false;
static bool phase2_fadein=false;
static bool phase3_fadeout=false;
static bool phase4_logo=false;

static FSOUND_STREAM* logostream=NULL;

bool TransAmLogoLogic()
{
	//initialise the graphics
	if(!initialised)
	{
		initialised=true;
		//load logo and return any key
		if(!logo) logo=new Animation(GameLibrary,"logo");
		if(!logo) return true;
		if(!gamelogo) gamelogo=new Animation(GameLibrary,"splash");
		if(!gamelogo)
		{
			if(logo) delete logo;
		}
		if(!gamelogo) return true;

        if(GameConfiguration->GetCustom("skipintro",1)!=1)
        {
			int channel=0;
            //play the tune and wait to start the fade
            //logostream=PlaySampleFromStream("logo.ogg",128);
            logostream=PlaySampleFromStream((const char*)(GameDAT[MUSIC_OGG_LOGO].dat),channel,-1,GameDAT[MUSIC_OGG_LOGO].size,FSOUND_LOADMEMORY);
            logo->SetCustomCountDown(1,1000);

            //set code to run the first override - the initial delay
            GameFramework->SetAutoGameLoopOverride(LogoOverridePhase1Logic,LogoOverridePhase1Drawing);
        }
        else
        {
            GameFramework->SetAutoGameLoopOverride(LogoOverridePhase4Logic,LogoOverridePhase4Drawing);
            return false;
        }
	}

	//the wait to fade has finished, now do the fade in
	if(phase1_delay)
	{
		phase1_delay=false;
		logo->FadeIn(6000,true);
		GameFramework->SetAutoGameLoopOverride(LogoOverridePhase2Logic,LogoOverridePhase2Drawing);
	}

	//the fade in has finished, now fade out
	if(phase2_fadein)
	{
		phase2_fadein=false;
		logo->FadeOut(2000,true);
		GameFramework->SetAutoGameLoopOverride(LogoOverridePhase3Logic,LogoOverridePhase3Drawing);
	}

	//the fade out has finished, now show logo
	if(phase3_fadeout)
	{
		phase3_fadeout=false;
		gamelogo->SetCustomCountDown(1,1000);	//wait 1 seconds
		gamelogo->SetCustomCountDown(2,5000);	//then show for 4
		GameFramework->SetAutoGameLoopOverride(LogoOverridePhase4Logic,LogoOverridePhase4Drawing);
	}

	//logo has finished
	if(phase4_logo)
	{
		//clean up - need to add function to destroy an animation completely from animation system
		//so can remove logos and stuff that is not needed
		//gamelogo->SetCustomCountDown(1,4000);	//wait 1 seconds
		//gamelogo->FadeOut(4000,true,makecol(229,227,92));
        phase4_logo=false;
		if(logo) delete logo;
		if(gamelogo) delete gamelogo;
		logo=gamelogo=NULL;
		GameFramework->SetAutoGameLoop(
						TransAmMenuLogic,TransAmMenuDrawing
						);
	}
	return false;
}
bool TransAmLogoDrawing()
{
	//will never get here as overrides are used
	return false;
}

//this is the initial delay from startup to starting the logo fade
bool LogoOverridePhase1Logic()
{
	phase1_delay=true;
	logo->ManualTimerUpdate();
	if(logo->ReadOnly_Timers[1])
		return true;

	if(keypressed() || GameFramework->JoypadAnythingPressed()) return true;
	return false;

}
bool LogoOverridePhase1Drawing()
{
	clear(GameFramework->DrawingSurface);
	return false;
}

//this is the fade in
bool LogoOverridePhase2Logic()
{
	phase2_fadein=true;
	logo->ManualTimerUpdate();
	if(logo->ReadOnly_Timers[0])
		return true;

	if(keypressed() || GameFramework->JoypadAnythingPressed()) return true;
	return false;

}
bool LogoOverridePhase2Drawing()
{
	clear(GameFramework->DrawingSurface);
	draw_sprite(GameFramework->DrawingSurface,logo->ReadOnly_CurrentItem,(SCREEN_W/2)-(logo->ReadOnly_CurrentItem->w/2),(SCREEN_H/2)-(logo->ReadOnly_CurrentItem->h/2));
	return false;
}
//this is the fade out
bool LogoOverridePhase3Logic()
{
	phase3_fadeout=true;
	logo->ManualTimerUpdate();
	if(logo->ReadOnly_Timers[0])
		return true;

	if(keypressed() || GameFramework->JoypadAnythingPressed()) return true;
	return false;
}
bool LogoOverridePhase3Drawing()
{
	clear(GameFramework->DrawingSurface);
	draw_sprite(GameFramework->DrawingSurface,logo->ReadOnly_CurrentItem,(SCREEN_W/2)-(logo->ReadOnly_CurrentItem->w/2),(SCREEN_H/2)-(logo->ReadOnly_CurrentItem->h/2));
	return false;
}

//this is the logo
bool LogoOverridePhase4Logic()
{
	phase4_logo=true;

    StopStream(logostream);
    GameFramework->ManualDraw();

    //MainFont=grab_font_from_bitmap(FontMain);
	MainFont=(FONT*)GameDAT[FONTMAIN].dat;
    LogoOverridePhase4Drawing();
    GameFramework->ManualDraw();
	rest(200);

    //SmallFont=grab_font_from_bitmap(FontSmall);
	SmallFont=(FONT*)GameDAT[FONTSMALL].dat;
    LogoOverridePhase4Drawing();
    GameFramework->ManualDraw();
	rest(200);

    //LargeFont=grab_font_from_bitmap(FontLarge);
	LargeFont=(FONT*)GameDAT[FONTLARGE].dat;
    LogoOverridePhase4Drawing();
    GameFramework->ManualDraw();
	rest(200);

    //MainFont2=grab_font_from_bitmap(FontMain2);
	MainFont2=(FONT*)GameDAT[FONTMAIN2].dat;
    LogoOverridePhase4Drawing();
    GameFramework->ManualDraw();
	rest(200);

    //LargeFont2=grab_font_from_bitmap(FontLarge2);
	LargeFont2=(FONT*)GameDAT[FONTLARGE2].dat;
    LogoOverridePhase4Drawing();
    //GameFramework->ManualDraw();

    adime_font=OriginalFont;
    adime_title_font=SmallFont;
    adime_button_font=SmallFont;
	rest(1500);


return true;
}

bool LogoOverridePhase4Drawing()
{
    static int cycle=64;
    static int colour=0;
    static int sx=0;
    static int sy=0;
    static int count=0;

    clear(GameFramework->DrawingSurface);

    int s=0;
    int gap=3;
    if(colour==0)
        colour=makecol(229,227,92)+128;

    if(gamelogo)
    {
        s=(int)(gamelogo->ReadOnly_CurrentItem->w/4.15);
        if(sx==0) sx=(SCREEN_W/2)-(gamelogo->ReadOnly_CurrentItem->w/2);
        if(sy==0) sy=(SCREEN_H/2)-(gamelogo->ReadOnly_CurrentItem->h/2)+gamelogo->ReadOnly_CurrentItem->h+5;
        draw_sprite(GameFramework->DrawingSurface,gamelogo->ReadOnly_CurrentItem,(SCREEN_W/2)-(gamelogo->ReadOnly_CurrentItem->w/2),(SCREEN_H/2)-(gamelogo->ReadOnly_CurrentItem->h/2));
    }

	for(int i=0;i<=count;i++)
		rectfill(GameFramework->DrawingSurface,
		sx+((s+gap)*i),sy,sx+((s+gap)*i)+s,sy+30,colour-(cycle*i));
	count++;
	return false;
}

