//Tranz-Am
#include "game_transam.h"

//Water* water1=NULL;
//Water* water2=NULL;
//int w1x,w1y,w2x,w2y;

//static const int WATERW =(200);
//static const int WATERH =(200);

//funky font stuff
static font_struct FunkyStandardMenuFont;
static font_struct FunkySpecialMenuFont;
static font_struct FunkyMenuMessagesFont;
static prop_text_struct FunkyCurrentMenuText;
static prop_text_struct FunkyMessageText;
static int oldCurrent=-1;

static bool Initialised=false;
static bool Terminate=false;

static std::vector<std::string> MessageText;

static const int MENU_QUIT=-1;
static const int MENU_ACTION=-2;
static const int MENU_ACCEPT=-30;
static const int MENU_BACK=-10;
static const int MENU_EMPTY=0;
static int MenuTopActions[][5]={
	{1			,MENU_ACTION	,MENU_ACTION	   ,4, MENU_QUIT},	//top menu - play/high-score/help/setup/quit
	{2          ,3          ,MENU_ACTION	,MENU_BACK	   ,MENU_EMPTY},	//main/party/network/
	{MENU_ACTION,MENU_ACTION ,MENU_ACTION	,MENU_BACK	   ,MENU_EMPTY},	//easy/normal/hard/back
	{MENU_ACTION,MENU_ACTION ,MENU_ACTION	,MENU_ACTION    ,MENU_BACK},	//survival/cup/quiz/race
	{6			,			9,		   13	,MENU_ACTION   ,MENU_BACK },	//controls/graphics/audio/advanced/back/
	{MENU_ACTION,MENU_ACTION ,MENU_ACTION	,MENU_BACK	   ,MENU_EMPTY},	//hs/credits/help/back/ - not used. left in to make it easier
	{7			,			8,MENU_BACK-4	,MENU_EMPTY    ,MENU_EMPTY},	//kb/jp/back/
	{MENU_ACTION,MENU_ACTION ,MENU_ACTION	,MENU_ACTION   ,MENU_BACK-6},	//cursors/wasd/qaop/plzx/back
	{MENU_ACTION,MENU_ACTION ,MENU_ACTION	,MENU_ACTION   ,MENU_BACK-6},	//set 1/2/3/4/back
	{10			,		   11,		   12	,MENU_ACCEPT-4 ,MENU_BACK-4},	//screen/res/mode/accept/back/
	{MENU_ACTION,MENU_ACTION ,MENU_BACK-9   ,MENU_EMPTY    ,MENU_EMPTY},	//window/full/back/
	{MENU_ACTION,MENU_ACTION ,MENU_BACK-9	,MENU_EMPTY    ,MENU_EMPTY},	//retro/classic/back/
	{MENU_ACTION,MENU_ACTION ,MENU_ACTION	,MENU_BACK-9   ,MENU_EMPTY},	//video/memory/triple/back/
	{14			,15			 ,MENU_ACTION	,MENU_BACK-4    ,MENU_EMPTY},	//music/sound
	{MENU_ACTION,MENU_ACTION ,MENU_ACTION	,MENU_ACTION   ,MENU_BACK-13},	//quiet/loud/etc
	{MENU_ACTION,MENU_ACTION ,MENU_ACTION	,MENU_ACTION   ,MENU_BACK-13},	//quiet/loud/etc
};

static std::string MenuTopStrings[][2][5]={
//0
	{{"Play","High-Scores","Help","Setup","Quit"},{"","","","",""}},
//1
	{{"Main Game","Mini Games","Get New Maps","Back",""},{"The main game of collect the cups","Quick play games","Check online for any new maps to download and play","",""}},
//2 - from main game
	{{"Easy","Normal","Hard","Back",""},{"No High-Score submission. Can see enemies on national radar","","More and faster enemies, no radar","",""}},
//3 - from party games
	{{"Race","Quiz","Cup Hunt","Survival","Back"},{"Start to Finish","Do you know your U.S. states?","Find the cup","Last as long as you can",""}},
//4
	{{"Controls","Graphics","Audio","Advanced","Back"},	{"","","","",""}},
//5 - not used
	{{"High-Score","Credits","Help","Back",""},	{"","","","",""}},
//6
	{{"Keyboard","Joypad","Back","",""},	{"","Main axis Left/Right is always turn left/right","","",""}},
//7
	{{"Cursors","WASD","QAOP","PLZX","Back"},	{"Hand-Brake is always any of SHIFT, CTRL or SPACE","","","",""}},
//8
	{{"Set 1","Set 2","Set 3","Set 4","Back"},	{"Up/Down (acc/brake), Any Button (hand-brake)",
		"Buttons 6,5 (acc/brake), Button 1 (hand-brake)",
		"Buttons 1,2 (acc/brake), Button 3 (hand-brake)",
		"Up (accelerate), Button 1 (brake), Button 6 (hand-brake)",""}},
//9 - change setinitialstrings if updating
	{{"Screen","Size","Mode","Accept","Back"},	{"","","","",""}},
//10 - change setinitialstrings if updating
	{{"windowed","fullscreen","Back","",""},	{"Triple buffering not available with this mode",
	"Triple Buffering available with this mode","","",""}},
//11 - change setinitialstrings if updating
	{{"Retro Screen","Classic Screen","Back","",""},	{"640x480 pixels","800x600 pixels","","",""}},
//12 - change setinitialstrings if updating
	{{"Video Paging","Memory Buffers","Triple Buffering","Back",""},	{"For Smooth display","Maximum compatibility (includes vsync and system bitmaps)","Best mode but fullscreen only","",""}},
//13
	{{"Music","Sound","Game Music","Back",""},	{"Music volume","Sound Effects Volume","Whether to play music in game","",""}},
//14 - music
	{{"None","Normal","Quieter","Louder","Back"},	{"","","","",""}},
//15 - sound
	{{"None","Normal","Quieter","Louder","Back"},	{"","","","",""}}
};

static int CurrentTopMenu=0;
static int CurrentMenuItem=0;
static int LastTopMenu=0;
static bool MenuProceed=false;
static BITMAP* temp=NULL;

static BITMAP* checker=NULL;
static bool restarting=false;

//forward declarators as making do without header file
void DrawSimpleMenu(BITMAP* whichbmp);
void SetInitialMenuStrings();

void restartSystem()
{
	blit(GameFramework->DrawingSurface,MemoryBuffer,0,0,0,0,MemoryBuffer->w,MemoryBuffer->h);

	if (GlobalReset)
	adime_lowlevel_dialogf(
		"Information",
		ADIME_ALIGN_CENTRE, ADIME_ALIGN_CENTRE, 100,
		"You are in fullscreen using video graphics.%nothing[]"
		"And you switched in/out.%nothing[]"
		"Game needs to restart unfortunately%nothing[]"
		"To refresh the graphics%nothing[]"
		"%buttonrow[OK;ENTER]",tranzam_adime_callback_close
		);

	GlobalReset=false;
	adime_lowlevel_dialogf(
		"Information",
		ADIME_ALIGN_CENTRE, ADIME_ALIGN_CENTRE, 100,
		"The game will now restart.%nothing[]"
		"If it fails/crashes, restarting should fix it as%nothing[]"
		"it is known that some configurations%nothing[]"
		"fail re-initialisation.%nothing[]"
		"%buttonrow[OK;ENTER]",tranzam_adime_callback_close
		);

/*	if (water1)
		delete water1;
	if (water2)
		delete water2;
	water1=water2=NULL;*/
	MessageText.clear();
	Initialised=false;
	//need to reset all graphics, etc. as video modes especially knack bitmaps
	if(temp)
	{
		destroy_bitmap(temp);
		temp=NULL;
	}
	CurrentMenuItem=0;
	CurrentTopMenu=0;
	PFONT_free_font (&FunkyStandardMenuFont);
	PFONT_free_font (&FunkySpecialMenuFont);
	PFONT_free_font (&FunkyMenuMessagesFont);
	adime_exit();
	EndGame();
	GameFramework->RestartSystem();
	SetupGame();

    textout_centre_ex(GameFramework->DrawingSurface,font,"Please Wait...",0,0,makecol(255,255,255),-1);
    GameFramework->ManualDraw();
	MainFont=(FONT*)GameDAT[FONTMAIN].dat;
	SmallFont=(FONT*)GameDAT[FONTSMALL].dat;
	LargeFont=(FONT*)GameDAT[FONTLARGE].dat;
	MainFont2=(FONT*)GameDAT[FONTMAIN2].dat;
	LargeFont2=(FONT*)GameDAT[FONTLARGE2].dat;

    /*MainFont=grab_font_from_bitmap(FontMain);
    SmallFont=grab_font_from_bitmap(FontSmall);
    LargeFont=grab_font_from_bitmap(FontLarge);
    MainFont2=grab_font_from_bitmap(FontMain2);
    LargeFont2=grab_font_from_bitmap(FontLarge2);*/

	adime_init();
	gui_set_screen(MemoryBuffer);
	adime_font=OriginalFont;
	adime_title_font=SmallFont;
	adime_button_font=SmallFont;
	RGB bg={225,227,84,0};
	RGB bt={0, 0, 127,0};
	adime_window_button_h=30;
	adime_background_rgb=bg;
	adime_button_rgb=bt;
	adime_bmp=MemoryBuffer;
	adime_callback=adime_transam_callback;
}

bool TransAmMenuLogic()
{
	static int lastkey=0;
	restarting=false;
	int currentkey=0;
	static float cycle=0.0;
	static float cycle2=0.0;
	static unsigned int currentmessage=0;
	//static bool d1=false;
	//static bool d2=false;
	static int menuitempause=10;

	menuitempause--;

	if(GlobalReset)
		restartSystem();

	if(!Initialised)
	{
		PlayTrackerSongFromDAT((const char*)(GameDAT[MUSIC_IT_MENU].dat),-1,GameDAT[MUSIC_IT_MENU].size,true,4);
/*		if(water1) delete water1;
		if(water2) delete water2;
		water1=new Water(WATERW,WATERH);
		water2=new Water(WATERW,WATERH);
		w1x=w1y=w2x=w2y=0;
*/
		Initialised=true;
		DisplayPanel->FadeIn(3000,false);	//just to use the timer
		DisplayPanel->ManualTimerUpdate();
		SetInitialMenuStrings();
		if(temp) destroy_bitmap(temp);
		if(is_video_bitmap(GameFramework->DrawingSurface))
			temp=create_video_bitmap(SCREEN_W,SCREEN_H);
		else if(is_system_bitmap(GameFramework->DrawingSurface))
			temp=create_system_bitmap(SCREEN_W,SCREEN_H);
		else
			temp=create_bitmap(SCREEN_W,SCREEN_H);

		//width/height is size of each char as need regular sheet of font glyphs
		//char filechar[255];
		//std::string filename;

/*		sprintf(filechar,"%s","gfx\\font_large_funky.bmp");
		filename=fix_filename_slashes( filechar );
		if(!exists(filename.c_str()))
			GameFramework->AbortSystem("Cannot find "+filename);
		PFONT_load_font (&FunkyStandardMenuFont, filename.c_str(), 36, 41);*/
		PFONT_load_font_from_bitmap(&FunkyStandardMenuFont, (BITMAP*)GameDAT[FONTFUNKYLARGE].dat, 36, 41);

		/*sprintf(filechar,"%s","gfx\\font_large2_funky.bmp");
		filename=fix_filename_slashes( filechar );
		if(!exists(filename.c_str()))
			GameFramework->AbortSystem("Cannot find "+filename);
		PFONT_load_font (&FunkySpecialMenuFont, filename.c_str(), 36, 41);*/
		PFONT_load_font_from_bitmap(&FunkySpecialMenuFont, (BITMAP*)GameDAT[FONTFUNKYLARGE2].dat, 36, 41);

/*		sprintf(filechar,"%s","gfx\\font_messages_funky.bmp");
		filename=fix_filename_slashes( filechar );
		if(!exists(filename.c_str()))
			GameFramework->AbortSystem("Cannot find "+filename);
		PFONT_load_font (&FunkyMenuMessagesFont, filename.c_str(), 16, 32);*/
		PFONT_load_font_from_bitmap(&FunkyMenuMessagesFont, (BITMAP*)GameDAT[FONTFUNKYMESSAGE].dat, 16, 32);

		//width is width to draw text in, x offset is spacing as proportional
		// y spacing is to remove, for example padding on top of font
		// run this again when changing text
		PFONT_create_frame_list (&FunkyCurrentMenuText , &FunkyStandardMenuFont ,
			"",
			640, PFONT_ALIGN_CENTER , 1, -6 , false, false );

		MessageText.clear();
		MessageText.push_back("Retrospec Presents TransAm");
		MessageText.push_back("Programming by Neil Walker");
		MessageText.push_back("Graphics by Audric (Yves Rizoud)");
		MessageText.push_back("Car Sprites by Graham Goring");
		MessageText.push_back("Mac conversion by Peter Hull");
		MessageText.push_back("Music from modarchive.com...");
		MessageText.push_back("Happiness by Sanctorum");
		MessageText.push_back("trs taxi by am-fm^s!p");
		MessageText.push_back("chip2 by tdk");
		MessageText.push_back("Sound effects from grsites.com");
		MessageText.push_back("Special thanks must go to:");
		MessageText.push_back("FMOD for the sound library");
		MessageText.push_back("Everyone involved with Allegro");
		MessageText.push_back("Graham Goring for funky font");
		MessageText.push_back("Bob and others for fblend");
		MessageText.push_back("Ultimate for the original game");
		MessageText.push_back("Retrospec mostly consist of:");
		MessageText.push_back("Jeff, Graham, Rich, Neil, Andrew");
		MessageText.push_back("Tomaz, John, Bill, Pierre, Matt,");
		MessageText.push_back("Dan, Adam, Tommo, Ignacio,");
		MessageText.push_back("Allan, Andy, Russ, Peter");
		MessageText.push_back("visit us at retrospec.sgn.net");
		MessageText.push_back("Tranz Am was released about 1983");
		MessageText.push_back("It is the year 3472");
		MessageText.push_back("You must gather 8 cups to win");
		MessageText.push_back("Whilst avoiding the deadly black turbos");

		PFONT_create_frame_list (&FunkyMessageText , &FunkyMenuMessagesFont ,
			MessageText[0].c_str(),
			640, PFONT_ALIGN_CENTER , 1, -6 , false, false );

		//menu backdrop
		checker=GenerateChecker();

		if(keypressed()) readkey();
		clear_keybuf();
	}

	//menu movement handler
	if(keypressed() || GameFramework->JoypadAnythingPressed())
	{
		if(keypressed())
			currentkey=readkey()>>8;
		else
		{
			int buttons=GameFramework->JoypadButtonPressed();
			int directions;
			GameFramework->JoypadAxisPressed(directions);
			//stuff keys - let buttons take precedence over axis
			if(buttons)
				currentkey=KEY_SPACE;	//invoke the menu
			else if(directions & JDUP)
				currentkey=KEY_UP;
			else if(directions & JDDOWN)
				currentkey=KEY_DOWN;
			else if(directions & JDLEFT)
				currentkey=KEY_LEFT;
			else if(directions & JDRIGHT)
				currentkey=KEY_RIGHT;
			else
				currentkey=0;
		}
		if(currentkey!=KEY_ESC && (currentkey!=lastkey) && currentkey!=KeyboardControls[KeyboardHandler][0] && currentkey!=KEY_LEFT)
		{
			lastkey=currentkey;
			menuitempause=10;
			if(currentkey==KEY_ENTER || currentkey==KEY_SPACE || currentkey==KEY_RIGHT || currentkey==KeyboardControls[KeyboardHandler][1] || GameFramework->JoypadButtonPressed())
			{
				//PlayExclusiveSFX(snd_menuselect);
				PlaySFX(snd_menuselect,1,true,false,-1);
				MenuProceed=true;
			}
			else
			{
				MenuProceed=false;
				if(currentkey==KEY_DOWN || currentkey==KeyboardControls[KeyboardHandler][3])
				{
					//PlayExclusiveSFX(snd_menuchange);
					PlaySFX(snd_menuselect,1,true,false,-1);

					CurrentMenuItem++;
				}
				if(currentkey==KEY_UP || currentkey==KeyboardControls[KeyboardHandler][2])
				{
					PlaySFX(snd_menuselect,1,true,false,-1);
					//PlayExclusiveSFX(snd_menuchange);
					CurrentMenuItem--;
				}
				//if(CurrentMenuItem>4)
				if(CurrentMenuItem>4 || MenuTopActions[CurrentTopMenu][CurrentMenuItem]==MENU_EMPTY)
					CurrentMenuItem--;
				if(CurrentMenuItem<=0)
					CurrentMenuItem=0;
			}
		}
		else
		{
			if(currentkey==KEY_ESC || currentkey==KEY_LEFT || currentkey==KeyboardControls[KeyboardHandler][0])
			{
				lastkey=0;
				oldCurrent=-1;	//reset when changing menu
				CurrentMenuItem=0;
				CurrentTopMenu=0;
			}
		}
	}
	else
	{
		if(menuitempause<1)
		{
			menuitempause=10;
			lastkey=0;
		}
	}

	//menu selection and processing
	//this section when an item has been invoked
	if(MenuProceed==true)
	{
		oldCurrent=-1;	//reset when changing menu
		MenuProceed=false;
		//lastkey=currentkey=0;
		int action=MenuTopActions[CurrentTopMenu][CurrentMenuItem];
		if (action==MENU_QUIT)
			Terminate=true;

		else if(action==MENU_ACTION)
		{
			//performing an action, not a menu change
			currentLevel=NULL;

			if(CurrentTopMenu==1)	//download
				Levels::NewMapsCheck();
			else if(CurrentTopMenu==2 || CurrentTopMenu==3) //a game type
			{
				if(CurrentTopMenu==2)
				{
					currentLevel=gameLevels->GetLevel(0);	//0 is always main game
					currentLevel->highScore=GameConfiguration->GetCustom("highscore1score",0);
					currentLevel->flag=CurrentMenuItem;		//flag becomes level - 0,1,2
				}
				else
				{
					std::string title;
					std::string items;
					Level* level;
					int count;
					int game;
					int returnval;
					std::stringstream ss;
					GameType currentType=GT_NORMAL;
					if(CurrentMenuItem==3)
					{
						//survival
						currentType=GT_SURVIVAL;
						title="Select Survivor Game";
					}
					else if(CurrentMenuItem==2)
					{
						//cup
						currentType=GT_CUP;
						title="Select Cup Game";
					}
					else if(CurrentMenuItem==1)
					{
						//quiz
						currentType=GT_QUIZ;
						title="Select Quiz Game";
					}
					else if(CurrentMenuItem==0)
					{
						//race
						currentType=GT_RACE;
						title="Select Race Game";
					}
					if(currentType!=GT_NORMAL)
					{
						count=gameLevels->Count(currentType);
						if(count>0)
						{
							ss<<"%list["<<count<<",";
							for(int i=0;i<count;i++)
							{
								level=gameLevels->GetLevel(i,currentType);
								ss<<level->name;
								if(count-i>1)
									ss<<";";
							}
							ss<<"]";

							items=ss.str();
							blit(GameFramework->DrawingSurface,MemoryBuffer,0,0,0,0,MemoryBuffer->w,MemoryBuffer->h);
							returnval=adime_dialogf(
								title.c_str(),
								ADIME_ALIGN_CENTRE, ADIME_ALIGN_CENTRE, 300,
								items.c_str(),
								&game
							);

							if(returnval==1)
							{
								//ok selected
								currentLevel=gameLevels->GetLevel(game,currentType);
							}
						}
					}
				}

				if(currentLevel)
				{
					CurrentTopMenu=0;
					CurrentMenuItem=0;
					Initialised=false;
					oldCurrent=-1;
					if(!musicInGame)
						StopTrackerSong();

					GameFramework->SetAutoGameLoop(
						TransAmGameLogic,TransAmGameDrawing
						);
				}
			}
			else if(CurrentTopMenu==4)	//advanced - no other actions in this menu
			{
				restarting=AdvancedConfiguration();
			}
			else if(CurrentTopMenu==0)	//main
			{
				if(CurrentMenuItem==1)	//hs
					GameFramework->SetAutoGameLoop(
						HighScoreLogic,HighScoreDrawing
						);
				else if(CurrentMenuItem==2)	//help and credits
					GameFramework->SetAutoGameLoop(
						TransAmHelpLogic,TransAmHelpDrawing
						);
			}

			else if(CurrentTopMenu==7)	//keyboard
			{
				KeyboardHandler=CurrentMenuItem;
				CurrentTopMenu=6;
				CurrentMenuItem=0;
				SetInitialMenuStrings();
			}
			else if(CurrentTopMenu==8)	//joystick
			{
				JoystickHandler=CurrentMenuItem;
				CurrentTopMenu=6;
				CurrentMenuItem=1;
				SetInitialMenuStrings();
			}
			else if(CurrentTopMenu==10)	//screen
			{
				MenuTopStrings[9][0][0]=MenuTopStrings[10][0][CurrentMenuItem];
				CurrentTopMenu=9;
				CurrentMenuItem=0;
			}
			else if(CurrentTopMenu==11)
			{
				MenuTopStrings[9][0][1]=MenuTopStrings[11][0][CurrentMenuItem];
				CurrentTopMenu=9;
				CurrentMenuItem=1;
			}
			else if(CurrentTopMenu==12)
			{
				if(CurrentMenuItem==0)	//paging
					MenuTopStrings[9][0][2]="Video Paging";
				if(CurrentMenuItem==1)	//memory
					MenuTopStrings[9][0][2]="Memory Buffers";
				if(CurrentMenuItem==2)	//paging
				{
					MenuTopStrings[9][0][2]="Triple Buffers";
					MenuTopStrings[9][0][0]="fullscreen";
				}
				CurrentTopMenu=9;
				CurrentMenuItem=2;
			}
			else if(CurrentTopMenu==13) //audio
			{
				if(CurrentMenuItem==2)	//toggle music
				{
					if(musicInGame)
						MenuTopStrings[13][0][2]="Game Music Off";
					else
						MenuTopStrings[13][0][2]="Game Music On";

					musicInGame=!musicInGame;
				}
			}
			else if(CurrentTopMenu==14)	//music
			{
				int lastmode=GameConfiguration->CapsSound.MusicVolume;
				if(CurrentMenuItem==0)
				{
					GameConfiguration->CapsSound.MusicVolume=0;
					StopTrackerSong();
				}
				else
				{
					if(CurrentMenuItem==1) GameConfiguration->CapsSound.MusicVolume=128;
					if(CurrentMenuItem==2) GameConfiguration->CapsSound.MusicVolume=64;
					if(CurrentMenuItem==3) GameConfiguration->CapsSound.MusicVolume=255;
					if(lastmode==0)
						PlayTrackerSongFromDAT((const char*)(GameDAT[MUSIC_IT_MENU].dat),-1,GameDAT[MUSIC_IT_MENU].size,true,4);

					AdjustMusicVolume(ActiveMusic,GameConfiguration->CapsSound.MusicVolume);
				}
				CurrentTopMenu=13;
				CurrentMenuItem=0;
				SetInitialMenuStrings();
			}
			else if(CurrentTopMenu==15)	//sound
			{
				if(CurrentMenuItem==0) GameConfiguration->CapsSound.SampleVolume=0;
				if(CurrentMenuItem==1) GameConfiguration->CapsSound.SampleVolume=128;
				if(CurrentMenuItem==2) GameConfiguration->CapsSound.SampleVolume=64;
				if(CurrentMenuItem==3) GameConfiguration->CapsSound.SampleVolume=255;
				FSOUND_SetSFXMasterVolume(GameConfiguration->CapsSound.SampleVolume);

				CurrentTopMenu=13;
				CurrentMenuItem=1;
				SetInitialMenuStrings();
			}
		}
		else if(action>0)
		{
			//is a menu item
			LastTopMenu=CurrentTopMenu;

			CurrentTopMenu=MenuTopActions[CurrentTopMenu][CurrentMenuItem];

			if(CurrentTopMenu==2)
				CurrentMenuItem=1;
			else
				CurrentMenuItem=0;
		}
		else if(action<0)
		{
			//accept or back
			if(action<=MENU_ACCEPT)
			{
				//accept and process actions - video mainly
				if(CurrentTopMenu==9)	//screen
				{
					//fullscreen or windowed
					GameConfiguration->CapsGraphics.WindowMode=MenuTopStrings[9][0][0];

					//screen size. if custom then don't update
					if(MenuTopStrings[9][0][1]=="Classic Screen")
					{
						GameConfiguration->CapsGraphics.ScrWidth=800;
						GameConfiguration->CapsGraphics.ScrHeight=600;
					}
					if(MenuTopStrings[9][0][1]=="Retro Screen")
					{
						GameConfiguration->CapsGraphics.ScrWidth=640;
						GameConfiguration->CapsGraphics.ScrHeight=480;
					}

					//mode. if custom don't update
					if(MenuTopStrings[9][0][2]=="Triple Buffers")
					{
						GameConfiguration->CapsGraphics.GraphicsMode=MODE_TRIPLE;
						GameConfiguration->CapsGraphics.WindowMode="fullscreen";
					}
					if(MenuTopStrings[9][0][2]=="Video Paging")
						GameConfiguration->CapsGraphics.GraphicsMode=MODE_PAGED;
					if(MenuTopStrings[9][0][2]=="Memory Buffers")
						GameConfiguration->CapsGraphics.GraphicsMode=MODE_SYSTEMDOUBLE;

					SetInitialMenuStrings();
					restarting=true;
				}
			}
			else
			{
				//back
				CurrentTopMenu=abs(action-MENU_BACK);
				CurrentMenuItem=0;
				SetInitialMenuStrings();	//reset screen stuff mainly
			}
		}
		else
		{
			//empty - do nothing
		}
	}

	/* animated fonts */
	//always reset this, but don't do anything else if no effects to use

	PFONT_posset_reset ( &FunkyCurrentMenuText );
	PFONT_texset_basic_spread ( &FunkyCurrentMenuText , 1 , 1 , cycle*16 , cycle*16 , true );
	PFONT_posset_reset ( &FunkyMessageText );
	PFONT_texset_basic_spread ( &FunkyMessageText , 1 , 1 , cycle*16 , cycle*16 , true );

	//c/2 - contract expand for current menu
	if(!ActiveMusic || GameConfiguration->CapsSound.MusicVolume==0)
		PFONT_posmod_scale ( &FunkyCurrentMenuText , 0.5 , 0.5 , 1.1+(sin (cycle)/10) , 1+(cos (cycle)/10) );
	else
		PFONT_posmod_scale ( &FunkyCurrentMenuText , 0.5 , 0.5 , 1.1+(sin (cycle*1.5)/10) , 1+(cos (cycle*1.5)/10) );

	//when sin var reaches zero then at most mad, so change text then
	cycle+=0.08;
	cycle2+=0.09;
/*	if(cycle2>30.0+rand()%15 && !d1)
	{
		d1=true;
		w1x=rand()%SCREEN_W;
		w1y=rand()%SCREEN_H;
		water1->Drop(WATERW/2, WATERH/2, -(Params::rippleSize-(rand()%200)));
	}
	if(cycle2>20+rand()%25 && !d2)
	{
		d2=true;
		w2x=rand()%SCREEN_W;
		w2y=rand()%SCREEN_H;
		water2->Drop(WATERW/2, WATERH/2, -(Params::rippleSize+(rand()%200)));
	}*/
	if(cycle2>65.0)
	{
		//d1=d2=false;
		cycle2=0.0;
		currentmessage++;
		if(currentmessage>=MessageText.size())
			currentmessage=0;

		PFONT_create_frame_list (&FunkyMessageText , &FunkyMenuMessagesFont,
			MessageText[currentmessage].c_str(),
			640, PFONT_ALIGN_CENTER , 1, -6 , false, false );
	}
    PFONT_posmod_sine_out_phase ( &FunkyMessageText , 0.2 , 0.2 , -60 , -20 , cycle2/8 , cycle2 );
    PFONT_posmod_damp ( &FunkyMessageText , (sin (cycle2/10)/2)+0.5 );
    PFONT_posmod_bow_in ( &FunkyMessageText , 0.5 , 0.5 , cos (cycle2/2) * 8.0 , sin (cycle2) * 8.0 );

	if(Terminate)
	{
		Initialised=false;
		StopTrackerSong();
		if(temp)
			destroy_bitmap(temp);
		if(checker)
			destroy_bitmap(checker);

		temp=checker=NULL;
		PFONT_free_font (&FunkyStandardMenuFont);
		PFONT_free_font (&FunkySpecialMenuFont);
		PFONT_free_font (&FunkyMenuMessagesFont);
		MessageText.clear();
/*		if (water1)
			delete water1;
		if (water2)
			delete water2;
		water1=water2=NULL;
*/
		return true;
	}
	else if(restarting)
	{
		restartSystem();
		return false;
	}

	//timer for fade
	if(!DisplayPanel->ReadOnly_Timers[0])
		DisplayPanel->ManualTimerUpdate();

	//update rain
//	water1->Process();
//	water2->Process();

	return false;
}

bool TransAmMenuDrawing()
{
	static double cycle=0.0;

	BITMAP* which;
	//do not draw if not initialised - e.g. if restarting
	cycle+=0.05;

	if(!Initialised)
		return false;

	if(!DisplayPanel->ReadOnly_Timers[0] && !is_video_bitmap(GameFramework->DrawingSurface))
	{
		//fading
		which=temp;
	}
	else
		which=GameFramework->DrawingSurface;

	//clear_to_color(which,makecol(229,227,92));
	if(which==temp)
		clear_to_color(GameFramework->DrawingSurface,makecol(229,227,92));

	blit(checker,which,0,0,0,0,checker->w,checker->h);
/*	water1->Draw(which,w1x,w1y,GameConfiguration->CapsActualSystem.DepthUsed);
	water2->Draw(which,w2x,w2y,GameConfiguration->CapsActualSystem.DepthUsed);*/
	draw_sprite(which,MenuTitle,SCREEN_W/2-(MenuTitle->w/2),16);

	//menu
	DrawSimpleMenu(which);

	if(!DisplayPanel->ReadOnly_Timers[0] && !is_video_bitmap(GameFramework->DrawingSurface))
		fblend_trans(which,GameFramework->DrawingSurface,0,0,(int)DisplayPanel->ReadOnly_TimersCounter[0]);

	PFONT_draw_frame_list_vert_lerped_coloured
	( &FunkyMessageText ,
		999 , SCREEN_W/2 , SCREEN_H-36 ,
		0.5 , 0.5 , which,
		128 , 0 , (int)((128*cos(cycle))+128) , (int)((64*sin(cycle))+64) , 0 , 255 );

	return false;
}

void SetInitialMenuStrings()
{
	//hack here to get the menu strings working
	//graphics
	if(GameConfiguration->CapsGraphics.WindowMode=="fullscreen")
		MenuTopStrings[9][0][0]="fullscreen";
	else
		MenuTopStrings[9][0][0]="windowed";

	if(GameConfiguration->CapsGraphics.ScrHeight==600)
		MenuTopStrings[9][0][1]="Classic Screen";
	else if(GameConfiguration->CapsGraphics.ScrHeight==480)
		MenuTopStrings[9][0][1]="Retro Screen";
	else
		MenuTopStrings[9][0][1]="Custom Size";

	if(GameConfiguration->CapsActualSystem.GraphicsMode==MODE_TRIPLE)
		MenuTopStrings[9][0][2]="Triple Buffers";
	else if(GameConfiguration->CapsActualSystem.GraphicsMode==MODE_PAGED)
		MenuTopStrings[9][0][2]="Video Paging";
	else if(GameConfiguration->CapsActualSystem.GraphicsMode==MODE_SYSTEMDOUBLE)
		MenuTopStrings[9][0][2]="Memory Buffers";
	else
		MenuTopStrings[9][0][2]="Custom Video";

	MenuTopStrings[6][0][0]="Keys: "+MenuTopStrings[7][0][KeyboardHandler];
	if(JoystickHandler<0)
		MenuTopStrings[6][0][1]="No Joystick";
	else
		MenuTopStrings[6][0][1]="Joystick: "+MenuTopStrings[8][0][JoystickHandler];

	if(GameConfiguration->GetCustom("enablefmod",1)==0)
	{
		MenuTopStrings[13][0][0]="Music Disabled";
		MenuTopStrings[13][0][1]="Sound Disabled";
	}
	else
	{
		if(GameConfiguration->CapsSound.MusicVolume==0)
			MenuTopStrings[13][0][0]="Music Off";
		else if(GameConfiguration->CapsSound.MusicVolume==64)
			MenuTopStrings[13][0][0]="Music Quiet";
		else if(GameConfiguration->CapsSound.MusicVolume==128)
			MenuTopStrings[13][0][0]="Music Normal";
		else if(GameConfiguration->CapsSound.MusicVolume==255)
			MenuTopStrings[13][0][0]="Music Louder";
		else
			MenuTopStrings[13][0][0]="Music Custom";

		if(GameConfiguration->CapsSound.SampleVolume==0)
			MenuTopStrings[13][0][1]="SFX Off";
		else if(GameConfiguration->CapsSound.SampleVolume==64)
			MenuTopStrings[13][0][1]="SFX Quiet";
		else if(GameConfiguration->CapsSound.SampleVolume==128)
			MenuTopStrings[13][0][1]="SFX Normal";
		else if(GameConfiguration->CapsSound.SampleVolume==255)
			MenuTopStrings[13][0][1]="SFX Loud";
		else
			MenuTopStrings[13][0][1]="SFX Custom";
	}

	if(musicInGame)
		MenuTopStrings[13][0][2]="Game Music On";
	else
		MenuTopStrings[13][0][2]="Game Music Off";

	return;
}


void DrawSimpleMenu(BITMAP* whichbmp)
{
	int x=SCREEN_W/2;
	int y=SCREEN_H/3-40;
	int yinfo=SCREEN_H/3+200;
	int lineskip=LargeFont->height*1;

	if(oldCurrent!=CurrentMenuItem)
	{
		if(CurrentMenuItem>1 && MenuTopActions[CurrentTopMenu][CurrentMenuItem]<=MENU_BACK)
			PFONT_create_frame_list (&FunkyCurrentMenuText , &FunkySpecialMenuFont ,
				(char*)MenuTopStrings[CurrentTopMenu][0][CurrentMenuItem].c_str(),
				640, PFONT_ALIGN_CENTER , 1, -6 , false, false );
		else
			PFONT_create_frame_list (&FunkyCurrentMenuText , &FunkyStandardMenuFont ,
			(char*)MenuTopStrings[CurrentTopMenu][0][CurrentMenuItem].c_str(),
			640, PFONT_ALIGN_CENTER , 1, -6 , false, false );

		oldCurrent=CurrentMenuItem;
	}

	//PFONT_draw_frame_list_notexture - max letters is the most characters to draw in total
	// handle x/y is the offset from the x/y but goes backaw
	if(CurrentMenuItem==0)
	{
		//textout_centre_ex(whichbmp,SmallFont,MenuTopStrings[CurrentTopMenu][0][0].c_str(),x,y+=lineskip,0,-1);
		PFONT_draw_frame_list_notexture ( &FunkyCurrentMenuText ,
			999 , SCREEN_W/2 , (y+=lineskip)-4 , 0.5 , 0.0 , whichbmp );

		textout_centre_ex(whichbmp,SmallFont,MenuTopStrings[CurrentTopMenu][1][0].c_str(),x,yinfo,0,-1);
	}
	else
		textout_centre_ex(whichbmp,MainFont,MenuTopStrings[CurrentTopMenu][0][0].c_str(),x,y+=lineskip,0,-1);

	if(CurrentMenuItem==1)
	{
		PFONT_draw_frame_list_notexture ( &FunkyCurrentMenuText ,
			999 , SCREEN_W/2 , (y+=lineskip)-4 , 0.5 , 0.0 , whichbmp );

		textout_centre_ex(whichbmp,SmallFont,MenuTopStrings[CurrentTopMenu][1][1].c_str(),x,yinfo,0,-1);
	}
	else
		textout_centre_ex(whichbmp,MainFont,MenuTopStrings[CurrentTopMenu][0][1].c_str(),x,y+=lineskip,0,-1);

	if(CurrentMenuItem==2)
	{
		PFONT_draw_frame_list_notexture ( &FunkyCurrentMenuText ,
			999 , SCREEN_W/2 , (y+=lineskip)-4 , 0.5 , 0.0 , whichbmp );

			textout_centre_ex(whichbmp,SmallFont,MenuTopStrings[CurrentTopMenu][1][2].c_str(),x,yinfo,0,-1);
	}
	else
	{
		if(MenuTopActions[CurrentTopMenu][2]<=MENU_BACK)
			textout_centre_ex(whichbmp,MainFont2,MenuTopStrings[CurrentTopMenu][0][2].c_str(),x,y+=lineskip,0,-1);
		else
			textout_centre_ex(whichbmp,MainFont,MenuTopStrings[CurrentTopMenu][0][2].c_str(),x,y+=lineskip,0,-1);
	}

	if(CurrentMenuItem==3)
	{
		PFONT_draw_frame_list_notexture ( &FunkyCurrentMenuText ,
			999 , SCREEN_W/2 , (y+=lineskip)-4 , 0.5 , 0.0 , whichbmp );

		textout_centre_ex(whichbmp,SmallFont,MenuTopStrings[CurrentTopMenu][1][3].c_str(),x,yinfo,0,-1);
	}
	else
	{
		if(MenuTopActions[CurrentTopMenu][3]<=MENU_BACK)
			textout_centre_ex(whichbmp,MainFont2,MenuTopStrings[CurrentTopMenu][0][3].c_str(),x,y+=lineskip,0,-1);
		else
		{
			textout_centre_ex(whichbmp,MainFont,MenuTopStrings[CurrentTopMenu][0][3].c_str(),x,y+=lineskip,0,-1);
		}
	}

	if(CurrentMenuItem==4)
	{
		PFONT_draw_frame_list_notexture ( &FunkyCurrentMenuText ,
			999 , SCREEN_W/2 , (y+=lineskip)-4 , 0.5 , 0.0 , whichbmp );

		textout_centre_ex(whichbmp,SmallFont,MenuTopStrings[CurrentTopMenu][1][4].c_str(),x,yinfo,0,-1);
	}
	else
	{
		if(MenuTopActions[CurrentTopMenu][4]<=MENU_BACK)
			textout_centre_ex(whichbmp,MainFont2,MenuTopStrings[CurrentTopMenu][0][4].c_str(),x,y+=lineskip,0,-1);
		else
		{
			textout_centre_ex(whichbmp,MainFont,MenuTopStrings[CurrentTopMenu][0][4].c_str(),x,y+=lineskip,0,-1);
		}
	}

}
bool AdvancedConfiguration()
{
	int returnval;

	int bVsync,iFPS,bMatch,iDepth,bSound,bFPS,bJoy,bMouse,bIntro;
	int bSoundCurrent,iDepthCurrent;

	bVsync=GameConfiguration->CapsGraphics.VSync?1:0;
	bMatch=GameConfiguration->CapsSystem.MatchRefreshRate?1:0;
	bFPS=GameConfiguration->GetCustom("showfps",0);
	bJoy=GameConfiguration->CapsSystem.UseJoystick?1:0;
	bMouse=GameConfiguration->CapsSystem.UseMouse?1:0;
	bSound=GameConfiguration->GetCustom("enablefmod",0);
	bSoundCurrent=bSound;
	bIntro=GameConfiguration->GetCustom("skipintro",0);
	if(bIntro==1) bIntro=0;
	else bIntro=1;

	iFPS=GameConfiguration->CapsSystem.fps;
	iDepth=GameConfiguration->CapsActualSystem.DepthUsed;
	if(iDepth==16) iDepth=0;
	else if(iDepth==24) iDepth=1;
	else iDepth=2;
	iDepthCurrent=iDepth;

	blit(GameFramework->DrawingSurface,MemoryBuffer,0,0,0,0,MemoryBuffer->w,MemoryBuffer->h);
	returnval=adime_dialogf(
				"Select your details",
				ADIME_ALIGN_CENTRE, ADIME_ALIGN_CENTRE, 200,
				"Video%nothing[]"
				"vsync where possible%bool[]"
				"Game FPS%int[30,300]"
				"Make monitor match FPS%bool[]"
				"Alter colour depth%list[3,16;24;32]"
				"%line[]"
				"Sound%nothing[]"
				"Soundcard Enabled%bool[]"
				"Maximum voices%int[0,255]"
				"Music volume%int[0,255]"
				"Sound FX volume%int[0,255]"
				"%line[]"
				"System%nothing[]"
				"Show FPS%bool[]"
				"Joystick Enabled%bool[]"
				"Mouse Enabled%bool[]"
				"Show game intro%bool[]",
				&bVsync,
				&iFPS,
				&bMatch,
				&iDepth,
				&bSound,
				&GameConfiguration->CapsSound.MaxSounds,
				&GameConfiguration->CapsSound.MusicVolume,
				&GameConfiguration->CapsSound.SampleVolume,
				&bFPS,
				&bJoy,
				&bMouse,
				&bIntro
	);

	bool resetGame=false;
	if(returnval==1)
	{
		//reset if depth, match fps or fps changes
		if(iDepth!=iDepthCurrent)
			resetGame=true;
		if((GameConfiguration->CapsSystem.MatchRefreshRate && bMatch==0) || (!GameConfiguration->CapsSystem.MatchRefreshRate && bMatch!=0))
			resetGame=true;
		if(iFPS!=GameConfiguration->CapsSystem.fps)
			resetGame=true;

		if((GameConfiguration->CapsSystem.UseJoystick && bJoy==0) || (!GameConfiguration->CapsSystem.UseJoystick && bJoy!=0))
		{
			GameConfiguration->CapsSystem.UseJoystick=(bJoy!=0?true:false);
			if(bJoy!=0)
				install_joystick(JOY_TYPE_AUTODETECT);
			else
				remove_joystick();
		}
		if((GameConfiguration->CapsSystem.UseMouse && bMouse==0) || (!GameConfiguration->CapsSystem.UseMouse && bMouse!=0))
		{
			GameConfiguration->CapsSystem.UseMouse=(bMouse!=0?true:false);
			if(bMouse!=0)
				install_mouse();
			else
				remove_mouse();
		}

		if(bSound!=0) bSound=1;
		if(bSound!=bSoundCurrent)
		{
			if(bSound==0)
				RemoveSound();
			else
				InitialiseSound();
		}

		GameConfiguration->CapsGraphics.VSync=(bVsync!=0);
		GameConfiguration->SetCustom("showfps",bFPS==0?0:1);
		GameConfiguration->SetCustom("skipintro",bIntro==0?1:0);
		GameConfiguration->SetCustom("enablefmod",bSound==0?0:1);

		GameConfiguration->CapsSystem.MatchRefreshRate=(bMatch!=0);
		if(iDepth==0) GameConfiguration->CapsGraphics.Depth=16;
		else if(iDepth==1) GameConfiguration->CapsGraphics.Depth=24;
		else GameConfiguration->CapsGraphics.Depth=32;

		GameConfiguration->CapsSystem.fps=iFPS;

		GameConfiguration->FlushCustom();
		GameConfiguration->FlushMain();
	}
	if(resetGame)
		return true;
	else
		return false;
}
