#ifndef tranzam_main
#define tranzam_main

#ifndef _MSC_VER
    #define CURL_STATICLIB
#endif

#include <algorithm>
#include <functional>      // For less<int>( )
#include <iomanip>

#include "resource.h"
#include "external\axl_framework.h"
#include "external\retrospec_highscore.h"
#include "external\mappyal.h"
#include "external\fmod.h"
#include "external\fmod_errors.h"
#include "external\adime.h"
#include "external\fblend.h"
#include "external\funkyfont.h"
#include "external\water.h"
#include "external\lib_fmod.h"
#include "external\stringtokeniser.h"
#include "game_astar.h"
#include "game_particles.h"
#include "game_car.h"
#include "game_ScrollingText.h"

using namespace AXL_Projects;

struct WayPoint
{
	int x;
	int y;
	WayPoint() {x=y=0;}
};

enum GameType {GT_NORMAL,GT_SURVIVAL,GT_QUIZ,GT_CUP,GT_RACE};
	//normal is get the cups, enemy mode is always attack
	//survival is last as long as possible, enemy mode is always attack
	//cup is find the cup.
	//quiz1 is find state, enemy mode is always attack
	//quiz2 is find state by given capital, enemy mode is ways attack
	//		quiz number type is determined by the flag value
	//race is find cup. if 1+ enemy then is 1 enemy in waypoint

#include "game_levels.h"

//constants
	const int TotalMaxEnemies=100;	//most enemies we'll have
	const int TotalMaxNumCups=100;	//most cups
	const int MainGameEnemies=20;
	const int MainGameEnemiesHard=40;
	const int MainGameEnemiesEasy=10;
	const int MainGameCups=8;		//8 in original game

	const float PI_Conv=AL_PI/180;
	const int CupBlockNumber=21;
	const int CupBlockFreeNumber=1;
	const int GraveBlockNumber=31;
	const int LocalRadarX=15;
	const int LocalRadarY=203;
	const int LocalMapX=15;
	const int LocalMapY=110;
	const float ShadowFactor=30.0/(1000.0*32.0);	//x pixels every 1000 (either half of map)
	const int LightSourceX=511*32;	//centre
	const int LightSourceY=283*32;
	//const float LocalMapScale=6.7;		//ratio of actual tilemap to usa map shown on game
	const float LocalMapScale=8.0;		//ratio of actual tilemap to usa map shown on game

//handlers
	extern int KeyboardHandler;
	extern int JoystickHandler;

	//left/right/acc/dec. handbrake is always shift/space/ctrl
	const int KeyboardControls[][4]={
		{KEY_LEFT,KEY_RIGHT,KEY_UP,KEY_DOWN},
		{KEY_A,KEY_D,KEY_W,KEY_S},
		{KEY_O,KEY_P,KEY_Q,KEY_A},
		{KEY_Z,KEY_X,KEY_P,KEY_L}
	};

	extern std::string states[51][3];

//function declarations
	int MapGetBlockNumber(int x, int y);

    //logo
    bool LogoOverridePhase1Logic();
    bool LogoOverridePhase2Logic();
    bool LogoOverridePhase3Logic();
    bool LogoOverridePhase4Logic();
    bool LogoOverridePhase5Logic();
    bool LogoOverridePhase1Drawing();
    bool LogoOverridePhase2Drawing();
    bool LogoOverridePhase3Drawing();
    bool LogoOverridePhase4Drawing();
    bool LogoOverridePhase5Drawing();

	//transam.cpp
	bool SetupGame();
	void EndGame();
	int tranzam_adime_callback_close(DIALOG *d, int n);
	int tranzam_adime_callback_highscore(DIALOG *d, int n);
	const std::string TimeFromSeconds(long time);
	void adime_transam_callback(DIALOG *d);
	BITMAP* GenerateChecker();


	//help.cpp
	bool TransAmHelpLogic();
	bool TransAmHelpDrawing();

	//credits.cpp
	bool CreditLogic();
	bool CreditDrawing();
    void CreditInitialise();
    void CreditDestroy();
    bool GenerateBitmaps();

	//logo.cpp
	bool TransAmLogoLogic();
	bool TransAmLogoDrawing();

	//game.cpp
	bool TransAmGameLogic();
	bool TransAmGameDrawing();
	bool NewLevel();
	void CleanUp();
	bool InitialiseLevel(bool ReloadLevel);
	bool LoadLevel();
	void RegenerateAstarMap(int magicblock=57);
	void GetWayPoints();

	//menu.cpp
	bool TransAmMenuLogic();
	bool TransAmMenuDrawing();
	bool AdvancedConfiguration();

	//wingame.cpp
	bool WinGameLogic();
	bool WinGameDrawing();

	//countdown.cpp
	bool StartCountdownLogic();
	bool StartCountdownDrawing();

	//pause
	bool PauseLogic();
	bool PauseDrawing();

	//wingame.cpp
	void GameEndInitialiseEndScreen();
	void GameEndDestroyEndScreen();
	bool GameEndLogic();
	bool GameEndDrawing();

	//highscore.cpp
	void HighScoreInitialise();
	void HighScoreDestroy();
	bool HighScoreLogic();
	bool HighScoreDrawing();
	int AddHighScore(int score,const std::string& name,bool reReadFromConfig=true);
	void InitialiseHighScores(bool reread=true);	//from xml

//globals
	//main library variables
	extern Framework* GameFramework;			//framework
	extern AnimationLibrary* GameLibrary;		//our graphics library
	extern Configuration* GameConfiguration;	//our configuration object
	extern bool FMOD_Enabled;					//enabled or not
	extern DATAFILE* GameDAT;					//datafile
	extern std::string currentMapFile;
	//game control
	extern Levels* gameLevels;
	extern Level* currentLevel;
	extern WayPoint WayPoints[50];
	extern WayPoint PlayerPositions[10];	//at most 10 players
	extern int CurrentWayPoint;
	extern bool quitPause;
	extern bool musicInGame;

	//timer stuff
	extern volatile int TimerCurrentFPS;

	//main game graphics
	extern int MaxEnemies;
	extern Animation* DisplayPanel;
	extern Animation* DisplaySpeedo;
	extern Animation* DisplayTemperature;
	extern Animation* DisplayFuel;
	extern Animation* PanelCar;
	extern Animation* Cup;
	extern Animation* StartCountdown;
	extern Animation* RadarUpdate;
	extern BITMAP* LocalRadar;
	extern BITMAP* LocalCup;
	extern BITMAP* LocalCar;
	extern BITMAP* LocalEnemy;
	extern BITMAP* LocalMap;
	extern BITMAP* DisplayedCup;
	extern BITMAP* MemoryBuffer;
	extern BITMAP* MenuTitle;
	extern BITMAP* RadarOff;
	extern BITMAP* RadarWarmup;
	/*extern BITMAP* FontMain;
	extern BITMAP* FontSmall;
	extern BITMAP* FontLarge;
	extern BITMAP* FontLarge2;
	extern BITMAP* FontMain2;*/
	extern FONT* OriginalFont;
	extern FONT* MainFont;
	extern FONT* LargeFont;
	extern FONT* SmallFont;
	extern FONT* LargeFont2;
	extern FONT* MainFont2;
	extern bool GlobalReset;

	//map stuff - where to show the map
	extern int ScreenXOffset;
	extern int ScreenYOffset;
	extern bool OriginalView;
	extern int ShownMapWidth;
	extern int ShownMapHeight;
	extern float mapXoff;
	extern float mapYoff;
	extern int* AstarMap;
	extern int AStarDistance_StartChase;
	//extern int AStarDistance2;
	//extern int AStarDistance3;

	//extern bool showFPS;

	//temp
	extern int temp2,temp3,temp4;
	extern float temp1;

	//car
	extern fix FIX_ANGLE[];
	extern int Lives;
	//enemy stuff
	extern EnemyCar* Enemies[];
	extern BITMAP* PlayerCars[40];
	extern BITMAP* EnemyCars[40];
	extern BITMAP* ShadowCars[40];

	//cup
	extern int MaxNumCups;
	extern int NumCups;
	extern int CupPositions[TotalMaxNumCups][3];


	extern int TempLocalRadar;

//fmod stuff
	extern FMUSIC_MODULE* ActiveMusic;

//samples
	extern FSOUND_SAMPLE *snd_menuchange;
	extern FSOUND_SAMPLE *snd_menuselect;
	extern FSOUND_SAMPLE *snd_gamefuelincrease;
	extern FSOUND_SAMPLE *snd_gamelowfuel;
	extern FSOUND_SAMPLE *snd_gamehandbrake;
	extern FSOUND_SAMPLE *snd_gamecarcrash;
	extern FSOUND_SAMPLE *snd_gamecountdown;
	extern FSOUND_SAMPLE *snd_gamecarmoving;
	extern FSOUND_SAMPLE *snd_findcup;
	extern FSOUND_SAMPLE *snd_gameradar;

extern bool TempDebug;
#endif
