#ifndef		WATER_H
#define		WATER_H

class Params {
	public:
		static int rippleSize;
		static int damping;
		static int smoothing;
		static float drops;
		static int zoom;
		static char back[512];
	
	public:
		static void Load();
		static void Save();
};

class Water {
	protected:
		int *prev;
		int *curr;
		int bSize;
		int w, h;
		int dispLut[512];

	public:
		Water(int w, int h);
		~Water();
	
		void Create(int w, int h);
		void Destroy();

		void Drop(int x, int y, int size);
		void Draw(BITMAP *buffer, int w, int h,int d);
		void Process();
};

#endif		//WATER_H
