//Tranz-Am
#include "game_transam.h"

//local game specifics
static bool newLevelRequired=true;	//new level
static bool WinGame=false;

static Car* Player=NULL;
static int countdown=1;
static long secondsPlayed=0;
static BITMAP* localMap=NULL;

static bool showLocal=true;
static bool showMap=true;
static std::string targetState="";
static bool countdownShown=false;
static bool lastKeyWasM=false;

static const int windowWidth=220; //half
static const int windowHeight=75;
static ScrollingText* tickerTapeHandler=NULL;

enum RADARMODE {RADAR_OFF, RADAR_WARMUP, RADAR_ACTIVE};
static RADARMODE radarMode=RADAR_OFF;

//radar
/*
when on reduces top speed by half
when on takes 20 seconds to warm up, or 1 second if easy
when on updates check every 10 seconds, or 5 if easy
not available for hard

<50 blocks beeps every 200 ms
<100 blocks beeps every 500 ms
>100 blocks beeps every 1000ms
*/
static int radarWarmup;		//how long before radar is working
static int radarCheckTime;	//when working how often to check
static const int radarSmallBlockDistance=40*32;
static const int radarMediumBlockDistance=60*32;
static const int radarLargeBlockDistance=80*32;
static int radarSmallBlockRepeatTime;
static int radarMediumBlockRepeatTime;
static int radarLargeBlockRepeatTime;
static int radarLargestBlockRepeatTime;
static bool radarAvailable=false;	//toggle on/off for switching in/out
static int radarFrameCount=0;
static int playingRadarBeep=-1;
static int radarRepeatReady=0;
static int radarRepeatReadyConstant=0;

static bool Logic_NewLevel();
static void Logic_UpdateRadarSystem();
static void Logic_GameKeyCheck();
static bool Logic_EndOfGameCheck();
static void Logic_CounterUpdates();
static bool Logic_UpdatePlayers();
static void Draw_PanelContents();
static void Draw_Enemies();
static void Draw_Player();
static void Draw_StateInformation();
static void Draw_PanelContents_LocalRadar();


bool TransAmGameLogic()
{
	if(GlobalReset)
	{
		MapRestore();
	}

	//has a new level started
	if(newLevelRequired)
	{
		if ( Logic_NewLevel() )
			return true;	//failed
	}

	//keyboard check for non-game keys
	Logic_GameKeyCheck();

	if( Logic_EndOfGameCheck() )
		return false;

	Logic_CounterUpdates();

	if( Logic_UpdatePlayers() )
		return false;

	//radar
	Logic_UpdateRadarSystem();

	//move the map the same as the player has moved
	//the car is always in the centre
	mapYoff=Player->mapy-(ShownMapHeight/2);
	mapXoff=Player->mapx-(ShownMapWidth/2);

	//stop falling off, just in case car code doesn't work
	//if(mapYoff+ShownMapHeight>(mapblockheight*mapheight-1))
	//	mapYoff=mapblockheight*mapheight-1-ShownMapHeight;
	//if(mapYoff<0) mapYoff=0;
	//if(mapXoff+ShownMapWidth>(mapblockwidth*mapwidth-1))
	//	mapXoff=mapblockwidth*mapwidth-1-mapXoff;
	//if(mapXoff<0) mapXoff=0;

	//mappy animations
	MapUpdateAnims();

	return false;
}

//drawing loop, called 1/FPS seconds
bool TransAmGameDrawing()
{
	//clear(GameFramework->DrawingSurface);

	//debug code
	//if(key[KEY_1])
	//	MapChangeLayer(1);


	//draw basic tilemap first
	MapDrawBGT (GameFramework->DrawingSurface, (int)mapXoff, (int)mapYoff, ScreenXOffset, ScreenYOffset, ShownMapWidth, ShownMapHeight);
	MapDrawFG (GameFramework->DrawingSurface, (int)mapXoff, (int)mapYoff, ScreenXOffset, ScreenYOffset, ShownMapWidth, ShownMapHeight, 0);
	MapChangeLayer(0);

	Draw_Enemies();

	Draw_PanelContents();

	Draw_Player();

	if(OriginalView)
		Draw_StateInformation();

	/*for(int n=0;n<MaxNumCups;n++)
		{
			textprintf_ex(GameFramework->DrawingSurface,font,240,0,-1,-1,"%d %d",(int)Player->mapx/32,(int)Player->mapy/32);
			textprintf_ex(GameFramework->DrawingSurface,font,100,n*15,-1,-1,"%d %d %d",CupPositions[n][0],CupPositions[n][1],CupPositions[n][2]);
		}*/
	return false;
}

/**********************************************
	local helper functions
*/

//initialise the new level
bool InitialiseLevel(bool Reload)
{
	FSOUND_StopSound(FSOUND_ALL);
	newLevelRequired=false;
	WinGame=false;

	OriginalView=true;	//set this according to currenLevel flag when created
	radarFrameCount=0;
	if(currentLevel->gameMode==GT_NORMAL || currentLevel->gameMode==GT_CUP)
	{
		radarSmallBlockRepeatTime=GameConfiguration->CapsSystem.fps;
		radarMediumBlockRepeatTime=GameConfiguration->CapsSystem.fps*4;
		radarLargeBlockRepeatTime=GameConfiguration->CapsSystem.fps*8;
		radarLargestBlockRepeatTime=GameConfiguration->CapsSystem.fps*30;
		radarRepeatReady=radarLargeBlockRepeatTime;
		if(currentLevel->flag==0 && currentLevel->gameMode!=GT_CUP)	//easy
		{
			radarMode=RADAR_WARMUP;
			radarWarmup=GameConfiguration->CapsSystem.fps*5;
			radarCheckTime=GameConfiguration->CapsSystem.fps*5;
		}
		else if(currentLevel->flag==1 || currentLevel->gameMode==GT_CUP)	//normal
		{
			radarMode=RADAR_WARMUP;
			radarWarmup=GameConfiguration->CapsSystem.fps*20;
			radarCheckTime=GameConfiguration->CapsSystem.fps*10;
		}
		else
			radarMode=RADAR_OFF;

		fblend_rect_trans(GameFramework->DrawingSurface,SCREEN_W/2-windowWidth,SCREEN_H/2-windowHeight,windowWidth*2,windowHeight*2,makecol(239, 119, 32),246);
		//ss << "Generating Map...";
		textout_centre_ex(GameFramework->DrawingSurface,MainFont2,"Generating Map...",SCREEN_W/2,SCREEN_H/2-20,0,-1);

		GameFramework->ManualDraw();
	}
	else
		radarMode=RADAR_OFF;

	if(Reload)
	{
		targetState="";
		secondsPlayed=currentLevel->countdown;
		NumCups=0;
		CleanUp();
		if(!LoadLevel())		//load map
		{
			Configuration::GlobalErrorString="Could not initialise map. Check log file and the '" + currentLevel->filename +"' file exists.";
			return false;
		}

		if(currentLevel->gameMode==GT_SURVIVAL || currentLevel->gameMode==GT_RACE)
			OriginalView=false;

		if(OriginalView)
			ScreenXOffset=DisplayPanel->ReadOnly_CurrentItem->w;
		else
			ScreenXOffset=0;
		ShownMapWidth=GameConfiguration->CapsGraphics.ScrWidth-ScreenXOffset;
		ShownMapHeight=GameConfiguration->CapsGraphics.ScrHeight-ScreenYOffset;

		Player=new Car();
		Player->SetupCar("player",Reload);

		//set enemies/cups - max set as a const
		//set cups - fixed for normal and zero if not normal or race
		//set enemies - fixed for normal and as xml for anything else
		showLocal=true;
		showMap=true;
		if(currentLevel->gameMode==GT_NORMAL)
		{
			MaxNumCups=MainGameCups;
			if(currentLevel->flag==0)
			{
				MaxEnemies=MainGameEnemiesEasy;
				Lives=3;
			}
			else if(currentLevel->flag==1)
			{
				MaxEnemies=MainGameEnemies;
				Lives=3;
			}
			else
			{
				MaxEnemies=MainGameEnemiesHard;
				Lives=2;
			}
		}
		else if(currentLevel->gameMode==GT_SURVIVAL)
		{
			Lives=0;
			showLocal=true;
			showMap=false;
			MaxEnemies=currentLevel->enemies;
			MaxNumCups=0;
			Player->DamageLevel=8;
			OriginalView=false;
		}
		else if(currentLevel->gameMode==GT_RACE)
		{
			Lives=0;
			showLocal=true;
			showMap=false;
			OriginalView=false;
			MaxEnemies=currentLevel->enemies;
			//MaxEnemies=1; - debugging with 1
			MaxNumCups=0;
		}
		else if(currentLevel->gameMode==GT_QUIZ)
		{
			Lives=1;
			showLocal=true;
			MaxNumCups=0;
			MaxEnemies=currentLevel->enemies;
			Player->SetCurrentState();
			int carState=Player->GetCurrentState();
			int findState=carState;
			while(findState==carState && findState!=33)
				findState=(rand()%49)+1;

			std::string target;
			std::string message;
			if(currentLevel->flag==1)
			{
				targetState=states[findState][0];
				target=states[findState][0];
				message="Find the state of "+target;
			}
			else
			{
				target=states[findState][1];
				targetState=states[findState][0];
				message="Find the state whose capital is "+target;
			}
			fblend_rect_trans(GameFramework->DrawingSurface,SCREEN_W/2-(windowWidth+50),SCREEN_H/2-windowHeight,(windowWidth+50)*2,windowHeight*2,makecol(239, 119, 32),246);
			textout_centre_ex(GameFramework->DrawingSurface,SmallFont,message.c_str(),SCREEN_W/2,SCREEN_H/2-20,0,-1);
			textout_centre_ex(GameFramework->DrawingSurface,SmallFont,"Press Any Key/Button",SCREEN_W/2,SCREEN_H/2+30,0,-1);
			GameFramework->ManualDraw();
			if(keypressed())readkey();
			while(true)
			{
				if(keypressed() || GameFramework->JoypadAnythingPressed())
					break;
			}
		}
		else	//cup
		{
			Lives=3;
			showMap=false;
			MaxNumCups=currentLevel->flag;
			MaxEnemies=currentLevel->enemies;
		}
		if(currentLevel->filename=="transam.fmp")
			showMap=true;

		if(MaxNumCups>TotalMaxNumCups)
			MaxNumCups=TotalMaxNumCups;
		if(MaxEnemies>TotalMaxEnemies)
			MaxEnemies=TotalMaxEnemies;

		//place cups
		int cupsPlaced=0;
		int x,y;
		BLKSTR* block;
		int count=0;
		while(cupsPlaced<MaxNumCups)
		{
			x=rand() % mapwidth;
			y=rand() % mapheight;
			block=MapGetBlock (x,y);
			if(block->br)
			{
				CupPositions[cupsPlaced][0]=x;
				CupPositions[cupsPlaced][1]=y;
				CupPositions[cupsPlaced][2]=0;	//set not found
				cupsPlaced++;
				MapSetBlock(x,y,CupBlockNumber);
			}
			count++;
			if(count>(mapwidth*mapheight))
			{
				//something wrong, e.g. cannot find blank spaces - dodgy map
				blit(GameFramework->DrawingSurface,MemoryBuffer,0,0,0,0,MemoryBuffer->w,MemoryBuffer->h);
				adime_lowlevel_dialogf(
					"Information",
					ADIME_ALIGN_CENTRE, ADIME_ALIGN_CENTRE, 100,
					"Could not place cups!.%nothing[]"
					"Not enough blank spaces found in map%nothing[]"
					"Game will exit%nothing[]"
					"%buttonrow[OK;ENTER]",tranzam_adime_callback_close
					);
				return false;
			}
		}

		//enemies
		for(int i=0;i<MaxEnemies;i++)
			Enemies[i]=new EnemyCar(i);

		//initialise local map
		if(localMap) destroy_bitmap(localMap);
		localMap=NULL;
		if(is_video_bitmap(LocalMap))
			localMap=create_video_bitmap(LocalMap->w,LocalMap->h);

		if(!localMap)
		{
			if (is_system_bitmap(LocalMap))
				localMap=create_system_bitmap(LocalMap->w,LocalMap->h);
			else
				localMap=create_bitmap(LocalMap->w,LocalMap->h);
		}
		clear_to_color(localMap,bitmap_mask_color(localMap));
		draw_sprite(localMap,LocalMap,0,0);

		//	put in petrol stations and roads
		BLKSTR* tmp;
		for(int y=0;y<mapheight;y++)
		{
			for(int x=0;x<mapwidth;x++)
			{
				tmp=MapGetBlock(x,y);
				if(tmp->unused2)	//road
					putpixel(localMap,(int)(x/LocalMapScale),(int)(y/LocalMapScale),makecol(229,167,1));
				if(tmp->unused1)	//petrol
					putpixel(localMap,(int)(x/LocalMapScale),(int)(y/LocalMapScale),makecol(255,255,255));
			}
		}
	}
	else
	{
		//refresh
		Player->SetupCar("player",false,false);
		Player->lastState=-1;
		Player->SetCurrentState();
	}

	if(currentLevel->gameMode==GT_RACE)
	{
		Player->angle=currentLevel->flag;
		Player->mapx=mapblockwidth*PlayerPositions[0].x;
		Player->mapy=mapblockheight*PlayerPositions[0].y;
	}

	RegenerateAstarMap();

	BLKSTR* startpos;
	//initialise the location of what part of the map (top left) we show - the middle for normal games
	bool foundRandom=false;
	if(currentLevel->positionX==0 || currentLevel->positionX<-1 || currentLevel->positionX>mapwidth)
		//middle
		mapXoff=(mapblockwidth*mapwidth)/2;
	else if(currentLevel->positionX>0)
		mapXoff=currentLevel->positionX;
	else
	{
		//random
		int loop=0;
		while(true)
		{
			loop++;
			foundRandom=true;
			mapXoff=rand()%mapwidth*mapblockwidth+(mapblockwidth/2);
			mapYoff=rand()%mapheight*mapblockheight+(mapblockheight/2);
			startpos=MapGetBlockInPixels((int)mapXoff,(int)mapYoff);
			if(startpos->tr)
				break;

			//stop endless loop
			if(loop>mapwidth*mapheight)
				break;
		}
	}

	if(currentLevel->gameMode==GT_RACE)
	{
		//already set player positions
		mapYoff=Player->mapy-(ShownMapHeight/2);
		mapXoff=Player->mapx-(ShownMapWidth/2);
	}
	else
	{
		if(currentLevel->positionY==0 || currentLevel->positionY<-1 || currentLevel->positionY>mapheight)
			//middle
			mapYoff=(mapblockheight*mapheight)/2;
		else if(currentLevel->positionY>0)
			mapYoff=currentLevel->positionY;
		else
		{
			//random - only need to look once
			int loop=0;
			if(!foundRandom)
			{
				while(true)
				{
					loop++;
					mapXoff=rand()%mapwidth*mapblockwidth+(mapblockwidth/2);
					mapYoff=rand()%mapheight*mapblockheight+(mapblockheight/2);
					startpos=MapGetBlockInPixels((int)mapXoff,(int)mapYoff);
					if(startpos->tr)
						break;

					//stop endless
					if(loop>mapwidth*mapheight)
						break;
				}
			}
		}
	}

	//initialise the car
	for(int i=0;i<MaxEnemies;i++)
	{
		if(AStarDistance_StartChase/mapblockwidth>110)
			Enemies[i]->SetupCar();	//use default (40)
		else
			Enemies[i]->SetupCar(10);	//get closer as map is small

		//positions if race
		if(currentLevel->gameMode==GT_RACE)
		{
			if(i<9 )	//player is position 0
			{
				Enemies[i]->mapx=PlayerPositions[i+1].x*mapblockwidth;
				Enemies[i]->mapy=PlayerPositions[i+1].y*mapblockheight;
				Enemies[i]->angle=currentLevel->flag;
				Enemies[i]->screenx=(int)(Enemies[i]->mapx-mapXoff+ScreenXOffset);//-(this->car->ReadOnly_CurrentItem->w/2);
				Enemies[i]->screeny=(int)(Enemies[i]->mapy-mapYoff+ScreenYOffset);//-(this->car->ReadOnly_CurrentItem->h/2);
			}
		}
	}

	//initialise the car location to be the current map location, but in the centre
	//if cannot, then get random position
	Player->mapx=mapXoff+(ShownMapWidth/2);
	Player->mapy=mapYoff+(ShownMapHeight/2);

	//just in case block has a grave
	startpos=MapGetBlockInPixels((int)Player->mapx,(int)Player->mapy);
	if(!startpos->tr && currentLevel->gameMode!=GT_RACE)
	{
		//int offset=15;
		int loop=0;
		while(true)
		{
			loop++;
			Player->mapx=rand()%mapwidth*mapblockwidth+(mapblockwidth/2);
			Player->mapy=rand()%mapheight*mapblockheight+(mapblockheight/2);
			startpos=MapGetBlockInPixels((int)Player->mapx,(int)Player->mapy);
			if(startpos->tr)
				break;

			//endless loop
			if(loop>mapwidth*mapheight)
				break;
		}
	}

	//no need now we get random - MapSetBlockInPixels(Player->mapx,Player->mapy,CupBlockFreeNumber);	//ensure start position does not have anything, e.g. a grave

	return true;
}

#define RANDAMOUNT 600
void RegenerateAstarMap(int magicblock)
{
	//regenerate map (1 blocked, 0 open, 2 open but prefer not to use it)
	BLKSTR* CurrentBlock;
	if(AstarMap) delete AstarMap;
	AstarMap=new int[mapwidth*mapheight];


	//to compensate for the car going too fast and changing diagonal direction next to an item
	//crashing into it, add padding around all blocks to save adding padding blocks on the map
	//change to a random amount to include errors or allow cars to sometimes go diagonally
	bool randy;
	BLKSTR* temp;
	short int * mymappt;
	for(int i=0;i<mapheight;i++)
		for(int j=0;j<mapwidth;j++)
		{
			MapChangeLayer(1);
			mymappt = mappt;
			mymappt += j;
			mymappt += i*mapwidth;
			CurrentBlock=MapGetBlock(j,i);
			if(*mymappt==magicblock)
			{
				//this is to allow pre-placed magic blocks to be used
				//only in the menu to coax the cars along
				AstarMap[i*mapwidth+j]=1;
				MapChangeLayer(0);
			}
			else
			{
				MapChangeLayer(0);
				CurrentBlock=MapGetBlock(j,i);
				if(CurrentBlock->tl)
				{
					//astar is only bothered by 0 or positive so using 2 for real collision, 1 for padded
					//this is so it we might be able to use it for weighted tiles later
					AstarMap[i*mapwidth+j]=2;

					//put in padding for x% of the time
					//dont fill all because might block an exit
					if(rand()%1000 > RANDAMOUNT) randy=true;
					else randy=false;
					if(randy && i>0 && j>0)
					{
						AstarMap[(i-1)*mapwidth+j-1]=1;			//top left
						temp=MapGetBlock(j-1,i-1);
						if(!temp->tl)
						{
							MapChangeLayer(1);
							MapSetBlock(j-1,i-1,magicblock);
							MapChangeLayer(0);
						}
					}
					if(rand()%1000 > RANDAMOUNT) randy=true;
					else randy=false;
					if(randy && i>0)
					{
						temp=MapGetBlock(j,i-1);
						if(!temp->tl)
						{
							MapChangeLayer(1);
							MapSetBlock(j,i-1,magicblock);
							MapChangeLayer(0);
						}
						AstarMap[(i-1)*mapwidth+j]=1;					//top
					}
					if(rand()%1000 > RANDAMOUNT) randy=true;
					else randy=false;
					if(randy && i>0 && j<mapwidth-1)
					{
						temp=MapGetBlock(j+1,i-1);
						if(!temp->tl)
						{
							MapChangeLayer(1);
							MapSetBlock(j+1,i-1,magicblock);
							MapChangeLayer(0);
						}
						AstarMap[(i-1)*mapwidth+j+1]=1;	//top right
					}
					if(rand()%1000 > RANDAMOUNT) randy=true;
					else randy=false;
					if(randy && j>0)
					{
						temp=MapGetBlock(j-1,i);
						if(!temp->tl)
						{
							MapChangeLayer(1);
							MapSetBlock(j-1,i,magicblock);
							MapChangeLayer(0);
						}
						AstarMap[i*mapwidth+j-1]=1;						//left
					}
					if(rand()%1000 > RANDAMOUNT) randy=true;
					else randy=false;
					if(randy && j<mapwidth-1)
					{
						temp=MapGetBlock(j+1,i);
						if(!temp->tl)
						{
							MapChangeLayer(1);
							MapSetBlock(j+1,i,magicblock);
							MapChangeLayer(0);
						}
						AstarMap[i*mapwidth+j+1]=1;			//right
					}
					if(rand()%1000 > RANDAMOUNT) randy=true;
					else randy=false;
					if(randy && i<mapheight-1 && j>0)
					{
						temp=MapGetBlock(j-1,i+1);
						if(!temp->tl)
						{
							MapChangeLayer(1);
							MapSetBlock(j-1,i+1,magicblock);
							MapChangeLayer(0);
						}
						AstarMap[(i+1)*mapwidth+j-1]=1;	//bottom left
					}
					if(rand()%1000 > RANDAMOUNT) randy=true;
					else randy=false;
					if(randy && i<mapheight-1)
					{
						temp=MapGetBlock(j,i+1);
						if(!temp->tl)
						{
							MapChangeLayer(1);
							MapSetBlock(j,i+1,magicblock);
							MapChangeLayer(0);
						}
						AstarMap[(i+1)*mapwidth+j]=1;			//bottom
					}
					if(rand()%1000 > RANDAMOUNT) randy=true;
					else randy=false;
					if(randy && i<mapheight-1 && j<mapwidth-1)
					{
						temp=MapGetBlock(j+1,i+1);
						if(!temp->tl)
						{
							MapChangeLayer(1);
							MapSetBlock(j+1,i+1,magicblock);
							MapChangeLayer(0);
						}
						AstarMap[(i+1)*mapwidth+j+1]=1;	//bottom right
					}
				}
				else
				{
					AstarMap[i*mapwidth+j]=0;
				}
			}
			//AstarMap[i*mapwidth+j]=0;	//go anywhere for now
		}
}

//reset everything
void CleanUp()
{
	FSOUND_StopSound(FSOUND_ALL);

	//player
	if(Player) delete Player;
	Player=NULL;

	for(int i=0;i<MaxEnemies;i++)
	{
		if(Enemies[i]) delete Enemies[i];
		Enemies[i]=NULL;
	}

	//local map
	if(localMap)
	{
		destroy_bitmap(localMap);
		localMap=NULL;
	}

	//astar
	if(AstarMap)
		delete AstarMap;
	AstarMap=NULL;

	//mappy
	//initial map file, try VRAM is paging or triple buffering
	MapFreeMem();

}

bool LoadLevel()
{
	//starts the level
	//does not perform resetting of all data as may be just a new life
	std::string mapName="";
	int loaded=1; //default to not loaded

	//mappy doesn't support system bitmaps
	char filechar[255];
	mapName=currentLevel->filename;
	sprintf(filechar,"%s%s","levels\\",mapName.c_str());
	std::string filename=fix_filename_slashes( filechar );

	if(GameConfiguration->CapsActualSystem.GraphicsMode==MODE_PAGED || GameConfiguration->CapsActualSystem.GraphicsMode==MODE_TRIPLE)
	{
		loaded=MapLoadVRAM((char*)filename.c_str());
		if(loaded!=0) Configuration::LogEntry("Buffer is VRAM but could not load map into vram, using standard");
		else Configuration::LogEntry("loaded map into VRAM");
	}
	if(loaded!=0)
	{
		loaded=MapLoad ((char*)filename.c_str());
		if(loaded!=0) Configuration::LogEntry("Buffer is not VRAM but could not load map into memory! crikey!");
		else Configuration::LogEntry("loaded map into memory");
	}
	if(loaded!=0) return false;

	//path finding - half it as player can be in middle
	if(mapwidth<110 || mapheight<110)
	{
		//small map - maps must be greater than a screen
		AStarDistance_StartChase=mapblockwidth*20;		//distance to start hunting
		//AStarDistance2=mapblockwidth*4;		//distance for refreshing path 200ms
		//AStarDistance3=mapblockwidth*10;	//distance for refreshing path 500ms
	}
	else
	{
		AStarDistance_StartChase=mapblockwidth*40;
		//AStarDistance2=mapblockwidth*4;
		//AStarDistance3=mapblockwidth*10;
	}

	//mappy initialisation
	MapGenerateYLookup();
	MapInitAnims ();

	if(currentLevel->gameMode==GT_RACE)
	{
		GetWayPoints();
		CurrentWayPoint=0;
	}
	//code to generate the bitmap image
	//BITMAP* image=create_bitmap(mapwidth,mapheight);
	//int blocknum;
	//BLKSTR* blk;
	//clear_to_color(image,makecol(255,0,255));
	//for(int x=0;x<mapwidth;x++)
	//{
	//	for(int y=0;y<mapheight;y++)
	//	{
	//		blocknum=MapGetBlockNumber(x,y);
	//		if((blocknum>2 && blocknum<11) || (blocknum>13 && blocknum<21))
	//		{
	//			//blue sea
	//		}
	//		else
	//		{
	//			//normal pixel
	//			//putpixel(image,x,y,makecol(0,255,0));
	//			//shaded by state
	//			MapChangeLayer(1);
	//			blk=MapGetBlock(x,y);
	//			//putpixel(image,x,y,makecol(5*blk->user4,5*blk->user4,5*blk->user4));
	//			putpixel(image,x,y,makecol(0,255-(4*blk->user4),0));
	//			MapChangeLayer(0);
	//		}
	//	}
	//}
	//save_bmp("temp.bmp",image,NULL);
	//destroy_bitmap(image);

	return true;
}

void GetWayPoints()
{
	//players are shown on layer 2 as blocks 1 to 10 with the cups drawn to allow the cars to get to any point on a line. player is 0
	//waypoints are shown on layer 3 as blocks 1 onwards for up to 50 blocks
	//waypoints start from enemy to each block in order
	//roughly every 30-40 blocks is a waypoint
	for(int i=0;i<50;i++)
	{
		WayPoints[i].x=0;
		WayPoints[i].y=0;
		if(i<10)
		{
			PlayerPositions[i].x=0;
			PlayerPositions[i].y=0;
		}
	}

	int blid;
	for(int j=0;j<mapheight;j++)
	{
		for(int i=0;i<mapwidth;i++)
		{
			//player check
			MapChangeLayer(2);
			blid=MapGetBlockNumber(i,j);
			if(blid>0 && blid<11)
			{
				PlayerPositions[blid-1].x=i;
				PlayerPositions[blid-1].y=j;
			}

			//waypoint check
			MapChangeLayer(3);
			blid=MapGetBlockNumber(i,j);
			if(blid>0 && blid<51)
			{
				WayPoints[blid-1].x=i;
				WayPoints[blid-1].y=j;
			}
		}
	}
	MapChangeLayer(0);


}

/* *********************
	Logic helper functions
******************/
static bool Logic_NewLevel()
{
	std::ostringstream ss;
	if(!InitialiseLevel(true))
	{
		countdownShown=false;
		return true;	//exit logic loop and game if failure
	}
	if(currentLevel->filename=="transam.fmp" )
	{
		if(tickerTapeHandler) delete tickerTapeHandler;
		tickerTapeHandler=NULL;
	//if(!tickerTapeHandler && currentLevel->filename=="transam.fmp" )
		if(GameConfiguration->GetCustom("tickertape",1)==1)
			tickerTapeHandler=new ScrollingText(SCREEN_W-ScreenXOffset,text_height(SmallFont),2,SmallFont);	//60.0/(float)GameConfiguration->CapsSystem.fps
	}
	if(currentLevel->gameMode==GT_NORMAL || currentLevel->gameMode==GT_CUP)
	{
		fblend_rect_trans(GameFramework->DrawingSurface,SCREEN_W/2-windowWidth,SCREEN_H/2-windowHeight,windowWidth*2,windowHeight*2,makecol(239, 119, 32),246);
		ss.str("");
		if(currentLevel->gameMode==GT_CUP)
			ss << "Collect " << currentLevel->flag << " cup(s)";
		else
			ss << "Collect " << MainGameCups << " cups to win the Ultimate Cup";

		textout_centre_ex(GameFramework->DrawingSurface,SmallFont,ss.str().c_str(),SCREEN_W/2,SCREEN_H/2-20,0,-1);
		ss.str("");
		ss << "Press Any Key/Button";
		textout_centre_ex(GameFramework->DrawingSurface,SmallFont,ss.str().c_str(),SCREEN_W/2,SCREEN_H/2+30,0,-1);
		GameFramework->ManualDraw();
		if(keypressed())readkey();
		while(true)
		{
			if(keypressed() || GameFramework->JoypadAnythingPressed())
				break;
		}
	}

	if(currentLevel->countdown)
	{
		ss.str("");
		ss << "This is a timed race. You have " << currentLevel->countdown << " Seconds to finish.";
		fblend_rect_trans(GameFramework->DrawingSurface,SCREEN_W/2-(windowWidth+50),SCREEN_H/2-windowHeight,(windowWidth+50)*2,windowHeight*2,makecol(239, 119, 32),246);
		textout_centre_ex(GameFramework->DrawingSurface,SmallFont,ss.str().c_str(),SCREEN_W/2,SCREEN_H/2-20,0,-1);
		textout_centre_ex(GameFramework->DrawingSurface,SmallFont,"Press Any Key/Button",SCREEN_W/2,SCREEN_H/2+30,0,-1);
		GameFramework->ManualDraw();
		if(keypressed())readkey();
		while(true)
		{
			if(keypressed() || GameFramework->JoypadAnythingPressed())
				break;
		}
	}
	return false;
}

static void Logic_UpdateRadarSystem()
{
	static int lastRadarCheckDistance=0;
	if(radarMode!=RADAR_OFF)
	{
		radarFrameCount++;
		if(radarMode==RADAR_WARMUP)
		{
			radarAvailable=false;
			if (radarFrameCount>radarWarmup)
			{
				//radar is now active
				radarFrameCount=0;
				radarRepeatReady=radarLargeBlockRepeatTime;
				radarMode=RADAR_ACTIVE;
				radarAvailable=true;
			}
		}
		else
		{
			//active
			if(radarFrameCount>radarCheckTime)
			{
				//radar is active and is about to update location radar
				//calculate distance to nearest cup and set sound effect repeat
				float d=0.0;
				float lastd=-1;
				radarFrameCount=0;

				for(int i=0;i<MaxNumCups;i++)
				{
					if(!CupPositions[i][2])	//cup still available to be found
					{
						d=(float)hypot((CupPositions[i][0]*mapblockwidth)-Player->mapx,(CupPositions[i][1]*mapblockheight)-Player->mapy);
						if(d<lastd || lastd<0) lastd=d;
					}
				}
				d=lastd;
				if(d<radarSmallBlockDistance)
				{
					//shortest gap
					if(lastRadarCheckDistance!=radarSmallBlockDistance)
					{
						lastRadarCheckDistance=radarSmallBlockDistance;
						radarRepeatReady=radarRepeatReadyConstant=radarSmallBlockRepeatTime;
					}
				}
				else if(d<radarMediumBlockDistance)
				{
					//medium gap
					if(lastRadarCheckDistance!=radarMediumBlockDistance)
					{
						lastRadarCheckDistance=radarMediumBlockDistance;
						radarRepeatReady=radarRepeatReadyConstant=radarMediumBlockRepeatTime;
					}
				}
				else if(d<radarLargeBlockDistance)
				{
					//large gap
					if(lastRadarCheckDistance!=radarLargeBlockDistance)
					{
						lastRadarCheckDistance=radarLargeBlockDistance;
						radarRepeatReady=radarRepeatReadyConstant=radarLargeBlockRepeatTime;
					}
				}
				else
				{
					//largest gap
					if(lastRadarCheckDistance!=(radarMediumBlockDistance+1))	//to make it different to small or large
					{
						lastRadarCheckDistance=(radarLargeBlockDistance+1);
						radarRepeatReadyConstant=radarRepeatReady=radarLargestBlockRepeatTime;
					}
				}
			}
			//radar active and playing normally or first time used
			//check if reached time to play it
			//set sound effect and repeat
			if(--radarRepeatReady<1)
			{
				playingRadarBeep=PlaySFX(snd_gameradar,FSOUND_LOOP_OFF,false,true,playingRadarBeep);
				radarRepeatReady=radarRepeatReadyConstant;
				RadarUpdate->Reset();
				//radarFrameCount=0;
			}
			else
				RadarUpdate->NextMove();
		}
	}
}
static void Logic_GameKeyCheck()
{
	//if(key[KEY_T]) NumCups=MaxNumCups;

	if(keypressed())
	{
		if(key[KEY_M])
		{
			if(!lastKeyWasM)
			{
				if(!musicInGame)
					PlayTrackerSongFromDAT((const char*)(GameDAT[MUSIC_IT_MENU].dat),-1,GameDAT[MUSIC_IT_MENU].size,true,4);
				else
					StopTrackerSong();

				lastKeyWasM=true;
				musicInGame=!musicInGame;
			}
		}
		else
			lastKeyWasM=false;
	}
}
static bool Logic_EndOfGameCheck()
{
	//check for end success. failure is determined next
	switch(currentLevel->gameMode)
	{
	case GT_NORMAL:
		if(NumCups>=MaxNumCups && MaxNumCups>0)
			currentLevel->endState=1;
		break;
	case GT_CUP:
		if(NumCups>=currentLevel->flag)
			currentLevel->endState=1;
		break;
	case GT_QUIZ:
		if(Player!=NULL && Player->usState==targetState)
			currentLevel->endState=1;
		break;
	case GT_RACE:
		break;
	case GT_SURVIVAL:
		break;
	}

	if(currentLevel->countdown>0 && secondsPlayed<=0)
		currentLevel->endState=3;

	//lost a life
	if(Player->State==CAR_DYING && Player->car->ReadOnly_Timers[1])
	{
		//put in grave
		MapSetBlock((int)(Player->mapx/mapblockwidth),(int)Player->mapy/mapblockheight,GraveBlockNumber);

		countdownShown=false;
		Player->State=CAR_NORMAL;
		Lives--;
		if(Lives<0)
			currentLevel->endState=3;
		else
			InitialiseLevel(false);

	}

	//end game
	if(currentLevel->endState!=0)
	{
		if(currentLevel->countdown==0)
			currentLevel->currentTime=secondsPlayed;
		else
			currentLevel->currentTime=currentLevel->countdown-secondsPlayed;

		currentLevel->currentMiles=(long)Player->MilesDriven;

		NumCups=0;
		countdownShown=false;
		newLevelRequired=true;
		NumCups=0;
		CleanUp();

		clear_keybuf();
		GameFramework->SetAutoGameLoop(WinGameLogic,WinGameDrawing);
		return true;
	}
	return false;
}
static void Logic_CounterUpdates()
{
	if(!countdownShown)
	{
		TransAmGameDrawing();
		GameFramework->SetAutoGameLoopOverride(StartCountdownLogic,StartCountdownDrawing);
		countdownShown=true;
	}

	if(tickerTapeHandler)
	{
		if(Player->stateChanged!=-1)
			tickerTapeHandler->SetNewContent(states[Player->stateChanged][2]);
		tickerTapeHandler->FrameUpdate();
	}

	//update relevant in game statistics
	//update counters every second
	if(countdown>=GameConfiguration->CapsSystem.fps)
	{
		countdown=1;
		if(currentLevel->countdown==0)
			secondsPlayed++;
		else
			secondsPlayed--;
	}
	else
		countdown++;
}
static bool Logic_UpdatePlayers()
{
	//update enemies
	//should really be called after player, but we want the hitcar flag to be kept correct
	if(currentLevel->enemies>0)
	{
		int enemyblock=0;
		for(int i=0;i<MaxEnemies;i++)
		{
			Enemies[i]->NextMove(Player);
			if(currentLevel->gameMode==GT_RACE)
			{
				MapChangeLayer(2);
				enemyblock=MapGetBlockNumber((int)(Enemies[i]->mapx/mapblockwidth),(int)(Enemies[i]->mapy/mapblockheight));
				if(enemyblock==CupBlockNumber)
				{
					//we have a winner - or is it a draw?
					currentLevel->endState=3;
				}
				MapChangeLayer(0);
			}
		}
	}

	if(Player->NextMove())
	{
	//	TempDebug=true;
		CleanUp();
		if(tickerTapeHandler)
			delete tickerTapeHandler;
		tickerTapeHandler=NULL;

		newLevelRequired=true;
		countdownShown=false;
		GameFramework->SetAutoGameLoop(
						TransAmMenuLogic,TransAmMenuDrawing
						);
		return true;
	}
	else
	{
		if(currentLevel->gameMode==GT_RACE)
		{
			MapChangeLayer(2);
			if(MapGetBlockNumber((int)(Player->mapx/(float)mapblockwidth),(int)(Player->mapy/mapblockheight))==CupBlockNumber)
			{
				//reached the end. first see if enemy is there at the same time
				if(currentLevel->endState==3)
					currentLevel->endState=2;
				else
					currentLevel->endState=1;
			}
			MapChangeLayer(0);
		}
	}
	return false;
}

/* *********************
	Drawing helper functions
******************/
void Draw_PanelContents()
{
	int speedwidth,tempwidth;
	float Fuelwidth;
	int newx,newy;

	//calculations
	if(!Player->BlockTopSpeedIncrease)
		speedwidth=(int)(((float)(DisplaySpeedo->ReadOnly_CurrentItem->w-20)/Car::MPH_MAX)*((Player->Mph)));
	else
		speedwidth=(int)(((float)DisplaySpeedo->ReadOnly_CurrentItem->w/Car::MPH_MAX)*((Player->Mph)));

	if(speedwidth>DisplaySpeedo->ReadOnly_CurrentItem->w) speedwidth=DisplaySpeedo->ReadOnly_CurrentItem->w;

	tempwidth=(int)(((float)DisplayTemperature->ReadOnly_CurrentItem->w/100)*((Player->Temperature)));
	if(tempwidth>DisplayTemperature->ReadOnly_CurrentItem->w) tempwidth=DisplayTemperature->ReadOnly_CurrentItem->w;

	Fuelwidth=((float)(DisplayFuel->ReadOnly_CurrentItem->w/Car::FUEL_MAX))*Player->Fuel;	//60 as that is how long fuel lasts
	if((int)Fuelwidth>DisplayFuel->ReadOnly_CurrentItem->w) Fuelwidth=(float)DisplayFuel->ReadOnly_CurrentItem->w;

	if(OriginalView)
	{
		//score panel - always top left. maybe only show if screen is > certain size
		blit(DisplayPanel->ReadOnly_CurrentItem,GameFramework->DrawingSurface,0,0,0,0,DisplayPanel->ReadOnly_CurrentItem->w,DisplayPanel->ReadOnly_CurrentItem->h);

		//time and distance
		if(currentLevel->countdown==0)
			textprintf_ex(GameFramework->DrawingSurface,SmallFont,47,35,makecol(255,255,255),-1,"%03ld:%02ld",secondsPlayed/60,secondsPlayed%60);
		else
			textprintf_ex(GameFramework->DrawingSurface,SmallFont,47,35,makecol(255,255,255),-1,"%03ld:%02ld",(currentLevel->countdown-secondsPlayed)/60,(currentLevel->countdown-secondsPlayed)%60);

		textprintf_ex(GameFramework->DrawingSurface,SmallFont,47,63,makecol(255,255,255),-1,"%06.0f",Player->MilesDriven);

		//number of cups found
		if(MaxNumCups>0)
			textprintf_ex(GameFramework->DrawingSurface,SmallFont,125,270,makecol(255,255,255),-1,"%d",NumCups);

		//lives
		for(int i=0;i<Lives;i++)
		{
			if(OriginalView)
				draw_sprite(GameFramework->DrawingSurface,PanelCar->ReadOnly_CurrentItem,18+(i*34),426);
			else
				draw_sprite(GameFramework->DrawingSurface,PanelCar->ReadOnly_CurrentItem,(i*34),SCREEN_H-32);
		}

	}
	else
	{
		//time and distance
		textprintf_ex(GameFramework->DrawingSurface,SmallFont,0,0,makecol(255,255,255),-1,"%03ld:%02ld",secondsPlayed/60,secondsPlayed%60);
		textprintf_ex(GameFramework->DrawingSurface,SmallFont,0,16,makecol(255,255,255),-1,"%06.0f",Player->MilesDriven);

		//number of cups found
		for(int i=0;i<NumCups;i++)
			draw_sprite(GameFramework->DrawingSurface,DisplayedCup,136+(i*DisplayedCup->w),SCREEN_H-DisplayedCup->h-2);
	}

	Draw_PanelContents_LocalRadar();

	if(OriginalView)
	{
		masked_blit(PanelCar->ReadOnly_CurrentItem,GameFramework->DrawingSurface,
		0,PanelCar->ReadOnly_CurrentItem->h-Player->DamageLevel,
		18+(Lives*34),426+PanelCar->ReadOnly_CurrentItem->h-Player->DamageLevel,
		Player->car->ReadOnly_CurrentItem->w,
		Player->DamageLevel);

		blit(DisplayFuel->ReadOnly_CurrentItem,GameFramework->DrawingSurface,0,0,58,333,(int)Fuelwidth,DisplayFuel->ReadOnly_CurrentItem->h);
		blit(DisplayTemperature->ReadOnly_CurrentItem,GameFramework->DrawingSurface,0,0,58,374,tempwidth,DisplayTemperature->ReadOnly_CurrentItem->h);
		blit(DisplaySpeedo->ReadOnly_CurrentItem,GameFramework->DrawingSurface,0,0,58,294,speedwidth,DisplaySpeedo->ReadOnly_CurrentItem->h);

		if(showLocal)
			//radar
			draw_sprite(GameFramework->DrawingSurface,LocalRadar,LocalRadarX,LocalRadarY);

		//local map - map of america
		//	draw map
		if(showMap)
			draw_sprite(GameFramework->DrawingSurface,localMap,LocalMapX,LocalMapY);

		if(radarMode!=RADAR_OFF)
		{
			if(!radarAvailable)
				blit(RadarWarmup,GameFramework->DrawingSurface,0,0,112,198,RadarOff->w,RadarOff->h);
			else
				blit(RadarUpdate->ReadOnly_CurrentItem,GameFramework->DrawingSurface,0,0,112,198,RadarOff->w,RadarOff->h);
		}
		else
			if(currentLevel->gameMode==GT_NORMAL || currentLevel->gameMode==GT_CUP)
				blit(RadarOff,GameFramework->DrawingSurface,0,0,112,198,RadarOff->w,RadarOff->h);

	}
	else
	{
		blit(DisplayFuel->ReadOnly_CurrentItem,GameFramework->DrawingSurface,0,0,0,30,(int)Fuelwidth,DisplayFuel->ReadOnly_CurrentItem->h);
		blit(DisplayTemperature->ReadOnly_CurrentItem,GameFramework->DrawingSurface,0,0,0,48,tempwidth,DisplayTemperature->ReadOnly_CurrentItem->h);
		//blit(DisplaySpeedo->ReadOnly_CurrentItem,GameFramework->DrawingSurface,0,0,52,293,speedwidth,DisplaySpeedo->ReadOnly_CurrentItem->h);

		//textprintf_ex(GameFramework->DrawingSurface,SmallFont,120,270,makecol(255,255,255),-1,"%d",NumCups);
		//radar
		if(showLocal)
		{
			fblend_rect_trans(GameFramework->DrawingSurface,SCREEN_W/2-(LocalRadar->w/2),0,LocalRadar->w,LocalRadar->h,makecol(0,196,60),96);
			draw_sprite(GameFramework->DrawingSurface,LocalRadar,SCREEN_W/2-(LocalRadar->w/2),0);
		}

		if(showMap)
			//local map - map of america
			//	draw map
			draw_sprite(GameFramework->DrawingSurface,localMap,0,0);
	}

	//	put in enemy cars on usa map
	if(currentLevel->flag==0 && showMap)
	{
		for(int i=0;i<MaxEnemies;i++)
		{
			//textprintf_ex(GameFramework->DrawingSurface,font,500,300+i*10,makecol(0,0,0),-1,"%f = %d",Enemies[i]->carangle,(180/AL_PI)*Enemies[i]->carangle);

			newx=(int)((Enemies[i]->mapx/(float)mapblockwidth)/LocalMapScale);
			newy=(int)((Enemies[i]->mapy/(float)mapblockheight)/LocalMapScale);
			if(OriginalView)
				rectfill(GameFramework->DrawingSurface,LocalMapX+newx,LocalMapY+newy,LocalMapX+newx+1,LocalMapY+newy+1,makecol(0,0,255));
			else
				rectfill(GameFramework->DrawingSurface,newx,newy,newx+1,newy+1,makecol(0,0,255));
		}
	}

	//	draw player on map
	if(showMap)
	{
		newx=(int)((Player->mapx/(float)mapblockwidth)/LocalMapScale);
		newy=(int)((Player->mapy/(float)mapblockheight)/LocalMapScale);
		if(OriginalView)
			rectfill(GameFramework->DrawingSurface,LocalMapX+newx,LocalMapY+newy,LocalMapX+newx+1,LocalMapY+newy+1,makecol(255,0,0));
		else
			rectfill(GameFramework->DrawingSurface,newx,newy,newx+1,newy+1,makecol(255,0,0));
	}
}

static void Draw_Enemies()
{
	//enemy cars
	//get rough distance from player, nothing fancy as clipping will take care of it
	//	800x600 has a map screen of about 600, 1024 has a screen of about 800
	float d;
	for(int j=0;j<MaxEnemies;j++)
	{
		if(Enemies[j]->screenx>0 && Enemies[j]->screenx<1000 && Enemies[j]->screeny>0 && Enemies[j]->screeny<1000)
		{
			if(Enemies[j]->shadowOffsetX!=0 || Enemies[j]->shadowOffsetY!=0)
			{
				d=(float)hypot(LightSourceX-Enemies[j]->mapx,LightSourceY-Enemies[j]->mapy);
				fblend_trans(ShadowCars[Enemies[j]->angle/9],GameFramework->DrawingSurface,Enemies[j]->screenx-Enemies[j]->shadowOffsetX-16, Enemies[j]->screeny-Enemies[j]->shadowOffsetY-16,255-(int)(d/255));
				//fblend_trans(ShadowCars[Enemies[j]->angle/9],GameFramework->DrawingSurface,Enemies[j]->screenx+Enemies[j]->shadowOffsetX, Enemies[j]->screeny+Enemies[j]->shadowOffsetY,192);
			}
			draw_sprite(GameFramework->DrawingSurface,EnemyCars[Enemies[j]->angle/9],Enemies[j]->screenx-16,Enemies[j]->screeny-16);
			Enemies[j]->crashParticles->Draw(GameFramework->DrawingSurface);
		}
	}
}

static void Draw_Player()
{
	//car
	if(Player->car)
    {
		if(Player->shadowOffsetX!=0 || Player->shadowOffsetY!=0)
		{
			float d=(float)hypot(LightSourceX-Player->mapx,LightSourceY-Player->mapy);
			fblend_trans(ShadowCars[Player->angle/9],GameFramework->DrawingSurface,Player->screenx-Player->shadowOffsetX, Player->screeny-Player->shadowOffsetY,255-(int)(d/255));
			//fblend_trans(ShadowCars[Player->angle/9],GameFramework->DrawingSurface,Player->screenx-Player->shadowOffsetX, Player->screeny-Player->shadowOffsetY,100);
		}

		draw_sprite(GameFramework->DrawingSurface,PlayerCars[Player->angle/9],Player->screenx, Player->screeny);
		Player->crashParticles->Draw(GameFramework->DrawingSurface);
    }
}

static void Draw_StateInformation()
{
	if(OriginalView)
	{
		textout_centre_ex(GameFramework->DrawingSurface,SmallFont,Player->usState.c_str(),81,410,0,0);
		if(Player->usState!=Player->usStateCapital)	//for dc
			textout_centre_ex(GameFramework->DrawingSurface,SmallFont,Player->usStateCapital.c_str(),81,461,0,0);
	}
	else
	{
		textout_centre_ex(GameFramework->DrawingSurface,SmallFont,Player->usState.c_str(),81,410,0,0);
		if(Player->usState!=Player->usStateCapital)	//for dc
			textout_centre_ex(GameFramework->DrawingSurface,SmallFont,Player->usStateCapital.c_str(),81,461,0,0);
	}

	if(tickerTapeHandler)
		draw_sprite(GameFramework->DrawingSurface,tickerTapeHandler->FrameDraw(),ScreenXOffset,0);

}
static void Draw_PanelContents_LocalRadar()
{
	if(showLocal)
	{
		//local radar - map of cups/enemies close up
		//get offset in blocks
		//assume 1 pixel is 1 block, i.e. 80x80 local radar will show 80x80 block radar
		//at 640x480 its about 5 screens, at 800x600 its about 4 screens
		clear_to_color(LocalRadar,bitmap_mask_color(LocalRadar));
		//if(!OriginalView)
		//	rect(LocalRadar,0,0,LocalRadar->w-1,LocalRadar->h-1,makecol(0,100,200));


		int carblockx=(int)Player->mapx/mapblockwidth;
		int carblocky=(int)Player->mapy/mapblockheight;
		int offset=LocalRadar->w/2;	//assumes a square radar
		int xoff=0;
		int yoff=0;
		for(int n=0;n<MaxNumCups;n++)
		{
			xoff=carblockx-CupPositions[n][0];
			yoff=carblocky-CupPositions[n][1];
			if(!CupPositions[n][2] && abs(xoff)<offset && abs(yoff)<offset)
			{
				//extra 5 pixels is because car is drawn from centre whereas cups/enemies are placed from topleft
				if(TempLocalRadar==1)
					draw_sprite(LocalRadar,LocalCup,offset-xoff-5,offset-yoff-5);
				else
					draw_sprite(LocalRadar,LocalCup,offset+xoff-5,offset+yoff-5);
			}
		}
		//put in enemies if they are close enough
		for(int cars=0;cars<MaxEnemies;cars++)
		{
			//draw on map same way as cups
			xoff=carblockx-((int)Enemies[cars]->mapx/mapblockwidth);
			yoff=carblocky-((int)Enemies[cars]->mapy/mapblockheight);
			//if(abs(Player->mapx-Enemies[cars]->mapx)<320 && abs(Player->mapy-Enemies[cars]->mapy)<320)
			if(abs(xoff)<offset && abs(yoff)<offset)
				//extra 5 pixels is because car is drawn from centre whereas cups/enemies are placed from topleft
				if(TempLocalRadar==1)
					rotate_sprite(LocalRadar,LocalEnemy,offset-xoff-5,offset-yoff-5,itofix(FIX_ANGLE[Enemies[cars]->angle]));
				else
					rotate_sprite(LocalRadar,LocalEnemy,offset+xoff-5,offset+yoff-5,itofix(FIX_ANGLE[Enemies[cars]->angle]));
		}
		//draw the local map and player on the local map
		rotate_sprite(LocalRadar, LocalCar, offset-5,offset-5, itofix(FIX_ANGLE[Player->angle]));
	}
}
