#include <allegro.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include "funkyfont.h"



int MATH_rand (int lowest, int highest)
{

	if (lowest > highest)
	{
		int temp = lowest;
		lowest = highest;
		highest = temp;
	}
	else if (lowest == highest)
		return lowest;


	int diff = highest - lowest;
	int temp_val = rand ();

	return ((temp_val % diff) + lowest);

}



float MATH_abs (float value)
{

	if (value<0.0f)
		return -value;
	else
		return value;

}



int MATH_wrap (int value , int wrap)
{

	if (wrap>0)
	{
		while (value < 0)
			value += (8 * wrap);

		value = value % wrap;

		return value;
	}
	else
		return 0;

}



float MATH_lerp (float value_1, float value_2, float percent)
{

	return (value_1 + ( ( value_2 - value_1 ) * percent ) );

}



void GRAPHICS_double_masked_blit_32bit ( BITMAP *graphic_source_image , BITMAP *mask_source_image , BITMAP *dest_image , int graphic_source_x , int graphic_source_y , int mask_source_x , int mask_source_y , int dest_x , int dest_y , int width , int height )
{
	// For speed (or rather because I'm lazy) this function only checks clipping on the destination image. Feel free to alter
	// it so it checks the sources as well, but I can't be arsed. :)

	// Basically it copies those pixels of graphic_source_image which aren't masked in mask_source_image.

	unsigned long mask_colour = makecol (255,0,255);
	unsigned long *g_source;
	unsigned long *m_source;
	unsigned long *dest;
	unsigned long colour;

	int y;
	int x;
	int start_y = 0;
	int start_x = 0;

	if (dest_x < 0)
		start_x -= dest_x;

	if (dest_y < 0)
		start_y -= dest_y;

	if (dest_x + width > dest_image->w)
		width -= (dest_x + width) - dest_image->w;

	if (dest_y + height > dest_image->h)
		height -= (dest_y + height) - dest_image->h;

	for (y = start_y; y < height; y++)
	{
		g_source = (unsigned long *) graphic_source_image->line[y+graphic_source_y];
		m_source = (unsigned long *) mask_source_image->line[y+mask_source_y];
		dest = (unsigned long *) dest_image->line[y+dest_y];

		for (x = start_x; x < width; x++)
		{
			colour = (unsigned long) (m_source[x+mask_source_x]);
			if (colour != mask_colour)
			{
				dest[x+dest_x] = g_source[x+graphic_source_x];
			}
		}
	}


}



void GRAPHICS_colour_blit_32bit ( BITMAP *mask_source_image , BITMAP *dest_image , int mask_source_x , int mask_source_y , int dest_x , int dest_y , int width , int height , unsigned long text_colour )
{
	// For speed (or rather because I'm lazy) this function only checks clipping on the destination image. Feel free to alter
	// it so it checks the sources as well, but I can't be arsed. :)

	// Basically it plot the given colour to the given image for those pixels which aren't masked in mask_source_image.

	unsigned long mask_colour = makecol (255,0,255);

	unsigned long *m_source;
	unsigned long *dest;

	unsigned long colour;

	int y;
	int x;
	int start_y = 0;
	int start_x = 0;

	if (dest_x < 0)
		start_x -= dest_x;

	if (dest_y < 0)
		start_y -= dest_y;

	if (dest_x + width > dest_image->w)
		width -= (dest_x + width) - dest_image->w;

	if (dest_y + height > dest_image->h)
		height -= (dest_y + height) - dest_image->h;

	for (y = start_y; y < height; y++)
	{
		m_source = (unsigned long *) mask_source_image->line[y+mask_source_y];
		dest = (unsigned long *) dest_image->line[y+dest_y];

		for (x = start_x; x < width; x++)
		{
			colour = (unsigned long) (m_source[x+mask_source_x]);
			if (colour != mask_colour)
			{
				dest[x+dest_x] = text_colour;
			}
		}
	}

}


void GRAPHICS_colour_vert_lerped_blit_32bit ( BITMAP *mask_source_image , BITMAP *dest_image , int mask_source_x , int mask_source_y , int dest_x , int dest_y , int width , int height , unsigned long *colour_table )
{
	// For speed (or rather because I'm lazy) this function only checks clipping on the destination image. Feel free to alter
	// it so it checks the sources as well, but I can't be arsed. :)

	// Basically it plot the given colour to the given image for those pixels which aren't masked in mask_source_image. However unlike
	// the above it vertically interpolates between the two given colours as it does it so you can make nice varied text.

	unsigned long mask_colour = makecol (255,0,255);
	unsigned long text_colour;

	unsigned long *m_source;
	unsigned long *dest;

	unsigned long colour;

	int y;
	int x;
	int start_y = 0;
	int start_x = 0;
	float percent;

	if (dest_x < 0)
		start_x -= dest_x;

	if (dest_y < 0)
		start_y -= dest_y;

	if (dest_x + width > dest_image->w)
		width -= (dest_x + width) - dest_image->w;

	if (dest_y + height > dest_image->h)
		height -= (dest_y + height) - dest_image->h;

	for (y = start_y; y < height; y++)
	{
		m_source = (unsigned long *) mask_source_image->line[y+mask_source_y];
		dest = (unsigned long *) dest_image->line[y+dest_y];
		percent = float (y) / float (height);

		text_colour = colour_table[y];

		for (x = start_x; x < width; x++)
		{
			colour = (unsigned long) (m_source[x+mask_source_x]);
			if (colour != mask_colour)
			{
				dest[x+dest_x] = text_colour;
			}
		}
	}

}



void GRAPHICS_double_masked_blit_16bit ( BITMAP *graphic_source_image , BITMAP *mask_source_image , BITMAP *dest_image , int graphic_source_x , int graphic_source_y , int mask_source_x , int mask_source_y , int dest_x , int dest_y , int width , int height )
{
	// For speed (or rather because I'm lazy) this function only checks clipping on the destination image. Feel free to alter
	// it so it checks the sources as well, but I can't be arsed. :)

	// Basically it copies those pixels of graphic_source_image which aren't masked in mask_source_image.

	unsigned short mask_colour = makecol (255,0,255);
	unsigned short *g_source;
	unsigned short *m_source;
	unsigned short *dest;
	unsigned short colour;

	int y;
	int x;
	int start_y = 0;
	int start_x = 0;

	if (dest_x < 0)
		start_x -= dest_x;

	if (dest_y < 0)
		start_y -= dest_y;

	if (dest_x + width > dest_image->w)
		width -= (dest_x + width) - dest_image->w;

	if (dest_y + height > dest_image->h)
		height -= (dest_y + height) - dest_image->h;

	for (y = start_y; y < height; y++)
	{
		g_source = (unsigned short *) graphic_source_image->line[y+graphic_source_y];
		m_source = (unsigned short *) mask_source_image->line[y+mask_source_y];
		dest = (unsigned short *) dest_image->line[y+dest_y];

		for (x = start_x; x < width; x++)
		{
			colour = (unsigned short) (m_source[x+mask_source_x]);
			if (colour != mask_colour)
			{
				dest[x+dest_x] = g_source[x+graphic_source_x];
			}
		}
	}


}



void GRAPHICS_colour_blit_16bit ( BITMAP *mask_source_image , BITMAP *dest_image , int mask_source_x , int mask_source_y , int dest_x , int dest_y , int width , int height , unsigned short text_colour )
{
	// For speed (or rather because I'm lazy) this function only checks clipping on the destination image. Feel free to alter
	// it so it checks the sources as well, but I can't be arsed. :)

	// Basically it plot the given colour to the given image for those pixels which aren't masked in mask_source_image.

	unsigned short mask_colour = makecol (255,0,255);

	unsigned short *m_source;
	unsigned short *dest;

	unsigned short colour;

	int y;
	int x;
	int start_y = 0;
	int start_x = 0;

	if (dest_x < 0)
		start_x -= dest_x;

	if (dest_y < 0)
		start_y -= dest_y;

	if (dest_x + width > dest_image->w)
		width -= (dest_x + width) - dest_image->w;

	if (dest_y + height > dest_image->h)
		height -= (dest_y + height) - dest_image->h;

	for (y = start_y; y < height; y++)
	{
		m_source = (unsigned short *) mask_source_image->line[y+mask_source_y];
		dest = (unsigned short *) dest_image->line[y+dest_y];

		for (x = start_x; x < width; x++)
		{
			colour = (unsigned short) (m_source[x+mask_source_x]);
			if (colour != mask_colour)
			{
				dest[x+dest_x] = text_colour;
			}
		}
	}

}


void GRAPHICS_colour_vert_lerped_blit_16bit ( BITMAP *mask_source_image , BITMAP *dest_image , int mask_source_x , int mask_source_y , int dest_x , int dest_y , int width , int height , unsigned short *colour_table  )
{
	// For speed (or rather because I'm lazy) this function only checks clipping on the destination image. Feel free to alter
	// it so it checks the sources as well, but I can't be arsed. :)

	// Basically it plot the given colour to the given image for those pixels which aren't masked in mask_source_image. However unlike
	// the above it vertically interpolates between the two given colours as it does it so you can make nice varied text.

	unsigned short mask_colour = makecol (255,0,255);
	unsigned short text_colour;

	unsigned short *m_source;
	unsigned short *dest;

	unsigned short colour;

	int y;
	int x;
	int start_y = 0;
	int start_x = 0;
	float percent;

	if (dest_x < 0)
		start_x -= dest_x;

	if (dest_y < 0)
		start_y -= dest_y;

	if (dest_x + width > dest_image->w)
		width -= (dest_x + width) - dest_image->w;

	if (dest_y + height > dest_image->h)
		height -= (dest_y + height) - dest_image->h;

	for (y = start_y; y < height; y++)
	{
		m_source = (unsigned short *) mask_source_image->line[y+mask_source_y];
		dest = (unsigned short *) dest_image->line[y+dest_y];
		percent = float (y) / float (height);

		text_colour = colour_table[y];

		for (x = start_x; x < width; x++)
		{
			colour = (unsigned short) (m_source[x+mask_source_x]);
			if (colour != mask_colour)
			{
				dest[x+dest_x] = text_colour;
			}
		}
	}

}


void PFONT_load_texture_from_bitmap (texture_struct *texture , BITMAP* bmp , int x_overlap , int y_overlap )
{
	texture->texture_image = bmp;
	texture->width = texture->texture_image->w;
	texture->height = texture->texture_image->h;
	texture->wrap_width = texture->width - x_overlap;
	texture->wrap_height = texture->height - y_overlap;
}

void PFONT_load_texture (texture_struct *texture , const char *filename , int x_overlap , int y_overlap )
{

	RGB *pal = NULL; // Not used, only dealing with 16 bit graphics mode.
	texture->usingDirectBMP=false;
	BITMAP* bmp = load_bitmap (filename , pal);
	PFONT_load_texture_from_bitmap (texture , bmp , x_overlap , y_overlap );
}



int PFONT_instr (char *string , char find, int start)
{

	while ( string[start] != find )
		start++;

	return start;

}



int PFONT_len (char *string)
{

	int length=0;
	while ( string[length] != '\0' )
		length++;

	return length;

}



int PFONT_get_line_length_width ( prop_text_struct *prop_text , int start , int end )
{

	int width = 0;
	int t;

	for (t = start ; t < end ; t++ )
		width += ( prop_text->prop_font->letter_widths[prop_text->text[t]-32] ) + prop_text->x_spacing ;

	return width - prop_text->x_spacing;
	// Chops off the last x_spacing otherwise the line could appear to be too long when in fact it fits very snuggly.

}



int PFONT_count_words ( prop_text_struct *prop_text , int start , int end )
{

	int counter = 0;
	int t;

	while ( prop_text->text[start] == ' ' )
		start++;

	while ( prop_text->text[end] == ' ' )
		end--;

	for ( t=start ; t<end ; t++ )
		counter = counter + (prop_text->text[t] == ' ');

	return counter+1;

}



int PFONT_get_line_length ( int pointer , prop_text_struct *prop_text , int &skipper )
{

	while ( prop_text->text[pointer] == ' ' )
		pointer ++;

	int line_width = 0;
	int last_space = -1;
	int exit_flag = 0;
	char letter;
	int value;
	int length = PFONT_len(prop_text->text);
	skipper = 0;

	do
	{

		// Every time we come across a space its position is noted so that if the next word makes the line too long,
		// we can roll back to the end of the previous word.

		if ( prop_text->text[pointer] == ' ' )
			last_space = pointer;

		// Then we incread the line_width by the width of the letter, plus the spacing between letters

		letter = prop_text->text[pointer];

		if (letter != PFONT_NEW_LINE_CHAR)
		{
			value = letter - 32;
			line_width += prop_text->prop_font->letter_widths[value];
			line_width += prop_text->x_spacing;
		}
		else
		{
			last_space = pointer;
			exit_flag = 1;
		}

		pointer++;

	} while ( (line_width <= prop_text->image_width + prop_text->x_spacing) && (pointer < length) && (exit_flag == 0) );

	// If the line is too wide for the box, or the pointer is currently not at a space (unless it's the end of the text)...

	if ( (line_width > prop_text->image_width + prop_text->x_spacing) || ( ( prop_text->text[pointer] != ' ' ) && ( pointer < length ) ) )
	{
		if (last_space != -1)
			pointer = last_space;
		else
			skipper = -1;
	}

	return pointer;

}



void PFONT_calculate_line_lengths ( prop_text_struct *prop_text )
{

	int pointer = 0;
	int line_counter = 0;
	int new_pointer;
	int length = PFONT_len(prop_text->text);
	int skipper;

	do
	{

		prop_text->line_start[line_counter] = pointer;

		new_pointer = PFONT_get_line_length ( pointer , prop_text , skipper );

		prop_text->line_length[line_counter] = (new_pointer - pointer);

		line_counter++;

		pointer = new_pointer + 1 + skipper;

	} while ( pointer < length );

	prop_text->total_lines = line_counter;

	prop_text->image_height = (line_counter * prop_text->prop_font->char_height) + ( (line_counter - 1) * prop_text->y_spacing );

}



void PFONT_free_font(font_struct *prop_font)
{
	if (prop_font->font_gfx != NULL && !prop_font->usingDirectBMP) // if summats been loaded into the font.
	{
		destroy_bitmap(prop_font->font_gfx);
		prop_font->font_gfx = NULL;
	}
}



void PFONT_free_texture ( texture_struct *texture )
{
	if (texture->texture_image != NULL && !texture->usingDirectBMP) // if summats been loaded into the texture.
	{
		destroy_bitmap ( texture->texture_image );
		texture->texture_image=NULL;
	}
}

void PFONT_load_font (font_struct *prop_font, const char *filename, int frame_width, int frame_height)
{
	prop_font->usingDirectBMP=false;
	RGB *pal = NULL; // Not used, only dealing with 16 bit graphics mode.
	BITMAP* bmp = load_bmp(filename,pal);
	PFONT_load_font_from_bitmap(prop_font, bmp, frame_width, frame_height);
}

void PFONT_load_font_from_bitmap(font_struct *prop_font, BITMAP* bmp, int frame_width, int frame_height)
{
	prop_font->font_gfx = bmp;
	prop_font->image_width = prop_font->font_gfx->w;
	prop_font->image_height = prop_font->font_gfx->h;
	prop_font->char_width = frame_width;
	prop_font->char_height = frame_height;
	prop_font->frames_per_row = (prop_font->image_width / prop_font->char_width);
	prop_font->frames_per_column = (prop_font->image_height / prop_font->char_height);

//	int number_of_letters = prop_font->frames_per_row * prop_font->frames_per_column;

	int x;
	int y;
	int xx;
	int yy;
	int first_solid_pixel;
	int frame;
	int check_colour;
	int mask_colour = makecol (255,0,255);

	// Go through each letter one at a time and find it's width by working backwards from the right-most
	// pixel of the letter to the left-most. First non-mask pixel found wins a prize!

	for (y=0 ; y<prop_font->frames_per_column ; y++)
	{
		for (x=0 ; x<prop_font->frames_per_row ; x++)
		{

			frame = ( y * prop_font->frames_per_row ) + x;
			first_solid_pixel = -1;

			for (xx = prop_font->char_width - 1 ; xx >= 0 ; xx--)
			{
				for (yy = 0 ; yy<prop_font->char_height ; yy++)
				{
					check_colour = getpixel (prop_font->font_gfx , xx + (x * prop_font->char_width) , yy + (y * prop_font->char_height) );
					if ( (check_colour != mask_colour) && (first_solid_pixel == -1) )
						first_solid_pixel = xx;
				}
			}

			prop_font->letter_widths[frame] = first_solid_pixel + 1;

		}
	}
}

int PFONT_generate_line ( prop_text_struct *prop_text , int start , int end , int x , int y , bool include_spaces , int counter )
{

	int t;
	int frame;
	int frame_x;
	int frame_y;
	int frame_width;

	for (t = start ; t < end ; t++)
	{
		frame = int (prop_text->text[t] - 32);
		frame_width = prop_text->prop_font->letter_widths[frame];
		if ( (frame > 0) || (include_spaces == true) )
		{

			frame_x = (frame % prop_text->prop_font->frames_per_row) * prop_text->prop_font->char_width;
			frame_y = (frame / prop_text->prop_font->frames_per_row) * prop_text->prop_font->char_height;

			prop_text->frame_list_image_x [ prop_text->frame_pointer + counter ] = frame_x;
			prop_text->frame_list_image_y [ prop_text->frame_pointer + counter ] = frame_y;
			prop_text->frame_list_base_x [ prop_text->frame_pointer + counter ] = x;
			prop_text->frame_list_base_y [ prop_text->frame_pointer + counter ] = y;
			prop_text->frame_list_new_x [ prop_text->frame_pointer + counter ] = x;
			prop_text->frame_list_new_y [ prop_text->frame_pointer + counter ] = y;
			prop_text->frame_list_frame [ prop_text->frame_pointer + counter ] = frame;

			counter++;
		}

		x += (frame_width + prop_text->x_spacing );
	}

	return counter;

}



void PFONT_generate_coords ( int line_number , prop_text_struct *prop_text , bool include_spaces , bool reverse_x_order )
{

	// Oh, that keep spaces thing is for the gradual text where for timing purpose you'll probably want
	// to print the spaces as well. Also because that's how it recognises where words end if you're using
	// the add_word function. Either way, they aren't actually ever drawn.

	int generated_frames = 0;

	int word_start = prop_text->line_start[line_number];
	int word_end = word_start + prop_text->line_length[line_number];

	int line_width = PFONT_get_line_length_width ( prop_text , word_start , word_end );
	// First thing to do is find how long the line is going to be pixelwise.

	int num_words = PFONT_count_words ( prop_text , word_start , word_end );
	// And how many words are in the line.

	int alignment = prop_text->alignment;
	// And store the alignment in a temporary variable because it can be changed depending on the circumstance.

	if ( ( (num_words == 1) || (line_number == prop_text->total_lines-1) ) && (alignment == PFONT_ALIGN_JUSTIFY) )
		alignment = PFONT_ALIGN_LEFT;
	// If it's justified, but you're on the last line or there is only one word on the line then change to left align.

	switch (alignment)
	{
	case PFONT_ALIGN_LEFT:
		generated_frames = PFONT_generate_line ( prop_text , word_start , word_end , 0 , (line_number * prop_text->prop_font->char_height) + ( line_number * prop_text->y_spacing ) , include_spaces , 0 );
		break;

	case PFONT_ALIGN_CENTER:
		generated_frames = PFONT_generate_line ( prop_text , word_start , word_end , (prop_text->image_width - line_width) / 2 , (line_number * prop_text->prop_font->char_height) + ( line_number * prop_text->y_spacing ) , include_spaces , 0 );
		break;

	case PFONT_ALIGN_RIGHT:
		generated_frames = PFONT_generate_line ( prop_text , word_start , word_end , prop_text->image_width - line_width , (line_number * prop_text->prop_font->char_height) + ( line_number * prop_text->y_spacing ) , include_spaces , 0 );
		break;

	case PFONT_ALIGN_JUSTIFY:
		int word_gap = (prop_text->image_width - line_width) / (num_words-1); // extra distance between words
		// This is the number of extra pixels between each word on the line given the length of the line and the width of the image.

		int spare_pixels = (prop_text->image_width - line_width) % (num_words-1);
		// How many pixels left over because obviously it's not always gonna' split precisely.

		int word_pointer = word_start;
		int next_word_pointer;

		int start_x = 0;

		int n;
		for (n=0 ; n<num_words ; n++)
		{
			next_word_pointer = PFONT_instr ( prop_text->text , ' ' , word_pointer );
			// Find the next word so we know the length of the word.

			generated_frames = PFONT_generate_line ( prop_text , word_pointer , next_word_pointer , start_x , (line_number * prop_text->prop_font->char_height) + ( line_number * prop_text->y_spacing ) , include_spaces , generated_frames );
			// Then draw that word.

			start_x += PFONT_get_line_length_width ( prop_text , word_pointer , next_word_pointer + 1 ) + word_gap + (n < spare_pixels) + prop_text->x_spacing;
			// Add the width of the word in pixels, plus the word gap, then one of the spare pixels if applicable and then x_spacing because PFONT_get_line_length_width cuts it off.

			word_pointer += (next_word_pointer - word_pointer) + 1;
			// Jumps over the the word and the space after it to the start of the next word.
		}
		break;
	}

	// Oh, wait there's this bit on the end. Silly me. This basically reverses the order of the just created co-ords in the frame list
	// if it is so desired. This is so that letters at the start of the sentance are drawn over the ones at the end if they happen to
	// occlude them.

	if (reverse_x_order == true)
	{
		int t;
		char temp;

		for (t=0 ; t<generated_frames ; t++)
		{
			temp = prop_text->text[ t + prop_text->frame_pointer ];
			prop_text->text[ t + prop_text->frame_pointer ] = prop_text->text[ (prop_text->frame_pointer + generated_frames) - (t+1) ];
			prop_text->text[ (prop_text->frame_pointer + generated_frames) - (t+1) ] = temp;
		}
	}

	prop_text->frame_pointer += generated_frames;
	// Then update the frame_pointer.

}



void PFONT_create_frame_list ( prop_text_struct *prop_text , font_struct *prop_font, const char *words, int width, int alignment, int x_spacing, int y_spacing , bool reverse_x_order , bool reverse_y_order )
{

	prop_text->prop_font = prop_font;
	prop_text->alignment = alignment;
	prop_text->x_spacing = x_spacing;
	prop_text->y_spacing = y_spacing;
	prop_text->image_width = width;
	prop_text->frame_pointer = 0;

	// Then start plopping new ones in. :)

	strcpy (prop_text->text , words);

	PFONT_calculate_line_lengths (prop_text);

	int l;

	if (reverse_y_order == false)
	{
		for (l=0 ; l<prop_text->total_lines ; l++)
			PFONT_generate_coords ( l , prop_text , false , reverse_x_order);
	}
	else
	{
		for (l=prop_text->total_lines-1 ; l>=0 ; l--)
			PFONT_generate_coords ( l , prop_text , false , reverse_x_order);
	}

}



void PFONT_posset_reset ( prop_text_struct *prop_text )
{
	// This just copies the base co-ords into the new co-ords and presents the letters "as-is" and resets
	// everything in readiness to apply all the other effects.

	int frame;

	for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
	{
		prop_text->frame_list_new_x[frame] = prop_text->frame_list_base_x[frame];
		prop_text->frame_list_new_y[frame] = prop_text->frame_list_base_y[frame];
	}

}



// These functions all modify the resetted co-ords of the frame list and so are all
// called PFONT_posmod_summat. "posmod" means position modification. To perform these
// functions you must first have first called PFONT_posset_reset function as otherwise their affect
// on the co-ordinates will accumulate over the course of several frames and although this may
// be desirable it won't be long until errors creep in due to degradation of nth generation data.

// It'll also probably make your letters explode or implode if you're doing any scaling.

// Note that the order in which you use the modifiers is very important as like vector maths,
// SCALE then ROTATE is not the same as ROTATE then SCALE. Things like the sine wave effects
// and soft selection are probably best done first.

// Note that all effects which use handles any the like have their figures based on the initial
// base rectangle formed by the base rectangle.



void PFONT_posmod_bouncing_in_phase ( prop_text_struct *prop_text , float x_angular_period , float y_angular_period , float x_amplitude , float y_amplitude , float x_angle_modifier , float y_angle_modifier )
{
	// This is basically a sine-wave effect except that instead of the wave passing through the origin, it effectively
	// bounces off of it due to the use of abs. This is the in-phase version of the effect, which doesn't look as nice
	// as the following out of phase version.

	int frame;

	for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
	{
		prop_text->frame_list_new_x[frame] += (x_amplitude * MATH_abs (sin ( x_angle_modifier + (prop_text->frame_list_new_x[frame] * x_angular_period) + (prop_text->frame_list_new_x[frame] * y_angular_period))));
		prop_text->frame_list_new_y[frame] += (y_amplitude * MATH_abs (sin ( y_angle_modifier + (prop_text->frame_list_new_y[frame] * y_angular_period) + (prop_text->frame_list_new_y[frame] * x_angular_period))));
	}

}



void PFONT_posmod_bouncing_out_phase ( prop_text_struct *prop_text , float x_angular_period , float y_angular_period , float x_amplitude , float y_amplitude , float x_angle_modifier , float y_angle_modifier )
{
	// This is basically a sine-wave effect except that instead of the wave passing through the origin, it effectively
	// bounces off of it due to the use of abs. This is the out-phase version of the effect, which is lovely and wobbly
	// and can be used to create nice effects like waves peaks on the ocean with your letters.

	int frame;

	for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
	{
		prop_text->frame_list_new_x[frame] += (x_amplitude * MATH_abs (sin ( x_angle_modifier + (prop_text->frame_list_new_y[frame] * x_angular_period) + (prop_text->frame_list_new_x[frame] * y_angular_period))));
		prop_text->frame_list_new_y[frame] += (y_amplitude * MATH_abs (sin ( y_angle_modifier + (prop_text->frame_list_new_x[frame] * y_angular_period) + (prop_text->frame_list_new_y[frame] * x_angular_period))));
	}

}



void PFONT_posmod_sine_in_phase  ( prop_text_struct *prop_text , float x_angular_period , float y_angular_period , float x_amplitude , float y_amplitude , float x_angle_modifier , float y_angle_modifier )
{
	// This makes the whole set of letters undulate in a pleasing manner while retaining their essentially
	// rectangular shape (though not position). It's really rather lovely, but not as nice as the out of phase
	// version with is quite the show-off.

	int frame;

	for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
	{
		prop_text->frame_list_new_x[frame] += (x_amplitude * sin ( x_angle_modifier + (prop_text->frame_list_new_x[frame] * x_angular_period)));
		prop_text->frame_list_new_y[frame] += (y_amplitude * sin ( y_angle_modifier + (prop_text->frame_list_new_y[frame] * y_angular_period)));
	}

}



void PFONT_posmod_sine_out_phase  ( prop_text_struct *prop_text , float x_angular_period , float y_angular_period , float x_amplitude , float y_amplitude , float x_angle_modifier , float y_angle_modifier )
{
	// This makes the whole set of letters undulate in a pleasing manner which can look as if the lines are
	// slithering over one another like snakes. It's really quite nice. You can also get affects which make
	// the profile of the text block look a bit like a waving flag.

	int frame;

	for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
	{
		prop_text->frame_list_new_x[frame] += (x_amplitude * sin ( x_angle_modifier + (prop_text->frame_list_new_y[frame] * x_angular_period)));
		prop_text->frame_list_new_y[frame] += (y_amplitude * sin ( y_angle_modifier + (prop_text->frame_list_new_x[frame] * y_angular_period)));
	}

}



void PFONT_posmod_selection ( prop_text_struct *prop_text , float handle_x , float handle_y , int drag_x , int drag_y , float extent , float inverse , int effect )
{
	// This is one of my favourites! It basically allows you to "pull" any area of the mesh of letters
	// and cause the surrounding ones to follow it as if they were attached. It uses a fair few more parameters
	// than most of the effects, but it's worth it.
	// The handle_x and handle_y say which point is being pulled as a percentage across the image (0-1 typical value),
	// the drag_x and drag_y say how far and in which direction it's getting pulled, the extent is again a percentage
	// value and say how far the effect reaches as a percent of the width of the image, aspect ratio is a value
	// which deforms the shape of the area being pulled and finally inverse float value from -1 to 1 which will basically
	// invert the selection.

	// This function uses square root and is therefor to be considered as one of the slower effects computationally.

	// Note that the way in which you pull the co-ords about can be chosen as either "soft", "bubble", "point" or "linear" with the effect values
	// of 0-3 corresponding.

	int offset_x = ( ( prop_text->image_width - prop_text->prop_font->char_width ) * handle_x );
	int offset_y = ( ( prop_text->image_height - prop_text->prop_font->char_height ) * handle_y );

	float distance;
	float influence;
	int frame;

	switch (effect)
	{
	case 0:
		for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
		{
			distance = sqrt ( ( ( prop_text->frame_list_new_x[frame] - offset_x ) * ( prop_text->frame_list_new_x[frame] - offset_x ) ) + ( ( prop_text->frame_list_new_y[frame] - offset_y ) * ( prop_text->frame_list_new_y[frame] - offset_y ) ) ); // distance of letter from handle.
			if (distance < extent) // if it's within the area of effect of the "bubble"
			{
				influence = (extent - distance) / extent; // linear value at this point
				influence *= (3.14597); // now a nice soft value.
				influence = (1-cos (influence))/2;
			}
			else
				influence = 0;

			influence = ((influence - 0.5) * inverse) + 0.5;

			prop_text->frame_list_new_x[frame] += (drag_x * influence);
			prop_text->frame_list_new_y[frame] += (drag_y * influence);
		}
		break;

	case 1:
		for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
		{
			distance = sqrt ( ( ( prop_text->frame_list_new_x[frame] - offset_x ) * ( prop_text->frame_list_new_x[frame] - offset_x ) ) + ( ( prop_text->frame_list_new_y[frame] - offset_y ) * ( prop_text->frame_list_new_y[frame] - offset_y ) ) ); // distance of letter from handle.
			if (distance < extent) // if it's within the area of effect of the "bubble"
			{
				influence = (1-(extent - distance) / extent); // linear value at this point
				influence *= influence; // now a nice bubble value.
				influence = -influence+1;
			}
			else
				influence = 0;

			influence = ((influence - 0.5) * inverse) + 0.5;

			prop_text->frame_list_new_x[frame] += (drag_x * influence);
			prop_text->frame_list_new_y[frame] += (drag_y * influence);
		}
		break;

	case 2:
		for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
		{
			distance = sqrt ( ( ( prop_text->frame_list_new_x[frame] - offset_x ) * ( prop_text->frame_list_new_x[frame] - offset_x ) ) + ( ( prop_text->frame_list_new_y[frame] - offset_y ) * ( prop_text->frame_list_new_y[frame] - offset_y ) ) ); // distance of letter from handle.
			if (distance < extent) // if it's within the area of effect of the "bubble"
			{
				influence = (extent - distance) / extent; // linear value at this point
				influence *= influence; // now a nice inverse bubble value.
			}
			else
				influence = 0;

			influence = ((influence - 0.5) * inverse) + 0.5;

			prop_text->frame_list_new_x[frame] += (drag_x * influence);
			prop_text->frame_list_new_y[frame] += (drag_y * influence);
		}
		break;

	case 3:
		for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
		{
			distance = sqrt ( ( ( prop_text->frame_list_new_x[frame] - offset_x ) * ( prop_text->frame_list_new_x[frame] - offset_x ) ) + ( ( prop_text->frame_list_new_y[frame] - offset_y ) * ( prop_text->frame_list_new_y[frame] - offset_y ) ) ); // distance of letter from handle.
			if (distance < extent) // if it's within the area of effect of the "bubble"
			{
				influence = (extent - distance) / extent; // linear value at this point
			}
			else
				influence = 0;

			influence = ((influence - 0.5) * inverse) + 0.5;

			prop_text->frame_list_new_x[frame] += (drag_x * influence);
			prop_text->frame_list_new_y[frame] += (drag_y * influence);
		}
		break;

	default:
		break;
	}

}



void PFONT_posmod_distort ( prop_text_struct *prop_text , float handle_x , float handle_y, float horizontal_deviation , float vertical_deviation  )
{
	// here you specify how much you want each side of the rectangle of text stretched by
	// (a value of 0-2 typically with 1 meaning no change) effecting a kind of perspective
	// distortion.

	// No square roots in this one so it's probably quite cheap, just like me. :)

	int offset_x = ( ( prop_text->image_width - prop_text->prop_font->char_width ) * handle_x );
	int offset_y = ( ( prop_text->image_height - prop_text->prop_font->char_height ) * handle_y );

	float vertical_percent;
	float horizontal_percent;

	float vertical_influence;
	float horizontal_influence;

	int frame;

	for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
	{
		horizontal_percent = float (prop_text->frame_list_base_x[frame] - offset_x) / float (prop_text->image_width);
		vertical_percent = float (prop_text->frame_list_base_y[frame] - offset_y) / float (prop_text->image_height);

		if (vertical_percent<0.0)
			vertical_percent = vertical_percent;

		horizontal_influence = horizontal_percent * horizontal_deviation;
		vertical_influence = vertical_percent * vertical_deviation;

		prop_text->frame_list_new_x[frame] += ((prop_text->frame_list_base_x[frame] - offset_x) * vertical_influence);
		prop_text->frame_list_new_y[frame] += ((prop_text->frame_list_base_y[frame] - offset_y) * horizontal_influence);
	}

}



void PFONT_posmod_add_noise ( prop_text_struct *prop_text , int x_noise , int y_noise )
{
	// This just adds a random number to each of the co-ordinates in the specified axis.

	int frame;

	for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
	{
		prop_text->frame_list_new_x[frame] += ( MATH_rand ( int (- x_noise) , int (x_noise) ) );
		prop_text->frame_list_new_y[frame] += ( MATH_rand ( int (- y_noise) , int (y_noise) ) );
	}

}



void PFONT_posmod_add_noise_baseline ( prop_text_struct *prop_text , int x_noise , int y_noise )
{
	// This just adds a random number to each of the co-ordinates in the specified axis, however it does
	// not produce negative noise and so the letters will effectively only vibrate half as far.

	int frame;

	for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
	{
		prop_text->frame_list_new_x[frame] += ( MATH_rand ( 0 , int (x_noise) ) );
		prop_text->frame_list_new_y[frame] += ( MATH_rand ( 0 , int (y_noise) ) );
	}

}



void PFONT_posmod_rotate ( prop_text_struct *prop_text, float handle_x , float handle_y , float angle  )
{
	// This rotates all the co-ordinates around by the supplied angle. The centre of rotation
	// is specified as the handle_x and handle_y which are typically values from 0 to 1 on each
	// axis whereby 0,0 is the top-left of the rectangle formed by the base co-ordinates and
	// 1,1 is the bottom right of said rectangle. Obviously 0.5,0.5 rotates around the middle
	// of the box.

	// As this uses both square root and sin and cosine, it should considered one of the most
	// computationally expensive effects in the roster. Chances are it'll still bloody fly on
	// today's machines, but a T-state saved is a T-state earned. ;)

	int offset_x = ( ( prop_text->image_width - prop_text->prop_font->char_width ) * handle_x );
	int offset_y = ( ( prop_text->image_height - prop_text->prop_font->char_height ) * handle_y );

	int frame;
	float distance;
	float current_angle;

	for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
	{
		distance = sqrt ( ( ( prop_text->frame_list_new_x[frame] - offset_x ) * ( prop_text->frame_list_new_x[frame] - offset_x ) ) + ( ( prop_text->frame_list_new_y[frame] - offset_y ) * ( prop_text->frame_list_new_y[frame] - offset_y ) ) );
		current_angle = atan2 ( ( prop_text->frame_list_new_x[frame] - offset_x ) , ( prop_text->frame_list_new_y[frame] - offset_y ) );
		prop_text->frame_list_new_x[frame] = distance * sin (angle + current_angle) + offset_x;
		prop_text->frame_list_new_y[frame] = distance * cos (angle + current_angle) + offset_y;
	}

}



void PFONT_posmod_rotate_selection ( prop_text_struct *prop_text, float handle_x , float handle_y , float angle  , float extent , float inverse , int effect)
{
	// This rotates all the co-ordinates around by the supplied angle. The centre of rotation
	// is specified as the handle_x and handle_y which are typically values from 0 to 1 on each
	// axis whereby 0,0 is the top-left of the rectangle formed by the base co-ordinates and
	// 1,1 is the bottom right of said rectangle. Obviously 0.5,0.5 rotates around the middle
	// of the box.

	// As this uses both square root and sin and cosine, it should considered one of the most
	// computationally expensive effects in the roster. Chances are it'll still bloody fly on
	// today's machines, but a T-state saved is a T-state earned. ;)

	int offset_x = ( ( prop_text->image_width - prop_text->prop_font->char_width ) * handle_x );
	int offset_y = ( ( prop_text->image_height - prop_text->prop_font->char_height ) * handle_y );

	int frame;
	float distance;
	float current_angle;
	float influence;

	switch (effect)
	{
	case 0:
		for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
		{
			distance = sqrt ( ( ( prop_text->frame_list_new_x[frame] - offset_x ) * ( prop_text->frame_list_new_x[frame] - offset_x ) ) + ( ( prop_text->frame_list_new_y[frame] - offset_y ) * ( prop_text->frame_list_new_y[frame] - offset_y ) ) ); // distance of letter from handle.
			if (distance < extent) // if it's within the area of effect of the "bubble"
			{
				influence = (extent - distance) / extent; // linear value at this point
				influence *= (3.14597); // now a nice soft value.
				influence = (1-cos (influence))/2;
			}
			else
				influence = 0;

			influence = ((influence - 0.5) * inverse) + 0.5;

			distance = sqrt ( ( ( prop_text->frame_list_new_x[frame] - offset_x ) * ( prop_text->frame_list_new_x[frame] - offset_x ) ) + ( ( prop_text->frame_list_new_y[frame] - offset_y ) * ( prop_text->frame_list_new_y[frame] - offset_y ) ) );
			current_angle = atan2 ( ( prop_text->frame_list_new_x[frame] - offset_x ) , ( prop_text->frame_list_new_y[frame] - offset_y ) );
			prop_text->frame_list_new_x[frame] = distance * sin (angle*influence + current_angle) + offset_x;
			prop_text->frame_list_new_y[frame] = distance * cos (angle*influence + current_angle) + offset_y;
		}
		break;

	case 1:
		for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
		{
			distance = sqrt ( ( ( prop_text->frame_list_new_x[frame] - offset_x ) * ( prop_text->frame_list_new_x[frame] - offset_x ) ) + ( ( prop_text->frame_list_new_y[frame] - offset_y ) * ( prop_text->frame_list_new_y[frame] - offset_y ) ) ); // distance of letter from handle.
			if (distance < extent) // if it's within the area of effect of the "bubble"
			{
				influence = (1-(extent - distance) / extent); // linear value at this point
				influence *= influence; // now a nice bubble value.
				influence = -influence+1;
			}
			else
				influence = 0;

			influence = ((influence - 0.5) * inverse) + 0.5;

			distance = sqrt ( ( ( prop_text->frame_list_new_x[frame] - offset_x ) * ( prop_text->frame_list_new_x[frame] - offset_x ) ) + ( ( prop_text->frame_list_new_y[frame] - offset_y ) * ( prop_text->frame_list_new_y[frame] - offset_y ) ) );
			current_angle = atan2 ( ( prop_text->frame_list_new_x[frame] - offset_x ) , ( prop_text->frame_list_new_y[frame] - offset_y ) );
			prop_text->frame_list_new_x[frame] = distance * sin (angle*influence + current_angle) + offset_x;
			prop_text->frame_list_new_y[frame] = distance * cos (angle*influence + current_angle) + offset_y;
		}
		break;

	case 2:
		for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
		{
			distance = sqrt ( ( ( prop_text->frame_list_new_x[frame] - offset_x ) * ( prop_text->frame_list_new_x[frame] - offset_x ) ) + ( ( prop_text->frame_list_new_y[frame] - offset_y ) * ( prop_text->frame_list_new_y[frame] - offset_y ) ) ); // distance of letter from handle.
			if (distance < extent) // if it's within the area of effect of the "bubble"
			{
				influence = (extent - distance) / extent; // linear value at this point
				influence *= influence; // now a nice inverse bubble value.
			}
			else
				influence = 0;

			influence = ((influence - 0.5) * inverse) + 0.5;

			distance = sqrt ( ( ( prop_text->frame_list_new_x[frame] - offset_x ) * ( prop_text->frame_list_new_x[frame] - offset_x ) ) + ( ( prop_text->frame_list_new_y[frame] - offset_y ) * ( prop_text->frame_list_new_y[frame] - offset_y ) ) );
			current_angle = atan2 ( ( prop_text->frame_list_new_x[frame] - offset_x ) , ( prop_text->frame_list_new_y[frame] - offset_y ) );
			prop_text->frame_list_new_x[frame] = distance * sin (angle*influence + current_angle) + offset_x;
			prop_text->frame_list_new_y[frame] = distance * cos (angle*influence + current_angle) + offset_y;
		}
		break;

	case 3:
		for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
		{
			distance = sqrt ( ( ( prop_text->frame_list_new_x[frame] - offset_x ) * ( prop_text->frame_list_new_x[frame] - offset_x ) ) + ( ( prop_text->frame_list_new_y[frame] - offset_y ) * ( prop_text->frame_list_new_y[frame] - offset_y ) ) ); // distance of letter from handle.
			if (distance < extent) // if it's within the area of effect of the "bubble"
			{
				influence = (extent - distance) / extent; // linear value at this point
			}
			else
				influence = 0;

			influence = ((influence - 0.5) * inverse) + 0.5;

			distance = sqrt ( ( ( prop_text->frame_list_new_x[frame] - offset_x ) * ( prop_text->frame_list_new_x[frame] - offset_x ) ) + ( ( prop_text->frame_list_new_y[frame] - offset_y ) * ( prop_text->frame_list_new_y[frame] - offset_y ) ) );
			current_angle = atan2 ( ( prop_text->frame_list_new_x[frame] - offset_x ) , ( prop_text->frame_list_new_y[frame] - offset_y ) );
			prop_text->frame_list_new_x[frame] = distance * sin (angle*influence + current_angle) + offset_x;
			prop_text->frame_list_new_y[frame] = distance * cos (angle*influence + current_angle) + offset_y;
		}
		break;

	default:
		break;
	}

}



void PFONT_posmod_scale ( prop_text_struct *prop_text , float handle_x , float handle_y , float percent_x , float percent_y )
{
	// This scales all the co-ordinates by the supplied amount in each axis. The centre of scaling
	// is specified as the handle_x and handle_y which are typically values from 0 to 1 on each
	// axis whereby 0,0 is the top-left of the rectangle formed by the base co-ordinates and
	// 1,1 is the bottom right of said rectangle. Obviously 0.5,0.5 scales from the middle
	// of the box and this would probably be the normal setting.

	int offset_x = ( ( prop_text->image_width - prop_text->prop_font->char_width ) * handle_x );
	int offset_y = ( ( prop_text->image_height - prop_text->prop_font->char_height ) * handle_y );

	int frame;

	for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
	{
		prop_text->frame_list_new_x[frame] = ( ( prop_text->frame_list_new_x[frame] - offset_x ) * percent_x ) + offset_x;
		prop_text->frame_list_new_y[frame] = ( ( prop_text->frame_list_new_y[frame] - offset_y ) * percent_y ) + offset_y;
	}

}



void PFONT_posmod_bow_in ( prop_text_struct *prop_text , float handle_x , float handle_y , float max_bow_x , float max_bow_y )
{
	// This bows the text as if there was a soft-selection on it, but it looks different to the regular
	// soft selection. It looks pretty nice, basically.

	int offset_x = ( ( prop_text->image_width - prop_text->prop_font->char_width ) * handle_x );
	int offset_y = ( ( prop_text->image_height - prop_text->prop_font->char_height ) * handle_y );

	float temp_x;
	float temp_y;
	float bow_x;
	float bow_y;

	int frame;

	for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
	{

		temp_x = ( prop_text->frame_list_new_x[frame] - offset_x ) / (prop_text->image_width / 2);
		temp_y = ( prop_text->frame_list_new_y[frame] - offset_y ) / (prop_text->image_height / 2);
		bow_y = max_bow_x - (temp_x * temp_x) * max_bow_x;
		bow_x = max_bow_y - (temp_y * temp_y) * max_bow_y;
		prop_text->frame_list_new_x[frame] += bow_x;
		prop_text->frame_list_new_y[frame] += bow_y;

	}
}



void PFONT_posmod_bow_out ( prop_text_struct *prop_text , float handle_x , float handle_y , float max_bow_x , float max_bow_y )
{
	// This bows the text as if there was a soft-selection on it, but it looks different to the regular
	// soft selection. It looks pretty nice, basically.

	int offset_x = ( ( prop_text->image_width - prop_text->prop_font->char_width ) * handle_x );
	int offset_y = ( ( prop_text->image_height - prop_text->prop_font->char_height ) * handle_y );

	float temp_x;
	float temp_y;
	float bow_x;
	float bow_y;

	int frame;

	for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
	{

		temp_x = ( prop_text->frame_list_new_x[frame] - offset_x ) / (prop_text->image_width / 2);
		temp_y = ( prop_text->frame_list_new_y[frame] - offset_y ) / (prop_text->image_height / 2);
		bow_y = (temp_x * temp_x) * max_bow_x;
		bow_x = (temp_y * temp_y) * max_bow_y;
		prop_text->frame_list_new_x[frame] += bow_x;
		prop_text->frame_list_new_y[frame] += bow_y;

	}
}



void PFONT_posmod_clamping ( prop_text_struct *prop_text , int damp_from , int damp_until )
{
	// This is like the above only it doesn't care about finding on axis points first, it
	// just resets all the co-ordinates between the specified values. It could be used
	// in conjunction with a noise effect - for instance - in order to make a "shudder"
	// run through your letters.

	int frame;

	for (frame=damp_from ; ( frame<damp_until ) && ( frame<prop_text->frame_pointer ) ; frame++ )
	{
		if (frame >= 0)
		{
			prop_text->frame_list_new_x[frame] = prop_text->frame_list_base_x[frame];
			prop_text->frame_list_new_y[frame] = prop_text->frame_list_base_y[frame];
		}
	}

}



void PFONT_posmod_damp_point ( prop_text_struct *prop_text , int damp_point , float extent , int method )
{
	// This allows you to specify a point in the sequence where a damping effect will be applied, with the effect
	// tapering off either linearily or by some other means.

	// method is either:

	// 0 = linear
	// 1 = bubble
	// 2 = point
	// 3 = soft

	// damp_strength is a float value typically from 0 to 1, with 0 meaning no damping and 1 meaning full damping.

	float influence;
	float distance;

	int frame;

	for (frame=damp_point - extent ; ( frame<damp_point + extent ) ; frame++ )
	{
		if ( (frame >= 0) && ( frame<prop_text->frame_pointer ) )
		{

			distance = MATH_abs (damp_point - frame);

			switch (method)
			{
			case 0:
				influence = (extent - distance) / extent;
				break;

			case 1:
				influence = (1-(extent - distance) / extent); // linear value at this point
				influence *= influence; // now a nice bubble value, or rather inverse bubble.
				influence = -influence+1; // which now falls in the right area. I hope.
				break;

			case 2:
				influence = (extent - distance) / extent; // linear value at this point
				influence *= influence; // now a nice bubble value, or rather inverse bubble.
				break;

			case 3:
				influence = (extent - distance) / extent; // linear value at this point
				influence *= (3.14597); // now a nice soft value, or rather inverse bubble.
				influence = (1-cos (influence))/2; // and now it's like a wobbly summat. Or summat.
				break;

			default:
				break;
			}

			// influence is basicaly a lerp value now, at least I think it is.

			prop_text->frame_list_new_x[frame] = MATH_lerp (prop_text->frame_list_base_x[frame] , prop_text->frame_list_new_x[frame] , 1-influence );
			prop_text->frame_list_new_y[frame] = MATH_lerp (prop_text->frame_list_base_y[frame] , prop_text->frame_list_new_y[frame] , 1-influence );

		}
	}

}



void PFONT_posmod_inverse_damp_point ( prop_text_struct *prop_text , int damp_point , float extent , int method )
{
	// This allows you to specify a point in the sequence where a damping effect will be applied, with the effect
	// tapering off either linearily or by some other means. Except in inverse this time, so the specified point
	// will actually be left alone and the rest of it will get damped.

	// method is either:

	// 0 = linear
	// 1 = bubble
	// 2 = point
	// 3 = soft

	// damp_strength is a float value typically from 0 to 1, with 0 meaning no damping and 1 meaning full damping.

	float influence;
	float distance;

	int frame;

	for (frame=0 ; frame < prop_text->frame_pointer ; frame++ )
	{

		distance = MATH_abs (damp_point - frame);

		if (distance > extent)
		{
			influence = 0;
		}
		else
		{
			switch (method)
			{
			case 0:
				influence = (extent - distance) / extent;
				break;

			case 1:
				influence = (1-(extent - distance) / extent); // linear value at this point
				influence *= influence; // now a nice bubble value, or rather inverse bubble.
				influence = -influence+1; // which now falls in the right area. I hope.
				break;

			case 2:
				influence = (extent - distance) / extent; // linear value at this point
				influence *= influence; // now a nice bubble value, or rather inverse bubble.
				break;

			case 3:
				influence = (extent - distance) / extent; // linear value at this point
				influence *= (3.14597); // now a nice soft value, or rather inverse bubble.
				influence = (1-cos (influence))/2; // and now it's like a wobbly summat. Or summat.
				break;

			default:
				break;
			}
		}

		// influence is basicaly a lerp value now, at least I think it is.

		prop_text->frame_list_new_x[frame] = MATH_lerp (prop_text->frame_list_base_x[frame] , prop_text->frame_list_new_x[frame] , influence );
		prop_text->frame_list_new_y[frame] = MATH_lerp (prop_text->frame_list_base_y[frame] , prop_text->frame_list_new_y[frame] , influence );

	}

}



void PFONT_posmod_damp ( prop_text_struct *prop_text , float damping )
{

	// This simply goes through all the letters and resets them to their default points by a given
	// degree. damping is a float value from 0 (no damping) to 1 (full damping).

	int frame;
	damping = 1-damping;

	for (frame=0 ; frame < prop_text->frame_pointer ; frame++ )
	{
		prop_text->frame_list_new_x[frame] = MATH_lerp (prop_text->frame_list_base_x[frame] , prop_text->frame_list_new_x[frame] , damping );
		prop_text->frame_list_new_y[frame] = MATH_lerp (prop_text->frame_list_base_y[frame] , prop_text->frame_list_new_y[frame] , damping );
	}

}






// These functions all modify the texture co-ords of the letters in case you are wanting to
// draw them using a texture instead of their standard appearance. The effects are largely
// similar to those used to manipulate the co-ordinates of the letters themselves, However
// unlike those effects these aren't really designed to be used in a cumulative fashion as
// each one will generally completely generate the co-ordinates from scratch. The exceptions
// to this rule are SCALE and ROTATE which can be safely added after any effect however as
// you're talking about texture effects they might not act quite as you expect. Just try
// some stuff out.

// All functions are prefaced with either "texset" which means it creates all new texture
// co-ordinates or "texmod" which will modify the current texture co-ordinates.

// Note that you don't need to specify a texture at all when doing these effects as it is
// irrelevent. Any co-ordinates which fall outside the scope of the texture used when drawing
// the actual item will be modulussed (there's a new one for the Oxford English) back into
// the correct bounds.

// Generally you'll only be working with either vertical gradient textures or horizontal texture
// gradients I would imagine and so when you're creating the basic spread you can opt to fold
// the effects of both axis into each axis. I'd explain that in english but you're best off
// just giving it a whizz to see how it effects things.

// All effects are based on the current co-ordinates of the text, not the base co-ordinates
// so when you call these functions in the sequence of creating an effect is very important!
// That said, almost anything looks really funky when you're working with gradients so I
// wouldn't sorry too much.


void PFONT_texset_basic_spread ( prop_text_struct *prop_text , float x_spread , float y_spread , float x_base , float y_base , bool convert )
{
	// This just allocates a texture co-ordinate based on the position of the letter on each
	// axis. It's a simple linear spread. If you want all texture co-ords to be 0,0 then just
	// specify an x_spread and y_spread of 0.

	int frame;

	for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
	{
		prop_text->frame_list_texture_x[frame] = x_base + (prop_text->frame_list_new_x[frame] * x_spread);
		if (convert = false)
			prop_text->frame_list_texture_y[frame] = y_base + (prop_text->frame_list_new_y[frame] * y_spread);
		else
			prop_text->frame_list_texture_x[frame] += y_base + (prop_text->frame_list_new_y[frame] * y_spread);
	}

}



void PFONT_texmod_bouncing_in_phase ( prop_text_struct *prop_text , float x_angular_period , float y_angular_period , float x_amplitude , float y_amplitude , float x_angle_modifier , float y_angle_modifier )
{
	// This is basically a sine-wave effect except that instead of the wave passing through the origin, it effectively
	// bounces off of it due to the use of abs. This is the in-phase version of the effect, which doesn't look as nice
	// as the following out of phase version.

	int frame;

	for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
	{
		prop_text->frame_list_texture_x[frame] += (x_amplitude * abs (sin ( x_angle_modifier + (prop_text->frame_list_new_x[frame] * x_angular_period))));
		prop_text->frame_list_texture_y[frame] += (y_amplitude * abs (sin ( y_angle_modifier + (prop_text->frame_list_new_y[frame] * y_angular_period))));
	}

}



void PFONT_texmod_bouncing_out_phase ( prop_text_struct *prop_text , float x_angular_period , float y_angular_period , float x_amplitude , float y_amplitude , float x_angle_modifier , float y_angle_modifier )
{
	// This is basically a sine-wave effect except that instead of the wave passing through the origin, it effectively
	// bounces off of it due to the use of abs. This is the out-phase version of the effect, which is lovely and wobbly
	// and can be used to create nice effects like waves peaks on the ocean with your letters.

	int frame;

	for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
	{
		prop_text->frame_list_texture_x[frame] += (x_amplitude * MATH_abs (sin ( x_angle_modifier + (prop_text->frame_list_new_y[frame] * x_angular_period) + (prop_text->frame_list_new_x[frame] * y_angular_period))));
		prop_text->frame_list_texture_y[frame] += (y_amplitude * MATH_abs (sin ( y_angle_modifier + (prop_text->frame_list_new_x[frame] * y_angular_period) + (prop_text->frame_list_new_y[frame] * x_angular_period))));
	}

}



void PFONT_texmod_sine_in_phase  ( prop_text_struct *prop_text , float x_angular_period , float y_angular_period , float x_amplitude , float y_amplitude , float x_angle_modifier , float y_angle_modifier )
{
	// This makes the whole set of texture co-ordinates undulate in a pleasing manner while retaining their essentially
	// rectangular shape (though not position). It's really rather lovely, but not as nice as the out of phase
	// version with is quite the show-off.

	int frame;

	for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
	{
		prop_text->frame_list_texture_x[frame] += (x_amplitude * sin ( x_angle_modifier + (prop_text->frame_list_new_x[frame] * x_angular_period)));
		prop_text->frame_list_texture_y[frame] += (y_amplitude * sin ( y_angle_modifier + (prop_text->frame_list_new_y[frame] * y_angular_period)));
	}

}



void PFONT_texmod_sine_out_phase  ( prop_text_struct *prop_text , float x_angular_period , float y_angular_period , float x_amplitude , float y_amplitude , float x_angle_modifier , float y_angle_modifier )
{
	// This makes the whole set of texture co-ordinates undulate in a pleasing manner which can look as if the lines are
	// slithering over one another like snakes. It's really quite nice. You can also get affects which make
	// the thing look a bit like a waving flag. So if you wanted you could have a texture of a flag which is spread
	// behind the letters when you could make it wave with this. Which would look quite nice I reckon.

	int frame;

	for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
	{
		prop_text->frame_list_texture_x[frame] += (x_amplitude * sin ( x_angle_modifier + (prop_text->frame_list_new_y[frame] * x_angular_period)));
		prop_text->frame_list_texture_y[frame] += (y_amplitude * sin ( y_angle_modifier + (prop_text->frame_list_new_x[frame] * y_angular_period)));
	}

}



void PFONT_texmod_selection ( prop_text_struct *prop_text , float handle_x , float handle_y , int drag_x , int drag_y , float extent , float inverse , int effect )
{
	// This is one of my favourites! It basically allows you to "pull" any area of the texture co-ordinates of the letters
	// and cause the surrounding ones to follow it as if they were attached. It uses a fair few more parameters
	// than most of the effects, but it's worth it.
	// The handle_x and handle_y say which point is being pulled as a percentage across the image (0-1 typical value),
	// the drag_x and drag_y say how far and in which direction it's getting pulled, the extent is again a percentage
	// value and say how far the effect reaches as a percent of the width of the image, aspect ratio is a value
	// which deforms the shape of the area being pulled and finally inverse is a boolean value which swaps whether
	// the point itself is getting pulled or rather the rest of the text is getting pulled (as if the handle point
	// was nailed down).

	// This function uses square root and is therefor to be considered as one of the slower effects computationally.

	// Note that the way in which you pull the co-ords about can be chosen as either "soft", "bubble", "point" or "linear" with the effect values
	// of 0-3 corresponding.

	int offset_x = ( ( prop_text->image_width - prop_text->prop_font->char_width ) * handle_x );
	int offset_y = ( ( prop_text->image_height - prop_text->prop_font->char_height ) * handle_y );

	float distance;
	float influence;
	int frame;

	switch (effect)
	{
	case 0: // Soft selection
		for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
		{
			distance = sqrt ( ( ( prop_text->frame_list_new_x[frame] - offset_x ) * ( prop_text->frame_list_new_x[frame] - offset_x ) ) + ( ( prop_text->frame_list_new_y[frame] - offset_y ) * ( prop_text->frame_list_new_y[frame] - offset_y ) ) ); // distance of letter from handle.
			if (distance < extent) // if it's within the area of effect of the "bubble"
			{
				influence = (extent - distance) / extent; // linear value at this point
				influence *= (3.14597); // now a nice soft value.
				influence = (1-cos (influence))/2;
				if (influence > 0.8)
					int john = 0;
			}
			else
				influence = 0;

			influence = ((influence - 0.5) * inverse) + 0.5;

			prop_text->frame_list_texture_x[frame] += (drag_x * influence);
			prop_text->frame_list_texture_y[frame] += (drag_y * influence);
		}
		break;

	case 1:
		for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
		{
			distance = sqrt ( ( ( prop_text->frame_list_new_x[frame] - offset_x ) * ( prop_text->frame_list_new_x[frame] - offset_x ) ) + ( ( prop_text->frame_list_new_y[frame] - offset_y ) * ( prop_text->frame_list_new_y[frame] - offset_y ) ) ); // distance of letter from handle.
			if (distance < extent) // if it's within the area of effect of the "bubble"
			{
				influence = (1-(extent - distance) / extent); // linear value at this point
				influence *= influence; // now a nice bubble value.
				influence = -influence+1;
				if (influence > 0.8)
					int john = 0;
			}
			else
				influence = 0;

			influence = ((influence - 0.5) * inverse) + 0.5;

			prop_text->frame_list_texture_x[frame] += (drag_x * influence);
			prop_text->frame_list_texture_y[frame] += (drag_y * influence);
		}
		break;

	case 2:
		for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
		{
			distance = sqrt ( ( ( prop_text->frame_list_new_x[frame] - offset_x ) * ( prop_text->frame_list_new_x[frame] - offset_x ) ) + ( ( prop_text->frame_list_new_y[frame] - offset_y ) * ( prop_text->frame_list_new_y[frame] - offset_y ) ) ); // distance of letter from handle.
			if (distance < extent) // if it's within the area of effect of the "bubble"
			{
				influence = (extent - distance) / extent; // linear value at this point
				influence *= influence; // now a nice inverse bubble value.
			}
			else
				influence = 0;

			influence = ((influence - 0.5) * inverse) + 0.5;

			prop_text->frame_list_texture_x[frame] += (drag_x * influence);
			prop_text->frame_list_texture_y[frame] += (drag_y * influence);
		}
		break;

	case 3:
		for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
		{
			distance = sqrt ( ( ( prop_text->frame_list_new_x[frame] - offset_x ) * ( prop_text->frame_list_new_x[frame] - offset_x ) ) + ( ( prop_text->frame_list_new_y[frame] - offset_y ) * ( prop_text->frame_list_new_y[frame] - offset_y ) ) ); // distance of letter from handle.
			if (distance < extent) // if it's within the area of effect of the "bubble"
			{
				influence = (extent - distance) / extent; // linear value at this point
			}
			else
				influence = 0;

			influence = ((influence - 0.5) * inverse) + 0.5;

			prop_text->frame_list_texture_x[frame] += (drag_x * influence);
			prop_text->frame_list_texture_y[frame] += (drag_y * influence);
		}
		break;

	default:
		break;
	}

}



void PFONT_texmod_add_noise ( prop_text_struct *prop_text , int x_noise , int y_noise )
{

	// Adds a random amount of noise to each texture co-ordinate.

	int frame;

	for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
	{
		prop_text->frame_list_texture_x[frame] += ( MATH_rand ( int (- x_noise) , int (x_noise) ) );
		prop_text->frame_list_texture_y[frame] += ( MATH_rand ( int (- y_noise) , int (y_noise) ) );
	}

}



void PFONT_texmod_add_noise_baseline ( prop_text_struct *prop_text , int x_noise , int y_noise )
{

	// This adds noise but only on one side of the origin of each axis.

	int frame;

	for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
	{
		prop_text->frame_list_texture_x[frame] += ( MATH_rand ( 0 , int (x_noise) ) );
		prop_text->frame_list_texture_y[frame] += ( MATH_rand ( 0 , int (y_noise) ) );
	}

}



void PFONT_texmod_rotate ( prop_text_struct *prop_text , float handle_x , float handle_y , float angle  )
{

	// Rotates the positions of the textures.

	int offset_x = ( ( prop_text->image_width - prop_text->prop_font->char_width ) * handle_x );
	int offset_y = ( ( prop_text->image_height - prop_text->prop_font->char_height ) * handle_y );

	int frame;
	float distance;
	float current_angle;

	for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
	{
		distance = sqrt ( ( ( prop_text->frame_list_new_x[frame] - offset_x ) * ( prop_text->frame_list_new_x[frame] - offset_x ) ) + ( ( prop_text->frame_list_new_y[frame] - offset_y ) * ( prop_text->frame_list_new_y[frame] - offset_y ) ) );
		current_angle = atan2 ( ( prop_text->frame_list_new_x[frame] - offset_x ) , ( prop_text->frame_list_new_y[frame] - offset_y ) );
		prop_text->frame_list_texture_x[frame] += distance * sin (angle + current_angle);
		prop_text->frame_list_texture_y[frame] += distance * cos (angle + current_angle);
	}

}



void PFONT_texmod_scale ( prop_text_struct *prop_text , float handle_x , float handle_y , float percent_x , float percent_y )
{

	// Scales the positions of the textures.

	int offset_x = ( ( prop_text->image_width - prop_text->prop_font->char_width ) * handle_x );
	int offset_y = ( ( prop_text->image_height - prop_text->prop_font->char_height ) * handle_y );

	int frame;

	for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
	{
		prop_text->frame_list_texture_x[frame] = ( ( prop_text->frame_list_texture_x[frame] - offset_x ) * percent_x ) + offset_x;
		prop_text->frame_list_texture_y[frame] = ( ( prop_text->frame_list_texture_y[frame] - offset_y ) * percent_y ) + offset_y;
	}

}



void PFONT_texmod_bow_in ( prop_text_struct *prop_text , float handle_x , float handle_y , float max_bow_x , float max_bow_y )
{
	// This bows the text as if there was a soft-selection on it, but it looks different to the regular
	// soft selection. It looks pretty nice, basically.

	int offset_x = ( ( prop_text->image_width - prop_text->prop_font->char_width ) * handle_x );
	int offset_y = ( ( prop_text->image_height - prop_text->prop_font->char_height ) * handle_y );

	float temp_x;
	float temp_y;
	float bow_x;
	float bow_y;

	int frame;

	for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
	{

		temp_x = ( prop_text->frame_list_new_x[frame] - offset_x ) / (prop_text->image_width / 2);
		temp_y = ( prop_text->frame_list_new_y[frame] - offset_y ) / (prop_text->image_height / 2);
		bow_y = max_bow_x - (temp_x * temp_x) * max_bow_x;
		bow_x = max_bow_y - (temp_y * temp_y) * max_bow_y;
		prop_text->frame_list_texture_x[frame] += bow_x + bow_y;
		prop_text->frame_list_texture_y[frame] += bow_x + bow_y;

	}
}



void PFONT_texmod_bow_out ( prop_text_struct *prop_text , float handle_x , float handle_y , float max_bow_x , float max_bow_y )
{
	// This bows the text as if there was a soft-selection on it, but it looks different to the regular
	// soft selection. It looks pretty nice, basically.

	int offset_x = ( ( prop_text->image_width - prop_text->prop_font->char_width ) * handle_x );
	int offset_y = ( ( prop_text->image_height - prop_text->prop_font->char_height ) * handle_y );

	float temp_x;
	float temp_y;
	float bow_x;
	float bow_y;

	int frame;

	for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
	{

		temp_x = ( prop_text->frame_list_new_x[frame] - offset_x ) / (prop_text->image_width / 2);
		temp_y = ( prop_text->frame_list_new_y[frame] - offset_y ) / (prop_text->image_height / 2);
		bow_y = (temp_x * temp_x) * max_bow_x;
		bow_x = (temp_y * temp_y) * max_bow_y;
		prop_text->frame_list_texture_x[frame] += bow_x + bow_y;
		prop_text->frame_list_texture_y[frame] += bow_x + bow_y;

	}
}



void PFONT_find_extremes (prop_text_struct *prop_text)
{

	prop_text->top_left_x = 0;
	prop_text->top_left_y = 0;
	prop_text->bottom_right_x = 0;
	prop_text->bottom_right_y = 0;

	int frame;

	for (frame=0 ; ( frame<prop_text->frame_pointer ) ; frame++ )
	{
		if ( prop_text->frame_list_new_x[frame] < prop_text->top_left_x )
			prop_text->top_left_x = prop_text->frame_list_new_x[frame];

		if ( prop_text->frame_list_new_y[frame] < prop_text->top_left_y )
			prop_text->top_left_y = prop_text->frame_list_new_y[frame];

		if ( prop_text->frame_list_new_x[frame] + prop_text->prop_font->char_width > prop_text->bottom_right_x )
			prop_text->bottom_right_x = prop_text->frame_list_new_x[frame] + prop_text->prop_font->char_width;

		if ( prop_text->frame_list_new_y[frame] + prop_text->prop_font->char_width > prop_text->bottom_right_y )
			prop_text->bottom_right_y = prop_text->frame_list_new_y[frame] + prop_text->prop_font->char_height;

	}
}



// All functions that draw to the screen or a bitmap surface...



void PFONT_draw_frame_list_notexture ( prop_text_struct *prop_text , int max_letters , int x , int y , float handle_x , float handle_y , BITMAP *buffer_image )
{
	int frame;

	int offset_x = ( ( prop_text->image_width ) * handle_x );
	int offset_y = ( ( prop_text->image_height ) * handle_y );

	x = x - offset_x;
	y = y - offset_y;

	for (frame=0 ; ( (frame<max_letters) && (frame<prop_text->frame_pointer) ) ; frame++ )
	{
		masked_blit ( prop_text->prop_font->font_gfx , buffer_image , prop_text->frame_list_image_x[frame] , prop_text->frame_list_image_y[frame] , x + prop_text->frame_list_new_x[frame] , y + prop_text->frame_list_new_y[frame] , prop_text->prop_font->char_width , prop_text->prop_font->char_height );
	}

}



void PFONT_draw_frame_list_texture ( prop_text_struct *prop_text , int max_letters , int x , int y , float handle_x , float handle_y , BITMAP *buffer_image , texture_struct *texture )
{
	int frame;

	int offset_x = ( ( prop_text->image_width ) * handle_x );
	int offset_y = ( ( prop_text->image_height ) * handle_y );

	x = x - offset_x;
	y = y - offset_y;

	for (frame = 0 ; frame < prop_text->frame_pointer ; frame++)
	{
		prop_text->frame_list_texture_x[frame]= MATH_wrap (prop_text->frame_list_texture_x[frame] , texture->wrap_width) ;
		prop_text->frame_list_texture_y[frame] = MATH_wrap (prop_text->frame_list_texture_y[frame] , texture->wrap_height) ;
	}

	acquire_bitmap(buffer_image);

	if (bitmap_color_depth(buffer_image) == 16)
	{
		for (frame=0 ; ( (frame<max_letters) && (frame<prop_text->frame_pointer) ) ; frame++ )
		{
			GRAPHICS_double_masked_blit_16bit ( texture->texture_image , prop_text->prop_font->font_gfx , buffer_image , prop_text->frame_list_texture_x[frame] , prop_text->frame_list_texture_y[frame] , prop_text->frame_list_image_x[frame] , prop_text->frame_list_image_y[frame] , x + prop_text->frame_list_new_x[frame] , y + prop_text->frame_list_new_y[frame] , prop_text->prop_font->letter_widths[prop_text->frame_list_frame[frame]] , prop_text->prop_font->char_height );
		}
	}
	else if (bitmap_color_depth(buffer_image) == 32)
	{
		for (frame=0 ; ( (frame<max_letters) && (frame<prop_text->frame_pointer) ) ; frame++ )
		{
			GRAPHICS_double_masked_blit_32bit ( texture->texture_image , prop_text->prop_font->font_gfx , buffer_image , prop_text->frame_list_texture_x[frame] , prop_text->frame_list_texture_y[frame] , prop_text->frame_list_image_x[frame] , prop_text->frame_list_image_y[frame] , x + prop_text->frame_list_new_x[frame] , y + prop_text->frame_list_new_y[frame] , prop_text->prop_font->letter_widths[prop_text->frame_list_frame[frame]] , prop_text->prop_font->char_height );
		}
	}

	release_bitmap(buffer_image);

}



void PFONT_draw_frame_list_coloured ( prop_text_struct *prop_text , int max_letters , int x , int y , float handle_x , float handle_y , BITMAP *buffer_image , int red , int green , int blue )
{
	int frame;

	int offset_x = ( ( prop_text->image_width ) * handle_x );
	int offset_y = ( ( prop_text->image_height ) * handle_y );

	unsigned short colour_16bit = makecol16 ( red , green , blue );
	unsigned long colour_32bit = makecol32 ( red , green , blue );;

	x = x - offset_x;
	y = y - offset_y;

	acquire_bitmap(buffer_image);

	if (bitmap_color_depth(buffer_image) == 16)
	{
		for (frame=0 ; ( (frame<max_letters) && (frame<prop_text->frame_pointer) ) ; frame++ )
		{
			GRAPHICS_colour_blit_16bit ( prop_text->prop_font->font_gfx , buffer_image , prop_text->frame_list_image_x[frame] , prop_text->frame_list_image_y[frame] , x + prop_text->frame_list_new_x[frame] , y + prop_text->frame_list_new_y[frame] , prop_text->prop_font->letter_widths[prop_text->frame_list_frame[frame]] , prop_text->prop_font->char_height , colour_16bit);
		}
	}
	else if (bitmap_color_depth(buffer_image) == 32)
	{
		for (frame=0 ; ( (frame<max_letters) && (frame<prop_text->frame_pointer) ) ; frame++ )
		{
			GRAPHICS_colour_blit_32bit ( prop_text->prop_font->font_gfx , buffer_image , prop_text->frame_list_image_x[frame] , prop_text->frame_list_image_y[frame] , x + prop_text->frame_list_new_x[frame] , y + prop_text->frame_list_new_y[frame] , prop_text->prop_font->letter_widths[prop_text->frame_list_frame[frame]] , prop_text->prop_font->char_height , colour_32bit);
		}
	}

	release_bitmap(buffer_image);

}



void PFONT_draw_frame_list_vert_lerped_coloured ( prop_text_struct *prop_text , int max_letters , int x , int y , float handle_x , float handle_y , BITMAP *buffer_image , int red_1 , int green_1 , int blue_1 , int red_2 , int green_2 , int blue_2 )
{
	int frame;

	int offset_x = ( ( prop_text->image_width ) * handle_x );
	int offset_y = ( ( prop_text->image_height ) * handle_y );

	unsigned short colour_table_16bit[MAX_DISPLAY_HEIGHT];
	unsigned long colour_table_32bit[MAX_DISPLAY_HEIGHT];

	int t;


	for (t=0 ; t < prop_text->prop_font->char_height ; t++)
	{
		colour_table_16bit[t] = makecol16 (MATH_lerp(red_1,red_2,float (t) / float (prop_text->prop_font->char_height)) , MATH_lerp(green_1,green_2,float (t) / float (prop_text->prop_font->char_height)) , MATH_lerp(blue_1,blue_2,float (t) / float (prop_text->prop_font->char_height)) );
		colour_table_32bit[t] = makecol32 (MATH_lerp(red_1,red_2,float (t) / float (prop_text->prop_font->char_height)) , MATH_lerp(green_1,green_2,float (t) / float (prop_text->prop_font->char_height)) , MATH_lerp(blue_1,blue_2,float (t) / float (prop_text->prop_font->char_height)) );
	}

	x = x - offset_x;
	y = y - offset_y;

	acquire_bitmap(buffer_image);

	if (bitmap_color_depth(buffer_image) == 16)
	{
		for (frame=0 ; ( (frame<max_letters) && (frame<prop_text->frame_pointer) ) ; frame++ )
		{
			GRAPHICS_colour_vert_lerped_blit_16bit ( prop_text->prop_font->font_gfx , buffer_image , prop_text->frame_list_image_x[frame] , prop_text->frame_list_image_y[frame] , x + prop_text->frame_list_new_x[frame] , y + prop_text->frame_list_new_y[frame] , prop_text->prop_font->letter_widths[prop_text->frame_list_frame[frame]] , prop_text->prop_font->char_height , colour_table_16bit );
		}
	}
	else if (bitmap_color_depth(buffer_image) == 32)
	{
		for (frame=0 ; ( (frame<max_letters) && (frame<prop_text->frame_pointer) ) ; frame++ )
		{
			GRAPHICS_colour_vert_lerped_blit_32bit ( prop_text->prop_font->font_gfx , buffer_image , prop_text->frame_list_image_x[frame] , prop_text->frame_list_image_y[frame] , x + prop_text->frame_list_new_x[frame] , y + prop_text->frame_list_new_y[frame] , prop_text->prop_font->letter_widths[prop_text->frame_list_frame[frame]] , prop_text->prop_font->char_height , colour_table_32bit );
		}
	}

	release_bitmap(buffer_image);

}
