#ifndef _FUNKYFONT_H_
#define _FUNKYFONT_H_

// Funky Font Defines
#define MAX_LETTERS_PER_FONT				(96)
#define MAX_LINES_PER_BOX					(100)
#define MAX_FRAME_LIST_SIZE					(2048)
#define MAX_LETTERS							(256)
#define PFONT_ALIGN_LEFT					(1)
#define PFONT_ALIGN_TOP						(1)
#define PFONT_ALIGN_CENTER					(2)
#define PFONT_ALIGN_RIGHT					(3)
#define PFONT_ALIGN_BOTTOM					(3)
#define PFONT_ALIGN_JUSTIFY					(4)
#define PFONT_TEMP_TEXT_ID					(0)
#define PFONT_TEXT_TYPE_BASIC				(1)
#define PFONT_TEXT_TYPE_INSTANT_IMAGE		(2)
#define PFONT_TEXT_TYPE_SPLIT_IMAGE			(3)
#define PFONT_TEXT_TYPE_FRAME_LIST			(4)
#define PFONT_TEXT_TYPE_GRADUAL_IMAGE		(5)
#define PFONT_STATUS_PRE_PROCESSING			(-1)
#define PFONT_STATUS_PROCESSING				(0)
#define PFONT_STATUS_COMPLETE				(1)
#define PFONT_DOES_NOT_EXIST				(2)

#define	PFONT_NEW_LINE_CHAR					'|'
	// If this is encountered in a chunk of text then it'll cause a line-break and paragraph end.

#define MAX_DISPLAY_HEIGHT					(480)
	// SET THIS TO YOUR SCREEN HEIGHT! This is used when creating the makecol tables for drawing vertically
	// colour banded sprites. If you send a sprite of a greater height than this via that function then it'll
	// implode messily with a "shwooooooop!" sound. Or maybe a beep.


// Funky Font Structures

struct font_struct
{
	BITMAP *font_gfx;
	int char_width;
	int char_height;
	int image_width;
	int image_height;
	int frames_per_row;
	int frames_per_column;
	int letter_widths[MAX_LETTERS];
	bool usingDirectBMP;
	font_struct() { usingDirectBMP=true; }
};

struct texture_struct
{
	BITMAP *texture_image;
	int width;
	int height;
	int wrap_width;
	int wrap_height;
	bool usingDirectBMP;
	texture_struct() { usingDirectBMP=true; }
};

typedef struct
{
	char text [MAX_FRAME_LIST_SIZE];
	// This is where the words you pass are stored.
	int image_width;
	// The size of the image created in order to store all the letters. Note it's not actually always created
	// but the information is used all over the place. It's specified by the user.
	int image_height;
	// The size of the image created in order to store all the letters. Note it's not actually always created
	// but the information is used all over the place.
	int top_left_x;
	int top_left_y;
	int bottom_right_x;
	int bottom_right_y;
	// When you draw text to a particular image it may well be that the co-ordinates spill outside of the base
	// base image size you specified because you scaled or transformed the letter co-ordinates in some way. As
	// such we need to find the proper size of the box needed to store the text as so we loop through the text
	// and find the extents of the letters. Now the really important one is the top_left_x and top_left_y as
	// when we draw letters to the box we need to modify their co-ordinates by this amount so that they all
	// appear within the confines of the box. Lawks.
	int total_lines;
	// The total number of lines in the paragraph generated.
	int x_spacing;
	// The pixel distance between each letter of text.
	int y_spacing;
	// The pixel distance between each row of text.
	int alignment;
	// Well, duh?
	int line_start[MAX_LINES_PER_BOX];
	int line_length[MAX_LINES_PER_BOX];
	// These are the starts of each line in the text box and the length of them and they're used stored to make things easy.
	int words_in_line[MAX_LINES_PER_BOX];
	// This is a list of the numbers of words in each line of the text and is used for... Um... Actually what the hell *is* it used for?
	font_struct *prop_font;
	// This is the number of the font used to calculate letter widths during the creation of the proportional text.
	float frame_list_base_x[MAX_FRAME_LIST_SIZE];
	float frame_list_base_y[MAX_FRAME_LIST_SIZE];
	// These are the co-ords calculated by the proportional print section and they are never altered once created.
	float frame_list_new_x[MAX_FRAME_LIST_SIZE];
	float frame_list_new_y[MAX_FRAME_LIST_SIZE];
	// These are the co-ords created by the various effect routines and are based on the base co-ords.
	float frame_list_image_x[MAX_FRAME_LIST_SIZE];
	float frame_list_image_y[MAX_FRAME_LIST_SIZE];
	// This is the co-ordinate of the texture for this letter within the font image to save on recalculation
	float frame_list_texture_x[MAX_FRAME_LIST_SIZE];
	float frame_list_texture_y[MAX_FRAME_LIST_SIZE];
	// This is the co-ords for the texture which colours in the letters afterwards if you have texturing turned on.
	int frame_list_frame[MAX_FRAME_LIST_SIZE];
	// This is is the number of the image within the font graphic and is kinda' redundant information
	int frame_pointer;
	// This is used throughout the creation of the proportional text and ends up as the number of frames created
	int drawn_frame_pointer;
	// This is used for when you're drawing frames to an image.
} prop_text_struct;

// Funky Font Headers

void PFONT_load_font (font_struct *prop_font, const char *filename, int frame_width, int frame_height);
void PFONT_load_font_from_bitmap(font_struct *prop_font, BITMAP* bmp, int frame_width, int frame_height);
void PFONT_free_font ( font_struct *prop_font);
void PFONT_free_texture ( texture_struct *texture );
void PFONT_load_texture ( texture_struct *texture , const char *filename , int x_overlap , int y_overlap );
void PFONT_load_texture_from_bitmap (texture_struct *texture , BITMAP* bmp , int x_overlap , int y_overlap );
void PFONT_draw_frame_list_notexture ( prop_text_struct *prop_text , int max_letters , int x , int y , float handle_x , float handle_y , BITMAP *buffer_image );
void PFONT_draw_frame_list_texture ( prop_text_struct *prop_text , int max_letters , int x , int y , float handle_x , float handle_y , BITMAP *buffer_image , texture_struct *texture );
void PFONT_draw_frame_list_coloured ( prop_text_struct *prop_text , int max_letters , int x , int y , float handle_x , float handle_y , BITMAP *buffer_image , int red , int green , int blue );
void PFONT_draw_frame_list_vert_lerped_coloured ( prop_text_struct *prop_text , int max_letters , int x , int y , float handle_x , float handle_y , BITMAP *buffer_image , int red_1 , int green_1 , int blue_1 , int red_2 , int green_2 , int blue_2 );

void PFONT_create_frame_list ( prop_text_struct *prop_text , font_struct *prop_font, const char *words, int width, int alignment, int x_spacing, int y_spacing , bool reverse_x_order , bool reverse_y_order );



void PFONT_posset_reset ( prop_text_struct *prop_text );
void PFONT_posmod_distort ( prop_text_struct *prop_text , float handle_x , float handle_y, float horizontal_deviation , float vertical_deviation  );
void PFONT_posmod_bouncing_in_phase ( prop_text_struct *prop_text , float x_angular_period , float y_angular_period , float x_amplitude , float y_amplitude , float x_angle_modifier , float y_angle_modifier );
void PFONT_posmod_bouncing_out_phase ( prop_text_struct *prop_text , float x_angular_period , float y_angular_period , float x_amplitude , float y_amplitude , float x_angle_modifier , float y_angle_modifier );
void PFONT_posmod_sine_in_phase  ( prop_text_struct *prop_text , float x_angular_period , float y_angular_period , float x_amplitude , float y_amplitude , float x_angle_modifier , float y_angle_modifier );
void PFONT_posmod_sine_out_phase  ( prop_text_struct *prop_text , float x_angular_period , float y_angular_period , float x_amplitude , float y_amplitude , float x_angle_modifier , float y_angle_modifier );
void PFONT_posmod_selection ( prop_text_struct *prop_text , float handle_x , float handle_y , int drag_x , int drag_y , float extent , float inverse , int effect );
void PFONT_posmod_add_noise ( prop_text_struct *prop_text , int x_noise , int y_noise );
void PFONT_posmod_add_noise_baseline ( prop_text_struct *prop_text , int x_noise , int y_noise );
void PFONT_posmod_rotate ( prop_text_struct *prop_text , float handle_x , float handle_y , float angle );
void PFONT_posmod_rotate_selection ( prop_text_struct *prop_text, float handle_x , float handle_y , float angle  , float extent , float inverse , int effect);
void PFONT_posmod_scale ( prop_text_struct *prop_text , float handle_x , float handle_y , float percent_x , float percent_y );
void PFONT_posmod_clamping ( prop_text_struct *prop_text , int damp_from , int damp_until );
void PFONT_posmod_damp_point ( prop_text_struct *prop_text , int damp_point , float extent , int method );
void PFONT_posmod_inverse_damp_point ( prop_text_struct *prop_text , int damp_point , float extent , int method );
void PFONT_posmod_damp ( prop_text_struct *prop_text , float damping );
void PFONT_posmod_bow_in ( prop_text_struct *prop_text , float handle_x , float handle_y , float max_bow_x , float max_bow_y );
void PFONT_posmod_bow_out ( prop_text_struct *prop_text , float handle_x , float handle_y , float max_bow_x , float max_bow_y );



void PFONT_texset_basic_spread ( prop_text_struct *prop_text , float x_spread , float y_spread , float x_base , float y_base , bool convert );
void PFONT_texmod_bouncing_in_phase ( prop_text_struct *prop_text , float x_angular_period , float y_angular_period , float x_amplitude , float y_amplitude , float x_angle_modifier , float y_angle_modifier );
void PFONT_texmod_bouncing_out_phase ( prop_text_struct *prop_text , float x_angular_period , float y_angular_period , float x_amplitude , float y_amplitude , float x_angle_modifier , float y_angle_modifier );
void PFONT_texmod_sine_in_phase  ( prop_text_struct *prop_text , float x_angular_period , float y_angular_period , float x_amplitude , float y_amplitude , float x_angle_modifier , float y_angle_modifier );
void PFONT_texmod_sine_out_phase  ( prop_text_struct *prop_text , float x_angular_period , float y_angular_period , float x_amplitude , float y_amplitude , float x_angle_modifier , float y_angle_modifier );
void PFONT_texmod_selection ( prop_text_struct *prop_text , float handle_x , float handle_y , int drag_x , int drag_y , float extent , float inverse , int effect );
void PFONT_texmod_add_noise ( prop_text_struct *prop_text , int x_noise , int y_noise );
void PFONT_texmod_add_noise_baseline ( prop_text_struct *prop_text , int x_noise , int y_noise );
void PFONT_texmod_rotate ( prop_text_struct *prop_text , float handle_x , float handle_y , float angle  );
void PFONT_texmod_scale ( prop_text_struct *prop_text , float handle_x , float handle_y , float percent_x , float percent_y );
void PFONT_texmod_bow_in ( prop_text_struct *prop_text , float handle_x , float handle_y , float max_bow_x , float max_bow_y );
void PFONT_texmod_bow_out ( prop_text_struct *prop_text , float handle_x , float handle_y , float max_bow_x , float max_bow_y );




// End

#endif
