#include "..\game_transam.h"

using namespace AXL_Projects;

void InitialiseSound()
{
    FMOD_Enabled=false;
	if(GameConfiguration->GetCustom("enablefmod",1))
	{
		if(FSOUND_Init(22050,GameConfiguration->CapsSound.MaxSounds,0))
		{
			FMOD_Enabled=true;
			FSOUND_SetSFXMasterVolume(GameConfiguration->CapsSound.SampleVolume);
			Configuration::LogEntry("FMOD initialised ok",false,"transam.log");
			LoadSamples();
		}
		else
		{
			FMOD_Enabled=false;
			std::string code=FMOD_ErrorString(FSOUND_GetError());
			Configuration::LogEntry("Failed to initialise fmod sound library: "+code,false,"transam.log");
		}
	}
	else
		Configuration::LogEntry("Music/Sound disabled by xml entry",false,"transam.log");

}

void RemoveSound()
{
	StopTrackerSong();
	StopSFX(FSOUND_ALL);
	if(FMOD_Enabled) FSOUND_Close();
	FMOD_Enabled=false;
}

//only ever have one thing at once
static FMUSIC_MODULE* PlayTrackerSongEX(const char* filename, int volume, int length, bool loop, int startpoint)
{
	//play mod, s3m, etc files
	//from file or memory. length -1 to assume memory -
	// this is a helper function, not to be used. use below two functions
    if(!FMOD_Enabled)
        InitialiseSound();
    if(!FMOD_Enabled || GameConfiguration->CapsSound.MusicVolume<1)
        return NULL;

	if(ActiveMusic)
	{
		FMUSIC_StopSong(ActiveMusic);
		FMUSIC_FreeSong(ActiveMusic);
	}

	if(length==-1)
		ActiveMusic=FMUSIC_LoadSong(filename);
	else
		ActiveMusic=FMUSIC_LoadSongEx(filename,0,length,FSOUND_NORMAL | FSOUND_LOADMEMORY,NULL,0);

	if(ActiveMusic)
	{
		FMUSIC_PlaySong(ActiveMusic);
		//FMUSIC_SetOrder(ActiveMusic,startpoint);
		if(volume!=-1)
			FMUSIC_SetMasterVolume(ActiveMusic,volume);
		else
			FMUSIC_SetMasterVolume(ActiveMusic,GameConfiguration->CapsSound.MusicVolume);

		if(!loop)
			FMUSIC_SetLooping(ActiveMusic,FALSE);
	}

	return ActiveMusic;
}

FMUSIC_MODULE* PlayTrackerSongFromDAT(const char* data, int volume, int length, bool loop, int startpoint)
{
	PlayTrackerSongEX(data,volume,length,loop,startpoint);
	return ActiveMusic;
}

FMUSIC_MODULE* PlayTrackerSongFromFile(const char* filename, int volume, bool loop, int startpoint)
{
	PlayTrackerSongEX(filename,volume,-1,loop,startpoint);
	return ActiveMusic;
}

void StopTrackerSong()
{
	FMUSIC_StopAllSongs();
	FMUSIC_FreeSong(ActiveMusic);
	ActiveMusic=NULL;
}

FSOUND_STREAM* PlaySampleFromStream(const char* filename, int& _channel,int volume, long length, long additionalmode)
{
	//use -1 for volume to change it from the master volume (optional param)
	//only use length if using memory reading, as below (optional param)
	//additionalmode is extra flags (FSOUND_MODES), eg FSOUND_LOADMEMORY (optional param)
    if(!FMOD_Enabled)
        InitialiseSound();

    if(!FMOD_Enabled || GameConfiguration->CapsSound.MusicVolume<1)
        return NULL;

	FSOUND_STREAM* fs=FSOUND_Stream_Open(filename,FSOUND_NORMAL | additionalmode,0,length);
	if(!fs) return NULL;
	int channel=FSOUND_Stream_Play(FSOUND_FREE,fs);

	_channel=channel;
	if(channel==-1)
	{
		FSOUND_Stream_Close(fs);
		return NULL;
	}
	else
	{
		//volume is relative to the master volume
		if(volume>=0 && volume<256)
			FSOUND_SetVolumeAbsolute(channel,volume);
		else
			FSOUND_SetVolumeAbsolute(channel,GameConfiguration->CapsSound.MusicVolume);
		return fs;
	}
	//does not return channel

}

void StopStream(FSOUND_STREAM* fs)
{
	if(fs)
		FSOUND_Stream_Close(fs);
}

void AdjustMusicVolume(FMUSIC_MODULE *music,int volume)
{
	if(music)
		FMUSIC_SetMasterVolume(music,volume);
}

void PlayExclusiveSFX(FSOUND_SAMPLE *snd)
{
	int channel;
	if(snd && FMOD_Enabled && GameConfiguration->CapsSound.SampleVolume>0)
	{
		//FSOUND_StopSound(FSOUND_ALL);
		StopSFX(FSOUND_ALL);
		channel=FSOUND_PlaySound(FSOUND_FREE,snd);
		FSOUND_SetVolumeAbsolute(channel,GameConfiguration->CapsSound.SampleVolume);
		FSOUND_SetLoopMode(channel,FSOUND_LOOP_OFF);
	}
}

void StopSFX(int channel)
{
	if(FMOD_Enabled)
	{
		if(channel>=0)
			FSOUND_StopSound(channel);
		else if(channel==FSOUND_ALL)
		{
			int channels;
			int count;
			channels = FSOUND_GetMaxChannels();
			for(count=0;count<channels;count++)
				if(FSOUND_IsPlaying(count)) FSOUND_StopSound(count);
		}
	}
}

void AdjustFrequencySFX(int channel,int rate)
{
	if(channel!=-1 && FMOD_Enabled && GameConfiguration->CapsSound.SampleVolume>0)
	{
		//adjust frequency
		FSOUND_SetFrequency(channel,rate);
	}
}
void AdjustVolumeSFX(int channel,int volume)
{
	//volume is 0 to 255 based on master volume
	if(channel!=-1 && FMOD_Enabled && GameConfiguration->CapsSound.SampleVolume>0)
		FSOUND_SetVolume(channel,volume);
}

int PlaySFX(FSOUND_SAMPLE *snd,int loop,bool forceRestart,bool onlyifnotplaying,int channel)
{
	//play sample snd, with looping
	//forcerestart to stop it and play it again if true
	//forcerestart to play it and cut any existing short
	//checkchannel to a number if wish to either force stop or to not play it if already playing
	//onlyifnotplaying used to play same sound once only or multiple times
	if(snd && FMOD_Enabled && GameConfiguration->CapsSound.SampleVolume>0)
	{
		if(forceRestart && channel>=0)
		{
			FSOUND_StopSound(channel);
			channel=-1;
		}

		if(onlyifnotplaying && channel!=-1 && FSOUND_IsPlaying(channel))
			return channel;

		int newchannel=FSOUND_PlaySound(FSOUND_FREE,snd);
		FSOUND_SetVolumeAbsolute(newchannel,GameConfiguration->CapsSound.SampleVolume);
		FSOUND_SetLoopMode(newchannel,loop);

		return newchannel;
	}
	else
		return -1;
}

//game specific
void LoadSamples()
{
	if(GameDAT)
	{
		snd_menuchange=LoadSample(SFX_MENUCHANGE);
		snd_menuselect=LoadSample(SFX_MENUSELECT);
		snd_gamefuelincrease=LoadSample(SFX_GAME_FUELINCREASE);
		snd_gamelowfuel=LoadSample(SFX_GAME_LOWFUEL);
		snd_gamehandbrake=LoadSample(SFX_GAME_HANDBRAKE);
		snd_gamecarcrash=LoadSample(SFX_GAME_CRASH);
		snd_gamecountdown=LoadSample(SFX_GAME_COUNTDOWN);
		snd_gamecarmoving=LoadSample(SFX_GAME_CARGROUND);
		snd_findcup=LoadSample(SFX_GAME_GETCUP);
		snd_gameradar=LoadSample(SFX_GAME_RADARBEEP);
	}
}

FSOUND_SAMPLE* LoadSample(int item)
{
	FSOUND_SAMPLE* ret=NULL;
	ret=FSOUND_Sample_Load(FSOUND_FREE,
							(const char *)GameDAT[item].dat,
							FSOUND_LOADMEMORY | FSOUND_NORMAL,
							0,
							GameDAT[item].size);

	if(!ret)
		Configuration::LogEntry((std::string)("Failed to initialise sample : ")+FMOD_ErrorString(FSOUND_GetError()),false,"transam.log");

	return ret;
}
