#include "game_transam.h"
#include "game_car.h"

using namespace std;

static bool GetJoyAccelerate(int dir, int button);
static bool GetJoyBrake(int dir, int button);
static bool GetJoyHandbrake(int button);

//innitialise a car back to it's defaults
const float Car::MAXVEL=-10.0;
const float Car::HALFVEL=-4.0;	//for enemy cars
float Car::MAXVELENEMY=Car::MAXVEL*0.8;	//see also car setup code
const float Car::MAXVELTURBO=-15.0;
const float Car::MPH_MAX=500.0;
const float Car::MPH_INCREASE=MPH_MAX/MAXVEL;
const int Car::MPH_REDLINE=400;
const int Car::MPH_YELLOWLINE=300;
const float Car::FUEL_MAX=60.0;	//60
const float Car::FUEL_INC=1/FUEL_MAX;

int MapGetBlockNumber(int x, int y)
{
	if(x>mapwidth || y>mapheight || x<0 || y<0)
		return 0;
	short int * mymappt;
	if (maparraypt!= NULL) {
		mymappt = maparraypt[y]+x;
	} else {
		mymappt = mappt;
		mymappt += x;
		mymappt += y*mapwidth;
	}
	return *mymappt;
}

void Car::SetCurrentState()
{
	MapChangeLayer(2);
	BLKSTR* b=MapGetBlockInPixels((int)mapx,(int)mapy);
	int currentState=b->user4;
	stateChanged=-1;
	if(currentState!=lastState)
	{
		stateChanged=currentState;
		lastState=currentState;
		usState=states[currentState][0];
		usStateCapital=states[currentState][1];
	}
	MapChangeLayer(0);
}

int Car::GetCurrentState()
{
	MapChangeLayer(2);
	BLKSTR* b=MapGetBlockInPixels((int)mapx,(int)mapy);
	int currentState=b->user4;
	MapChangeLayer(0);
	return currentState;
}

void Car::SetupCar(std::string animtype,bool resetMiles,bool resetPosition)
{
	stateChanged=0;
	playingFuelIncrease=-1;
	playingFuelLow=-1;
	playingHandbrake=-1;
	playingCarNoise=-1;
	playingFindCup=-1;
	originalCarNoiseFrequency=0;
	angle=0;acc=0;vel=0.0;
	lastangle=-1;
	decel=0.5;
	Handbrake=false;
	Mph=0;
	Fuel=Car::FUEL_MAX;
	Temperature=0.0;
	DamageLevel=32;
	if(resetMiles) MilesDriven=0.0;
	TemperatureLatch=false;
	BlockTopSpeedIncrease=false;
	SpeedFactor=1.0;
	HitCar=false;
	shadowOffsetX=shadowOffsetY=0;

	TemperatureInc=3.333/GameConfiguration->CapsSystem.fps;

	if(currentLevel && currentLevel->gameMode!=GT_RACE)
		TemperatureDec=5.0/GameConfiguration->CapsSystem.fps;
	else
		TemperatureDec=12.0/GameConfiguration->CapsSystem.fps;

	FuelUnit=(1.0/(float)Car::MPH_MAX)/GameConfiguration->CapsSystem.fps;

	if(car) delete car;		//delete if already exists
	car=new Animation(GameLibrary,animtype);	//get graphics for the car
	if(Configuration::GlobalErrorString!="")
		GameFramework->AbortSystem("animation could not be found for setupcar");

	//get size of car and the positions to show it
	car->GetStandardDimensions(&CarWidth, &CarHeight);
	//car is always in the centre of the screen, so we already know
	//what bit of the map is being shown, so we get the centre of that
	//as it is shown on the screen
	if(resetPosition)
	{
		screenx=((ShownMapWidth/2)+ScreenXOffset)-(CarWidth/2);
		screeny=((ShownMapHeight/2)+ScreenYOffset)-(CarHeight/2);
	}

	//what the car is doing
	Move=CAR_FREEWHEELING;
	Direction=CAR_STRAIGHT;
	State=CAR_NORMAL;
}

Car::Car() {
		stateChanged=0;
		playingFuelIncrease=-1;
		playingFuelLow=-1;
		playingHandbrake=-1;
		playingCarCrash=-1;
		playingFindCup=-1;
		LastHitX=LastHitY=-1;
		lastState=0;
		TemperatureLatch=false;
		screenx=screeny=angle=Mph=0;
		lastangle=-1;
		DamageLevel=32;
		acc=vel=decel=xdistancemoved=ydistancemoved=mapx=mapy=MilesDriven=0.0;
		Temperature=Fuel=TemperatureInc=TemperatureDec=0.0;
		car=NULL;
		BlockTopSpeedIncrease=false;
		SpeedFactor=1.0;
		State=CAR_NORMAL;
		CarWidth=CarHeight=0;
		HitCar=false;
		usState="";
		usStateCapital="";
		shadowOffsetX=0;
		shadowOffsetY=0;
		crashParticles=new Particles(GameConfiguration->CapsSystem.fps,10);
}

Car::~Car()
{
	//remove animation
	if(car) delete car;
	if(crashParticles)
		delete crashParticles;
	car=NULL;
}

bool Car::NextMove()
{
	static int soundcounter=0;
	soundcounter++;
	//update the car. called every frame
	//default to no acceleration pressed
	//and if simple acceleration then car will decrease when no acceleration
	acc=0;
	decel=0.0;
	Handbrake=false;
	Move=CAR_FREEWHEELING;
	Direction=CAR_STRAIGHT;
	shadowOffsetX=(int)((LightSourceX-mapx)*ShadowFactor);
	shadowOffsetY=(int)((LightSourceY-mapy)*ShadowFactor);

	if(Temperature>=100 || (TemperatureLatch && Temperature>75))TemperatureLatch=true;
	else TemperatureLatch=false;

	if((TemperatureLatch && Mph>100) || this->Fuel<=0)
		decel=0.05;

	//if run out of fuel, let it conk out first
	if(Fuel<=0 && vel>=0 && State!=CAR_DYING)
	{
		//dead
		State=CAR_DYING;
		this->crashParticles->Add("blowout",500,screenx,screeny,0);
		this->crashParticles->Add("blowout",500,screenx+8,screeny,100);
		this->crashParticles->Add("blowout",500,screenx+16,screeny+16,200);
		this->crashParticles->Add("blowout",500,screenx,screeny+8,300);
		car->SetCustomCountDown(1,2000);
	}

	if(Fuel<15)
		playingFuelLow=PlaySFX(snd_gamelowfuel,FSOUND_LOOP_NORMAL,false,true,playingFuelLow);
	else
		StopSFX(playingFuelLow);

	//key presses
	//order is important
	if(quitPause)
	{
		quitPause=false;
		return true;
	}

	if(this->State!=CAR_NORMAL)
	{
		decel=0.2;
	}
	else
	{
		int joyDir=0;
		int joyButton=0;
		if(JoystickHandler>=0)
		{
			GameFramework->JoypadAxisPressed(joyDir);
			joyButton=GameFramework->JoypadButtonPressed();
		}
		if(keypressed() || joyButton || joyDir)
		{
			if(key[KEY_SPACE] || key[KEY_LSHIFT] || key[KEY_RSHIFT] || key[KEY_LCONTROL] || key[KEY_RCONTROL] || GetJoyHandbrake(joyButton))
			{
				Handbrake=true;
				if(lastangle==-1) lastangle=angle;
				if(vel<0)
					playingHandbrake=PlaySFX(snd_gamehandbrake,FSOUND_LOOP_NORMAL,false,true,playingHandbrake);

			}
			else lastangle=-1;

			if(key[KEY_ESC])
			{
				clear_keybuf();
				FSOUND_StopSound(FSOUND_ALL);
				this->playingCarNoise=this->playingFuelIncrease=this->playingFuelLow=this->playingHandbrake=-1;

				GameFramework->SetAutoGameLoopOverride(PauseLogic,PauseDrawing);
				return false;
			}

			//brake takes precedence
			if(key[KeyboardControls[KeyboardHandler][3]] || GetJoyBrake(joyDir,joyButton))
			{
				//if(decel==0) decel=0.05;
				Move=CAR_DECELERATE;
			}
			else
			{
				//if(!TemperatureLatch) decel=0.0;
				if(key[KeyboardControls[KeyboardHandler][2]] || GetJoyAccelerate(joyDir,joyButton)) Move=CAR_ACCELERATE;
			}
			if(key[KeyboardControls[KeyboardHandler][1]] || (joyDir & JDRIGHT)) Direction=CAR_RIGHT;
			if(key[KeyboardControls[KeyboardHandler][0]] || (joyDir & JDLEFT)) Direction=CAR_LEFT;
		}

		if(currentLevel->gameMode==GT_SURVIVAL && vel>-6)
			Move=CAR_ACCELERATE;	//survivor always moves.

		//handle movement
		if(Move==CAR_ACCELERATE)
			Accelerate();
		else if(Move==CAR_DECELERATE)
			Decelerate();

		//handle direction
		if(Direction==CAR_LEFT)
			TurnLeft();
		else if(Direction==CAR_RIGHT)
			TurnRight();

		//handbrake increases the braking rate and stops any acceleration
		if(Handbrake)
		{
			decel=0.15;
			acc=0;
		}
	}
	//adjust speed
	//due to rounding problems of tiny fractions stop the car if we know it has stopped
	if(acc==0 && vel>=0)
	{
		decel=0;
		vel=0;
	}

	//adjust speed based on acceleration/deceleration
	vel=vel-(acc*0.1)+decel;

	//maximum or minimum velocity reached
	if(!this->BlockTopSpeedIncrease)
	{
		//if no topspeed increase then can be capped speed
		if(vel<(Car::MAXVEL*SpeedFactor))
			vel=(Car::MAXVEL*SpeedFactor);
		//if(vel>(Car::MAXVEL*SpeedFactor))
		//	vel=Car::MAXVEL*SpeedFactor;
	}
	else
	{
		if(vel<Car::MAXVELTURBO) vel=Car::MAXVELTURBO;
		//if(vel>Car::MAXVELTURBO) vel=Car::MAXVELTURBO;
	}

	//set cars statistics
	Mph=(int)(vel*Car::MPH_INCREASE*SpeedFactor);
	if(MilesDriven<999999.0) MilesDriven+=((float)Mph/10.0)/GameConfiguration->CapsSystem.fps;

	//temperature is 100 units, increase by 3.33 per second when redlining
	//if mph in yellow, temperature stays the same
	//if in green, temperature decreases
	if((Mph)>Car::MPH_REDLINE)
		Temperature+=TemperatureInc;
	else if((Mph)<Car::MPH_YELLOWLINE)
		Temperature-=TemperatureDec;

	if(Temperature>=100) Temperature=100;
	else if(Temperature<0) Temperature=0;
	//fuel - idling doesn't use up much fuel (i.e. pretend 0.5 mph
	Fuel-=(Mph+0.5)*FuelUnit;
	if(Fuel<0) Fuel=0;

	//get movement for car, swapped round for our movement
	if(!Handbrake)
	{
		xdistancemoved=sin((float)(angle*PI_Conv))*vel;
		ydistancemoved=cos((float)(angle*PI_Conv))*vel;
	}
	else
	{
		xdistancemoved=sin((float)(lastangle*PI_Conv))*vel;
		ydistancemoved=cos((float)(lastangle*PI_Conv))*vel;
	}
	//set map offset as being that of the player car
	this->mapx-=xdistancemoved;
	this->mapy+=ydistancemoved;

	this->SetCurrentState();

	if(vel<0)
	{
		playingCarNoise=PlaySFX(snd_gamecarmoving,FSOUND_LOOP_BIDI,false,true,playingCarNoise);
		if(originalCarNoiseFrequency==0)
		{
			originalCarNoiseFrequency=(int)(FSOUND_GetFrequency(playingCarNoise)/1.5);
		}
	}
	else
	{
		StopSFX(playingCarNoise);
		playingCarNoise=-1;
	}
	//if(soundcounter>10)
	{
		int adjustment=(int)((vel-Car::MAXVEL)*700);
		AdjustFrequencySFX(playingCarNoise,originalCarNoiseFrequency-adjustment);
		AdjustVolumeSFX(playingCarNoise,(int)(-vel*10+55));
		soundcounter=0;
	}

    //car->SetAnimationFrame(7-(this->angle/45)); - now using pre-rendered
	car->NextMove();	//update any animations (only animation is death) and timers
	CheckCollision();	//still bounce if dying

	if(!Handbrake || (vel>=0))
	{
		StopSFX(playingHandbrake);
		playingHandbrake=-1;
	}
	this->crashParticles->NextFrame(true,0,0);
	return false;
}

bool Car::CheckCollision()
{
	//return value does nothing for car

	//using array is faster
	HitCar=false;
	int HitAngle=0;
	BLKSTR* CurrentBlock=MapGetBlockInPixels ((int)this->mapx,(int)this->mapy);

	//reset everything
	BlockTopSpeedIncrease=false;
	SpeedFactor=1.0;

	//check collision against enemy cars
	//	this would look a lot nicer if we had a cars class or perhaps a cars static and used virtuals
	for(int i=0;i<MaxEnemies;i++)
	{
		//if(check_bb_collision_general(mapx,mapy,CarWidth,CarHeight,Enemies[i]->mapx,Enemies[i]->mapy,Enemies[i]->CarWidth,Enemies[i]->CarHeight))
		//use screen to offset any dodgy stuff
		//if(check_bb_collision_general(screenx+7,screeny+7,CarWidth-14,CarHeight-14,Enemies[i]->screenx+7,Enemies[i]->screeny+7,Enemies[i]->CarWidth-14,Enemies[i]->CarHeight-14))
		if(check_bb_collision_general(mapx-10,mapy-10,CarWidth-12,CarHeight-12,Enemies[i]->mapx-10,Enemies[i]->mapy-10,Enemies[i]->CarWidth-12,Enemies[i]->CarHeight-12))
		{
			//hit an enemy
			HitCar=true;
			HitAngle=rand()%40*9;
			Enemies[i]->HitCar=true;
			this->crashParticles->Add("blowout",500,screenx+8,screeny+8);
			break;
		}
	}

	//bounce
	//if((CurrentBlock->tl || HitCar) && !CurrentBlock->bl)
	if(CurrentBlock->tl || HitCar || CurrentBlock->bl)
	{
		//only hit if not the same block
		if(LastHitX==-1 || (LastHitX!=(int)(this->mapx/mapblockwidth)) || (LastHitY!=(int)(this->mapy/mapblockheight)))
		{
			playingCarCrash=PlaySFX(snd_gamecarcrash,FSOUND_LOOP_OFF,false,true,playingCarCrash);
			LastHitX=(int)(mapx/mapblockwidth);
			LastHitY=(int)(mapy/mapblockheight);
			if(!car->ReadOnly_TimersCounter[2])
			{
				if(!HitCar)
				{
					this->crashParticles->Add("blowout",500,screenx+8,screeny+8,0);
					if(!Handbrake)
					{
						if(angle>180) angle=(angle-180);
						else angle+=180;
						if(angle>359)
							angle=0;
					}
					else
					{
						if(lastangle>180) lastangle=(lastangle-180);
						else lastangle+=180;
						if(lastangle>359)
							lastangle=0;
					}
					vel/=2; //testing this
				}
				else
				{
					angle=HitAngle;
					this->Temperature=100;
					if(currentLevel->gameMode!=GT_RACE)
						car->SetCustomCountDown(2,1000);
				}

				if(currentLevel->gameMode!=GT_RACE)
					DamageLevel-=8;	//starts off at 32 (height of the car)
			}
		}
		if((DamageLevel<1 && State!=CAR_DYING) || CurrentBlock->bl)
		{
			DamageLevel=0;
			State=CAR_DYING;
			this->crashParticles->Add("blowout",500,screenx,screeny,0);
			this->crashParticles->Add("blowout",500,screenx+14,screeny,100);
			this->crashParticles->Add("blowout",500,screenx+12,screeny+12,800);
			this->crashParticles->Add("blowout",500,screenx,screeny+8,400);
			this->crashParticles->Add("blowout",500,screenx,screeny,50);
			this->crashParticles->Add("blowout",500,screenx-8,screeny,350);
			this->crashParticles->Add("blowout",500,screenx-8,screeny-8,200);
			this->crashParticles->Add("blowout",500,screenx,screeny-8,700);
			car->SetCustomCountDown(1,2000);
		}
		HitCar=false;
		return false;
	}
	else
	{
		LastHitX=LastHitY=-1;
	}

	//petrol
	if(CurrentBlock->unused1 && Fuel<Car::FUEL_MAX)
	{
		playingFuelIncrease=PlaySFX(snd_gamefuelincrease,FSOUND_LOOP_NORMAL,false,true,playingFuelIncrease);
		this->Fuel+=Car::FUEL_INC*80;

		return false;
	}
	else
	{
		StopSFX(playingFuelIncrease);
		playingFuelIncrease=-1;
	}

	//topspeed increase
	if(CurrentBlock->unused2)
	{
		BlockTopSpeedIncrease=true;
		return false;
	}

	//bad response, need to check userdata5
	if(CurrentBlock->user5)
	{
		if(CurrentBlock->user5<=100 && CurrentBlock->user5>0)
		{
			SpeedFactor=((float)CurrentBlock->user5/100);
			return false;
		}
	}

	//check if blank space. as nothing else is there. if a cup is placed there at the start
	//the block is updated. put any that might affect sound effects above
	if(CurrentBlock->br || CurrentBlock->tr) return false;

	//dead
/*	if(CurrentBlock->bl && State!=CAR_DYING)
	{
		//dead
		State=CAR_DYING;
			this->crashParticles->Add("blowout",500,screenx,screeny,0);
			this->crashParticles->Add("blowout",500,screenx+14,screeny,100);
			this->crashParticles->Add("blowout",500,screenx+12,screeny+12,800);
			this->crashParticles->Add("blowout",500,screenx,screeny+8,400);
			this->crashParticles->Add("blowout",500,screenx,screeny,50);
			this->crashParticles->Add("blowout",500,screenx-8,screeny,350);
			this->crashParticles->Add("blowout",500,screenx-8,screeny-8,200);
			this->crashParticles->Add("blowout",500,screenx,screeny-8,700);
		car->SetCustomCountDown(1,2000);
		return false;
	}
*/
	//cup
	if(CurrentBlock->unused3)
	{
		playingFindCup=PlaySFX(snd_findcup,FSOUND_LOOP_OFF,true,true,playingFindCup);
		MapSetBlockInPixels((int)mapx,(int)mapy,CupBlockFreeNumber);
		NumCups++;
		for(int n=0;n<MaxNumCups;n++)
		{
			if(CupPositions[n][0]==(int)(mapx/mapblockwidth) && CupPositions[n][1]==(int)(mapy/mapblockheight))
			{
				CupPositions[n][2]=1;
				break;
			}
		}
		return false;
	}

	return false;
}

void Car::Accelerate()
{
	//can accelerate if temperature<max red
	//if temperature reaches 100, must wait until 75 (yellow)
	//car can always go upto 100mph
	if(Fuel &&
		(Mph<100
		 || (Temperature<100 && !TemperatureLatch)
		 || (Temperature<75 && TemperatureLatch)
		)
	)
	{
		//if(Temperature<75) TemperatureLatch=false;
		decel=0;
		acc=1;
	}
	else
	{
		//TemperatureLatch=true;
	}
}

void Car::Decelerate()
{
		decel=0.07;
}

void Car::TurnLeft()
{
	static int counter=1;

	counter++;
	if(counter>2)
	{
		angle-=9;
		if(angle<0)
			angle=360+angle;
		counter=0;
	}
	//if not accelerating and turning then apply a bit of deceleration
	if(acc==0) decel*=2;
}

void Car::TurnRight()
{
	static int counter=1;

	counter++;
	if(counter>2)
	{
		angle+=9;
		if(angle>359) angle=360-angle;
		counter=0;
	}
	//if not accelerating and turning then apply a bit of deceleration
	if(acc==0) decel*=2;
}


/*********************************************
 enemy car
**********************************************/
void EnemyCar::SetupCar(int offset, int magicblock, string cartype)
{
	playingCarCrash=-1;
	playingCarNoise=-1;
	MagicBlock=magicblock;
	originalCarNoiseFrequency=0;

	angle=0;acc=0;vel=0.0;
	decel=0.5;
	car=NULL;
	Mph=0;
	Fuel=Car::FUEL_MAX;
	Temperature=0.0;
	DamageLevel=32;
	TemperatureLatch=false;
	BlockTopSpeedIncrease=false;
	SpeedFactor=1.0;
	HitCar=false;
	Route=NULL;
	RouteGenerated=false;

	if(car) delete car;		//delete if already exists
	car=new Animation(GameLibrary,cartype);	//get graphics for the car - or change to random ones if needed
	if(Configuration::GlobalErrorString!="")
		GameFramework->AbortSystem("animation could not be found for setup enemy car");

	//get size of car and the positions to show it
	car->GetStandardDimensions(&CarWidth, &CarHeight);

	//set position
	BLKSTR* loc1;
	BLKSTR* loc2;
	int loop=0;
	while(true)
	{
		loop++;
		this->mapx=rand()%mapwidth*mapblockwidth+(mapblockwidth/2);
		this->mapy=rand()%mapheight*mapblockheight+(mapblockheight/2);
		loc1=MapGetBlockInPixels((int)mapx,(int)mapy);
		MapChangeLayer(1);
		loc2=MapGetBlockInPixels((int)mapx,(int)mapy);
		MapChangeLayer(0);
		if(loc1->tr && loc2->user7!=1 && fabs(mapx-(mapwidth*mapblockwidth/2))>offset*mapblockwidth && fabs(mapy-(mapheight*mapblockheight/2))>offset*mapblockwidth)
			break;

		//to stop an endless loop
		if(loop>mapwidth*mapheight)
			break;
	}

	//what the car is doing
	Move=CAR_FREEWHEELING;
	Direction=CAR_STRAIGHT;
	State=CAR_NORMAL;
	screenx=(int)(mapx-mapXoff+ScreenXOffset);//-(this->car->ReadOnly_CurrentItem->w/2);
	screeny=(int)(mapy-mapYoff+ScreenYOffset);//-(this->car->ReadOnly_CurrentItem->h/2);

	//map
	if(Route) delete Route;
	Route=new AstarClass(AstarMap,mapwidth,mapheight,mapblockwidth);

	MAXVELENEMY=Car::MAXVEL*currentLevel->enemyvel;
	/*if(currentLevel->gameMode==GT_RACE)
		MAXVELENEMY=Car::MAXVEL*0.7;
		//MAXVELENEMY=Car::MAXVEL*0.97;
	else if(currentLevel->gameMode==GT_SURVIVAL)
		MAXVELENEMY=Car::MAXVEL*0.6;
	else
		MAXVELENEMY=Car::MAXVEL*0.7;
*/
	return;
}

bool EnemyCar::NextMove(Car* player)
{
	static int soundcounter=0;
	soundcounter++;
	//update the car. called every frame
	//default to no acceleration pressed
	static int oldcarx=-1;
	static int oldcary=-1;
	Direction=CAR_STRAIGHT;
	acc=0;
	decel=0.0;
	Move=CAR_FREEWHEELING;

	screenx=(int)(mapx-mapXoff+ScreenXOffset);//-(this->car->ReadOnly_CurrentItem->w/2);
	screeny=(int)(mapy-mapYoff+ScreenYOffset);//-(this->car->ReadOnly_CurrentItem->h/2);
	//usa map is about 1000 by 500 so assume max pixels offset is 10
	shadowOffsetX=(int)((LightSourceX-mapx)*ShadowFactor);
	shadowOffsetY=(int)((LightSourceY-mapy)*ShadowFactor);
	//astar
	float distance=hypot(mapx-player->mapx,mapy-player->mapy);
	//int distance=fabs((mapx-player->mapx)+(mapy-player->mapy));
	//int distance=(fabs(mapx-player->mapx)+fabs(mapy-player->mapy));

	//if not a RACE then we are using countdown timer for recalcuating route to player
	// update the timer if we have a route and the timer is active and we aren't in a collision
	// set a new route if route is active and the countdown has finished and we aren't in a collision
	if(currentLevel->gameMode!=GT_RACE)
	{
		//if we are in a route and countdown is finished and not in collision set a new route
		//otherwise update timer
		if(RouteGenerated && this->car->ReadOnly_Timers[1] && !car->ReadOnly_TimersCounter[2])
			RouteGenerated=false;
		else
			this->car->ManualTimerUpdate();

		//no route and we are within distance then generate new path
		//and set countdown based on distance to player
		if(!RouteGenerated && distance<AStarDistance_StartChase)
		{
			if(currentLevel->gameMode==GT_SURVIVAL && currentLevel->enemies>1)
			{
				this->car->SetCustomCountDown(1,2000+(rand()%1000));
			}
			else
			{
				//have a quick update if the player is fast
				if(player->vel<(Car::MAXVEL*0.7))
					this->car->SetCustomCountDown(1,400);
				else if(player->vel<(Car::MAXVEL*0.4))
					this->car->SetCustomCountDown(1,500);
				else  if(player->vel<(Car::MAXVEL*0.2))
					this->car->SetCustomCountDown(1,1000);
				else
					this->car->SetCustomCountDown(1,1500);
				//if(distance<AStarDistance2)
				//	this->car->SetCustomCountDown(1,200);
				//else if(distance<AStarDistance3)
				//	this->car->SetCustomCountDown(1,500);
				//else
				//	this->car->SetCustomCountDown(1,1000);
			}
			RouteGenerated=Route->NewPath((int)(mapx-(int)mapx%mapblockwidth),(int)(mapy-(int)mapy%mapblockwidth),(int)(player->mapx-(int)player->mapx%mapblockwidth),(int)(player->mapy-(int)player->mapy%mapblockwidth),true);
		}
	}
	else
	{
		//in RACE game
		//if no route then generate a route as based on fixed waypoints
		if(!RouteGenerated)
			RouteGenerated=Route->NewPath((int)mapx,(int)mapy,WayPoints[CurrentWayPoint].x*mapblockwidth,WayPoints[CurrentWayPoint].y*mapblockheight,true);
	}

	//if route is generated
	// and RACE or (not RACE and countdown timer is not finished)
	//		if still within range then move car
	//		if not within range, then decellerate
	if(RouteGenerated && (currentLevel->gameMode==GT_RACE || (currentLevel->gameMode!=GT_RACE && !car->ReadOnly_TimersCounter[2] )))
	{
		//direction
		//still within range
		int destX,destY;
		if(currentLevel->gameMode==GT_RACE || distance<AStarDistance_StartChase)
		{
			//get the tile it's at
			destX= Route->NodeGetX()/mapblockwidth;	//current tile
			destY= Route->NodeGetY()/mapblockwidth;	//current tile
			//temp1=destX;	//where it is now
			//temp2=destY;
			int carX = (int)(mapx/mapblockwidth);			//where car is
			int carY = (int)(mapy/mapblockwidth);
			//temp1=destX;
			//temp2=destY;
			//temp3=carX;
			//temp4=carY;
			//move if on the one we require or are not on the same as the old one (e.g. moving faster than the refresh)
			if((destX==carX && destY==carY) || (carX!=oldcarx || carY!=oldcary))
			{
				if(!Route->ReachedGoal())
				{
					Route->PathNextNode();
					destX= Route->NodeGetX()/mapblockwidth;
					destY= Route->NodeGetY()/mapblockwidth;
				}
			}

			oldcarx=carX;
			oldcary=carY;

			int targetangle=-1;
			if(destX==carX)		//to the top or bottom
			{
				if(destY<carY) //top
					targetangle=0;
				else
					targetangle=180; //bottom
			}
			else if(destY==carY) //to the left or right
			{
				if(destX<carX) //left
					targetangle=270;
				else
					targetangle=90;
			}
			else if(destY<carY && destX<carX)	//top left
				targetangle=315;
			else if(destY<carY && destX>carX)	//top right
				targetangle=45;
			else if(destY>carY && destX<carX)	//bottom left
				targetangle=225;
			else if(destY>carY && destX>carX)	//bottom right
				targetangle=135;

			if(angle!=targetangle && targetangle!=-1)
			{
				int diff=abs(angle-targetangle);
				Direction=CAR_LEFT;
				if(targetangle>angle)
				{
					if(diff<180)
						Direction=CAR_RIGHT;
				}
				else
				{
					if(diff>180)
						Direction=CAR_RIGHT;
				}

				//speed
				if((diff<27))
					Move=CAR_ACCELERATE;
				else if(diff<40)
					Move=CAR_FREEWHEELING;
				else
					Move=CAR_DECELERATE;
			}

			if(Route->ReachedGoal())
			{
				//found the car. may want to do something else
				RouteGenerated=false;
				if(currentLevel->gameMode==GT_RACE && CurrentWayPoint<50)
					CurrentWayPoint++;

			}
			if(AutoDirection!=CAR_STRAIGHT)
			{
				if(AutoDirection==CAR_LEFT) TurnLeft();
				if(AutoDirection==CAR_RIGHT) TurnRight();
			}
			else
			{
				if(Direction==CAR_LEFT) TurnLeft();
				if(Direction==CAR_RIGHT) TurnRight();
			}

			//distance factor and ontarget
			//temp3=(int)vel;
			if(angle==targetangle) Move=CAR_ACCELERATE;
			if(currentLevel->gameMode!=GT_RACE && player->car->ReadOnly_TimersCounter[2])// || (vel<-2 && angle!=targetangle))
				Move=CAR_DECELERATE;

			if(AutoMove!=CAR_FREEWHEELING && vel>MAXVELENEMY)
			{
				if(AutoMove==CAR_ACCELERATE)
					Accelerate();
				else
					decel=0.2;
			}
			else if(Move==CAR_ACCELERATE && vel>MAXVELENEMY)
				Accelerate();
			else if(Move==CAR_DECELERATE)
			{
				decel=0.2;
				//decel=0.1;//Decelerate();
			}

		}
		else
			//out of reach and not in race
			decel=0.05;

	}
	else
	{
		//route is not generated the here
		//if route is generated and not in a race but in a collision then here
		//decelerate
		//unless on a magic square then accelerate until we are out of danger
		// this is to stop getting stuck inside a block
		int x,y;
		x= (int)(mapx/mapblockwidth);	//current tile
		y= (int)(mapy/mapblockwidth);	//current tile
		if(x>=0 && y>=0 && x<mapwidth && y<mapheight)
		{
			MapChangeLayer(1);
			if(MapGetBlockNumber(x,y)!=MagicBlock)
				decel=0.05;
			else
				acc=0.5;
			MapChangeLayer(0);
		}
	}

	if(vel<0)
	{
		playingCarNoise=PlaySFX(snd_gamecarmoving,FSOUND_LOOP_BIDI,false,true,playingCarNoise);
		if(originalCarNoiseFrequency==0)
		{
			originalCarNoiseFrequency=(int)(FSOUND_GetFrequency(playingCarNoise)/1.5);
		}
	}
	else
	{
		StopSFX(playingCarNoise);
		playingCarNoise=-1;
	}
	//if(soundcounter>10)
	{
		int adjustment=(int)((vel-Car::MAXVEL)*700);
		AdjustFrequencySFX(playingCarNoise,originalCarNoiseFrequency-adjustment);
		AdjustVolumeSFX(playingCarNoise,(int)(-vel*10+55));
		soundcounter=0;
	}

	//check below and see if can comment all code for all cars
	bool oncollision=CheckCollision();

	//perform calculations for speed
	if(acc==0 && vel>=0)
	{
		decel=0;
		vel=0;
	}

	if(vel==0 && oncollision) acc=3.0;

	//adjust speed based on acceleration/deceleration
	vel=vel-(acc*0.1)+decel;
	if(vel<(Car::MAXVELENEMY*SpeedFactor))
		vel=(Car::MAXVELENEMY*SpeedFactor);

	//if(vel<(Car::MAXVEL))
	//	vel=(Car::MAXVEL);

	//get movement for car, swapped round for our movement
	float newangle;
	float newdirection_x;
	float newdirection_y;
	newangle=(float)(angle*PI_Conv);

	newdirection_x=sin(newangle);
	newdirection_y=cos(newangle);
	xdistancemoved=newdirection_x*vel;
	ydistancemoved=newdirection_y*vel;

	//set map offset as being that of the player car
	this->mapx-=xdistancemoved;
	this->mapy+=ydistancemoved;

	this->crashParticles->NextFrame(false,screenx,screeny);

	return false;
}

bool EnemyCar::CheckCollision()
{
	//return shows if userdata7 was set
	//using array is faster
	BLKSTR* CurrentBlock=MapGetBlockInPixels ((int)this->mapx,(int)this->mapy);
	SpeedFactor=1.0;

	if(!CurrentBlock)
		return false;

	//hit car or bounce
	//if((HitCar || CurrentBlock->tl) && !car->ReadOnly_TimersCounter[2])
	//if((HitCar || CurrentBlock->tl) && !car->ReadOnly_TimersCounter[2])
	if((HitCar || CurrentBlock->tl))
	{
		if(LastHitX==-1 || (LastHitX!=(int)(this->mapx/mapblockwidth)) || (LastHitY!=(int)(this->mapy/mapblockheight)))
		{
			this->crashParticles->Add("blowout",500,screenx+8,screeny+8,0);
			LastHitX=(int)(mapx/mapblockwidth);
			LastHitY=(int)(mapy/mapblockheight);
			//only stop enemies if hitcar, i.e. if we bounce, don't stop other enemies
			if(HitCar)
			{
				if(currentLevel->gameMode!=GT_RACE)
				{
					for(int i=0;i<MaxEnemies;i++)
						Enemies[i]->car->SetCustomCountDown(2,rand()%1000+3000);
				}
				else
				{
					this->car->SetCustomCountDown(2,1000);
				}
				vel/=2; //testing this
			}
			else
				//only play if not hit player as player does own sound
				playingCarCrash=PlaySFX(snd_gamecarcrash,FSOUND_LOOP_OFF,false,true,playingCarCrash);
			HitCar=false;
			//bounce back
			if(angle>180) angle=(angle-180);
			else angle+=180;
			if(angle>359)
				angle=0;
		}
	}
	else
	{
		LastHitX=LastHitY=-1;
	}

	//check collision against enemy cars
	//	this would look a lot nicer if we had a cars class or perhaps a cars static and used virtuals
	bool collisio=false;
	for(int i=0;i<MaxEnemies;i++)
	{
		//use screen to offset any dodgy stuff
		if(num!=Enemies[i]->num && check_bb_collision_general(mapx,mapy,CarWidth,CarHeight,Enemies[i]->mapx,Enemies[i]->mapy,Enemies[i]->CarWidth,Enemies[i]->CarHeight))
		{
			collisio=true;
			//hit an enemy
			//if not already auto move then move
			if(AutoMove==CAR_FREEWHEELING && AutoDirection==CAR_STRAIGHT)
			{
				//don't want it to decelerate now, only left or right
				if(Enemies[i]->AutoMove==CAR_DECELERATE)
				{
					AutoDirection=CAR_LEFT;
					AutoMove=CAR_ACCELERATE;
				}
				else if(Enemies[i]->AutoDirection==CAR_LEFT)
				{
					AutoDirection=CAR_RIGHT;
					AutoMove=CAR_ACCELERATE;
				}
				else
				{
					AutoDirection=CAR_LEFT;
					AutoMove=CAR_ACCELERATE;
				}
			}
			break;
		}
	}
	if(!collisio)
	{
		AutoMove=CAR_FREEWHEELING;
		AutoDirection=CAR_STRAIGHT;
	}

	if(CurrentBlock->br || CurrentBlock->tr) return false;

	//bad response, need to check userdata5
	if(CurrentBlock->user5)
	{
		if(CurrentBlock->user5<=100 && CurrentBlock->user5>0)
		{
			SpeedFactor=((float)CurrentBlock->user5/100);
			return false;
		}
	}

	if(CurrentBlock->user7 || CurrentBlock->tl) return true;

	return false;
}

float EnemyCar::CrossProduct(float x1, float y1, float x2, float y2, float x3, float y3)
{ //positive means move clockwise, negative means move anti-clockwise

	float v1x, v1y, v2x, v2y;
	v1x=x2-x1;
	v1y=y2-y1;
	v2x=x3-x1;
	v2y=y3-y1;
    return( (v1x * v2y) - (v2x * v1y) );
}

static bool GetJoyAccelerate(int dir, int button)
{
	switch(JoystickHandler)
	{
	case 0: //up
	case 3: //up
		if(dir & JDUP)
			return true;
		break;
	case 1: //button 6
		if(button & JB6)
			return true;
		break;
	case 2: //button 1
		if(button & JB1)
			return true;
		break;
	}
	return false;
}

static bool GetJoyBrake(int dir, int button)
{
	switch(JoystickHandler)
	{
	case 0: //down
		if(dir & JDDOWN)
			return true;
		break;
	case 1: //button 5
		if(button & JB5)
			return true;
		break;
	case 2: //button 2
		if(button & JB2)
			return true;
		break;
	case 3: //button 1
		if(button & JB1)
			return true;
		break;
	}
	return false;
}

static bool GetJoyHandbrake(int button)
{
	switch(JoystickHandler)
	{
	case 0: //any button
		if(button)
			return true;
		break;
	case 1: //button 1
		if(button & JB1)
			return true;
		break;
	case 2: //button 3
		if(button & JB3)
			return true;
		break;
	case 3: //button 6
		if(button & JB6)
			return true;
		break;
	}
	return false;
}


