#include "game_transam.h"
#include "game_particles.h"

//note: bitmaps are not garbage collected (as they might be globals used elsewhere)
//but animations are because multiple pointers to the same animation would result
//in the frames being adjusted from multiple sources so passing in new objects makes sense

//not very optimised at the minute as it always deletes animation objects. if
//seems fit, then don't delete and keep it open until the particles object is deleted
//and reuse animation if it is the same, or delete just before adding it
Particle::Particle()
{
	bmp_anim=NULL;
	bmp_single=NULL;
	lifespan_frames=delay_frames=0;
	x=y=0.0;
}

Particle::~Particle()
{
	if(bmp_anim)
		delete bmp_anim;
}

Particles::Particles(int fps, int poolsize=10)
{
	this->fps=fps;
	//pool of 10
	for(int i=0;i<poolsize;i++)
		particles.push_back(new Particle());
}
Particles::~Particles()
{
	Destroy();
}

void Particles::NextFrame(bool adjust,float x, float y)
{
	std::vector<Particle*>::iterator pIterator;
	for(pIterator=particles.begin();pIterator<particles.end();pIterator++)
	{
		if((*pIterator)->bmp_single!=NULL || (*pIterator)->bmp_anim!=NULL)
		{
			(*pIterator)->delay_frames--;
			if((*pIterator)->delay_frames<=0)
			{
				(*pIterator)->delay_frames=0;
				(*pIterator)->lifespan_frames--;
				if((*pIterator)->lifespan_frames<1)
				{
					//no erase as pooling last deleted item
					(*pIterator)->bmp_single=NULL;
					if((*pIterator)->bmp_anim)
						delete (*pIterator)->bmp_anim;
					(*pIterator)->bmp_anim=NULL;
				}
				else
				{
					if(adjust)
					{
						(*pIterator)->x+=x;
						(*pIterator)->y+=y;
					}
					else
					{
						(*pIterator)->x=x;
						(*pIterator)->y=y;
					}
				}

				if((*pIterator)->bmp_anim)
					(*pIterator)->bmp_anim->NextMove();
			}
		}
	}
}

void Particles::Draw(BITMAP* buffer)
{
	std::vector<Particle*>::iterator pIterator;
	for(pIterator=particles.begin();pIterator<particles.end();pIterator++)
	{
		if((*pIterator)->delay_frames<=0)
		{
			if((*pIterator)->bmp_anim)
				draw_sprite(buffer,(*pIterator)->bmp_anim->ReadOnly_CurrentItem,(int)((*pIterator)->x),(int)((*pIterator)->y));
			else if((*pIterator)->bmp_single)
				draw_sprite(buffer,(*pIterator)->bmp_single,(int)((*pIterator)->x),(int)((*pIterator)->y));
		}
	}
}

void Particles::Add(std::string anim,int lifespan_ms,float x, float y, int delay_ms)
{
	Initialise(NULL,anim,lifespan_ms,x,y,delay_ms);
}

void Particles::Add(BITMAP* bmp,int lifespan_ms,float x, float y, int delay_ms)
{
	Initialise(bmp,NULL,lifespan_ms,x,y,delay_ms);
}

void Particles::Initialise(BITMAP* bmp, std::string anim,int lifespan_ms, float x, float y,int delay_ms)
{
	Particle* p=NULL;
	//use spare if available
	std::vector<Particle*>::iterator pIterator;
	for(pIterator=particles.begin();pIterator<particles.end();pIterator++)
	{
		if((*pIterator)->bmp_single==NULL && (*pIterator)->bmp_anim==NULL)
		{
			p=*pIterator;
			break;
		}
	}

	//new item as no spare slots
	if(!p)
	{
		p=new Particle();
		particles.push_back(p);
	}

	p->bmp_single=bmp;
	if(anim!="")
		p->bmp_anim=new Animation(GameLibrary,anim);

	p->lifespan_frames=(int)((float)fps/1000.0*lifespan_ms);
	p->x=x;
	p->y=y;
	p->delay_frames=(int)((float)fps/1000.0*delay_ms);
}

void Particles::Destroy()
{
	std::vector<Particle*>::iterator pIterator;
	for(pIterator=particles.begin();pIterator<particles.end();pIterator++)
		delete (*pIterator);

	particles.clear();
}

