#ifndef tranzam_particles
#define tranzam_particles

class Particle
{
public:
	friend class Particles;
	Particle();
	~Particle();
private:
	AXL_Projects::Animation* bmp_anim;
	BITMAP* bmp_single;
	int lifespan_frames;
	int delay_frames;
	float x;
	float y;
};

class Particles
{
public:
	Particles::Particles(int fps, int poolsize);
	~Particles();
	void Particles::NextFrame(bool adjust,float x, float y);
	void Particles::Draw(BITMAP* buffer);
	void Add(std::string anim,int lifespan_ms,float x, float y, int delay_ms=0);
	void Add(BITMAP* bmp,int lifespan_ms,float x, float y, int delay_ms=0);
	void Destroy();
private:
	int fps;
	void Particles::Initialise(BITMAP* bmp, std::string anim,int lifespan_ms, float x, float y,int delay_ms);
	std::vector<Particle*> particles;
};

#endif

