//Tranz-Am
#include "game_transam.h"

int main(void)
{
	//initialise graphics and animations, set up buffers and ready for action
	//we will allow any changes to the config file, cos we're hard
	//also there is no bitmap loader as all we want is the bitmaps loaded from a bitmap file
	//in this case, it's a sheet graphic - only one graphic file for the whole project, plus the panel
	//GameFramework=new Framework("config.xml","animations.xml");

	//manual update so we can call remote site to allow firewall to be configured 
	//before possibly triple buffering is called
	//url does not exist, just going to the correct remote site
	GameFramework=new Framework("config.xml","animations.xml",false);
	GameConfiguration=GameFramework->GetConfiguration();
	std::string error="";
	std::string contents=GetURLData(GameConfiguration->GetCustom("rootsite","http://retrospec.sgn.net")+"/thisdoesnotexist.html",GameConfiguration->GetCustom("proxy",""),error);
	GameFramework->InitialiseFramework();

	if(Configuration::GlobalErrorString!="")
	{
		//some kind of error
		delete GameFramework;
		allegro_message(Configuration::GlobalErrorString.c_str());
	}
	else
	{
		//initialise some stuff first
		if(!SetupGame())
		{
			delete GameFramework;
			allegro_message(Configuration::GlobalErrorString.c_str());
		}
		else
		{
			//this function invokes the FPS based timer loop.
			//we do not require ESCape to be defaulted as an escape from the whole system
			//as we are coding that ourselves
			//we only want one logic/drawing function hook and we've assigned it to the 'GAME' enumeration
			//doesn't matter what we do as the names ar arbitrary
			//The two functions mentioned are in game_game.cpp
			if(adime_init()!=0)
			{
				delete GameFramework;
				allegro_message("Failed to initialise Adime Dialog system");
			}
			else
			{
				gui_set_screen(MemoryBuffer);
				adime_font=OriginalFont;
				adime_title_font=SmallFont;
				adime_button_font=SmallFont;
				RGB bg={225,227,84,0};
				RGB bt={0, 0, 127,0};
				adime_window_button_h=30;
				adime_background_rgb=bg;
				adime_button_rgb=bt;
				adime_bmp=MemoryBuffer;
				adime_callback=adime_transam_callback;

				//levels
				if(gameLevels)
					delete gameLevels;

				gameLevels=new Levels();

				if( !GameFramework->StartGameLoop(
						TransAmLogoLogic,TransAmLogoDrawing,
						false) )
				{
					delete GameFramework;
					allegro_message("Failed to run game loop. Check config.log");
				}
				else
				{
					//endgame will destroy all the stuff we created
					EndGame();
					adime_exit();

					//this will destroy all animations and configurations, and shut down allegro
					//any final errors
					if(Configuration::GlobalErrorString!="")
					{
						Configuration::LogEntry(Configuration::GlobalErrorString);
						delete GameFramework;
						allegro_message(Configuration::GlobalErrorString.c_str());
					}
					else
						delete GameFramework;
				}
			}
		}
	}
	//just in case
	FMUSIC_StopAllSongs();
	StopSFX(FSOUND_ALL);

	allegro_exit();
	return 0;
}
END_OF_MAIN();

/**********************************************************************************
 our helper functions, the same as the animation functions, but using the framework
*/

void DisplaySwitchIn()
{
	if(ActiveMusic)
		FMUSIC_SetPaused(ActiveMusic,FALSE);

	//graphics reset only required for fullscreen
	if(!is_windowed_mode() && GameConfiguration->CapsActualSystem.GraphicsMode>MODE_SYSTEMDOUBLE)
	{
		MapRestore();
		GlobalReset=true;
	}
}

void DisplaySwitchOut()
{
	StopSFX(FSOUND_ALL);
	if(ActiveMusic)
		FMUSIC_SetPaused(ActiveMusic,TRUE);
}


bool SetupGame()
{
	srand ( time(NULL) );
	set_display_switch_callback(SWITCH_OUT,DisplaySwitchOut);
	set_display_switch_callback(SWITCH_IN,DisplaySwitchIn);

	//after the framework is initialised we need to access the animations and configuration objects
	//the objects returned are the same as those if we created configuration and animation objects ourselves as in example 2
	GameLibrary=GameFramework->GetGraphicsLibrary();
	GameConfiguration=GameFramework->GetConfiguration();

	if(GameDAT)
		unload_datafile(GameDAT);
	GameDAT=load_datafile("resource.dat");


	Configuration::LogEntry("Transam Log",true,"transam.log");
	if(!GameDAT)
	{
		Configuration::LogEntry("failed to load resource.dat",false,"transam.log");
		Configuration::GlobalErrorString="Failed to load resource.dat";
		EndGame();
		return false;
	}

	//fonts
	//FontSmall			=GameLibrary->GetFirstGraphic("fontsmall");
	//FontMain			=GameLibrary->GetFirstGraphic("fontmain");
	//FontLarge			=GameLibrary->GetFirstGraphic("fontlarge");
	//FontMain2			=GameLibrary->GetFirstGraphic("fontmain2");
	//FontLarge2			=GameLibrary->GetFirstGraphic("fontlarge2");
	MenuTitle			=GameLibrary->GetFirstGraphic("menutitle");
	//animations
	//initialise single use graphics in game
	DisplayPanel		=new Animation(GameLibrary,"panel");
	DisplaySpeedo		=new Animation(GameLibrary,"speedo");
	DisplayFuel			=new Animation(GameLibrary,"fuel");
	DisplayTemperature	=new Animation(GameLibrary,"temperature");
	StartCountdown		=new Animation(GameLibrary,"go");
	RadarUpdate			=new Animation(GameLibrary,"radarscan");
	//lives
	PanelCar			=new Animation(GameLibrary,"player");
	//cup
	Cup					=new Animation(GameLibrary,"cup");
	//local radar
	LocalRadar			=GameLibrary->GetFirstGraphic("localradar");
	LocalCup			=GameLibrary->GetFirstGraphic("localcup");
	LocalCar			=GameLibrary->GetFirstGraphic("localcar");
	LocalEnemy			=GameLibrary->GetFirstGraphic("localenemy");
	LocalMap			=GameLibrary->GetFirstGraphic("map_usa");
	DisplayedCup		=GameLibrary->GetFirstGraphic("displaycup");
	RadarOff			=GameLibrary->GetFirstGraphic("radaroff");
	RadarWarmup			=GameLibrary->GetFirstGraphic("radarwarmup");
	MemoryBuffer		=create_bitmap(SCREEN_W,SCREEN_H);

	//tests for startup validity
	Animation* player=new Animation(GameLibrary,"player");
	Animation* enemy=new Animation(GameLibrary,"enemy1");
	Animation* BlowOut=new Animation(GameLibrary,"blowout");

	BITMAP* shadow=GameLibrary->GetFirstGraphic("carshadow");

	//this sometimes takes a while. can't draw to screen normally as might be video. so pixels always do
	OriginalFont=font;

	//!FontSmall || !FontMain || !FontLarge || !FontMain2 || !FontLarge2 || 
	if(!RadarOff || !RadarWarmup || !RadarUpdate || !BlowOut->ReadOnly_CurrentItem || !player->ReadOnly_CurrentItem || !enemy->ReadOnly_CurrentItem || !shadow || !StartCountdown || !MenuTitle || !DisplayPanel || !DisplaySpeedo || !DisplayFuel || !DisplayTemperature || !PanelCar ||
		!Cup || !LocalRadar || !LocalCup || !LocalMap || !LocalCar || !LocalEnemy || !DisplayedCup)
		Configuration::GlobalErrorString="Error setting bitmaps. Check Log File";

	if(Configuration::GlobalErrorString!="")
	{
		Configuration::LogEntry("animation initialisation failed in setup",false,"transam.log");
		EndGame();
		return false;
	}

	//change to magic pink
	clear_to_color(LocalRadar,bitmap_mask_color(LocalRadar));

	//for rotating stuff
	float angle;
	for(int i=0;i<360;i++)
	{
		angle=(float)(i/360.0)*256;
		FIX_ANGLE[i]=angle;
	}

	//cars
	BITMAP* temp;
	int item=0;
	//cars are always memory bitmaps
	for(int i=0;i<40;i++)
	{
		item=i/5;

		temp=create_bitmap(32,32);
		player->SetAnimationFrame(7-item);
		clear_to_color(temp,makecol(255,0,255));
        rotate_sprite(temp, player->ReadOnly_CurrentItem, 0, 0,itofix(FIX_ANGLE[i*9]));
		PlayerCars[i]=temp;

		temp=create_bitmap(32,32);
		enemy->SetAnimationFrame(item);
		clear_to_color(temp,makecol(255,0,255));
        rotate_sprite(temp, enemy->ReadOnly_CurrentItem, 0, 0,itofix(FIX_ANGLE[i*9]));
		EnemyCars[i]=temp;

		temp=create_bitmap(32,32);
		clear_to_color(temp,makecol(255,0,255));
        rotate_sprite(temp, shadow, 0, 0,itofix(FIX_ANGLE[i*9]));
		ShadowCars[i]=temp;
	}

	//debug to see the graphics
	//GameLibrary->draw();
	//GameLibrary->DebugData();

	//map positions
	//ScreenXOffset=DisplayPanel->ReadOnly_CurrentItem->w;
	ScreenYOffset=0;
	ShownMapWidth=GameConfiguration->CapsGraphics.ScrWidth-ScreenXOffset;
	ShownMapHeight=GameConfiguration->CapsGraphics.ScrHeight-ScreenYOffset;

	//sound stuff
	InitialiseSound();

	KeyboardHandler=GameConfiguration->GetCustom("keyboard",0);
	JoystickHandler=GameConfiguration->GetCustom("joystick",0);

	if(KeyboardHandler<0 || KeyboardHandler>3)
		KeyboardHandler=0;
	if(JoystickHandler<-1 || JoystickHandler>3)	//-1 for disable
		JoystickHandler=0;

	Configuration::LogEntry("initialised",false,"transam.log");

	//showFPS=GameConfiguration->GetCustom("showfps",false);

	//animations were only used for temporary use to generate rotations
	if(player)
		delete player;
	if(enemy)
		delete enemy;

	if(BlowOut)
		delete BlowOut;

	int gamecount=GameConfiguration->GetCustom("playedcount",0);
	int currentstate=1;	//0 element is always blank

	std::ostringstream ss;
	ss.str("");
	//first try cached version
	int foundcount=0;
	for(int i=1;i<51;i++)
	{
		ss.str("");
		ss << "state" << i;
		states[i][2]=GameConfiguration->GetCustom(ss.str(),"");
		if(states[i][2]!="") foundcount++;
	}
	if(foundcount==0)
		gamecount=0;

	if(gamecount>10 || gamecount==0)
	{
		GameConfiguration->SetCustom("playedcount",0);
		gamecount=0;
		std::string error="";
		ss.str("");
		std::string statedescriptions=GetURLData(GameConfiguration->GetCustom("statedetails","http://retrospec.sgn.net/users/nwalker/tranzam/")+"states.txt",GameConfiguration->GetCustom("proxy",""),error);
		int pos=statedescriptions.find_first_of("#");
		if(pos!=0)
		{
			for(int i=1;i<51;i++)
				states[i][2]="No information given for "+states[i][0]+". Why not submit some yourself at the website.";
		}
		else
		{
			for(unsigned int i=1;i<statedescriptions.length();i++)
			{
				//looping from first character to last
				if(statedescriptions[i]<32)
				{
					//white space - valid for ascii/utf8
					if(ss.str()!="")
					{
						//white space reached and we haven't found any already so this is a full line
						if(currentstate>50)
							break;
						else
							states[currentstate][2]=ss.str();

						ss.str("");
						currentstate++;
					}
				}
				else
					ss << statedescriptions[i];
			}
		}	
		for(int i=1;i<51;i++)
		{
			ss.str("");
			ss << "state" << i;
			GameConfiguration->SetCustom(ss.str(),states[i][2]);
		}

	}
	GameConfiguration->SetCustom("playedcount",++gamecount);
	musicInGame=GameConfiguration->GetCustom("musicingame",0)==1;

	return true;
}

void EndGame()
{
	//only delete the stuff we create
	//the framework deletes the drawing buffers, animation, framework, configuration

	GameConfiguration->SetCustom("keyboard",KeyboardHandler);
	GameConfiguration->SetCustom("joystick",JoystickHandler);
	GameConfiguration->SetCustom("musicingame",musicInGame);

	if(GameDAT)
		unload_datafile(GameDAT);

	GameDAT=NULL;

	//this is also called by the menu options that restart the system
	MapFreeMem();
	if(DisplayPanel) delete DisplayPanel;
	if(DisplaySpeedo) delete DisplaySpeedo;
	if(DisplayFuel) delete DisplayFuel;
	if(DisplayTemperature) delete DisplayTemperature;
	if(PanelCar) delete PanelCar;
	if(Cup) delete Cup;
	if(StartCountdown) delete StartCountdown;
	if(RadarUpdate) delete RadarUpdate;
	if(MemoryBuffer) destroy_bitmap(MemoryBuffer);

	MemoryBuffer=NULL;
	RadarUpdate=StartCountdown=DisplayPanel=DisplaySpeedo=DisplayFuel=DisplayTemperature=NULL;
	MenuTitle=NULL;
	//FontMain=FontLarge=FontSmall=FontMain2=FontLarge2
	MainFont=LargeFont=SmallFont=LargeFont2=MainFont2=NULL;
	Cup=NULL;
	PanelCar=NULL;

	RemoveSound();

	if(MainFont) destroy_font(MainFont);
	if(LargeFont) destroy_font(LargeFont);
	if(MainFont2) destroy_font(MainFont2);
	if(LargeFont2) destroy_font(LargeFont2);
	if(SmallFont) destroy_font(SmallFont);

	for(int i=0;i<40;i++)
	{
		if(PlayerCars[i]) 
		{
			destroy_bitmap(PlayerCars[i]);
			PlayerCars[i]=NULL;
		}
		if(EnemyCars[i])
		{
			destroy_bitmap(EnemyCars[i]);
			EnemyCars[i]=NULL;
		}
		if(ShadowCars[i])
		{
			destroy_bitmap(ShadowCars[i]);
			ShadowCars[i]=NULL;
		}
	}

	Configuration::LogEntry("terminated",false,"transam.log");
}

//used when putting in a ok button only
int tranzam_adime_callback_close(DIALOG *d, int n)
{
	return 1;
}
int tranzam_adime_callback_highscore(DIALOG *d, int n)
{
	return -n;	//negative is stripped and contents saves
}

void adime_transam_callback(DIALOG *d)
{
	//adime required for fixing:
	//	1. adime height for centreing was using width not height
	//  2. some functions were using screen and not adime_bmp
	//  3. set to set allegro gui screen to buffer prior to calling dialog if using a bitmap
	//  4. copy drawing buffer to buffer prior to calling dialog
	blit(MemoryBuffer,GameFramework->DrawingSurface,0,0,0,0,MemoryBuffer->w,MemoryBuffer->h);
	GameFramework->ManualDraw();
}


const std::string TimeFromSeconds(long time)
{
	int h=time/(60*60);
	int m=(time-(h*60*60))/60;
	int s=(time%60);
	std::ostringstream ss;
	ss << h << " hrs " << m << " mins " << s << " seconds";
	return ss.str();
}

BITMAP* GenerateChecker()
{
	BITMAP* checker;
	checker=create_bitmap(SCREEN_W,SCREEN_H);
	float h,s,v,h2,s2,v2;
	int r,g,b,r2,g2,b2,col1,col2;
	r=229,g=227,b=92,r2=229,g2=220,b2=87;
	rgb_to_hsv(229,227,92,&h,&s,&v);
	rgb_to_hsv(229,220,87,&h2,&s2,&v2);
	bool swap=false;
	for(int y=0;y<SCREEN_H;y+=(SCREEN_W/8)) //same size square
	{
		col1=makecol(r,g,b);
		col2=makecol(r2,g2,b2);
		for(int x=0;x<SCREEN_W;x+=(SCREEN_W/8))
		{
			if(!swap)
				rectfill(checker,x,y,x+SCREEN_W/8,y+SCREEN_W/8,col1);
			else
				rectfill(checker,x,y,x+SCREEN_W/8,y+SCREEN_W/8,col2);

			swap=!swap;
		}
		swap=!swap;
		s-=0.05;
		s2-=0.05;
		if(s<0) s=0;
		if(s2<0) s2=0;
		hsv_to_rgb(h,s,v,&r,&g,&b);
		hsv_to_rgb(h2,s2,v2,&r2,&g2,&b2);
	}
	return checker;
}
