// version 1.3
//Configurations, optimisations and AXL setup
//this file is included by each module. you DO NOT include this file assuming it is the one to use
//version history at bottom of file

#ifndef axl_setup
#define axl_setup

//ANIMATION OPTIMISATIONS AND VALUES
#define OPTIMISE_NOFADE 0			//if 1 we won't be using faders so this will speed up the loops, otherwise 0 to use
#define OPTIMISE_NOCOUNTERS 0		//if 1 we won't be using countdown timers so this will speed up loops, otherwise 0 to use 
#define MAX_COUNTDOWN_TIMERS 5		//maximum number of countdown timers being used. set to maximum you need to speed up loops
#define USE_FBLEND 0				//if 1 will include fblend in fade routines
#define USE_OPENLAYER 0				//if using openlayer set this. couldn't find a proper openlayer definition to use
#define _CRT_SECURE_NO_WARNINGS		//for msvc

//FRAMEWORK OPTIMISATIONS AND VALUES
#define OPTIMISE_NO_FPS 0			//if 1 we won't be using the FPS value anywhere so this saves on a timer, otherwise 0 to use
#define TIMER_DIGIPURGETIME 5000	//how often in milliseconds to free sounds



/*************************************************
	end of optimisations, remainder is required
*************************************************/

#if (USE_OPENLAYER==1)
	#define OL_ANIMATION_HPP
	#include <OpenLayer.hpp>
	typedef ol::Bitmap AXL_BITMAP;
	#define BITMAP ol::Bitmap
#else
    // typedef BITMAP AXL_BITMAP;
	#define AXL_BITMAP BITMAP
	#if (USE_FBLEND==1)
		#include "extern/fblend_minimum/fblend.h"
	#endif
#endif

#ifdef _MSC_VER
#pragma warning( disable : 4786 )
#pragma warning( disable : 4996 )
#endif

#include <string>
#include <map>
#include <vector>
#include <sstream>
#include <stdio.h>
#include <time.h>
#include <allegro.h>
#include <math.h>
#ifdef _WIN32
	#include <winalleg.h> //allow tinyXML to include windows.h
#endif
#include "tinyxml.h"

#endif

/* 
 version history

1.3 Tutorial and a few minor changes
1.2 Only framework.h/cpp files have changed
	a) fixed another bug linked to (e) in 1.1 below. This should now fix all bugs relating to crashing or keyboard errors during logic/drawing changeovers, including using the function override method.
	b) removed buffer lock when using video bitmaps

1.1	all source files have changed, as has the documentation:

	a)	CHANGE: allow config or animation filenames to be actual strings not filenames.
		this allows XML to be embedded in strings or read from elsewhere.
		simply call the same constructors/functions but use XML. NOTE: all attributes
		need to still be quoted, i.e. by using \, e.g. fps=\"60\". See examples for code, and documentation

	b)	CHANGE: you can now specify your own bitmap loader for the graphics to override the default which 
		calls 'load_bmp'. This is useful for loading png files, from a dat file or pre-rendering (e.g. applying lighting)
		
	c)  CHANGE: because of (a) and (b) all constructors have been replaced by a single constructor for each. This makes 
		things much easier. You will need to redo your code to match. See documentation and examples
		
	d)	CHANGE: because of (c) there is no need to call LoadAnimations() separately, the constructor for the Animation library
		does this for you - if you have it in code as well, it will mean all graphics are loaded twice! just remove it.
		
	e)  BUG: on changing timer loop type it could result in the drawing code for the new
		function being called but the logic not until the next loop. This could have
		implications if the drawing relied on stuff produced by the logic code

1.0	(or the unnamed version). Original release
	
*/
