#ifndef retrospec_game_car
#define retrospec_game_car

enum CarDirection {CAR_STRAIGHT,CAR_LEFT,CAR_RIGHT};
enum CarMovement {CAR_FREEWHEELING,CAR_ACCELERATE,CAR_DECELERATE};
enum CarStatus {CAR_NORMAL, CAR_DYING, CAR_DEAD};

class Car
{
public:
	int lastState;
public:
	static const float MAXVEL;
	static const float HALFVEL;	//for enemy cars
	static float MAXVELENEMY;
	static const float MAXVELTURBO;
	static const float MPH_MAX;
	static const float MPH_INCREASE;
	static const int MPH_REDLINE;
	static const int MPH_YELLOWLINE;
	static const float FUEL_MAX;
	static const float FUEL_INC;
	Car();
	~Car();
	void SetupCar(std::string animtype,bool resetMiles,bool resetPosition=true);	//overridden by enemy cars, but we'll not make it virtual
	bool NextMove();			//overridden by enemy cars, but we'll not make it virtual
	void SetCurrentState();
	int Car::GetCurrentState();
protected:
	int playingFuelIncrease;
	int playingFuelLow;
	int playingHandbrake;
	int playingCarCrash;
	int playingCarNoise;
	int playingFindCup;
	int originalCarNoiseFrequency;
	void Accelerate();
	void Decelerate();
	void TurnRight();
	void TurnLeft();
	bool CheckCollision();		//overridden by enemy cars, but we'll not make it virtual

public:
	Particles* crashParticles;
	AXL_Projects::Animation* car;
	bool HitCar;
	float acc;
	float vel;
	float decel;
	float mapx, mapy;			//real position in map
	int screenx,screeny;		//position to draw on the screen
	float MilesDriven;
	int angle;
	int lastangle;				//when handbrake, continue moving in same direction
								//but allow car to turn without affecting direction
	int Mph;
	float Fuel;
	float Temperature;
	CarStatus State;
	int DamageLevel;
	bool BlockTopSpeedIncrease;
	float SpeedFactor;
	int CarWidth;
	int CarHeight;
	std::string usState;
	int stateChanged;	//current state - number is index in array, or -1 if state has not changed
	std::string usStateCapital;
	int shadowOffsetX;
	int shadowOffsetY;
protected:
	float TemperatureInc;
	float TemperatureDec;
	float FuelUnit;
	bool Handbrake;
	float xdistancemoved,ydistancemoved;		//position moved
	CarMovement Move;
	CarDirection Direction;
	bool TemperatureLatch;
	bool BlockBadResponse;
	int LastHitX;
	int LastHitY;
};

/* path finding is as follows
	1. car is activated if player is within 50 blocks (about 3 screens)
	2. path is created and incremented every few seconds using the animation timer
	3. increment time is a random figure between 1 and 3 seconds
	4. if outside range and path is active then it is closed and car is placed in a new place
	5. movement to be done
*/

/* car movement is as follows
	1. determine the next node (first if new, new one if at next node, existing if not)
	2. get angle between car and node
	3.	<40 can accelerate to full speed while turning
		<90 can accelerate to half speed while turning
		>90 decelerate while turning
	4. if acceleration > half and angle >90 then hand-brake (set a rand flag at setup to say if car uses handbrake)
	5. If hit item then apply normal collision as user
		6. If hit player or player dies, then slowdown and set course for random tile close to player
	7. if player bounces when close then slowdown
	8. when player loses life reset at new random position
	9. when player out of range (random 20-40 squares) then reset to new random place
	   as will not be visible on screen
*/

class EnemyCar : public Car
{
public:
	void SetupCar(int offset=40,int magicblock=57,std::string cartype="enemy1");
	bool NextMove(Car* player);
	EnemyCar(int i) { Route=NULL; num=i;}
	~EnemyCar() { if(Route) delete Route; }
	bool RouteGenerated;
	AstarClass* Route;
protected:
	bool CheckCollision();
private:
	float EnemyCar::CrossProduct(float x1, float y1, float x2, float y2, float x3, float y3);
	CarMovement AutoMove;
	CarDirection AutoDirection;
	int num;
	int MagicBlock;
};

#endif
