//Tranz-Am
#include "game_transam.h"

static int yoff=0;
static int xoff=0;
static const int helpwidth=380;

static bool Initialised=false;
static BITMAP* checker=NULL;
static int currentpage=1;
static int lastpage=1;
static int currentItem=0;
static BITMAP* panel=NULL;
static BITMAP* arrow=NULL;
static BITMAP* p1=NULL;		//damage/collision items and keys/joypad
static BITMAP* p2=NULL;		//5 game modes

static font_struct FunkyFont;
static prop_text_struct FunkyText;

static int positions_p1[][2]={
	{150,14},
	{150,88},
	{100,188},
	{150,158},
	{150,188},
	{150,274},
	{150,312},
	{150,352},
	{150,392},
	{-170,200}
};
static std::string page1[]={
	"Distance travelled and time taken|- Finish the quickest!",
	"National Map|- Red dot is you|- White dots are fuel|- Blue dots are enemy cars|- Only easy level shows enemy cars",
	"Local Map|- Shows small portion of the map|- Shows your car in the centre|- Shows cups|- Shows enemies",
	"Radar|- Red is off|- blue is warming up|- Green shows radar pulse|- Pulse speed increases when close",
	"Cups|- Shows the cups collected",
	"Speed|- Faster means worse fuel consumption|- Red area increases engine temperature|- Green area reduces temperature|- Yellow area keeps temperature static|- Good roads boost top speed",
	"Fuel|- Drive over fuel to top-up!- Run out and you will lose a life",
	"Temperature|- Red cuts out engine|- If red, cannot accelerate|- Temperature increases on collision",
	"Status|- Number of lives|- Current U.S. State|- Current U.S. State's Capital|- Life is lost after too much damage",
	"Map objects"	//picture on bitmap of objects
};

static int positions_p2[][2]={
	{120,70},
	{120,155},
	{120,230},
	{120,300},
	{120,380},
	{120,380},
	{-340,225},
	{-400,350},
	{-400,350},
	{-400,350},
	{-400,350}
};
static std::string page2[]={
	"Main Game|- Collect the cups to win|- No high-score table for easy mode",
	"Survivor|- Survive for as long as you can!",
	"Cup Hunt|- Find one or more cups",
	"Race|- Beat your opponents in a race",
	"Quiz 1|- Drive to a given State",
	"Quiz 2|- Drive to a given State|- Knowing only the capital",
	"Movement|- Select configuration in Setup menu|- Joypad or Keyboard|- Accelerate/Brake|- Turn Left/Right|- Handbrake for fast turn/brake",
	"Setup Options|- Change keyboard controls|- Change joypad controls|- Change graphics modes|- Change sound/music options",
	"Setup/Graphics|- Memory is worst but most compatible|- Video is smooth|- Triple is the smoothest and fastest|- Triple buffering requires fullscreen",
	"Setup/Advanced|- Fine-tune the system",
	"Reset|- Use config.xml.bak to restore defaults"
};

void Initialise();
static void DrawWindow(int colour);

void DestroyHelp()
{
	Initialised=false;
	panel=arrow=p1=p2=NULL;
	currentpage=lastpage=1;
	currentItem=0;
	if(checker)
		destroy_bitmap(checker);
	checker=panel=arrow=p1=p2=NULL;
    PFONT_free_font (&FunkyFont);
}

void Initialise()
{
	checker=GenerateChecker();
	xoff=(SCREEN_W-640)/2;
	yoff=(SCREEN_H-480)/2;
	panel=GameLibrary->GetFirstGraphic("help_panel");
	arrow=GameLibrary->GetFirstGraphic("help_arrow");
	p1=GameLibrary->GetFirstGraphic("help_p1");
	p2=GameLibrary->GetFirstGraphic("help_p2");

	PFONT_load_font_from_bitmap(&FunkyFont, (BITMAP*)GameDAT[FONTFUNKYMESSAGE].dat, 16, 32);
		PFONT_create_frame_list (&FunkyText , &FunkyFont ,
			"hello",
			helpwidth, PFONT_ALIGN_LEFT , 1, -8 , false, false );
	if(!panel || !arrow || !p1 || !p2)
	{
		DestroyHelp();
		GameFramework->AbortSystem("Cannot find help graphics");
	}

	//PFONT_load_font (&FunkyFont, filename.c_str(), 16, 32);

}

bool TransAmHelpLogic()
{
	static int count=0;
	std::string current="";

	bool nextOK=false;

	if(!Initialised)
	{
		DestroyHelp();
		Initialised=true;
		Initialise();
	}
	//forced pause x seconds
	if(count>(GameConfiguration->CapsSystem.fps*0.5))
		nextOK=true;
	else
		count++;

	if(key[KEY_ESC])
	{
		DestroyHelp();
		GameFramework->SetAutoGameLoop(
		TransAmMenuLogic,TransAmMenuDrawing
		);
		return false;
	}

	//keypress
	if(nextOK && (keypressed() || GameFramework->JoypadAnythingPressed()))
	{
		//PlayExclusiveSFX(snd_menuchange);
		PlaySFX(snd_menuchange,1,true,false,-1);
		count=0;
		if(nextOK)
			currentItem++;

		if(currentpage==1 && currentItem>8)
			currentpage=2;

		if(currentpage!=lastpage)
		{
			lastpage=currentpage;
			currentItem=0;
		}
		if(currentpage==2 && currentItem>10)
		{
			DestroyHelp();
            GameFramework->SetAutoGameLoop(
                        CreditLogic,CreditDrawing
                        );
		}

		while(keypressed())
			readkey();
        clear_keybuf();
	}

	switch(currentpage)
	{
	case 1:
		current=page1[currentItem];
		break;
	case 2:
		current=page2[currentItem];
		break;
	}

	PFONT_create_frame_list (&FunkyText , &FunkyFont ,
		current.c_str(),
		helpwidth, PFONT_ALIGN_LEFT , 1, -8 , false, false );
	return false;
}

bool TransAmHelpDrawing()
{
	if(!Initialised)
		return false;

	blit(checker,GameFramework->DrawingSurface,0,0,0,0,checker->w,checker->h);
	switch(currentpage)
	{
	case 1:
		draw_sprite(GameFramework->DrawingSurface,panel,xoff,yoff);
		draw_sprite(GameFramework->DrawingSurface,p1,640-p1->w,480-p1->h);
		//current
		DrawWindow(makecol(239, 119, 32));
		break;
	case 2:
		draw_sprite(GameFramework->DrawingSurface,p2,10,yoff+480-(p2->h)-10);
		DrawWindow(makecol(239, 119, 32));
		break;
	}

	return false;
}

static void DrawWindow(int colour)
{
	//position is start x/y of arrow, text goes after this
	const int xgap=4;
	const int ygap=4;

	fblend_rect_trans(GameFramework->DrawingSurface,250+xoff,10,xoff+helpwidth+(xgap*2),FunkyText.image_height+(ygap*2),colour,236);
	PFONT_draw_frame_list_notexture(&FunkyText,1000,xoff+250+xgap+(helpwidth/2),10+ygap,0.5,0,GameFramework->DrawingSurface);

    //i know what you're thinking, and I'm thinking it to. but I'm just too far down the
    //rocky road and I can't go back
    if(currentpage==1)
    {
        if(positions_p1[currentItem][0]>=0)
            draw_sprite(GameFramework->DrawingSurface,arrow, xoff+positions_p1[currentItem][0]-16,yoff+positions_p1[currentItem][1]);
        else
            rotate_sprite(GameFramework->DrawingSurface,arrow, xoff+abs(positions_p1[currentItem][0])-16,yoff+positions_p1[currentItem][1],itofix(128));
    }
    else if(currentpage==2)
    {
        if(positions_p2[currentItem][0]>=0)
            draw_sprite(GameFramework->DrawingSurface,arrow, xoff+positions_p2[currentItem][0]-16,yoff+positions_p2[currentItem][1]);
        else
            rotate_sprite(GameFramework->DrawingSurface,arrow, xoff+abs(positions_p2[currentItem][0])-16,yoff+positions_p2[currentItem][1],itofix(128));
    }
}
