//Tranz-Am
#include "game_transam.h"

static bool initialised=false;

static BITMAP* block1=NULL;
static BITMAP* block2=NULL;

static const int blocksize=16;
static int block1colour=0;
static int block2colour=0;
static int offsetx=0;
static int offsety=0;
static int swap=false;
static bool newHighScore=false;	//main game only
static int newHighScoreValue=0;
static bool newMiniHighScore=false;
//screen output
static std::string line1;	//game over, congrats, etc.
static std::string line2;	//game end description
static std::string line3;	//high-score achieved
static std::string line5;	//time taken
static std::string line6;	//miles driven
static std::string line8;	//no high-score

//funky font
static std::string filename;
static font_struct FunkyFont;
static prop_text_struct FunkyText;
static BITMAP* temp=NULL;

void GameEndInitialiseEndScreen()
{
	GameEndDestroyEndScreen();
	temp=create_bitmap(SCREEN_W,SCREEN_H);

	if(temp)
	{
		//black out border if not 640x480 as we want red/white stripes to be ok
		clear(temp);
		if(SCREEN_H>480)
		{
			blit(GameFramework->DrawingSurface,temp,(SCREEN_W-640)/2,(SCREEN_H-480)/2,(SCREEN_W-640)/2,(SCREEN_H-480)/2,640,480);
			fblend_rect_trans(temp,(SCREEN_W-640)/2,(SCREEN_H-480)/2,640,480,makecol(114,112,46),246);
		}
		else
		{
			blit(GameFramework->DrawingSurface,temp,0,0,0,0,temp->w,temp->h);
			fblend_rect_trans(temp,0,0,SCREEN_W,SCREEN_H,makecol(114,112,46),246);
		}
	}

	block1colour=makecol(255,0,0);
	block2colour=makecol(255,255,255);
	block1=create_bitmap(blocksize,blocksize);
	block2=create_bitmap(blocksize,blocksize);
	clear_to_color(block1,block1colour);
	clear_to_color(block2,block2colour);
	if(SCREEN_W>640)
		offsetx=(SCREEN_W-640)/2;
	if(SCREEN_H>480)
		offsety=(SCREEN_H-480)/2;

	Cup->Reset();

	std::ostringstream ss;

	if(currentLevel->endState==1)
	{
		PlayTrackerSongFromDAT((const char*)(GameDAT[MUSIC_MOD_WIN].dat),-1,GameDAT[MUSIC_MOD_WIN].size,true,0);
	}
	else
	{
		PlayTrackerSongFromDAT((const char*)(GameDAT[MUSIC_MOD_LOSE].dat),-1,GameDAT[MUSIC_MOD_LOSE].size,true,0);
	}

	//top two lines
	switch(currentLevel->endState)
	{
	case 1:
		line1="Congratulations";
		if(currentLevel->gameMode==GT_NORMAL)
		{
			ss << "You've colleced all " << MaxNumCups << " cups of Ultimate";
			line2=ss.str();
			//try to add this score to the highscore and see if it succeeds. highscore is always wiped
			//so no traces will be there and xml not updated as empty name
			newHighScore=(AddHighScore(currentLevel->currentTime,"")!=-1);
			if(newHighScore)
				newHighScoreValue=currentLevel->currentTime;
		}
		else if(currentLevel->gameMode==GT_RACE)
			line2="You've won the race";
		else if(currentLevel->gameMode==GT_QUIZ)
			line2="You found the correct State";
		else if(currentLevel->gameMode==GT_CUP)
		{
			ss << "You've collected all " << MaxNumCups << " cups";
			line2=ss.str();
		}
		break;
	case 2:	//only in race
		line1="Good Race";
		line2="You managed a draw";
		//FMUSIC_SetMasterSpeed(ActiveMusic,0.8);
		break;
	case 3:
		if(currentLevel->gameMode==GT_RACE)
		{
			FMUSIC_SetMasterSpeed(ActiveMusic,0.8);
			line1="Game Over";
			if(currentLevel->countdown>0 && currentLevel->currentTime<=0)
				line2="You ran out of time";
			else
				line2="You lost the race";
		}
		else
			line1="Game Over";
		break;
	}

	//line 3 and 8
	if(currentLevel->gameMode==GT_NORMAL && currentLevel->flag==0)
	{
		line3="No high-score available in easy mode";
	}
	else if(
		(currentLevel->endState!=3 || currentLevel->gameMode==GT_SURVIVAL) &&
		(
			(currentLevel->highScore==0 || (currentLevel->gameMode!=GT_SURVIVAL && currentLevel->currentTime<currentLevel->highScore)) ||
			(currentLevel->highScore==0 || (currentLevel->gameMode==GT_SURVIVAL && currentLevel->currentTime>currentLevel->highScore))
		)
	)
	{
		line8="New highest score!";
		newMiniHighScore=true;
		currentLevel->highScore=currentLevel->currentTime;
	}
	else
	{
		ss.str("");
		if(currentLevel->highScore!=0)
			ss << "The best time so far is " << TimeFromSeconds(currentLevel->highScore);
		line3=ss.str();
	}

	//line 6
	ss.str("");
	ss << "You travelled " << currentLevel->currentMiles << " miles "<< "In " << TimeFromSeconds(currentLevel->currentTime);
	line6=ss.str();

	/*sprintf(filechar,"%s","gfx\\font_large_funky.bmp");
	filename=fix_filename_slashes( filechar );
	if(!exists(filename.c_str()))
		GameFramework->AbortSystem("Cannot find "+filename);
	PFONT_load_font (&FunkyFont, filename.c_str(), 36, 41);*/
	PFONT_load_font_from_bitmap(&FunkyFont, (BITMAP*)GameDAT[FONTFUNKYLARGE].dat, 36, 41);

	PFONT_create_frame_list (&FunkyText , &FunkyFont ,
		line1.c_str(),
		640, PFONT_ALIGN_CENTER , 1, -6 , false, false );

	if(newMiniHighScore)
		gameLevels->SetHighScore(currentLevel);
}

void GameEndDestroyEndScreen()
{
	initialised=false;
	newHighScore=newMiniHighScore=false;
	PFONT_free_font (&FunkyFont);
	if(block1) destroy_bitmap(block1);
	if(block2) destroy_bitmap(block2);
	if(temp) destroy_bitmap(temp);
	temp=block1=block2=NULL;
	line1=line2=line3=line5=line6=line8="";

	if(ActiveMusic)
		StopTrackerSong();
}

bool WinGameLogic()
{
	static float cycle=0.0;
	static int simplePause=0;
	static int loops=0;

    loops++;
	if(!initialised)
	{
		cycle=0.0;
		simplePause=0;
		GameEndInitialiseEndScreen();
		initialised=true;
	}

	static int counter=0;

	counter++;
	if(counter>GameConfiguration->CapsSystem.fps*1.2)
	{
		swap=!swap;
		counter=0;
	}


	if((keypressed() || GameFramework->JoypadAnythingPressed()) && loops>180)
	{
		loops=0;
		if(keypressed())
			readkey();
		if(currentLevel->endState==1 && currentLevel->flag!=0 && currentLevel->gameMode==GT_NORMAL)
		{
			clear_keybuf();
			//only set for main game and set only if in top 10
			int returnval;
			char name[255]="";
			strcpy(name,GameConfiguration->GetCustom("lastname","").c_str());
			int datSizes[2]={4,4};
			std::string encrypted;
			std::string error;
			std::string code;
			code=CreateHighScoreCode(97,HighScoreEntry(name,currentLevel->currentTime,currentLevel->currentMiles,0,0,""),2,datSizes);
			std::ostringstream ss;
			blit(GameFramework->DrawingSurface,MemoryBuffer,0,0,0,0,MemoryBuffer->w,MemoryBuffer->h);
			if(newHighScore)
			{
				ss << "You've made the local high score table. Enter your name%nothing[]%nothing[]"
				"If left blank or cancel selected, high-score will not be updated%nothing[]"
				"Select upload to send score to website, which may take a few seconds%nothing[]"
				"%nothing[]%line[]%nothing[]"
				"To submit later, your code is: " << code <<
				"%nothing[]Name%string[15]"
				"%buttonrow[Save,Save/Upload,Cancel]";
			}
			else
			{
				ss << "You haven't made the local high score table%nothing[]%nothing[]"
				"However, enter your name if you wish to upload%nothing[]"
				"to the website, which may take a few seconds%nothing[]"
				"If left blank or cancel selected, high-score will not be updated%nothing[]"
				"%nothing[]%line[]%nothing[]"
				"To submit later, your code is: " << code <<
				"%nothing[]Name%string[15]"
				"%buttonrow[Cancel,Upload]"
				;
			}
			returnval=adime_lowlevel_dialogf(
			"High-Score Entry",
			ADIME_ALIGN_CENTRE, ADIME_ALIGN_CENTRE, 300,
			ss.str().c_str(),
			name,
			tranzam_adime_callback_highscore
			);

			if(newHighScore && returnval!=3 && strcmp("",name)!=0)
				AddHighScore(newHighScoreValue,name);

			if(strcmp("",name)!=0)
				GameConfiguration->SetCustom("lastname",name);

			if(returnval==2 && strcmp("",name)!=0)
			{
				long position;
				position=SubmitHighScore(code,name,error,GameConfiguration->GetCustom("rootsite","http://retrospec.sgn.net"),GameConfiguration->GetCustom("proxy",""));
				blit(GameFramework->DrawingSurface,MemoryBuffer,0,0,0,0,MemoryBuffer->w,MemoryBuffer->h);
				if(error!="" || position<1)
				{
					ss.str("");
					ss << "The following error was generated submitting details:%nothing[]" <<error << "%nothing[]%line[]";
					ss << "For manual uploading your code is:%nothing[]" << code << "%nothing[]";
					ss << "%line[]The code is also stored in highscore.log%nothing[]%buttonrow[OK]";
					adime_lowlevel_dialogf(
						"Failed to upload",
						ADIME_ALIGN_CENTRE,ADIME_ALIGN_CENTRE,300,
						ss.str().c_str(),
						tranzam_adime_callback_close
						);
					ss.str("");
					ss << "time of: " << TimeFromSeconds(currentLevel->currentTime) << ". your code is " << code;
					Configuration::LogEntry(ss.str(),false,"highscore.log");
				}
				else
				{
				    ss.str("");
					ss << "You are currently at position " << position << "%nothing[]";
					ss << "For reference/future uploading your code is:%nothing[]" << code << "%nothing[]";
					ss << "%line[]The code is also stored in highscore.log%nothing[]%buttonrow[OK]";
					adime_lowlevel_dialogf(
						"Upload Success",
						ADIME_ALIGN_CENTRE,ADIME_ALIGN_CENTRE,300,
						ss.str().c_str(),
						tranzam_adime_callback_close
						);
					ss.str("");
					ss << "time of: " << TimeFromSeconds(currentLevel->currentTime) << ". your code is " << code;
					Configuration::LogEntry(ss.str(),false,"highscore.log");
				}
			}
		}

        if(currentLevel->endState==1 && currentLevel->gameMode==GT_NORMAL)
        {
            GameEndDestroyEndScreen();
            GameFramework->SetAutoGameLoop(
                        CreditLogic,CreditDrawing
                        );
        }
        else
        {
            GameEndDestroyEndScreen();
            GameFramework->SetAutoGameLoop(
                        TransAmMenuLogic,TransAmMenuDrawing
                        );
        }

		return false;
	}
	else
	{
		if(keypressed())
			readkey();
        clear_keybuf();
	}

	Cup->NextMove();

	PFONT_posset_reset ( &FunkyText );
	PFONT_texset_basic_spread ( &FunkyText , 1 , 1 , cycle*16 , cycle*16 , true );

	//slide in out
	//PFONT_posmod_scale ( &FunkyText , 0.5 , 0.5 , 1.1+(sin (cycle)/10) , 1+(cos (cycle)/10) );

	//move round a little
	//PFONT_posmod_add_noise ( &FunkyText , 0 , 4 );
	//PFONT_posmod_inverse_damp_point ( &FunkyText , (int (cycle*50) % 1000)-50 , 50 , 3 );
	//PFONT_posmod_bow_in ( &FunkyText , 0.5 , 0.5 , cos (cycle/2) * 16.0 , sin (cycle) * 16.0 );

	//sine wave
	PFONT_posmod_sine_out_phase ( &FunkyText , 0.02 , 0.02 , -20 , -20 , cycle , cycle );
	PFONT_posmod_damp_point ( &FunkyText , (int (cycle*2) % 1500)-300 , 300 , 0 );

	cycle+=0.04;
	return false;
}

bool WinGameDrawing()
{
	//always just use 640x480
	if(temp)
		blit(temp,GameFramework->DrawingSurface,0,0,0,0,temp->w,temp->h);
	else
		clear(GameFramework->DrawingSurface);

	BITMAP* current;
	BITMAP* alt;
	//background
	for(int i=0;i<(640/blocksize);i++)
	{
		//across
		if(i%2)
		{
			if(swap)
			{
				current=block1;
				alt=block2;
			}
			else
			{
				current=block2;
				alt=block1;
			}
		}
		else
		{
			if(swap)
			{
				current=block2;
				alt=block1;
			}
			else
			{
				current=block1;
				alt=block2;
			}
		}
		blit(current,GameFramework->DrawingSurface,0,0,offsetx+(i*blocksize),offsety,blocksize,blocksize);
		blit(alt,GameFramework->DrawingSurface,0,0,offsetx+(i*blocksize),offsety+480-blocksize,blocksize,blocksize);
	}
	for(int j=1;j<(480-blocksize)/blocksize;j++)
	{
		//down
		if(j%2)
		{
			if(swap)
			{
				current=block1;
				alt=block2;
			}
			else
			{
				current=block2;
				alt=block1;
			}
		}
		else
		{
			if(swap)
			{
				current=block2;
				alt=block1;
			}
			else
			{
				current=block1;
				alt=block2;
			}
		}
		blit(current,GameFramework->DrawingSurface,0,0,offsetx,offsety+(j*blocksize),blocksize,blocksize);
		blit(alt,GameFramework->DrawingSurface,0,0,offsetx+640-blocksize,offsety+(j*blocksize),blocksize,blocksize);
	}

	//the spinning cup
	if(currentLevel->endState<3)
	{
		draw_sprite(GameFramework->DrawingSurface,Cup->ReadOnly_CurrentItem,offsetx+32,SCREEN_H/2-(Cup->ReadOnly_CurrentItem->h/2));
		draw_sprite(GameFramework->DrawingSurface,Cup->ReadOnly_CurrentItem,offsetx+640-Cup->ReadOnly_CurrentItem->w-32,SCREEN_H/2-(Cup->ReadOnly_CurrentItem->h/2));
	}

	//text
	int starty=32;
	int height_mf=MainFont->height;
	int startx=SCREEN_W/2;
	if(SCREEN_H>480)
		starty+=SCREEN_H-480;

	textout_centre_ex(GameFramework->DrawingSurface,SmallFont,currentLevel->name.c_str(),startx,starty,-1,-1);
	//textout_centre_ex(GameFramework->DrawingSurface,LargeFont,line1.c_str(),startx,starty+(2*height_mf),-1,-1);
	textout_centre_ex(GameFramework->DrawingSurface,SmallFont,line2.c_str(),startx,15+starty+(3*height_mf),-1,-1);
	textout_centre_ex(GameFramework->DrawingSurface,SmallFont,line3.c_str(),startx,15+starty+(4*height_mf),-1,-1);
	textout_centre_ex(GameFramework->DrawingSurface,SmallFont,line6.c_str(),startx,15+starty+(8*height_mf),-1,-1);
	textout_centre_ex(GameFramework->DrawingSurface,MainFont2,line8.c_str(),startx,15+starty+(10*height_mf),-1,-1);

	PFONT_draw_frame_list_notexture (&FunkyText ,
		100 , SCREEN_W/2 , starty+(2*height_mf)-15, 0.5 , 0.0 , GameFramework->DrawingSurface );

	return false;
}

