# -*- coding: utf-8 -*-

# Copyright 2010, 2014 Richard Dymond (rjdymond@gmail.com)
#
# This file is part of Pyskool.
#
# Pyskool is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# Pyskool is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# Pyskool. If not, see <http://www.gnu.org/licenses/>.

from .skoolini import BACK_TO_SKOOL_DAZE
from . import skoolbuilder
from .skooltaps import *
from .skoolids import *

#: The `chase_x` argument for the MonitorEric command.
CHASE_X = 160

SIG_ASSEMBLY_STARTED = 'AssemblyStarted'
SIG_ASSEMBLY_FINISHED = 'AssemblyFinished'

SIG_UPPER_ROOM_READY = 'UpperRoomReady'
SIG_MIDDLE_ROOM_READY = 'MiddleRoomReady'
SIG_BLUE_ROOM_READY = 'BlueRoomReady'
SIG_YELLOW_ROOM_READY = 'YellowRoomReady'
SIG_SCIENCE_LAB_READY = 'ScienceLabReady'

SIG_LEADER_READY = 'LeaderReady'
SIG_LEADER_READY_AGAIN = 'LeaderReadyAgain'

CL_ASSEMBLY_BOY_1 = 'Assembly-Boy-1'
CL_ASSEMBLY_BOY_2 = 'Assembly-Boy-2'
CL_ASSEMBLY_BULLY = 'Assembly-Bully'
CL_ASSEMBLY_DUTY = 'AssemblyDuty'
CL_ASSEMBLY_TEACHER = 'Assembly-Teacher'
CL_ASSEMBLY_TEARAWAY = 'Assembly-Tearaway'
CL_ASSEMBLY_WACKER = 'Assembly-Wacker'
CL_BLUE_ROOM_BOY = 'BlueRoom-Boy'
CL_BLUE_ROOM_BULLY = 'BlueRoom-Bully'
CL_BLUE_ROOM_SWOT = 'BlueRoom-Swot'
CL_BLUE_ROOM_TEACHER = 'BlueRoom-Teacher'
CL_BLUE_ROOM_TEARAWAY = 'BlueRoom-Tearaway'
CL_BOYS_SKOOL_STAMPEDE_FOLLOWER = 'BoysSkoolStampede-Follower'
CL_BOYS_SKOOL_STAMPEDE_LEADER = 'BoysSkoolStampede-Leader'
CL_CHASE_ERIC_OUT = 'ChaseEricOut-Take'
CL_DINNER_BOY = 'Dinner-Boy'
CL_DINNER_BULLY = 'Dinner-Bully'
CL_DINNER_DUTY = 'DinnerDuty'
CL_DINNER_HALL_GIRL = 'DinnerHall-Girl'
CL_DINNER_TEARAWAY = 'Dinner-Tearaway'
CL_GIRLS_SKOOL_STAMPEDE_FOLLOWER = 'GirlsSkoolStampede-Follower'
CL_GIRLS_SKOOL_STAMPEDE_LEADER = 'GirlsSkoolStampede-Leader'
CL_GIRLS_SKOOL_WALKABOUT_TEACHER = 'GirlsSkoolWalkabout-Teacher'
CL_HEADS_STUDY = 'HeadsStudy'
CL_KITCHEN_GIRL = 'Kitchen-Girl'
CL_KITCHEN_TEACHER = 'Kitchen-Teacher'
CL_MIDDLE_ROOM_GIRL = 'MiddleRoom-Girl'
CL_MIDDLE_ROOM_TEACHER = 'MiddleRoom-Teacher'
CL_OPEN_GATE_AND_DOOR = 'OpenGateAndDoor-Albert'
CL_PLAYTIME_WALKABOUT_BOY_GIRL = 'PlaytimeWalkabout-Boy/Girl'
CL_REVISION_LIBRARY_BOY = 'RevisionLibrary-Boy'
CL_REVISION_LIBRARY_BULLY = 'RevisionLibrary-Bully'
CL_REVISION_LIBRARY_TEARAWAY = 'RevisionLibrary-Tearaway'
CL_SCIENCE_LAB_BOY = 'ScienceLab-Boy'
CL_SCIENCE_LAB_BULLY = 'ScienceLab-Bully'
CL_SCIENCE_LAB_SWOT = 'ScienceLab-Swot'
CL_SCIENCE_LAB_TEACHER = 'ScienceLab-Teacher'
CL_SCIENCE_LAB_TEARAWAY = 'ScienceLab-Tearaway'
CL_SHADOW_ERIC = 'ShadowEric'
CL_SHUT_GATE_AND_DOOR = 'ShutGateAndDoor-Albert'
CL_STALK_HEROINE_BULLY = 'StalkHeroine-Bully'
CL_UPPER_ROOM_GIRL = 'UpperRoom-Girl'
CL_UPPER_ROOM_TEACHER = 'UpperRoom-Teacher'
CL_WALKABOUT1_TEACHER = 'Walkabout1-Teacher'
CL_WALKABOUT1_WACKER = 'Walkabout1-Wacker'
CL_WALKABOUT2_TEACHER = 'Walkabout2-Teacher'
CL_WALKABOUT2_WACKER = 'Walkabout2-Wacker'
CL_WALKABOUT_BULLY = 'Walkabout-Bully'
CL_WALKABOUT_TEARAWAY = 'Walkabout-Tearaway'
CL_WRITE_ON_BOARDS_IN_BOYS_SKOOL = 'WriteOnBoardsInBoysSkool-Tearaway'
CL_WRITE_ON_BOARDS_IN_GIRLS_SKOOL = 'WriteOnBoardsInGirlsSkool-Tearaway'
CL_YELLOW_ROOM_BOY = 'YellowRoom-Boy'
CL_YELLOW_ROOM_BULLY = 'YellowRoom-Bully'
CL_YELLOW_ROOM_SWOT = 'YellowRoom-Swot'
CL_YELLOW_ROOM_TEACHER = 'YellowRoom-Teacher'
CL_YELLOW_ROOM_TEARAWAY = 'YellowRoom-Tearaway'

class BTSTapMaker:
    def __init__(self, custom):
        self.custom = custom

    def get_taps(self):
        taps = []

        tap = CommandList(CL_UPPER_ROOM_GIRL)
        tap.add_command(GO_TO, LOC_UPPER_ROOM)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_UPPER_ROOM_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIT_STILL)
        taps.append(tap)

        tap = CommandList(CL_MIDDLE_ROOM_GIRL)
        tap.add_command(GO_TO, LOC_MIDDLE_ROOM)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_MIDDLE_ROOM_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIT_STILL)
        taps.append(tap)

        tap = CommandList(CL_BLUE_ROOM_BOY)
        tap.add_command(GO_TO, LOC_BLUE_ROOM_1)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_BLUE_ROOM_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIT_STILL)
        taps.append(tap)

        tap = CommandList(CL_YELLOW_ROOM_BOY)
        tap.add_command(GO_TO, LOC_YELLOW_ROOM_1)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_YELLOW_ROOM_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIT_STILL)
        taps.append(tap)

        tap = CommandList(CL_SCIENCE_LAB_BOY)
        tap.add_command(GO_TO, LOC_SCIENCE_LAB_1)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_SCIENCE_LAB_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIT_STILL)
        taps.append(tap)

        tap = CommandList(CL_KITCHEN_GIRL)
        tap.add_command(GO_TO, LOC_KITCHEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_DINNER_HALL_GIRL)
        tap.add_command(GO_TO, LOC_GIRLS_DINNER_HALL)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_REVISION_LIBRARY_BOY)
        tap.add_command(GO_TO, LOC_REVISION_LIBRARY_1)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_DINNER_BOY)
        tap.add_command(GO_TO, LOC_BOYS_DINNER_HALL_1)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        tap.add_command(GO_TO_RANDOM_LOCATION)
        tap.add_command(WALK_AROUND, 10)
        tap.add_command(RESTART)
        taps.append(tap)

        tap = CommandList(CL_ASSEMBLY_BOY_1)
        tap.add_command(GO_TO, LOC_ASSEMBLY_HALL_0)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_ASSEMBLY_STARTED)
        tap.add_command(SIT_FOR_ASSEMBLY, SIG_ASSEMBLY_FINISHED, 1)
        tap.add_command(GO_TO_RANDOM_LOCATION)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_UPPER_ROOM_TEACHER)
        tap.add_command(SET_SUBCOMMAND, MONITOR_ERIC, CL_CHASE_ERIC_OUT, CHASE_X)
        tap.add_command(GO_TO, LOC_TAKES_STUDY_DOORWAY)
        tap.add_command(GO_TO, LOC_DRINKS_CABINET)
        tap.add_command(JUMP_IF_SHUT, SKOOL_DOOR, 2)
        tap.add_command(SHUT_DOOR, DRINKS_CABINET)
        tap.add_command(JUMP_IF_OPEN, SKOOL_DOOR, -5)
        tap.add_command(OPEN_DOOR, DRINKS_CABINET)
        tap.add_command(SET_RESTART_POINT)
        tap.add_command(GO_TO, LOC_TAKES_STUDY_DOORWAY)
        tap.add_command(GO_TO, LOC_UPPER_ROOM_DOORWAY)
        tap.add_command(START_LESSON_IF_READY, SIG_UPPER_ROOM_READY)
        tap.add_command(GO_TO, LOC_UPPER_ROOM_BOARD_EDGE)
        tap.add_command(CONDUCT_CLASS, SIG_SWOT_READY_FOR_LESSON)
        taps.append(tap)

        tap = CommandList(CL_MIDDLE_ROOM_TEACHER)
        tap.add_command(SET_SUBCOMMAND, MONITOR_ERIC, CL_CHASE_ERIC_OUT, CHASE_X)
        tap.add_command(GO_TO, LOC_TAKES_STUDY_DOORWAY)
        tap.add_command(GO_TO, LOC_DRINKS_CABINET)
        tap.add_command(JUMP_IF_SHUT, SKOOL_DOOR, 2)
        tap.add_command(SHUT_DOOR, DRINKS_CABINET)
        tap.add_command(JUMP_IF_OPEN, SKOOL_DOOR, -5)
        tap.add_command(OPEN_DOOR, DRINKS_CABINET)
        tap.add_command(SET_RESTART_POINT)
        tap.add_command(GO_TO, LOC_GIRLS_MIDDLE_FLOOR_WINDOW)
        tap.add_command(GO_TO, LOC_MIDDLE_ROOM_DOORWAY)
        tap.add_command(START_LESSON_IF_READY, SIG_MIDDLE_ROOM_READY)
        tap.add_command(GO_TO, LOC_MIDDLE_ROOM_BOARD_EDGE)
        tap.add_command(CONDUCT_CLASS, SIG_SWOT_READY_FOR_LESSON)
        taps.append(tap)

        tap = CommandList(CL_KITCHEN_TEACHER)
        tap.add_command(SET_SUBCOMMAND, MONITOR_ERIC, CL_CHASE_ERIC_OUT, CHASE_X)
        tap.add_command(GO_TO, LOC_DRINKS_CABINET)
        tap.add_command(SHUT_DOOR, DRINKS_CABINET)
        tap.add_command(GO_TO, LOC_KITCHEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_GIRLS_SKOOL_WALKABOUT_TEACHER)
        tap.add_command(GO_TO, LOC_DRINKS_CABINET)
        tap.add_command(SHUT_DOOR, DRINKS_CABINET)
        tap.add_command(SET_RESTART_POINT)
        tap.add_command(GO_TO_RANDOM_LOCATION)
        tap.add_command(RESTART)
        taps.append(tap)

        tap = CommandList(CL_DINNER_DUTY)
        tap.add_command(GO_TO, LOC_BOYS_DINNER_HALL_END_2)
        tap.add_command(GO_TO, LOC_BOYS_DINNER_HALL_END_1)
        tap.add_command(START_DINNER_IF_READY)
        tap.add_command(SET_RESTART_POINT)
        tap.add_command(GO_TO, LOC_BOYS_DINNER_HALL_END_2)
        tap.add_command(FIND_ERIC_IF_MISSING)
        tap.add_command(GO_TO, LOC_BOYS_DINNER_HALL_END_1)
        tap.add_command(FIND_ERIC_IF_MISSING)
        tap.add_command(RESTART)
        taps.append(tap)

        tap = CommandList(CL_SCIENCE_LAB_TEARAWAY)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(GO_TO, LOC_SCIENCE_LAB_BOARD_MIDDLE)
        tap.add_command(WRITE_ON_BOARD_UNLESS, SIG_SCIENCE_LAB_READY)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(GO_TO, LOC_SCIENCE_LAB_0)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_SCIENCE_LAB_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIT_STILL)
        taps.append(tap)

        tap = CommandList(CL_SCIENCE_LAB_BULLY)
        tap.add_command(SET_CONTROLLING_COMMAND, HIT_NOW_AND_THEN)
        tap.add_command(GO_TO, LOC_SCIENCE_LAB_0)
        tap.add_command(SET_CONTROLLING_COMMAND, HIT_NOW_AND_THEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_SCIENCE_LAB_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIT_STILL)
        taps.append(tap)

        tap = CommandList(CL_REVISION_LIBRARY_TEARAWAY)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(GO_TO, LOC_REVISION_LIBRARY_0)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_DINNER_TEARAWAY)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(GO_TO, LOC_BOYS_DINNER_HALL_0)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_ASSEMBLY_TEARAWAY)
        tap.add_command(GO_TO, LOC_ASSEMBLY_HALL_1)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_ASSEMBLY_STARTED)
        tap.add_command(SIT_FOR_ASSEMBLY, SIG_ASSEMBLY_FINISHED, 1)
        tap.add_command(GO_TO_RANDOM_LOCATION)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_WALKABOUT_TEARAWAY)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(GO_TO_RANDOM_LOCATION)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(WALK_AROUND, 9)
        tap.add_command(RESTART)
        taps.append(tap)

        tap = CommandList(CL_STALK_HEROINE_BULLY)
        tap.add_command(SET_CONTROLLING_COMMAND, STALK_AND_HIT, HEROINE)
        tap.add_command(GO_TO, '%s%s' % (LOCATION_MARKER, HEROINE))
        tap.add_command(SET_CONTROLLING_COMMAND, STALK_AND_HIT, HEROINE)
        tap.add_command(WALK_AROUND, 9)
        tap.add_command(RESTART)
        taps.append(tap)

        tap = CommandList(CL_BLUE_ROOM_TEARAWAY)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(GO_TO, LOC_BLUE_ROOM_BOARD_MIDDLE)
        tap.add_command(WRITE_ON_BOARD_UNLESS, SIG_BLUE_ROOM_READY)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(GO_TO, LOC_BLUE_ROOM_0)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_BLUE_ROOM_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIT_STILL)
        taps.append(tap)

        tap = CommandList(CL_BLUE_ROOM_BULLY)
        tap.add_command(SET_CONTROLLING_COMMAND, HIT_NOW_AND_THEN)
        tap.add_command(GO_TO, LOC_BLUE_ROOM_0)
        tap.add_command(SET_CONTROLLING_COMMAND, HIT_NOW_AND_THEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_BLUE_ROOM_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIT_STILL)
        taps.append(tap)

        tap = CommandList(CL_YELLOW_ROOM_TEARAWAY)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(GO_TO, LOC_YELLOW_ROOM_BOARD_MIDDLE)
        tap.add_command(WRITE_ON_BOARD_UNLESS, SIG_YELLOW_ROOM_READY)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(GO_TO, LOC_YELLOW_ROOM_0)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_YELLOW_ROOM_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIT_STILL)
        taps.append(tap)

        tap = CommandList(CL_YELLOW_ROOM_BULLY)
        tap.add_command(SET_CONTROLLING_COMMAND, HIT_NOW_AND_THEN)
        tap.add_command(GO_TO, LOC_YELLOW_ROOM_0)
        tap.add_command(SET_CONTROLLING_COMMAND, HIT_NOW_AND_THEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_YELLOW_ROOM_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIT_STILL)
        taps.append(tap)

        tap = CommandList(CL_WRITE_ON_BOARDS_IN_BOYS_SKOOL)
        tap.add_command(GO_TO, LOC_BLUE_ROOM_BOARD_MIDDLE)
        tap.add_command(WRITE_ON_BOARD_UNLESS, SIG_END_OF_LESSON)
        tap.add_command(GO_TO, LOC_YELLOW_ROOM_BOARD_MIDDLE)
        tap.add_command(WRITE_ON_BOARD_UNLESS, SIG_END_OF_LESSON)
        tap.add_command(GO_TO, LOC_SCIENCE_LAB_BOARD_MIDDLE)
        tap.add_command(WRITE_ON_BOARD_UNLESS, SIG_END_OF_LESSON)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(GO_TO_RANDOM_LOCATION)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_WRITE_ON_BOARDS_IN_GIRLS_SKOOL)
        tap.add_command(GO_TO, LOC_UPPER_ROOM_BOARD_MIDDLE)
        tap.add_command(WRITE_ON_BOARD_UNLESS, SIG_END_OF_LESSON)
        tap.add_command(GO_TO, LOC_MIDDLE_ROOM_BOARD_MIDDLE)
        tap.add_command(WRITE_ON_BOARD_UNLESS, SIG_END_OF_LESSON)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(GO_TO_RANDOM_LOCATION)
        tap.add_command(SET_CONTROLLING_COMMAND, FIRE_NOW_AND_THEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_BLUE_ROOM_TEACHER)
        tap.add_command(GO_TO, LOC_REVISION_LIBRARY)
        tap.add_command(GO_TO, LOC_BLUE_ROOM_DOORWAY)
        tap.add_command(START_LESSON_IF_READY, SIG_BLUE_ROOM_READY)
        tap.add_command(GO_TO, LOC_BLUE_ROOM_BOARD_EDGE)
        tap.add_command(CONDUCT_CLASS, SIG_SWOT_READY_FOR_LESSON)
        taps.append(tap)

        tap = CommandList(CL_YELLOW_ROOM_TEACHER)
        tap.add_command(GO_TO, LOC_REVISION_LIBRARY)
        tap.add_command(GO_TO, LOC_YELLOW_ROOM_DOORWAY)
        tap.add_command(START_LESSON_IF_READY, SIG_YELLOW_ROOM_READY)
        tap.add_command(GO_TO, LOC_YELLOW_ROOM_BOARD_EDGE)
        tap.add_command(CONDUCT_CLASS, SIG_SWOT_READY_FOR_LESSON)
        taps.append(tap)

        tap = CommandList(CL_SCIENCE_LAB_TEACHER)
        tap.add_command(GO_TO, LOC_JUST_OUTSIDE_TOILETS)
        tap.add_command(GO_TO, LOC_SCIENCE_LAB_DOORWAY)
        tap.add_command(START_LESSON_IF_READY, SIG_SCIENCE_LAB_READY)
        tap.add_command(GO_TO, LOC_SCIENCE_LAB_BOARD_EDGE)
        tap.add_command(CONDUCT_CLASS, SIG_SWOT_READY_FOR_LESSON)
        taps.append(tap)

        tap = CommandList(CL_WALKABOUT1_TEACHER)
        tap.add_command(GO_TO, LOC_ASSEMBLY_HALL_STAGE_EDGE)
        tap.add_command(GO_TO, LOC_REVISION_LIBRARY)
        tap.add_command(RESTART)
        taps.append(tap)

        tap = CommandList(CL_WALKABOUT1_WACKER)
        tap.add_command(GO_TO, LOC_HEADS_STUDY_WINDOW)
        tap.add_command(GO_TO_RANDOM_LOCATION)
        tap.add_command(RESTART)
        taps.append(tap)

        tap = CommandList(CL_WALKABOUT2_TEACHER)
        tap.add_command(GO_TO_RANDOM_LOCATION)
        tap.add_command(RESTART)
        taps.append(tap)

        tap = CommandList(CL_WALKABOUT2_WACKER)
        tap.add_command(GO_TO, LOC_HEADS_STUDY_WINDOW)
        tap.add_command(GO_TO, LOC_ASSEMBLY_HALL_STAGE_MIDDLE)
        tap.add_command(GO_TO, LOC_CLOAK_ROOM)
        tap.add_command(GO_TO, LOC_ASSEMBLY_HALL_STAGE_MIDDLE)
        tap.add_command(RESTART)
        taps.append(tap)

        tap = CommandList(CL_ASSEMBLY_WACKER)
        tap.add_command(GO_TO, LOC_HEADS_STUDY_WINDOW)
        tap.add_command(GO_TO, LOC_TOP_OF_STAIRS_DOWN_TO_STAGE)
        tap.add_command(START_ASSEMBLY_IF_READY, SIG_ASSEMBLY_STARTED)
        tap.add_command(GO_TO, LOC_ASSEMBLY_HALL_STAGE_EDGE)
        tap.add_command(CONDUCT_ASSEMBLY)
        tap.add_command(SIGNAL, SIG_ASSEMBLY_FINISHED)
        tap.add_command(SET_CLOCK, 100)
        tap.add_command(GO_TO, LOC_HEADS_STUDY_0)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_HEADS_STUDY)
        tap.add_command(GO_TO, LOC_HEADS_STUDY_0)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_SHUT_GATE_AND_DOOR)
        tap.add_command(GO_TO, LOC_BOYS_PLAYGROUND_MIDDLE)
        tap.add_command(JUMP_IF_SHUT, SKOOL_GATE, 3)
        tap.add_command(GO_TO, LOC_SKOOL_GATE_TO_SHUT)
        tap.add_command(WAIT_AT_DOOR, SKOOL_GATE)
        tap.add_command(SHUT_DOOR, SKOOL_GATE)
        tap.add_command(JUMP_IF_SHUT, SKOOL_DOOR, 3)
        tap.add_command(GO_TO, LOC_BOYS_SKOOL_DOOR)
        tap.add_command(WAIT_AT_DOOR, SKOOL_DOOR)
        tap.add_command(SHUT_DOOR, SKOOL_DOOR)
        tap.add_command(GO_TO, LOC_JUST_RIGHT_OF_TREE)
        tap.add_command(SET_CONTROLLING_COMMAND, WATCH_FOR_ERIC, WACKER, CL_SHADOW_ERIC, "$%s^HE'S ESCAPING" % WACKER, 96, (2, 6))
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_OPEN_GATE_AND_DOOR)
        tap.add_command(GO_TO, LOC_BOYS_SKOOL_DOOR)
        tap.add_command(OPEN_DOOR, SKOOL_DOOR)
        tap.add_command(GO_TO, LOC_SKOOL_GATE_TO_OPEN)
        tap.add_command(OPEN_DOOR, SKOOL_GATE)
        tap.add_command(SET_RESTART_POINT)
        tap.add_command(GO_TO_RANDOM_LOCATION)
        tap.add_command(RESTART)
        taps.append(tap)

        tap = CommandList(CL_ASSEMBLY_TEACHER)
        tap.add_command(GO_TO, LOC_ASSEMBLY_HALL_WAY_BACK)
        tap.add_command(GO_TO, LOC_ASSEMBLY_HALL_BACK)
        tap.add_command(WAIT_UNTIL, SIG_ASSEMBLY_FINISHED)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_ASSEMBLY_DUTY)
        tap.add_command(GO_TO, LOC_ASSEMBLY_HALL_WAY_BACK)
        tap.add_command(GO_TO, LOC_ASSEMBLY_HALL_BACK)
        tap.add_command(DO_ASSEMBLY_DUTY, SIG_ASSEMBLY_STARTED, SIG_ASSEMBLY_FINISHED)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_BLUE_ROOM_SWOT)
        tap.add_command(GO_TO, LOC_BLUE_ROOM_0)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_BLUE_ROOM_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIGNAL, SIG_SWOT_READY_FOR_LESSON)
        tap.add_command(GRASS_AND_ANSWER_QUESTIONS)
        taps.append(tap)

        tap = CommandList(CL_YELLOW_ROOM_SWOT)
        tap.add_command(GO_TO, LOC_YELLOW_ROOM_1)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_YELLOW_ROOM_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIGNAL, SIG_SWOT_READY_FOR_LESSON)
        tap.add_command(GRASS_AND_ANSWER_QUESTIONS)
        taps.append(tap)

        tap = CommandList(CL_SCIENCE_LAB_SWOT)
        tap.add_command(GO_TO, LOC_SCIENCE_LAB_2)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_SCIENCE_LAB_READY)
        tap.add_command(FIND_SEAT)
        tap.add_command(SIGNAL, SIG_SWOT_READY_FOR_LESSON)
        tap.add_command(GRASS_AND_ANSWER_QUESTIONS)
        taps.append(tap)

        tap = CommandList(CL_ASSEMBLY_BOY_2)
        tap.add_command(GO_TO, LOC_ASSEMBLY_HALL_2)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_ASSEMBLY_STARTED)
        tap.add_command(SIT_FOR_ASSEMBLY, SIG_ASSEMBLY_FINISHED, 1)
        tap.add_command(GO_TO_RANDOM_LOCATION)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_REVISION_LIBRARY_BULLY)
        tap.add_command(SET_CONTROLLING_COMMAND, HIT_NOW_AND_THEN)
        tap.add_command(GO_TO, LOC_REVISION_LIBRARY_0)
        tap.add_command(SET_CONTROLLING_COMMAND, HIT_NOW_AND_THEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_DINNER_BULLY)
        tap.add_command(SET_CONTROLLING_COMMAND, HIT_NOW_AND_THEN)
        tap.add_command(GO_TO, LOC_BOYS_DINNER_HALL_0)
        tap.add_command(SET_CONTROLLING_COMMAND, HIT_NOW_AND_THEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_ASSEMBLY_BULLY)
        tap.add_command(GO_TO, LOC_ASSEMBLY_HALL_1)
        tap.add_command(SET_CONTROLLING_COMMAND, HIT_NOW_AND_THEN)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_ASSEMBLY_STARTED)
        tap.add_command(SIT_FOR_ASSEMBLY, SIG_ASSEMBLY_FINISHED, 1)
        tap.add_command(GO_TO_RANDOM_LOCATION)
        tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
        taps.append(tap)

        tap = CommandList(CL_WALKABOUT_BULLY)
        tap.add_command(SET_CONTROLLING_COMMAND, HIT_NOW_AND_THEN)
        tap.add_command(GO_TO_RANDOM_LOCATION)
        tap.add_command(SET_CONTROLLING_COMMAND, HIT_NOW_AND_THEN)
        tap.add_command(WALK_AROUND, 9)
        tap.add_command(RESTART)
        taps.append(tap)

        if self.custom == BACK_TO_SKOOL_DAZE:
            tap = CommandList(CL_BOYS_SKOOL_STAMPEDE_LEADER)
            tap.add_command(SET_CONTROLLING_COMMAND, WALK_FAST)
            tap.add_command(GO_TO, LOC_BOYS_PLAYGROUND_0)
            tap.add_command(WALK_AROUND, 10)
            tap.add_command(SET_CLOCK, 2000)
            tap.add_command(SIGNAL, SIG_LEADER_READY)
            tap.add_command(SET_CONTROLLING_COMMAND, TRIP_PEOPLE_UP)
            tap.add_command(GO_TO, LOC_YELLOW_ROOM_DOORWAY)
            tap.add_command(UNSIGNAL, SIG_LEADER_READY)
            tap.add_command(WALK_AROUND, 5)
            tap.add_command(SET_CLOCK, 1000)
            tap.add_command(SIGNAL, SIG_LEADER_READY_AGAIN)
            tap.add_command(SET_CONTROLLING_COMMAND, TRIP_PEOPLE_UP)
            tap.add_command(GO_TO, LOC_BOYS_PLAYGROUND_0)
            tap.add_command(UNSIGNAL, SIG_LEADER_READY_AGAIN)
            tap.add_command(GO_TO_RANDOM_LOCATION)
            tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
            taps.append(tap)

            tap = CommandList(CL_BOYS_SKOOL_STAMPEDE_FOLLOWER)
            tap.add_command(GO_TO, LOC_BOYS_PLAYGROUND_0)
            tap.add_command(MOVE_ABOUT_UNTIL, SIG_LEADER_READY)
            tap.add_command(SET_CONTROLLING_COMMAND, TRIP_PEOPLE_UP)
            tap.add_command(FOLLOW, BOY01)
            tap.add_command(MOVE_ABOUT_UNTIL, SIG_LEADER_READY_AGAIN)
            tap.add_command(SET_CONTROLLING_COMMAND, TRIP_PEOPLE_UP)
            tap.add_command(FOLLOW, BOY01)
            tap.add_command(GO_TO_RANDOM_LOCATION)
            tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
            taps.append(tap)

            tap = CommandList(CL_GIRLS_SKOOL_STAMPEDE_LEADER)
            tap.add_command(SET_CONTROLLING_COMMAND, WALK_FAST)
            tap.add_command(GO_TO, LOC_GIRLS_PLAYGROUND_0)
            tap.add_command(WALK_AROUND, 10)
            tap.add_command(SET_CLOCK, 2000)
            tap.add_command(SIGNAL, SIG_LEADER_READY)
            tap.add_command(SET_CONTROLLING_COMMAND, TRIP_PEOPLE_UP)
            tap.add_command(GO_TO, LOC_TAKES_STUDY_DOORWAY)
            tap.add_command(UNSIGNAL, SIG_LEADER_READY)
            tap.add_command(WALK_AROUND, 5)
            tap.add_command(SET_CLOCK, 1000)
            tap.add_command(SIGNAL, SIG_LEADER_READY_AGAIN)
            tap.add_command(SET_CONTROLLING_COMMAND, TRIP_PEOPLE_UP)
            tap.add_command(GO_TO, LOC_GIRLS_PLAYGROUND_0)
            tap.add_command(UNSIGNAL, SIG_LEADER_READY_AGAIN)
            tap.add_command(GO_TO_RANDOM_LOCATION)
            tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
            taps.append(tap)

            tap = CommandList(CL_GIRLS_SKOOL_STAMPEDE_FOLLOWER)
            tap.add_command(GO_TO, LOC_GIRLS_PLAYGROUND_0)
            tap.add_command(MOVE_ABOUT_UNTIL, SIG_LEADER_READY)
            tap.add_command(SET_CONTROLLING_COMMAND, TRIP_PEOPLE_UP)
            tap.add_command(FOLLOW, BOY01)
            tap.add_command(MOVE_ABOUT_UNTIL, SIG_LEADER_READY_AGAIN)
            tap.add_command(SET_CONTROLLING_COMMAND, TRIP_PEOPLE_UP)
            tap.add_command(FOLLOW, BOY01)
            tap.add_command(GO_TO_RANDOM_LOCATION)
            tap.add_command(MOVE_ABOUT_UNTIL, SIG_END_OF_LESSON)
            taps.append(tap)

        tap = CommandList(CL_PELLET)
        tap.add_command(MOVE_PELLET)
        taps.append(tap)

        tap = CommandList(CL_MOUSE)
        tap.add_command(MOVE_MOUSE, (5, 20), (2, 5), (2, 5), (10, 41))
        taps.append(tap)

        if self.custom != BACK_TO_SKOOL_DAZE:
            tap = CommandList(CL_FROG)
            tap.add_command(MOVE_FROG, 0.75, 0.25, 0.5)
            taps.append(tap)

        tap = CommandList(CL_WATER)
        tap.add_command(MOVE_WATER)
        taps.append(tap)

        tap = CommandList(CL_STINKBOMB)
        tap.add_command(STINK, 29)
        taps.append(tap)

        tap = CommandList(CL_DESK_LID)
        tap.add_command(MOVE_DESK_LID, 10)
        taps.append(tap)

        tap = CommandList(CL_BIKE)
        tap.add_command(MOVE_BIKE)
        taps.append(tap)

        tap = CommandList(CL_PLANT)
        tap.add_command(GROW, 12, 19, 26)
        taps.append(tap)

        tap = CommandList(CL_WATER_DROP)
        tap.add_command(FALL)
        taps.append(tap)

        tap = CommandList(CL_SHERRY_DROP)
        tap.add_command(FALL)
        taps.append(tap)

        tap = CommandList(CL_CONKER)
        tap.add_command(FALL)
        taps.append(tap)

        tap = CommandList(CL_CHASE_ERIC_OUT)
        tap.add_command(CHASE_ERIC_OUT, 137)
        taps.append(tap)

        tap = CommandList(CL_SHADOW_ERIC)
        tap.add_command(SHADOW_ERIC)
        taps.append(tap)

        tap = CommandList(CL_EXPEL_ERIC_TOO_MANY_LINES)
        tap.add_command(FIND_ERIC)
        tap.add_command(TELL_ERIC, "YOU HAVE 10000 LINES $%s         YOU'RE EXPELLED" % HERO)
        tap.add_command(END_GAME)
        taps.append(tap)

        tap = CommandList(CL_EXPEL_ERIC_NOT_A_BIRD)
        tap.add_command(FIND_ERIC)
        tap.add_command(TELL_ERIC, "YOU ARE NOT A BIRD $%s         YOU'RE EXPELLED" % HERO)
        tap.add_command(END_GAME)
        taps.append(tap)

        return taps

    def get_lessons(self):
        lessons = []

        lesson = Lesson(LSN_CREAK_BLUE_ROOM_1, CREAK, BLUE_ROOM)
        lesson.add_entry(GIRL01, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL02, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL03, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL04, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL05, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL06, CL_KITCHEN_GIRL)
        lesson.add_entry(GIRL07, CL_KITCHEN_GIRL)
        lesson.add_entry(BOY01, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY02, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY03, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY04, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY05, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY06, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY07, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY08, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY09, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY10, CL_BLUE_ROOM_BOY)
        lesson.add_entry(WACKER, CL_HEADS_STUDY)
        lesson.add_entry(WITHIT, CL_YELLOW_ROOM_TEACHER)
        lesson.add_entry(ROCKITT, CL_WALKABOUT2_TEACHER)
        lesson.add_entry(CREAK, CL_BLUE_ROOM_TEACHER)
        lesson.add_entry(TAKE, CL_UPPER_ROOM_TEACHER)
        lesson.add_entry(ALBERT, CL_SHUT_GATE_AND_DOOR)
        lesson.add_entry(TEARAWAY, CL_BLUE_ROOM_TEARAWAY)
        lesson.add_entry(BULLY, CL_BLUE_ROOM_BULLY)
        lesson.add_entry(SWOT, CL_BLUE_ROOM_SWOT)
        lesson.add_entry(HEROINE, CL_UPPER_ROOM_GIRL)
        lessons.append(lesson)

        lesson = Lesson(LSN_CREAK_BLUE_ROOM_2, CREAK, BLUE_ROOM)
        lesson.add_entry(GIRL01, CL_DINNER_HALL_GIRL)
        lesson.add_entry(GIRL02, CL_DINNER_HALL_GIRL)
        lesson.add_entry(GIRL03, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL04, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL05, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL06, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL07, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(BOY01, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY02, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY03, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY04, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY05, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY06, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY07, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY08, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY09, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY10, CL_BLUE_ROOM_BOY)
        lesson.add_entry(WACKER, CL_WALKABOUT2_WACKER)
        lesson.add_entry(WITHIT, CL_WALKABOUT1_TEACHER)
        lesson.add_entry(ROCKITT, CL_SCIENCE_LAB_TEACHER)
        lesson.add_entry(CREAK, CL_BLUE_ROOM_TEACHER)
        lesson.add_entry(TAKE, CL_MIDDLE_ROOM_TEACHER)
        lesson.add_entry(ALBERT, CL_SHUT_GATE_AND_DOOR)
        lesson.add_entry(TEARAWAY, CL_SCIENCE_LAB_TEARAWAY)
        lesson.add_entry(BULLY, CL_BLUE_ROOM_BULLY)
        lesson.add_entry(SWOT, CL_BLUE_ROOM_SWOT)
        lesson.add_entry(HEROINE, CL_MIDDLE_ROOM_GIRL)
        lessons.append(lesson)

        lesson = Lesson(LSN_CREAK_YELLOW_ROOM_1, CREAK, YELLOW_ROOM)
        lesson.add_entry(GIRL01, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL02, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL03, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL04, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL05, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL06, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL07, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(BOY01, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY02, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY03, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY04, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY05, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY06, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY07, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY08, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY09, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY10, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(WACKER, CL_HEADS_STUDY)
        lesson.add_entry(WITHIT, CL_BLUE_ROOM_TEACHER)
        lesson.add_entry(ROCKITT, CL_SCIENCE_LAB_TEACHER)
        lesson.add_entry(CREAK, CL_YELLOW_ROOM_TEACHER)
        lesson.add_entry(TAKE, CL_UPPER_ROOM_TEACHER)
        lesson.add_entry(ALBERT, CL_SHUT_GATE_AND_DOOR)
        lesson.add_entry(TEARAWAY, CL_YELLOW_ROOM_TEARAWAY)
        lesson.add_entry(BULLY, CL_YELLOW_ROOM_BULLY)
        lesson.add_entry(SWOT, CL_YELLOW_ROOM_SWOT)
        lesson.add_entry(HEROINE, CL_UPPER_ROOM_GIRL)
        lessons.append(lesson)

        lesson = Lesson(LSN_CREAK_YELLOW_ROOM_2, CREAK, YELLOW_ROOM)
        lesson.add_entry(GIRL01, CL_KITCHEN_GIRL)
        lesson.add_entry(GIRL02, CL_KITCHEN_GIRL)
        lesson.add_entry(GIRL03, CL_KITCHEN_GIRL)
        lesson.add_entry(GIRL04, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL05, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL06, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL07, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(BOY01, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY02, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY03, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY04, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY05, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY06, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY07, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY08, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY09, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY10, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(WACKER, CL_WALKABOUT2_WACKER)
        lesson.add_entry(WITHIT, CL_BLUE_ROOM_TEACHER)
        lesson.add_entry(ROCKITT, CL_SCIENCE_LAB_TEACHER)
        lesson.add_entry(CREAK, CL_YELLOW_ROOM_TEACHER)
        lesson.add_entry(TAKE, CL_MIDDLE_ROOM_TEACHER)
        lesson.add_entry(ALBERT, CL_SHUT_GATE_AND_DOOR)
        lesson.add_entry(TEARAWAY, CL_YELLOW_ROOM_TEARAWAY)
        lesson.add_entry(BULLY, CL_SCIENCE_LAB_BULLY)
        lesson.add_entry(SWOT, CL_YELLOW_ROOM_SWOT)
        lesson.add_entry(HEROINE, CL_KITCHEN_GIRL)
        lessons.append(lesson)

        lesson = Lesson(LSN_WITHIT_BLUE_ROOM_1, WITHIT, BLUE_ROOM)
        lesson.add_entry(GIRL01, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL02, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL03, CL_DINNER_HALL_GIRL)
        lesson.add_entry(GIRL04, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL05, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL06, CL_DINNER_HALL_GIRL)
        lesson.add_entry(GIRL07, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(BOY01, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY02, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY03, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY04, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY05, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY06, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY07, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY08, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY09, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY10, CL_BLUE_ROOM_BOY)
        lesson.add_entry(WACKER, CL_HEADS_STUDY)
        lesson.add_entry(WITHIT, CL_BLUE_ROOM_TEACHER)
        lesson.add_entry(ROCKITT, CL_WALKABOUT2_TEACHER)
        lesson.add_entry(CREAK, CL_YELLOW_ROOM_TEACHER)
        lesson.add_entry(TAKE, CL_UPPER_ROOM_TEACHER)
        lesson.add_entry(ALBERT, CL_SHUT_GATE_AND_DOOR)
        lesson.add_entry(TEARAWAY, CL_BLUE_ROOM_TEARAWAY)
        lesson.add_entry(BULLY, CL_YELLOW_ROOM_BULLY)
        lesson.add_entry(SWOT, CL_BLUE_ROOM_SWOT)
        lesson.add_entry(HEROINE, CL_DINNER_HALL_GIRL)
        lessons.append(lesson)

        lesson = Lesson(LSN_WITHIT_BLUE_ROOM_2, WITHIT, BLUE_ROOM)
        lesson.add_entry(GIRL01, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL02, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL03, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL04, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL05, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL06, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL07, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(BOY01, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY02, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY03, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY04, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY05, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY06, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY07, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY08, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY09, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY10, CL_BLUE_ROOM_BOY)
        lesson.add_entry(WACKER, CL_WALKABOUT2_WACKER)
        lesson.add_entry(WITHIT, CL_BLUE_ROOM_TEACHER)
        lesson.add_entry(ROCKITT, CL_YELLOW_ROOM_TEACHER)
        lesson.add_entry(CREAK, CL_WALKABOUT2_TEACHER)
        lesson.add_entry(TAKE, CL_MIDDLE_ROOM_TEACHER)
        lesson.add_entry(ALBERT, CL_SHUT_GATE_AND_DOOR)
        lesson.add_entry(TEARAWAY, CL_REVISION_LIBRARY_TEARAWAY)
        lesson.add_entry(BULLY, CL_BLUE_ROOM_BULLY)
        lesson.add_entry(SWOT, CL_BLUE_ROOM_SWOT)
        lesson.add_entry(HEROINE, CL_UPPER_ROOM_GIRL)
        lessons.append(lesson)

        lesson = Lesson(LSN_WITHIT_YELLOW_ROOM_1, WITHIT, YELLOW_ROOM)
        lesson.add_entry(GIRL01, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL02, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL03, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL04, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL05, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL06, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL07, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(BOY01, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY02, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY03, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY04, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY05, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY06, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY07, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY08, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY09, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY10, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(WACKER, CL_HEADS_STUDY)
        lesson.add_entry(WITHIT, CL_YELLOW_ROOM_TEACHER)
        lesson.add_entry(ROCKITT, CL_SCIENCE_LAB_TEACHER)
        lesson.add_entry(CREAK, CL_BLUE_ROOM_TEACHER)
        lesson.add_entry(TAKE, CL_MIDDLE_ROOM_TEACHER)
        lesson.add_entry(ALBERT, CL_SHUT_GATE_AND_DOOR)
        lesson.add_entry(TEARAWAY, CL_YELLOW_ROOM_TEARAWAY)
        lesson.add_entry(BULLY, CL_BLUE_ROOM_BULLY)
        lesson.add_entry(SWOT, CL_YELLOW_ROOM_SWOT)
        lesson.add_entry(HEROINE, CL_MIDDLE_ROOM_GIRL)
        lessons.append(lesson)

        lesson = Lesson(LSN_WITHIT_YELLOW_ROOM_2, WITHIT, YELLOW_ROOM)
        lesson.add_entry(GIRL01, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL02, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL03, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL04, CL_KITCHEN_GIRL)
        lesson.add_entry(GIRL05, CL_KITCHEN_GIRL)
        lesson.add_entry(GIRL06, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL07, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(BOY01, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY02, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY03, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY04, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY05, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY06, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY07, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY08, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY09, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY10, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(WACKER, CL_WALKABOUT2_WACKER)
        lesson.add_entry(WITHIT, CL_YELLOW_ROOM_TEACHER)
        lesson.add_entry(ROCKITT, CL_SCIENCE_LAB_TEACHER)
        lesson.add_entry(CREAK, CL_BLUE_ROOM_TEACHER)
        lesson.add_entry(TAKE, CL_UPPER_ROOM_TEACHER)
        lesson.add_entry(ALBERT, CL_SHUT_GATE_AND_DOOR)
        lesson.add_entry(TEARAWAY, CL_YELLOW_ROOM_TEARAWAY)
        lesson.add_entry(BULLY, CL_REVISION_LIBRARY_BULLY)
        lesson.add_entry(SWOT, CL_YELLOW_ROOM_SWOT)
        lesson.add_entry(HEROINE, CL_KITCHEN_GIRL)
        lessons.append(lesson)

        lesson = Lesson(LSN_WITHIT_SCIENCE_LAB_1, WITHIT, SCIENCE_LAB)
        lesson.add_entry(GIRL01, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL02, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL03, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL04, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL05, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL06, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL07, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(BOY01, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY02, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY03, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY04, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY05, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY06, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY07, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY08, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY09, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY10, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(WACKER, CL_HEADS_STUDY)
        lesson.add_entry(WITHIT, CL_SCIENCE_LAB_TEACHER)
        lesson.add_entry(ROCKITT, CL_WALKABOUT2_TEACHER)
        lesson.add_entry(CREAK, CL_YELLOW_ROOM_TEACHER)
        lesson.add_entry(TAKE, CL_MIDDLE_ROOM_TEACHER)
        lesson.add_entry(ALBERT, CL_SHUT_GATE_AND_DOOR)
        lesson.add_entry(TEARAWAY, CL_SCIENCE_LAB_TEARAWAY)
        lesson.add_entry(BULLY, CL_SCIENCE_LAB_BULLY)
        lesson.add_entry(SWOT, CL_SCIENCE_LAB_SWOT)
        lesson.add_entry(HEROINE, CL_DINNER_HALL_GIRL)
        lessons.append(lesson)

        lesson = Lesson(LSN_WITHIT_SCIENCE_LAB_2, WITHIT, SCIENCE_LAB)
        lesson.add_entry(GIRL01, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL02, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL03, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL04, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL05, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL06, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL07, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(BOY01, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY02, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY03, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY04, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY05, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY06, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY07, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY08, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY09, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY10, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(WACKER, CL_WALKABOUT2_WACKER)
        lesson.add_entry(WITHIT, CL_SCIENCE_LAB_TEACHER)
        lesson.add_entry(ROCKITT, CL_YELLOW_ROOM_TEACHER)
        lesson.add_entry(CREAK, CL_BLUE_ROOM_TEACHER)
        lesson.add_entry(TAKE, CL_UPPER_ROOM_TEACHER)
        lesson.add_entry(ALBERT, CL_SHUT_GATE_AND_DOOR)
        lesson.add_entry(TEARAWAY, CL_REVISION_LIBRARY_TEARAWAY)
        lesson.add_entry(BULLY, CL_YELLOW_ROOM_BULLY)
        lesson.add_entry(SWOT, CL_SCIENCE_LAB_SWOT)
        lesson.add_entry(HEROINE, CL_UPPER_ROOM_GIRL)
        lessons.append(lesson)

        lesson = Lesson(LSN_ROCKITT_SCIENCE_LAB_1, ROCKITT, SCIENCE_LAB)
        lesson.add_entry(GIRL01, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL02, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL03, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL04, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL05, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL06, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL07, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(BOY01, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY02, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY03, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY04, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY05, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY06, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY07, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY08, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY09, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY10, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(WACKER, CL_HEADS_STUDY)
        lesson.add_entry(WITHIT, CL_YELLOW_ROOM_TEACHER)
        lesson.add_entry(ROCKITT, CL_SCIENCE_LAB_TEACHER)
        lesson.add_entry(CREAK, CL_BLUE_ROOM_TEACHER)
        lesson.add_entry(TAKE, CL_MIDDLE_ROOM_TEACHER)
        lesson.add_entry(ALBERT, CL_SHUT_GATE_AND_DOOR)
        lesson.add_entry(TEARAWAY, CL_SCIENCE_LAB_TEARAWAY)
        lesson.add_entry(BULLY, CL_SCIENCE_LAB_BULLY)
        lesson.add_entry(SWOT, CL_SCIENCE_LAB_SWOT)
        lesson.add_entry(HEROINE, CL_MIDDLE_ROOM_GIRL)
        lessons.append(lesson)

        lesson = Lesson(LSN_ROCKITT_SCIENCE_LAB_2, ROCKITT, SCIENCE_LAB)
        lesson.add_entry(GIRL01, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL02, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL03, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL04, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL05, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL06, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL07, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(BOY01, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY02, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY03, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY04, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY05, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY06, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY07, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY08, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY09, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY10, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(WACKER, CL_WALKABOUT2_WACKER)
        lesson.add_entry(WITHIT, CL_WALKABOUT1_TEACHER)
        lesson.add_entry(ROCKITT, CL_SCIENCE_LAB_TEACHER)
        lesson.add_entry(CREAK, CL_BLUE_ROOM_TEACHER)
        lesson.add_entry(TAKE, CL_MIDDLE_ROOM_TEACHER)
        lesson.add_entry(ALBERT, CL_SHUT_GATE_AND_DOOR)
        lesson.add_entry(TEARAWAY, CL_BLUE_ROOM_TEARAWAY)
        lesson.add_entry(BULLY, CL_SCIENCE_LAB_BULLY)
        lesson.add_entry(SWOT, CL_SCIENCE_LAB_SWOT)
        lesson.add_entry(HEROINE, CL_MIDDLE_ROOM_GIRL)
        lessons.append(lesson)

        lesson = Lesson(LSN_ROCKITT_SCIENCE_LAB_3, ROCKITT, SCIENCE_LAB)
        lesson.add_entry(GIRL01, CL_DINNER_HALL_GIRL)
        lesson.add_entry(GIRL02, CL_DINNER_HALL_GIRL)
        lesson.add_entry(GIRL03, CL_KITCHEN_GIRL)
        lesson.add_entry(GIRL04, CL_KITCHEN_GIRL)
        lesson.add_entry(GIRL05, CL_DINNER_HALL_GIRL)
        lesson.add_entry(GIRL06, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL07, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(BOY01, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY02, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY03, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY04, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY05, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY06, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY07, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY08, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY09, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY10, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(WACKER, CL_HEADS_STUDY)
        lesson.add_entry(WITHIT, CL_BLUE_ROOM_TEACHER)
        lesson.add_entry(ROCKITT, CL_SCIENCE_LAB_TEACHER)
        lesson.add_entry(CREAK, CL_YELLOW_ROOM_TEACHER)
        lesson.add_entry(TAKE, CL_UPPER_ROOM_TEACHER)
        lesson.add_entry(ALBERT, CL_SHUT_GATE_AND_DOOR)
        lesson.add_entry(TEARAWAY, CL_SCIENCE_LAB_TEARAWAY)
        lesson.add_entry(BULLY, CL_REVISION_LIBRARY_BULLY)
        lesson.add_entry(SWOT, CL_SCIENCE_LAB_SWOT)
        lesson.add_entry(HEROINE, CL_UPPER_ROOM_GIRL)
        lessons.append(lesson)

        lesson = Lesson(LSN_DINNER_WACKER, '%s%s' % (skoolbuilder.HIDE_TEACHER_MARKER, WACKER), DINNER_HALL)
        lesson.add_entry(GIRL01, CL_DINNER_HALL_GIRL)
        lesson.add_entry(GIRL02, CL_DINNER_HALL_GIRL)
        lesson.add_entry(GIRL03, CL_DINNER_HALL_GIRL)
        lesson.add_entry(GIRL04, CL_DINNER_HALL_GIRL)
        lesson.add_entry(GIRL05, CL_DINNER_HALL_GIRL)
        lesson.add_entry(GIRL06, CL_DINNER_HALL_GIRL)
        lesson.add_entry(GIRL07, CL_DINNER_HALL_GIRL)
        lesson.add_entry(BOY01, CL_DINNER_BOY)
        lesson.add_entry(BOY02, CL_DINNER_BOY)
        lesson.add_entry(BOY03, CL_DINNER_BOY)
        lesson.add_entry(BOY04, CL_DINNER_BOY)
        lesson.add_entry(BOY05, CL_DINNER_BOY)
        lesson.add_entry(BOY06, CL_DINNER_BOY)
        lesson.add_entry(BOY07, CL_DINNER_BOY)
        lesson.add_entry(BOY08, CL_DINNER_BOY)
        lesson.add_entry(BOY09, CL_DINNER_BOY)
        lesson.add_entry(BOY10, CL_DINNER_BOY)
        lesson.add_entry(WACKER, CL_DINNER_DUTY)
        lesson.add_entry(WITHIT, CL_WALKABOUT1_TEACHER)
        lesson.add_entry(ROCKITT, CL_WALKABOUT2_TEACHER)
        lesson.add_entry(CREAK, CL_WALKABOUT2_TEACHER)
        lesson.add_entry(TAKE, CL_KITCHEN_TEACHER)
        lesson.add_entry(ALBERT, CL_SHUT_GATE_AND_DOOR)
        lesson.add_entry(TEARAWAY, CL_DINNER_TEARAWAY)
        lesson.add_entry(BULLY, CL_DINNER_BULLY)
        lesson.add_entry(SWOT, CL_DINNER_BOY)
        lesson.add_entry(HEROINE, CL_DINNER_HALL_GIRL)
        lessons.append(lesson)

        lesson = Lesson(LSN_DINNER_WITHIT, '%s%s' % (skoolbuilder.HIDE_TEACHER_MARKER, WITHIT), DINNER_HALL)
        lesson.add_entry(GIRL01, CL_DINNER_HALL_GIRL)
        lesson.add_entry(GIRL02, CL_DINNER_HALL_GIRL)
        lesson.add_entry(GIRL03, CL_DINNER_HALL_GIRL)
        lesson.add_entry(GIRL04, CL_DINNER_HALL_GIRL)
        lesson.add_entry(GIRL05, CL_DINNER_HALL_GIRL)
        lesson.add_entry(GIRL06, CL_DINNER_HALL_GIRL)
        lesson.add_entry(GIRL07, CL_DINNER_HALL_GIRL)
        lesson.add_entry(BOY01, CL_DINNER_BOY)
        lesson.add_entry(BOY02, CL_DINNER_BOY)
        lesson.add_entry(BOY03, CL_DINNER_BOY)
        lesson.add_entry(BOY04, CL_DINNER_BOY)
        lesson.add_entry(BOY05, CL_DINNER_BOY)
        lesson.add_entry(BOY06, CL_DINNER_BOY)
        lesson.add_entry(BOY07, CL_DINNER_BOY)
        lesson.add_entry(BOY08, CL_DINNER_BOY)
        lesson.add_entry(BOY09, CL_DINNER_BOY)
        lesson.add_entry(BOY10, CL_DINNER_BOY)
        lesson.add_entry(WACKER, CL_WALKABOUT2_WACKER)
        lesson.add_entry(WITHIT, CL_DINNER_DUTY)
        lesson.add_entry(ROCKITT, CL_WALKABOUT2_TEACHER)
        lesson.add_entry(CREAK, CL_WALKABOUT2_TEACHER)
        lesson.add_entry(TAKE, CL_KITCHEN_TEACHER)
        lesson.add_entry(ALBERT, CL_SHUT_GATE_AND_DOOR)
        lesson.add_entry(TEARAWAY, CL_DINNER_TEARAWAY)
        lesson.add_entry(BULLY, CL_DINNER_BULLY)
        lesson.add_entry(SWOT, CL_DINNER_BOY)
        lesson.add_entry(HEROINE, CL_DINNER_HALL_GIRL)
        lessons.append(lesson)

        lesson = Lesson(LSN_ASSEMBLY, '%s%s' % (skoolbuilder.HIDE_TEACHER_MARKER, WITHIT), ASSEMBLY_HALL)
        lesson.add_entry(GIRL01, CL_DINNER_HALL_GIRL)
        lesson.add_entry(GIRL02, CL_DINNER_HALL_GIRL)
        lesson.add_entry(GIRL03, CL_DINNER_HALL_GIRL)
        lesson.add_entry(GIRL04, CL_DINNER_HALL_GIRL)
        lesson.add_entry(GIRL05, CL_DINNER_HALL_GIRL)
        lesson.add_entry(GIRL06, CL_DINNER_HALL_GIRL)
        lesson.add_entry(GIRL07, CL_DINNER_HALL_GIRL)
        lesson.add_entry(BOY01, CL_ASSEMBLY_BOY_1)
        lesson.add_entry(BOY02, CL_ASSEMBLY_BOY_1)
        lesson.add_entry(BOY03, CL_ASSEMBLY_BOY_1)
        lesson.add_entry(BOY04, CL_ASSEMBLY_BOY_1)
        lesson.add_entry(BOY05, CL_ASSEMBLY_BOY_2)
        lesson.add_entry(BOY06, CL_ASSEMBLY_BOY_2)
        lesson.add_entry(BOY07, CL_ASSEMBLY_BOY_2)
        lesson.add_entry(BOY08, CL_ASSEMBLY_BOY_2)
        lesson.add_entry(BOY09, CL_ASSEMBLY_BOY_2)
        lesson.add_entry(BOY10, CL_ASSEMBLY_BOY_1)
        lesson.add_entry(WACKER, CL_ASSEMBLY_WACKER)
        lesson.add_entry(WITHIT, CL_ASSEMBLY_DUTY)
        lesson.add_entry(ROCKITT, CL_ASSEMBLY_TEACHER)
        lesson.add_entry(CREAK, CL_ASSEMBLY_TEACHER)
        lesson.add_entry(TAKE, CL_KITCHEN_TEACHER)
        lesson.add_entry(ALBERT, CL_SHUT_GATE_AND_DOOR)
        lesson.add_entry(TEARAWAY, CL_ASSEMBLY_TEARAWAY)
        lesson.add_entry(BULLY, CL_ASSEMBLY_BULLY)
        lesson.add_entry(SWOT, CL_ASSEMBLY_BOY_1)
        lesson.add_entry(HEROINE, CL_DINNER_HALL_GIRL)
        lessons.append(lesson)

        lesson = Lesson(LSN_REVISION_LIBRARY_1, REVISION_LIBRARY)
        lesson.add_entry(GIRL01, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL02, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL03, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL04, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL05, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL06, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL07, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(BOY01, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY02, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY03, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY04, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY05, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY06, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY07, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY08, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY09, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY10, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(WACKER, CL_HEADS_STUDY)
        lesson.add_entry(WITHIT, CL_WALKABOUT1_TEACHER)
        lesson.add_entry(ROCKITT, CL_SCIENCE_LAB_TEACHER)
        lesson.add_entry(CREAK, CL_YELLOW_ROOM_TEACHER)
        lesson.add_entry(TAKE, CL_UPPER_ROOM_TEACHER)
        lesson.add_entry(ALBERT, CL_SHUT_GATE_AND_DOOR)
        lesson.add_entry(TEARAWAY, CL_REVISION_LIBRARY_TEARAWAY)
        lesson.add_entry(BULLY, CL_REVISION_LIBRARY_BULLY)
        lesson.add_entry(SWOT, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(HEROINE, CL_UPPER_ROOM_GIRL)
        lessons.append(lesson)

        lesson = Lesson(LSN_REVISION_LIBRARY_2, REVISION_LIBRARY)
        lesson.add_entry(GIRL01, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL02, CL_MIDDLE_ROOM_GIRL)
        lesson.add_entry(GIRL03, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL04, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL05, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL06, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(GIRL07, CL_UPPER_ROOM_GIRL)
        lesson.add_entry(BOY01, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY02, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY03, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY04, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY05, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY06, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY07, CL_BLUE_ROOM_BOY)
        lesson.add_entry(BOY08, CL_YELLOW_ROOM_BOY)
        lesson.add_entry(BOY09, CL_SCIENCE_LAB_BOY)
        lesson.add_entry(BOY10, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(WACKER, CL_WALKABOUT2_WACKER)
        lesson.add_entry(WITHIT, CL_BLUE_ROOM_TEACHER)
        lesson.add_entry(ROCKITT, CL_SCIENCE_LAB_TEACHER)
        lesson.add_entry(CREAK, CL_YELLOW_ROOM_TEACHER)
        lesson.add_entry(TAKE, CL_UPPER_ROOM_TEACHER)
        lesson.add_entry(ALBERT, CL_SHUT_GATE_AND_DOOR)
        lesson.add_entry(TEARAWAY, CL_BLUE_ROOM_TEARAWAY)
        lesson.add_entry(BULLY, CL_REVISION_LIBRARY_BULLY)
        lesson.add_entry(SWOT, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(HEROINE, CL_UPPER_ROOM_GIRL)
        lessons.append(lesson)

        lesson = Lesson(LSN_PLAYTIME_1, PLAYTIME)
        lesson.add_entry(GIRL01, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL02, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL03, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL04, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL05, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL06, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL07, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY01, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY02, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY03, CL_REVISION_LIBRARY_BOY)
        lesson.add_entry(BOY04, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY05, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY06, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY07, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY08, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY09, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY10, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(WACKER, CL_WALKABOUT1_WACKER)
        lesson.add_entry(WITHIT, CL_WALKABOUT2_TEACHER)
        lesson.add_entry(ROCKITT, CL_WALKABOUT2_TEACHER)
        lesson.add_entry(CREAK, CL_WALKABOUT2_TEACHER)
        lesson.add_entry(TAKE, CL_KITCHEN_TEACHER)
        lesson.add_entry(ALBERT, CL_OPEN_GATE_AND_DOOR)
        lesson.add_entry(TEARAWAY, CL_WRITE_ON_BOARDS_IN_BOYS_SKOOL)
        lesson.add_entry(BULLY, CL_STALK_HEROINE_BULLY)
        lesson.add_entry(SWOT, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(HEROINE, CL_KITCHEN_GIRL)
        lessons.append(lesson)

        lesson = Lesson(LSN_PLAYTIME_2, PLAYTIME)
        lesson.add_entry(GIRL01, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL02, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL03, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL04, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL05, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL06, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL07, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY01, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY02, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY03, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY04, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY05, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY06, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY07, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY08, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY09, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY10, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(WACKER, CL_WALKABOUT1_WACKER)
        lesson.add_entry(WITHIT, CL_WALKABOUT2_TEACHER)
        lesson.add_entry(ROCKITT, CL_WALKABOUT2_TEACHER)
        lesson.add_entry(CREAK, CL_WALKABOUT2_TEACHER)
        lesson.add_entry(TAKE, CL_GIRLS_SKOOL_WALKABOUT_TEACHER)
        lesson.add_entry(ALBERT, CL_OPEN_GATE_AND_DOOR)
        lesson.add_entry(TEARAWAY, CL_WRITE_ON_BOARDS_IN_BOYS_SKOOL)
        lesson.add_entry(BULLY, CL_WALKABOUT_BULLY)
        lesson.add_entry(SWOT, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(HEROINE, CL_KITCHEN_GIRL)
        lessons.append(lesson)

        lesson = Lesson(LSN_PLAYTIME_3, PLAYTIME)
        lesson.add_entry(GIRL01, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL02, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL03, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL04, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL05, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL06, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL07, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY01, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY02, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY03, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY04, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY05, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY06, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY07, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY08, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY09, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY10, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(WACKER, CL_WALKABOUT1_WACKER)
        lesson.add_entry(WITHIT, CL_WALKABOUT2_TEACHER)
        lesson.add_entry(ROCKITT, CL_WALKABOUT2_TEACHER)
        lesson.add_entry(CREAK, CL_WALKABOUT2_TEACHER)
        lesson.add_entry(TAKE, CL_KITCHEN_TEACHER)
        lesson.add_entry(ALBERT, CL_OPEN_GATE_AND_DOOR)
        lesson.add_entry(TEARAWAY, CL_WRITE_ON_BOARDS_IN_GIRLS_SKOOL)
        lesson.add_entry(BULLY, CL_STALK_HEROINE_BULLY)
        lesson.add_entry(SWOT, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(HEROINE, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lessons.append(lesson)

        lesson = Lesson(LSN_PLAYTIME_4, PLAYTIME)
        lesson.add_entry(GIRL01, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL02, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL03, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL04, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL05, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL06, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL07, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY01, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY02, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY03, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY04, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY05, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY06, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY07, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY08, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY09, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY10, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(WACKER, CL_WALKABOUT1_WACKER)
        lesson.add_entry(WITHIT, CL_WALKABOUT2_TEACHER)
        lesson.add_entry(ROCKITT, CL_WALKABOUT2_TEACHER)
        lesson.add_entry(CREAK, CL_WALKABOUT2_TEACHER)
        lesson.add_entry(TAKE, CL_GIRLS_SKOOL_WALKABOUT_TEACHER)
        lesson.add_entry(ALBERT, CL_OPEN_GATE_AND_DOOR)
        lesson.add_entry(TEARAWAY, CL_WALKABOUT_TEARAWAY)
        lesson.add_entry(BULLY, CL_WALKABOUT_BULLY)
        lesson.add_entry(SWOT, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(HEROINE, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lessons.append(lesson)

        lesson = Lesson(LSN_PLAYTIME_5, PLAYTIME)
        lesson.add_entry(GIRL01, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL02, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL03, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL04, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL05, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL06, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(GIRL07, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY01, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY02, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY03, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY04, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY05, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY06, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY07, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY08, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY09, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(BOY10, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(WACKER, CL_WALKABOUT1_WACKER)
        lesson.add_entry(WITHIT, CL_WALKABOUT2_TEACHER)
        lesson.add_entry(ROCKITT, CL_WALKABOUT2_TEACHER)
        lesson.add_entry(CREAK, CL_WALKABOUT2_TEACHER)
        lesson.add_entry(TAKE, CL_KITCHEN_TEACHER)
        lesson.add_entry(ALBERT, CL_OPEN_GATE_AND_DOOR)
        lesson.add_entry(TEARAWAY, CL_WALKABOUT_TEARAWAY)
        lesson.add_entry(BULLY, CL_STALK_HEROINE_BULLY)
        lesson.add_entry(SWOT, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lesson.add_entry(HEROINE, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
        lessons.append(lesson)

        if self.custom == BACK_TO_SKOOL_DAZE:
            lesson = Lesson(LSN_PLAYTIME_BOYS_SKOOL_STAMPEDE, PLAYTIME)
            lesson.add_entry(GIRL01, CL_BOYS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(GIRL02, CL_BOYS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(GIRL03, CL_BOYS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(GIRL04, CL_BOYS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(GIRL05, CL_BOYS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(GIRL06, CL_BOYS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(GIRL07, CL_BOYS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(BOY01, CL_BOYS_SKOOL_STAMPEDE_LEADER)
            lesson.add_entry(BOY02, CL_BOYS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(BOY03, CL_BOYS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(BOY04, CL_BOYS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(BOY05, CL_BOYS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(BOY06, CL_BOYS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(BOY07, CL_BOYS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(BOY08, CL_BOYS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(BOY09, CL_BOYS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(BOY10, CL_BOYS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(WACKER, CL_WALKABOUT1_WACKER)
            lesson.add_entry(WITHIT, CL_WALKABOUT2_TEACHER)
            lesson.add_entry(ROCKITT, CL_WALKABOUT2_TEACHER)
            lesson.add_entry(CREAK, CL_WALKABOUT2_TEACHER)
            lesson.add_entry(TAKE, CL_KITCHEN_TEACHER)
            lesson.add_entry(ALBERT, CL_OPEN_GATE_AND_DOOR)
            lesson.add_entry(TEARAWAY, CL_WALKABOUT_TEARAWAY)
            lesson.add_entry(BULLY, CL_WALKABOUT_BULLY)
            lesson.add_entry(SWOT, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
            lesson.add_entry(HEROINE, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
            lessons.append(lesson)

            lesson = Lesson(LSN_PLAYTIME_GIRLS_SKOOL_STAMPEDE, PLAYTIME)
            lesson.add_entry(GIRL01, CL_GIRLS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(GIRL02, CL_GIRLS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(GIRL03, CL_GIRLS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(GIRL04, CL_GIRLS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(GIRL05, CL_GIRLS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(GIRL06, CL_GIRLS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(GIRL07, CL_GIRLS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(BOY01, CL_GIRLS_SKOOL_STAMPEDE_LEADER)
            lesson.add_entry(BOY02, CL_GIRLS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(BOY03, CL_GIRLS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(BOY04, CL_GIRLS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(BOY05, CL_GIRLS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(BOY06, CL_GIRLS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(BOY07, CL_GIRLS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(BOY08, CL_GIRLS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(BOY09, CL_GIRLS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(BOY10, CL_GIRLS_SKOOL_STAMPEDE_FOLLOWER)
            lesson.add_entry(WACKER, CL_WALKABOUT1_WACKER)
            lesson.add_entry(WITHIT, CL_WALKABOUT1_TEACHER)
            lesson.add_entry(ROCKITT, CL_WALKABOUT2_TEACHER)
            lesson.add_entry(CREAK, CL_WALKABOUT2_TEACHER)
            lesson.add_entry(TAKE, CL_GIRLS_SKOOL_WALKABOUT_TEACHER)
            lesson.add_entry(ALBERT, CL_OPEN_GATE_AND_DOOR)
            lesson.add_entry(TEARAWAY, CL_WALKABOUT_TEARAWAY)
            lesson.add_entry(BULLY, CL_WALKABOUT_BULLY)
            lesson.add_entry(SWOT, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
            lesson.add_entry(HEROINE, CL_PLAYTIME_WALKABOUT_BOY_GIRL)
            lessons.append(lesson)

        return lessons
