
//@renderpasses 0,1,2

varying vec2 v_TexCoord0;
varying vec4 v_Color;

//@vertex

attribute vec4 a_Position;
attribute vec2 a_TexCoord0;
attribute vec4 a_Color;

uniform mat4 r_ModelViewProjectionMatrix;

uniform vec4 m_ImageColor;

void main(){

	v_TexCoord0=a_TexCoord0;

	v_Color=m_ImageColor * a_Color;
	
	gl_Position=r_ModelViewProjectionMatrix * a_Position;
}

//@fragment

uniform sampler2D m_ImageTexture0;

vec3 BrightContrast( vec3 value, float frag_brightness, float frag_contrast ){
    return (value - 0.5) * frag_contrast + 0.5 + frag_brightness;
}

vec3 FindClosest( vec3 ref ){
	vec3 old = vec3 (100.0 * 255.0);
	
	#define TRY_COLOR(new) old = mix (new, old, step (length (old-ref), length (new-ref)));

		TRY_COLOR (vec3 (  0.0,   0.0,   0.0));		//  0 - black
		TRY_COLOR (vec3 (  0.0,  25.0, 182.0));		//  1 - low blue
		TRY_COLOR (vec3 (  0.0, 180.0,  29.0));		//  2 - low green
		TRY_COLOR (vec3 (  0.0, 182.0, 184.0));		//  3 - low cyan
		TRY_COLOR (vec3 (196.0,  31.0,  12.0));		//  4 - low red
		TRY_COLOR (vec3 (193.0,  43.0, 182.0));		//  5 - low magenta
		TRY_COLOR (vec3 (193.0, 106.0,  21.0));		//  6 - brown
		TRY_COLOR (vec3 (184.0, 184.0, 184.0));		//  7 - light grey
		TRY_COLOR (vec3 (104.0, 104.0, 104.0));		//  8 - dark grey
		TRY_COLOR (vec3 ( 95.0, 110.0, 252.0));		//  9 - high blue
		TRY_COLOR (vec3 ( 57.0, 250.0, 111.0));		// 10 - high green
		TRY_COLOR (vec3 ( 36.0, 252.0, 254.0));		// 11 - high cyan
		TRY_COLOR (vec3 (255.0, 112.0, 106.0));		// 12 - high red
		TRY_COLOR (vec3 (255.0, 118.0, 253.0));		// 13 - high magenta
		TRY_COLOR (vec3 (255.0, 253.0, 113.0));		// 14 - yellow
		TRY_COLOR (vec3 (255.0, 255.0, 255.0));		// 15 - white

	return old;
}

void main(){

#if MX2_RENDERPASS==0

	vec4 luma = vec4( 0.299, 0.587, 0.114, 1.0 );

	vec4 col = texture2D( m_ImageTexture0, v_TexCoord0 );
//	vec4 col = texture2D( m_ImageTexture0, v_TexCoord0 ) * luma;
//	float grey = dot( col.rgb, luma.rgb ) * 2.0;

	float mono = (col.r + col.g + col.b) / 0.3;
	
	vec3 rgb = col.rgb * v_Color.rgb;

//	rgb = BrightContrast( rgb, -0.5, 5.0 );
	
//	rgb = FindClosest( rgb * 255.0 );
//	rgb = max( rgb, 0.0 );


//	gl_FragColor = vec4( col.rgb * v_Color.rgb, col.a );
	gl_FragColor = vec4( rgb, mono );
//	gl_FragColor = vec4( grey * v_Color.r, grey * v_Color.g, grey * v_Color.b, mono );
	
#else

	float alpha=texture2D( m_ImageTexture0,v_TexCoord0 ).a * v_Color.a;

	gl_FragColor=vec4( 0.0,0.0,0.0,alpha );

#endif

}
