
;#define equ .equ
;#define end .end

DISPLAY_FILE:   equ 4000h
DISPLAY_LEN:	equ 6144
ATTRIB_FILE:	equ 5800h
ATTRIB_LEN	equ 768
BOTTOM_LINE:	equ 22
CAGE_COLOUR:	equ 056h
CAGE_MAX:	equ 250
PAUSE_DELAY:	equ 1250	;Original value: equ 1400

;System variables
CHARS:		equ 23606
FRAMES:		equ 23672
FRAMES_SEC:	equ 23673

ORG     28000


start:		ld 	hl,(sparestrt)          
		ld 	(spareptr),hl
		call	bld_scrtab
gointro:	call	init_vars
		call	intro_screen
	;	jp	c,return2basic
		call	setup_screen
		xor	a
		ld	(FRAMES),a
gameloop:	ld	a,(xpos)
		ld	c,a
		ld	a,(ypos)
		ld	b,a
		call 	plot_point	;Draw trail pixels
		ld	a,(mousex)
		ld	c,a
		ld	a,(mousey)
		ld	b,a
		call 	xor_point	;Draw mouse
		call	read_keyboard
;Do the mouse
		call	detect_trap	;test if mouse is in cage area		
		call	move_mouse
		call	read_x	;read 'x' key
		jr	c,quitplay
		call	update_timer
		jr	c,quitplay    ;jump if out of time
		call	pause
;Update general counter
		ld	hl,(counter1)		
		ld	bc,7
		add	hl,bc
		ld	(counter1),hl
		call	update_random
		ld	hl,(trapped_count)
		ld	bc,CAGE_MAX
		and	a
		sbc	hl,bc  ;if the mouse is in the cage area for long enough, consider a win
		jr	nc,wingame
;erase old mouse position
		ld	a,(mousepx)
		ld	c,a
		ld	a,(mousepy)
		ld	b,a
		call	xor_point
		call	detect_hit	;Test if mouse hit line anywhere

		jr	gameloop
quitplay:	call	ShortFart
		jr	gointro

wingame:	ld	c,7
		ld	b,15
		ld	d,79
		call	write_string
		DEFM "CONGRATULATIONS!!",161
		dec	b
		ld	c,2
		call	write_string
		DEFM "You managed to trap the mous", 229
		dec	b
		ld	c,2
		call	write_string
		DEFM "in    ", 160
		ld	c,5
		call	print_timer
		inc	c
		call write_string
		DEFM " seconds",161
		call	is_best_time
		call	GameoverSnd
		call	wait10secs
quitg:		jp	gointro

return2basic:	ret

intro_screen:	call	cls
		call	all_blue
		ld	c,7
		ld	b,22
		ld	d,121
		call	wr_wide_string ;write_string
		DEFM "MOUSETRA",208
		ld	c,2
		ld	b,19
		ld	d,78
		call	write_string
		DEFM "Use the cursor keys or QAO", "P"+128
		ld	c,2
		dec	b
		call	write_string
		DEFM "to trap the mouse in the re", 228
		ld	c,2
		dec	b
		call	write_string
		DEFM "box", 174
		ld	c,2
		dec	b
		call	write_string
		DEFB "The bits of cheese ar", 229
		ld	c,2
		dec	b
		call	write_string
		DEFB "just there for kicks", 174
		ld	c,2
		dec	b
		dec	b
		call	write_string
		DEFB "Be sure not to get the mous", 229
 		dec	b
		ld	c,2
		call	write_string
		DEFB "trapped elsewhere,"
		DEFB " or you'l", 236
		dec	b
		ld	c,2
		call	write_string
		DEFB "have to quit (using 'x')", 174
		ld	c,7
		ld	b,8
		ld	d,79
		call	write_string
		DEFB "Press 'p' to pla", 0F9h
		dec	b
		dec	b
		ld	c,4
		call	write_string
		DEFB "Best time:     ", 160
		ld	c,14
		ld	hl,btime_dec_last
		call	print_dec_no

waitfor_p:	halt
		call	update_random
		call	read_p
		jr	c,p_pressed
	;	call	read_x
		jr	waitfor_p
	;	scf
	;	jr	$+3
p_pressed:	and	a
		ret

;String start pointed to by address at top of stack
;b=line  c=column  d=attribute value
write_string:	di
		ex	(sp),hl
		push	de
		push	bc
		exx		;Save the alternate regs
		push	hl
		push	de
		exx
		push	hl
		push	de
;Calculate the display address
		ld	a,b	;get line
		add	a,a
		add	a,a
		add	a,a	;multiply by 8
		ld	l,a
		ld	h,0
		add	hl,hl	;further multiply by 2
		ld	de,(scrptr)
		dec	de
		dec	de
		add	hl,de
		ld	a,(hl)
		add	a,c	;add column
		ld	e,a
		inc	hl
		ld	d,(hl)	;de contains display address

		ld	a,d
		rrca
		rrca
		rrca
		and	03h
		or	88
		ld	h,a
		ld	l,e
		push	hl
		exx
		pop	hl	;attr address
		pop	de	;attrib value
		exx

		pop	hl
		ld	bc,(CHARS)
write_stringl:	ld	a,(hl)	;Get character
		push	af
		push	hl
		add	a,a	;Lookup character bits in ROM
		ld	l,a
		ld	h,0
		add	hl,hl
		add	hl,hl	;ASCII*8
		add	hl,bc	;Add base

		exx
		ld	(hl),d	;Write attribute byte
		inc	hl
		exx
		ld	a,(hl)
		ld	(de),a
		inc	hl
		inc	d
		ld	a,(hl)
		ld	(de),a
		inc	hl
		inc	d
		ld	a,(hl)
		ld	(de),a
		inc	hl
		inc	d
		ld	a,(hl)
		ld	(de),a
		inc	hl
		inc	d
		ld	a,(hl)
		ld	(de),a
		inc	hl
		inc	d
		ld	a,(hl)
		ld	(de),a
		inc	hl
		inc	d
		ld	a,(hl)
		ld	(de),a
		inc	hl
		inc	d
		ld	a,(hl)
		ld	(de),a
		ld	a,d
		and	0f8h
		ld	d,a
		inc	e
		pop	hl
		pop	af
		inc	hl
		and	080h
		jr	z,write_stringl

		exx
		pop	de
		pop	hl
		exx
		pop	bc
		pop	de
		ex	(sp),hl
		ei
		ret

;Write a double-wide string
;String start pointed to by address at top of stack
;b=line  c=column  d=attribute value
wr_wide_string:	di
		ex	(sp),hl
		push	de
		push	bc
		exx		;Save the alternate regs
		push	hl
		push	de
		exx
		push	hl
		push	de
;Calculate the display address
		ld	a,b	;get line
		add	a,a
		add	a,a
		add	a,a	;multiply by 8
		ld	l,a
		ld	h,0
		add	hl,hl	;further multiply by 2
		ld	de,(scrptr)
		dec	de
		dec	de
		add	hl,de
		ld	a,(hl)
		add	a,c	;add column
		ld	e,a
		inc	hl
		ld	d,(hl)	;de contains display address

		ld	a,d
		rrca
		rrca
		rrca
		and	03h
		or	88
		ld	h,a
		ld	l,e
		push	hl
		exx
		pop	hl	;attr address
		pop	de	;attrib value
		exx

		pop	hl
		ld	bc,(CHARS)
wr_stringl:	ld	a,(hl)	;Get character
		push	af
		push	hl
		and	07fh
		ld	l,a	;Lookup character bits in ROM
		ld	h,0
		add	hl,hl
		add	hl,hl
		add	hl,hl	;ASCII*8
		add	hl,bc	;Add base

		exx
		ld	(hl),d	;Write attribute byte
		inc	hl
		ld	(hl),d
		inc	hl
		exx
		push	bc
		ld	b,8
		inc	e
stretch:	ld	c,(hl)
		xor	a
		rrc	c
		rra
		sra	a
		rrc	c
		rra
		sra	a
		rrc	c
		rra
		sra	a
		rrc	c
		rra
		sra	a
		ld	(de),a
		dec	e
		rrc	c
		rra
		sra	a
		rrc	c
		rra
		sra	a
		rrc	c
		rra
		sra	a
		rrc	c
		rra
		sra	a
		ld	(de),a
		inc	e
		inc	hl
		inc	d
		djnz	stretch
		pop	bc
		dec	d
		ld	a,d
		and	0f8h
		ld	d,a
		inc	e
		pop	hl
		pop	af
		inc	hl
		and	080h
		jr	z,wr_stringl

		exx
		pop	de
		pop	hl
		exx
		pop	bc
		pop	de
		ex	(sp),hl
		ei
		ret

;b=char line, c=col, a=ASCII char, d=attrib value
Print_char:	push	hl
		push	de
		push	bc
		push	af
		push	de
		ld	a,b	;get line
		add	a,a
		add	a,a
		add	a,a	;multiply by 8
		ld	l,a
		ld	h,0
		add	hl,hl	;further multiply by 2
		ld	de,(scrptr)
		dec	de
		dec	de
		add	hl,de
		ld	a,(hl)
		add	a,c	;add column
		ld	e,a
		inc	hl
		ld	d,(hl)
		pop	bc	;b contains attribute value
		ld	a,d
		rrca
		rrca
		rrca
		and	03h
		or	88
		ld	h,a
		ld	l,e
		ld	(hl),b	;Poke attrib value
		pop	af
		ld	l,a
		ld	h,0
		add	hl,hl
		add	hl,hl
		add	hl,hl
		ld	bc,(CHARS)
		add	hl,bc
		ld	b,2
pcharloop:	ld	a,(hl)
		ld	(de),a
		inc	hl
		inc	d
		ld	a,(hl)
		ld	(de),a
		inc	hl
		inc	d
		ld	a,(hl)
		ld	(de),a
		inc	hl
		inc	d
		ld	a,(hl)
		ld	(de),a
		inc	hl
		inc	d
		djnz	pcharloop	
		pop	bc
		pop	de
		pop	hl
		ret

is_best_time:	ld	hl,timer_last
		call	dec2bin
		ld	de,(best_time)
		push	hl
		and	a
		sbc	hl,de
		pop	hl
		jr	nc,not_better
		ld	(best_time),hl
		ld	c,4
		ld	b,10
		ld	d,242
		call	write_string
		DEFB "*YOU HAVE THE BEST TIME"
		DEFB 170
		ld	hl,timer
		ld	de,btime_dec
		ld	bc,4
		ldir
not_better:	ret

;Alternate between 2 keyboard reading routines
read_keyboard:	ld	a,(keyroutine)
		xor	0ffh		;toggle byte
		ld	(keyroutine),a
		jr	z,jmp14
		jr	read_keyb1
jmp14:		jp	read_keyb2

read_keyb1:	ld	l,0
		ld	h,l
		ld	bc,63486
		in	a,(c)
		and	10h
		jr	nz,jmp3
		ld	l,2
		jr	jmp4
jmp3:		ld	bc,61438
		in	a,(c)
		bit	4,a
		jr	nz,jmp5
		ld	l,4
		jr	jmp4
jmp5:		bit	3,a
		jr	nz,jmp6
		ld	l,6
		jr	jmp4
jmp6:		bit	2,a
		jr	nz,jmp4
		ld	l,8
jmp4:		ld	a,l
		and	a
					;		jr	z,jmp7
		jr	z,read_keyQAOP1
		ld	(keypressed),a
jmp7:		ld	a,(keypressed)
		ld	l,a
		ld	de,movetable
		add	hl,de
		ld	e,(hl)
		inc	hl
		ld	d,(hl)
		ex	de,hl
		jp	(hl)

read_keyQAOP1:	ld	l,0
		ld	h,l
		ld	bc,57342	;P to Y
		in	a,(c)
		bit	0,a		;P (right)
		jr	nz,jmpQAOP3
		ld	l,8
		jr	jmpQAOP4
jmpQAOP3:	bit	1,a		;O (left)
		jr	nz,jmpQAOP8
		ld	l,2
		jr	jmpQAOP4		
jmpQAOP8:	ld	bc,64510	;Q to T  (up)
		in	a,(c)
		bit	0,a		;Q - up
		jr	nz,jmpQAOP5
		ld	l,6
		jr	jmpQAOP4
jmpQAOP5:	ld	bc,65022	;A to G
		in	a,(c)
		bit	0,a		;A - down
		jr	nz,jmpQAOP4
		ld	l,4
jmpQAOP4:	ld	a,l
		and	a
		jr	z,jmpQAOP7
		ld	(keypressed),a
jmpQAOP7:	ld	a,(keypressed)
		ld	l,a
		ld	de,movetable
		add	hl,de
		ld	e,(hl)
		inc	hl
		ld	d,(hl)
		ex	de,hl
		jp	(hl)

read_keyb2:	ld	l,0
		ld	h,l
		ld	bc,61438
		in	a,(c)
		bit	2,a
		jr	nz,jmp8
		ld	l,8
		jr	jmp12
jmp8:		in	a,(c)
		bit	3,a
		jr	nz,jmp9
		ld	l,6
		jr	jmp12
jmp9:		bit	4,a
		jr	nz,jmp10
		ld	l,4
		jr	jmp12
jmp10:		ld	bc,63486
		in	a,(c)
		and	10h
		jr	nz,jmp12
		ld	l,2
jmp12:		ld	a,l
		and	a
		jr	z,read_keyQAOP2
		ld	(keypressed),a
jmp13:		ld	a,(keypressed)
		ld	l,a
		ld	de,movetable
		add	hl,de
		ld	e,(hl)
		inc	hl
		ld	d,(hl)
		ex	de,hl
		jp	(hl)

read_keyQAOP2:	ld	l,0
		ld	h,l
		ld	bc,64510	;Q to T  (up)
		in	a,(c)
		bit	0,a		;Q - up
		jr	nz,jmpQAOP10	
		ld	l,6
		jr	jmpQAOP14
jmpQAOP10:	ld	bc,65022	;A to G
		in	a,(c)
		bit	0,a		;A - down
		jr	nz,jmpQAOP11
		ld	l,4
		jr	jmpQAOP14
jmpQAOP11:	ld	bc,57342	;P to Y
		in	a,(c)
		bit	0,a		;P (right)
		jr	nz,jmpQAOP12
		ld	l,8
		jr	jmpQAOP14
jmpQAOP12:	bit	1,a		;O (left)
		jr	nz,jmpQAOP14
		ld	l,2
jmpQAOP14:	ld	a,l
		and	a
		jr	z,jmpQAOP15
		ld	(keypressed),a
jmpQAOP15:	ld	a,(keypressed)
		ld	l,a
		ld	de,movetable
		add	hl,de
		ld	e,(hl)
		inc	hl
		ld	d,(hl)
		ex	de,hl
		jp	(hl)


;No key pressed
nokey:		ret

read_q:		ld	bc,64510
		in	a,(c)
		and	01h
		jr	nz,qnothit
		scf
qnothit:	ret

read_x:		ld	bc,65278
		in	a,(c)
		and	04h
		jr	nz,xnothit
		scf
xnothit:	ret


read_p:		ld	bc,57342
		in	a,(c)
		and	01h
		jr	nz,pnothit
		scf
pnothit:	ret

;Move left
moveleft:	ld	a,(xpos)
		and	a
		jr	z,end1
		dec	a
 		ld	(xpos),a
end1:		ret

;Move right
moveright:	ld	a,(xpos)
		cp	0feh
		jr	nc,end2
		inc	a
 		ld	(xpos),a
end2:		ret

;Move up
moveup:		ld	a,(ypos)
		cp	0bfh
		jr	nc,end3
		inc	a
 		ld	(ypos),a
end3:		ret

;Move down
movedown:	ld	a,(ypos)
		cp	(23-BOTTOM_LINE)*8+1
		jr	z,end4
		jr	c,end4
		dec	a
 		ld	(ypos),a
end4:		ret


move_mouse:	ld	a,(mousex)
		ld	(mousepx),a
		ld	b,a
		ld	hl,mousexdisp
		add	a,(hl)
		ld	c,a
		cp	2
		jr	c,jmp15
		cp	254
		jr	c,jmp16	
jmp15:		ld	a,(hl)
		neg
		ld	(hl),a
		call	BlipSound
		ld	c,b
jmp16:		ld	a,c
		ld	(mousex),a
		ld	a,(mousey)
		ld	(mousepy),a
		ld	b,a	
		ld	hl,mouseydisp
		add	a,(hl)
		ld	c,a
		cp	(23-BOTTOM_LINE)*8+1
		jr	c,jmp17
		cp	190
		jr	c,jmp18
jmp17:		ld	a,(hl)
		neg
		ld	(hl),a
		call	BlipSound
		ld	c,b
jmp18:		ld	a,c
		ld	(mousey),a
		ret


;b=line   C-column
plot_point:	ld 	l,b
		ld	h,0
		add	hl,hl
		ld	de,(scrptr)
		add 	hl,de
		push 	hl
		ld	e,(hl)
		inc 	hl
		ld 	d,(hl)
		ld	a,c
		rrca
		rrca
		rrca
		and	01fh
		push	af
		add	a,e
		ld	e,a	;DE=Scr address
		ld	a,c
		and	07h
		ld	c,a
		ld	b,0
		ld	hl,pixbase
		add	hl,bc
		ld	a,(hl)
		ld	b,a	;save A
		ex	de,hl
		or	(hl)
		ld	(hl),a
		ld	a,c
		cp	07h
		jr	nz, jmp1
		inc	l
		ld	a,080h
		or	(hl)
		ld	(hl),a
		dec	l
jmp1:		pop	af
		pop	hl
		dec	hl
		ld	d,(hl)
		dec 	hl
		ld	e,(hl)
		add	a,e
		ld	l,a
		ld	h,d
		ld	a,b
		or	(hl)
		ld	(hl),a
		ld	a,c
		cp	07h
		jr	nz, jmp2
		inc	l
		ld	a,080h
		or	(hl)
		ld	(hl),a
jmp2:		ret

;b=line   C-column
xor_point:	ld 	l,b
		ld	h,0
		add	hl,hl
		ld	de,(scrptr)
		add 	hl,de
		push 	hl
		ld	e,(hl)
		inc 	hl
		ld 	d,(hl)
		ld	a,c
		rrca
		rrca
		rrca
		and	01fh
		push	af
		add	a,e
		ld	e,a	;DE=Scr address
		ld	a,c
		and	07h
		ld	c,a
		ld	b,0
		ld	hl,pixbase
		add	hl,bc
		ld	a,(hl)
		ld	b,a	;save A
		ex	de,hl
		xor	(hl)
		ld	(hl),a
		ld	a,c
		cp	07h
		jr	nz, jmp26
		inc	l
		ld	a,080h
		xor	(hl)
		ld	(hl),a
		dec	l
jmp26:		pop	af
		pop	hl
		dec	hl
		ld	d,(hl)
		dec 	hl
		ld	e,(hl)
		add	a,e
		ld	l,a
		ld	h,d
		ld	a,b
		xor	(hl)
		ld	(hl),a
		ld	a,c
		cp	07h
		jr	nz, jmp27
		inc	l
		ld	a,080h
		xor	(hl)
		ld	(hl),a
jmp27:		ret

;Erase a point
;b=line   C-column
;erase_point:	ld 	l,b
;		ld	h,0
;		add	hl,hl
;		ld	de,(scrptr)
;		add 	hl,de
;		push 	hl
;		ld	e,(hl)
;		inc 	hl
;		ld 	d,(hl)
;		ld	a,c
;		rrca
;		rrca
;		rrca
;		and	01fh
;		push	af
;		add	a,e
;		ld	e,a	;DE=Scr address
;		ld	a,c
;		and	07h
;		ld	c,a
;		ld	b,0
;		ld	hl,pixbase
;		add	hl,bc
;		ld	a,(hl)
;		cpl
;		ld	b,a	;save A
;		ex	de,hl
;		and	(hl)
;		ld	(hl),a
;		ld	a,c
;		cp	07h
;		jr	nz, jmp19
;		inc	l
;		ld	a,07fh
;		and	(hl)
;		ld	(hl),a
;		dec	l
;jmp19:		pop	af
;		pop	hl
;		dec	hl
;		ld	d,(hl)
;		dec 	hl
;		ld	e,(hl)
;		add	a,e
;		ld	l,a
;		ld	h,d
;		ld	a,b
;		and	(hl)
;		ld	(hl),a
;		ld	a,c
;		cp	07h
;		jr	nz, jmp20
;		inc	l
;		ld	a,07fh
;		and	(hl)
;		ld	(hl),a
;jmp20:		ret

;Test if mouse hit a line
detect_hit:	call test_leftright
		call test_updown
		ret

test_leftright:	ld	a,(mousexdisp)
		and	80h
		jr	z,movingright
		ld	a,(mouseydisp)	;mouse is moving left
		and	80h
		jr	z,movingleftup
		call	testpoint1
		jr	c,jmp22
		jr	jmp23
movingleftup:	call	testpoint4
		jr	c,jmp22
		jr	jmp23		;jump to end
movingright:	ld	a,(mouseydisp)
		and	80h
		jr	z,movingrightup
		call	testpoint2
		jr	c,jmp22
		jr	jmp23
movingrightup:	call	testpoint3
		jr	c,jmp22
		jr	jmp23
jmp22:		ld	a,(mousepx)
		ld	(mousex),a
		ld	a,(mousexdisp)
		neg
		ld	(mousexdisp),a
		call	BlipSound
jmp23:		ret

;Test for vertical collision
test_updown:	ld	a,(mouseydisp)
		and	80h
		jr	z,movingup
		ld	a,(mousexdisp)	;mouse is moving down
		and	80h
		jr	z,movingdownrig
		call	testpoint3
		jr	c,jmp24
		jr	jmp25
movingdownrig:	call	testpoint4
		jr	c,jmp24
		jr	jmp25		;jump to end
movingup:	ld	a,(mousexdisp)
		and	80h
		jr	z,movinguprig
		call	testpoint2
		jr	c,jmp24
		jr	jmp25
movinguprig:	call	testpoint1
		jr	c,jmp24
		jr	jmp25
jmp24:		ld	a,(mousepy)
		ld	(mousey),a
		ld	a,(mouseydisp)
		neg
		ld	(mouseydisp),a
		call	BlipSound
		ld	a,(random_no)
		cp	9
		jr	c,jmp25
;On a random occurance, move the mouse horizontal
		ld	a,(mousexdisp)
		bit	7,a
		jr	z,tstforleft
		call	testpoint2
		jr	c,jmp25	;jump if occupied
		jr	nudgemouse
tstforleft:	call	testpoint1
		jr	c,jmp25
nudgemouse:	ld	a,(mousex)
		ld	(mousepx),a
		ld	hl,mousexdisp
		add	a,(hl)
		ld	(mousex),a
jmp25:		ret

detect_trap:	ld	a,(mousex)
		inc	a
		ld	c,a
		ld	a,(mousey)
		ld	b,a
		call	attr_adr
		ld	a,(hl)
		ld	hl,(trapped_count)
		cp	CAGE_COLOUR	;is it in cage?
		jr	nz,reset_trap
		inc	hl
		jr	endtrap
reset_trap:	ld	hl,0
endtrap:	ld	(trapped_count),hl
		ret
;Get Attribute address of pixel coords
attr_adr:	ld	a,c
		rrca
		rrca
		rrca
		and	01fh
		ld	l,a
		ld	a,191
		sub	b
		ld	h,a
		rlca
		rlca
		and	0e0h
		or	l
		ld	l,a
		ld	a,h
		rlca
		rlca
		and	03h
		or	88
		ld	h,a
		ret		

;testpoint 1 to 4 tess each of the 4 points making up the mouse
testpoint1:	ld	a,(mousex)
		ld	c,a
		ld	a,(mousey)
		ld	b,a
		call	test_point
		ret

testpoint2:	ld	a,(mousex)
		inc	a
		ld	c,a
		ld	a,(mousey)
		ld	b,a
		call	test_point
		ret

testpoint3:	ld	a,(mousex)
		inc	a
		ld	c,a
		ld	a,(mousey)
		dec	a
		ld	b,a
		call	test_point
		ret

testpoint4:	ld	a,(mousex)
		ld	c,a
		ld	a,(mousey)
		dec	a
		ld	b,a
		call	test_point
		ret

;Test a point.  Carry flag returns with 1 if pixel is set, or 0 if point is reset
;b=line   C-column
test_point:	ld 	l,b
		ld	h,0
		add	hl,hl
		ld	de,(scrptr)
		add 	hl,de
		ld	e,(hl)
		inc 	hl
		ld 	d,(hl)
		ld	a,c
		rrca
		rrca
		rrca
		and	01fh
		add	a,e
		ld	e,a	;DE=Scr address
		ld	a,c
		and	07h
		ld	c,a
		ld	b,0
		ld	hl,pixtestbase
		add	hl,bc
		ld	a,(de)
		and	(hl)
		jr	z,jmp21
		scf		;if the pixel is set, return with carry set
jmp21:		ret

	
setup_screen:	call	FancyClear
		call	all_blue
;Draw a frame around screen
		ld	b,(23-BOTTOM_LINE)*8+1
		ld	c,0
loop6:		push	bc
		push	bc
		call	plot_point
		pop	bc
		ld	b,191
		call	plot_point
		pop	bc
		inc	c
		inc	c
		ld	a,c
		and	a
		jr	nz,loop6
		ld	b,(23-BOTTOM_LINE)*8+1
		ld	c,0
loop7:		push	bc
		push	bc
		call	plot_point
		pop	bc
		ld	c,254
		call	plot_point
		pop	bc
		inc	b
		inc	b
		ld	a,b
		cp	190
		jr	c,loop7
		call	drawcheese	;Draw the cheese
		call	draw_trap_rnd	;Randomly position the trap
		ld	c,17
		ld	b,23-BOTTOM_LINE
		ld	d,79
		call	wr_wide_string
		DEFB "Time", 186
		ld	c,27
		ld	b,23-BOTTOM_LINE
		call	print_timer	;Print the time
		ret

all_blue:	ld	a,1
		out	(254),a		;Blue border
		ld	hl,ATTRIB_FILE
		ld	d,h
		ld	e,l
		inc	de
		ld	bc,ATTRIB_LEN-1
		ld	(hl),04eh
		ldir
		ret
;Clear the display file
cls:		ld	hl,(scrptr)
		ld	b,DISPLAY_LEN/32
clsloop:	ld	e,(hl)
		inc	hl
		ld	d,(hl)
		inc	hl
		push	hl
		push	bc
		ld	h,d
		ld	l,e
		inc	de
		ld	bc,31
		ld	(hl),0
		ldir
		pop	bc
		pop	hl
		djnz	clsloop
		ret
;Draw trap in a random position
draw_trap_rnd:	call	update_random
		ld	a,(random256)
		and	01fh
		jr	z,withinran1
		dec	a
withinran1:	ld	c,a
		push	bc
		call	update_random
		ld	a,(random256)
		ld	c,a
		ld	a,(random_no)
		add	a,c
		and	03fh
mod22:		cp	BOTTOM_LINE
		jr	c,withinran2
		sub	BOTTOM_LINE
		jr	mod22
withinran2:	ld	l,a
		ld	h,0
		add	hl,hl
		add	hl,hl
		add	hl,hl
		add	hl,hl
		add	hl,hl   ;multiply by 32
		pop	bc
withinran3:	ld	b,0
		add	hl,bc
		ld	bc,ATTRIB_FILE
		add	hl,bc
;Test for collision with cheese
		call	test_for_chees
		jr	c,draw_trap_rnd	;try again if collision
		inc	l
		call	test_for_chees
		jr	c,draw_trap_rnd
		ld	de,32
		add	hl,de
		call	test_for_chees
		jr	c,draw_trap_rnd
		dec	l
		call	test_for_chees
		jr	c,draw_trap_rnd
		ld	a,CAGE_COLOUR
		ld	(hl),a
		inc	l
		ld	(hl),a
		ld	de,32
		sbc	hl,de
		ld	(hl),a
		dec	l
		ld	(hl),a
		ret

update_timer:	ld	hl,frames_copy
		ld	a,(FRAMES)
		cp	(hl)
		jr	z,notime
		ld	(hl),a
		ld	a,(seconds50)
		inc	a
		ld	(seconds50),a
		cp	50
		jr	nc,justasec
		jr	notime
justasec:	xor	a
		ld	(seconds50),a
;now update the timer
		ld	hl,timer
		ld	bc,000ah
		inc	(hl)	;1st (lsd) digit
		ld	a,(hl)
		cp	c	;reached 10?
		jr	c,pr_digs
		ld	(hl),b
		inc	hl
		inc	(hl)	;2nd digit
		ld	a,(hl)
		and	00fh
		ld	(hl),a
		cp	c
		jr	c,pr_digs
		ld	(hl),b
		inc	hl
		inc	(hl)	;3rd digit
		ld	a,(hl)
		and	00fh
		ld	(hl),a
		cp	c
		jr	c,pr_digs
		ld	(hl),b
		inc	hl
		inc	(hl)	;4th digit
		ld	a,(hl)
		and	00fh
		ld	(hl),a
		cp	c
		jr	c,pr_digs
		ld	(hl),b
;Time is up	
		ld	c,3
		ld	b,10
		ld	d,207
		call	write_string
		DEFB "Sorry, you're out of time"
		DEFB 161
		call	wait10secs
		scf
		jr	timeoutj
pr_digs:	ld	c,27
		ld	b,23-BOTTOM_LINE
		call	print_timer				
notime:		and	a
timeoutj:	ret

;Converts 4-byte decimal number pointed to by hl, to a binary number in hl
dec2bin:	ex	de,hl
		ld	h,0
		ld	b,h
		ld	a,(de)	;most significant digit first
		and	0fh
		ld	l,a
		call	mul10
		dec	de
		ld	a,(de)
		and	0fh
		ld	c,a
		add	hl,bc
		call	mul10
		dec	de
		ld	a,(de)
		and	0fh
		ld	c,a
		add	hl,bc
		call	mul10
		dec	de
		ld	a,(de)
		and	0fh
		ld	c,a
		add	hl,bc
		ret
;Multiply hl by 10
mul10:		push	de
		ld	e,l
		ld	d,h
		add	hl,hl
		add	hl,hl
		add	hl,de
		add	hl,hl
		pop	de
		ret

;b=line, c=column
print_timer:	ld	hl,timer_last
		call	print_dec_no
		ret
;Print the decimal number pointed to by HL at the unit amount
print_dec_no:	ld	d,79
		ld	a,(hl)
		bit	7,a
		jr	nz,nxtdig1
		add	a,030h
		call	Print_char
nxtdig1:	dec	hl
		inc	c
		ld	a,(hl)
		bit	7,a
		jr	nz,nxtdig2
		add	a,030h
		call	Print_char
nxtdig2:	dec	hl
		inc	c
		ld	a,(hl)
		bit	7,a
		jr	nz,nxtdig3
		add	a,030h
		call	Print_char
nxtdig3:	dec	hl
		inc	c
		ld	a,(hl)
		add	a,030h
		call	Print_char
		ret

init_vars:	ld	hl,(FRAMES)
		ld	(counter1),hl
		ld	a,127
		ld	(xpos),a
		ld	a,96
		ld	(ypos),a
		ld	a,100
		ld	(mousex),a
		ld	a,80
		ld	(mousey),a
		ld	a,1
		ld	(mousexdisp),a
		neg
		ld	(mouseydisp),a
		xor	a
		ld	(keypressed),a
		ld	(trapped_count),a
		ld	(seconds50),a
		ld	a,080h
		ld	hl,timer
		ld	(hl),0
		inc	hl
		ld	(hl),a
		inc	hl
		ld	(hl),a
		inc	hl
		ld	(hl),a
		ld	a,(FRAMES)
		ld	b,a
;get some randomness going
rnd_loop:	push	bc
		call	update_random
		pop	bc
		djnz	rnd_loop
		xor	a
		ld	(frames_copy),a
		ld	(FRAMES),a
		ret

pause:		ld	bc,PAUSE_DELAY
loop5:		dec	bc
		ld	a,b
		or	c
		jr	nz,loop5
		ret

test_anykey:	push	bc
		ld	bc,0fefeh
testkagain:	in	a,(c)
		cpl
		and	01fh
		jr	nz,a_key_pressed
		rlc	b
		jr	c,testkagain
		and	a
		jr	no_key_pressed
a_key_pressed:	scf
no_key_pressed:	pop	bc
		ret

wait1sec:	ld	b,50
wait1secl:	halt
		djnz	wait1secl
		ret

wait5secs:	ld	bc,250
wait5secsl:	halt
		dec	bc
		ld	a,b
		or	c
		jr	nz,wait5secsl
		ret

wait10secs:	call	wait1sec
		ld	bc,450
wait10secsl:	halt
		call	test_anykey
		jr	c,endwait10
		dec	bc
		ld	a,b
		or	c
		jr	nz,wait10secsl
endwait10:	ret

;Generate a new random number from 0 to 16, then from 0 to 256
update_random:	ld	a,(random256)
		ld	e,a
		ld	a,(FRAMES)
		add	a,e
		adc	a,0
		ld	a,(counter1)
		ld	d,a
		add	a,e
		add	a,1fh
		adc	a,7
		ld	(random256),a
		ld	e,a
		inc	a
		and	003h
		add	a,a
		ld	l,a
		ld	h,0
		ld	bc,random_ptr
		add	hl,bc
		ld	c,(hl)
		inc	hl
		ld	b,(hl)
		ld	a,e
		add	a,d	;add counter
		and	0fh
		ld	l,a
		ld	h,0
		add	hl,bc
		ld	a,(hl)
		ld	(random_no),a
		ret

bld_scrtab:	ld	hl,(spareptr)
		ld	de,dummyadr
		ld	b,8		;fill underflow dummy addresses	
loop4:		ld	(hl),e
		inc hl
		ld	(hl),d
		inc	hl
		djnz	loop4
		ld	(scrptr),hl
		ld 	de,57e0h
loop2:		ld	(hl),e
		inc 	hl
		ld	(hl),d
		inc 	hl
		dec 	d
		ld 	a,d
		and	07h
		cp	07h
		jr	nz,loop2
		ld	a,d
		add	a,8
		ld	d,a
		ld	a,e
		sub	32
		ld	e,a
		and	0e0h
		cp	0e0h
		jr	nz,loop2
		ld	a,d	
		sub	8
		ld	d,a
		cp	40h
		jr	nc,loop2
		ld	de,dummyadr
		ld	b,32
loop3:		ld	(hl),e
		inc	hl
		ld	(hl),d
		inc	hl
		djnz	loop3
		ld	(spareptr),hl
		ret

drawcheese:	ld	hl,(spareptr)
		ld	(invalid_locs),hl
		push	hl
		pop	ix
		ld	hl,16451
		call	drawcheeseg
		ld	hl,16473
		call	drawcheeseg
		ld	hl,18502
		call	drawcheeseg
		ld	hl,18518
		call	drawcheeseg
		ld	hl,20579
		call	drawcheeseg
		ld	hl,20601
		call	drawcheeseg
		ret

drawcheeseg:	ld	de,cheesegraf
		ld	b,2
cheeloop1:	push	bc
		push	hl
		ld	b,3
cheeloop2:	push	hl
		push	hl
;Convert to Attrib address and store
		call	disp_to_attr
		ld	(ix+0),l
		ld	(ix+1),h
		inc	ix
		inc	ix
		pop	hl
		push	bc
		ld	b,4
cheeloop3:	ld	a,(de)
		or	(hl)
		ld	(hl),a
		inc	de
		inc	h
		ld	a,(de)
		or	(hl)
		ld	(hl),a
		inc	de
		inc	h
		djnz	cheeloop3
		pop	bc
		pop	hl
		inc	hl
		djnz	cheeloop2
		pop	hl
		ld	a,l
		and	0e0h
		cp	0e0h
		jr	z,next_seg
		ld	bc,32
		add	hl,bc
		jr	cheejmp1
next_seg:	ld	a,l
		and	01fh
		ld	l,a
		ld	a,h
		add	a,8
		ld	h,a
cheejmp1:	pop	bc
		djnz	cheeloop1
		ld	hl,0ffffh
		ld	(ix+0),l
		ld	(ix+1),h
		ret

disp_to_attr:	ld	a,h
		and	018h
		rrca
		rrca
		rrca
		or	058h
		ld	h,a
		ret
;Check if there's a co-incide with where the trap will print, and the position
;of a piece of cheese
test_for_chees:	push	hl
		push	hl
		ld	hl,(invalid_locs)
		push	hl
		pop	ix
		pop	de
testcloop:	ld	l,(ix+0)
		ld	h,(ix+1)
		ld	a,h
		cp	0ffh
		jr	z,end_of_test
		and	a
		sbc	hl,de
		jr	z,fail_test
		inc	ix
		inc	ix
		jr	testcloop		
fail_test:	scf
		jr	$+3
end_of_test:	and	a
		pop	hl
		ret

BlipSound:	ld	a,1
		ld	l,b	;Save b
		ld 	b,7
BlipLoop1:	out	(0FEh),a
		xor	10h
		ld	e,a
		ld a,b
		and	1Fh
		inc a		;make sure it's never 0
BlipLoop2:	dec a
		nop
		jr	nz,BlipLoop2
		nop
		nop
		ld a,e
		djnz	BlipLoop1
		ld	b,l	;Restore b
		ret

ShortFart:	ld	b,100
FLoop:		push	bc
		call	FartSound
		pop	bc
		djnz	FLoop
		ret

FartSound:	ld	a,1
		
FartLoop1:	out	(0FEh),a
		out	(0FEh),a
		out	(0FEh),a
		out	(0FEh),a
		out	(0FEh),a
		out	(0FEh),a
		out	(0FEh),a
		out	(0FEh),a
		out	(0FEh),a
		out	(0FEh),a
		out	(0FEh),a
		out	(0FEh),a
		out	(0FEh),a
		out	(0FEh),a
		out	(0FEh),a
		out	(0FEh),a
		out	(0FEh),a
		out	(0FEh),a
		out	(0FEh),a
		ld	a,b
		and	0f8h
		or	01h
		out	(0FEh),a
		nop
		out	(0FEh),a
		nop
		nop
		out	(0FEh),a
		dec b
		jr	nz,FartLoop1
		ret

GameoverSnd:	ld	b,3
GameoverSndL1:	push	bc
		call	GameoverSn2
		pop	bc
		djnz	GameoverSndL1
		ret

GameoverSn2:	ld	hl,500
		ld	b,125
GameoverSn2L1:	push	bc
		push	hl
		ld	a,l
		and	07h
		ld	e,a
		ld	d,0
		call	949
		call	949
		pop	hl
		inc	hl
		pop	bc
		djnz	GameoverSn2L1
		ret		

FancyClear:	ld	hl,16384
		ld 	de,17
		ld	b,e
		ld	c,0
		ld	a,87
FancyLoop1:	push	bc
FancyLoop2:	ld	(hl),c
		add	hl,de
		cp	h
		jr	nc,FancyLoop2
		ld	b,24
		and	a
		sbc	hl,bc
		halt
		halt
		pop	bc
		djnz	FancyLoop1
		ret

pixbase:	DEFB 0c0h, 060h, 030h, 018h, 00ch, 006h, 003h, 001h
pixtestbase	DEFB 080h, 040h, 020h, 010h, 008h, 004h, 002h, 001h

scrptr:		DEFW 0
xpos:		DEFB 127
ypos:		DEFB 96
mousex:		DEFB 100
mousey:		DEFB 80
mousepx:	DEFB 0
mousepy:	DEFB 0
mousexdisp	DEFB 1
mouseydisp	DEFB 0ffh
keyroutine:	DEFB 0
keypressed	DEFB 0
movetable:	DEFW nokey
		DEFW moveleft
		DEFW movedown
		DEFW moveup
		DEFW moveright
random_tab1:	DEFB 7, 2, 10, 13, 9, 0, 15, 4, 11, 12, 6, 3, 1, 14, 5, 8
random_tab2:	DEFB 11, 14, 0, 5, 8, 6, 12, 1, 2, 15, 3, 10, 7, 4, 13, 9
random_tab3:	DEFB 12, 4, 13, 5, 14, 6, 0, 9, 2, 8, 15, 10, 11, 7, 1, 3
random_tab4:	DEFB 12, 8, 11, 6, 7, 3, 14, 1, 2, 10, 13, 5, 9, 15, 0, 4
random_ptr:	DEFW random_tab1
		DEFW random_tab2
		DEFW random_tab3
		DEFW random_tab4		
random_no:	DEFB 0abh
random256:	DEFB 0aah
dectab:		DEFW 1000
		DEFW  100
		DEFW   10

cheesegraf:	DEFB 000h, 000h, 000h, 000h, 000h, 001h, 00fh, 01fh
		DEFB 000h, 000h, 001h, 00fh, 03fh, 0f3h, 0f3h, 0ffh
		DEFB 000h, 038h, 0fch, 0fch, 0e6h, 0e6h, 0e3h, 0ffh
		DEFB 001h, 07eh, 0ffh, 0ffh, 0ffh, 01fh, 007h, 003h
		DEFB 0ffh, 000h, 0ffh, 0ffh, 0feh, 0feh, 0ffh, 0ffh
		DEFB 0f9h, 007h, 0ffh, 03fh, 01fh, 01fh, 03eh, 0fch
sav_sp:		DEFW 0

sparestrt:	DEFW spare
spareptr:	DEFW spare
trapped_count:	DEFW 0
counter1:	DEFW 0fbh
timer:		DEFB 0, 0, 0
timer_last:	DEFB 0
best_time:	DEFW 360
btime_dec:	DEFB 0, 0, 0
btime_dec_last:	DEFB 0
frames_copy	DEFB 0
seconds50:	DEFB 0
invalid_locs:	DEFW 0
dummyadr:	DEFW 0, 0			;dummy address written to if screen out of range
spare:		DEFB 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

                end
